/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericMethod;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.IPythonRoutine;
import java.io.IOException;

public class PythonMethod
extends GenericMethod
implements IPythonRoutine {
    private Kind m_kind = Kind.METHOD;
    private int m_serialNumber;
    private boolean m_isAsync = false;

    public PythonMethod(NamedElement parent) {
        super(parent);
    }

    public PythonMethod(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int serialNumber) {
        super(msp, parent, name, lineNumber);
        assert (serialNumber >= 0);
        this.m_serialNumber = serialNumber;
    }

    public boolean isInitializer() {
        return this.getShortName().equals("__init__");
    }

    public boolean isStatic() {
        return this.m_kind == Kind.STATIC_METHOD;
    }

    public String getFullyQualifiedNamePart() {
        if (this.m_serialNumber == 0) {
            return super.getFullyQualifiedNamePart();
        }
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.m_serialNumber);
    }

    public Kind getKind() {
        return this.m_kind;
    }

    public void setKind(Kind kind) {
        this.m_kind = kind;
    }

    @Override
    public boolean isAsync() {
        return this.m_isAsync;
    }

    @Override
    public void markAsAsync() {
        this.m_isAsync = true;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        String kind = reader.readString();
        this.m_kind = Kind.valueOf(kind);
        this.m_serialNumber = reader.readInt();
        this.m_isAsync = reader.readBoolean();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_kind.name());
        writer.writeInt(this.m_serialNumber);
        writer.writeBoolean(this.m_isAsync);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPythonMethod(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitPythonMethod(PythonMethod var1);
    }

    public static enum Kind {
        METHOD,
        CLASS_METHOD,
        STATIC_METHOD;

    }
}

