/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.AbstractPythonVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParser;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.tree.RuleNode;

class LhsNameCollector
extends AbstractPythonVisitor<String> {
    private final List<String> m_names;
    private final Set<String> m_fields = new THashSet();

    LhsNameCollector(Scope currentScope, PythonSourceFile source, List<String> names) {
        super(currentScope, source, false);
        assert (names != null) : "Parameter 'names' of method 'LhsNameCollector' must not be null";
        this.m_names = names;
    }

    boolean isField(String name) {
        return this.m_fields.contains(name);
    }

    @Override
    public String visitSingle_target(PythonParser.Single_targetContext ctx) {
        if (ctx.single_subscript_attribute_target() != null) {
            return null;
        }
        if (ctx.NAME() != null) {
            this.m_names.add(ctx.NAME().getText());
        } else {
            this.visitChildren((RuleNode)ctx);
        }
        return null;
    }

    @Override
    public String visitTarget_with_star_atom(PythonParser.Target_with_star_atomContext ctx) {
        String name;
        if (ctx.NAME() != null) {
            if ("self".equals(ctx.t_primary().accept(this))) {
                String memberName = ctx.NAME().getText();
                this.m_names.add(memberName);
                this.m_fields.add(memberName);
            }
        } else if (ctx.star_atom() != null && (name = ctx.star_atom().accept(this)) != null) {
            this.m_names.add(name);
        }
        return null;
    }

    @Override
    public String visitStar_atom(PythonParser.Star_atomContext ctx) {
        if (ctx.NAME() != null) {
            return ctx.NAME().getText();
        }
        return (String)super.visitStar_atom(ctx);
    }

    @Override
    public String visitAtom(PythonParser.AtomContext ctx) {
        if (ctx.NAME() != null) {
            return ctx.NAME().getText();
        }
        return null;
    }

    @Override
    public String visitT_primary(PythonParser.T_primaryContext ctx) {
        if (ctx.atom() != null) {
            return ctx.atom().accept(this);
        }
        String name = ctx.t_primary().accept(this);
        if (name != null && name.equals("self") && ctx.NAME() != null) {
            String memberName = ctx.NAME().getText();
            this.m_names.add(memberName);
            this.m_fields.add(memberName);
        }
        return null;
    }
}

