/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParserBaseVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPythonVisitor<T>
extends PythonParserBaseVisitor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPythonVisitor.class);
    private static final Set<String> INTERNAL_NAMES = Set.of("__name__");
    protected Scope m_currentScope;
    protected final PythonSourceFile m_source;
    private boolean m_createIssues = true;

    protected AbstractPythonVisitor(Scope currentScope, PythonSourceFile source) {
        this(currentScope, source, true);
    }

    protected AbstractPythonVisitor(Scope currentScope, PythonSourceFile source, boolean createIssues) {
        assert (currentScope != null) : "Parameter 'currentScope' of method 'AbstractPythonVisitor' must not be null";
        assert (source != null) : "Parameter 'source' of method 'AbstractPythonVisitor' must not be null";
        this.m_currentScope = currentScope;
        this.m_source = source;
        this.m_createIssues = createIssues;
    }

    protected void unresolvedName(String name, int line) {
        if (this.m_createIssues && !INTERNAL_NAMES.contains(name) && !this.m_source.isExternal()) {
            LOGGER.warn("Cannot resolve '" + name + "'", (Object)line);
        }
    }

    protected NamedElement getFromObject() {
        NamedElement fromObject = this.m_currentScope.getModelObject();
        Scope scope = this.m_currentScope.getParent();
        while (fromObject == null && scope != null) {
            fromObject = scope.getModelObject();
            scope = scope.getParent();
        }
        return fromObject;
    }
}

