/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonMethod;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;

class ScopeItem {
    private final NamedElement m_modelObject;
    private final String m_name;
    private final int m_line;
    private ScopeItem m_parentScope;
    private ITypeHint m_typeHint = null;

    protected ScopeItem(ScopeItem parentScope, NamedElement modelObject) {
        assert (modelObject != null) : "Parameter 'modelObject' of method 'Scope' must not be null";
        this.m_name = modelObject.getShortName();
        this.m_parentScope = parentScope;
        this.m_modelObject = modelObject;
        this.m_line = modelObject.getLineNumber();
    }

    protected ScopeItem(ScopeItem parentScope, String name, int line) {
        assert (parentScope != null) : "Parameter 'parentScope' of method 'ScopeItem' must not be null";
        assert (name != null) : "Parameter 'name' of method 'ScopeItem' must not be null";
        this.m_parentScope = parentScope;
        this.m_name = name;
        this.m_modelObject = null;
        this.m_line = line;
    }

    protected ScopeItem(String name, ScopeItem parentScope, NamedElement modelObject) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'Scope' must not be empty";
        assert (modelObject != null) : "Parameter 'modelObject' of method 'Scope' must not be null";
        this.m_name = name;
        this.m_parentScope = parentScope;
        this.m_modelObject = modelObject;
        this.m_line = modelObject.getLineNumber();
    }

    final void setParent(ScopeItem parent) {
        assert (parent != null) : "Parameter 'parent' of method 'setParent' must not be null";
        this.m_parentScope = parent;
    }

    final String getName() {
        return this.m_name;
    }

    final int getLine() {
        return this.m_line;
    }

    final ITypeHint getTypeHint() {
        return this.m_typeHint;
    }

    final void setTypeHint(ITypeHint typeHint) {
        this.m_typeHint = typeHint;
    }

    final NamedElement getModelObject() {
        return this.m_modelObject == null ? this.m_parentScope.getModelObject() : this.m_modelObject;
    }

    final boolean isPackage() {
        return this.m_modelObject instanceof GenericPackage;
    }

    final boolean isPythonModule() {
        return this.m_modelObject instanceof PythonSourceFile;
    }

    final boolean isMethodScope() {
        return this.getModelObject() instanceof PythonMethod;
    }

    final boolean isFunctionScope() {
        return this.m_modelObject == null ? this.m_parentScope.isFunctionScope() : this.m_modelObject instanceof IRoutine;
    }

    final boolean isClassScope() {
        return this.getModelObject() instanceof IType;
    }

    ScopeItem getParent() {
        return this.m_parentScope;
    }

    PythonSourceFile getSourceFile() {
        return this.m_parentScope == null ? null : this.m_parentScope.getSourceFile();
    }

    public String toString() {
        return "ScopeItem [m_modelObject=" + this.m_modelObject.getClass().getName() + ", m_name=" + this.m_name + ", m_line=" + this.m_line + "]";
    }

    public static interface ITypeHint {
        public ScopeItem getScope();
    }
}

