/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ScopeItem;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Scope
extends ScopeItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scope.class);
    private final Set<String> m_nonLocals = new THashSet();
    private final Set<String> m_globals = new THashSet();
    private final MapWrapper m_definitions;
    private final boolean m_isSourceScope;
    private int m_numberOfStatements = 0;
    private int m_ccn = 1;
    private int m_andOrCount = 0;
    private boolean m_finished = false;

    private Scope(String name, Scope parentScope, NamedElement modelObject, MapWrapper defs) {
        super(name, parentScope, modelObject);
        this.m_definitions = defs;
        this.m_isSourceScope = modelObject instanceof PythonSourceFile;
    }

    Scope(Scope parentScope, NamedElement modelObject) {
        this(modelObject.getShortName(), parentScope, modelObject, new MapWrapper());
    }

    Scope(String name, Scope parentScope, NamedElement modelObject) {
        this(name, parentScope, modelObject, new MapWrapper());
    }

    Scope(Scope parentScope, NamedElement modelObject, Scope sharedScope, boolean addToParent) {
        this(modelObject.getShortName(), parentScope, modelObject, sharedScope == null ? new MapWrapper() : sharedScope.m_definitions);
        if (addToParent) {
            this.getParent().m_definitions.put(modelObject.getShortName(), this);
        }
    }

    Scope(Scope parentScope) {
        super(parentScope, "", -1);
        this.m_definitions = new MapWrapper();
        this.m_isSourceScope = false;
    }

    final Scope addScope(String name, NamedElement modelObject) {
        assert (modelObject != null) : "Parameter 'modelObject' of method 'addScope' must not be null";
        Scope newScope = name.equals("__init__") && modelObject instanceof SourceFile && this.isPackage() ? new Scope(name, this, modelObject, this.m_definitions) : new Scope(name, this, modelObject);
        this.m_definitions.put(name, newScope);
        return newScope;
    }

    @Override
    final PythonSourceFile getSourceFile() {
        if (this.m_isSourceScope) {
            return (PythonSourceFile)this.getModelObject();
        }
        return super.getSourceFile();
    }

    final ScopeItem addItem(NamedElement modelObject) {
        assert (modelObject != null) : "Parameter 'modelObject' of method 'addItem' must not be null";
        String name = modelObject.getShortName();
        ScopeItem newItem = new ScopeItem(this, modelObject);
        this.m_definitions.put(name, newItem);
        return newItem;
    }

    final void addChild(ScopeItem scope) {
        assert (scope != null) : "Parameter 'scope' of method 'addChild' must not be null";
        this.m_definitions.put(scope.getName(), scope);
    }

    final void importScopeItem(String name, ScopeItem imported) {
        assert (imported != null) : "Parameter 'imported' of method 'importScope' must not be null";
        this.m_definitions.put(name, imported);
    }

    final void addNonlocalName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addNonlocalName' must not be empty";
        this.m_nonLocals.add(name);
    }

    final void addGlobalName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addGlobalName' must not be empty";
        this.m_globals.add(name);
    }

    @Override
    public Scope getParent() {
        return (Scope)super.getParent();
    }

    final boolean hasDefinitionFor(String name) {
        return this.m_definitions.get(name) != null;
    }

    final ScopeItem lookupLocal(String name) {
        return (ScopeItem)this.m_definitions.get(name);
    }

    ScopeItem lookupMember(String name, PythonSourceFile source, int line, boolean fromFunctionBody) {
        return this.lookup(name, source, line, fromFunctionBody);
    }

    ScopeItem lookup(String name, PythonSourceFile source, int line, boolean fromFunctionBody) {
        ScopeItem result = (ScopeItem)this.m_definitions.get(name);
        Scope parent = this.getParent();
        if (result == null) {
            if (parent != null) {
                result = parent.lookup(name, source, line, fromFunctionBody);
            }
        } else if (!fromFunctionBody && result.getModelObject() != null && result.getSourceFile() == source && result.getModelObject().getLineNumber() > line) {
            result = null;
            if (parent != null) {
                result = parent.lookup(name, source, line, fromFunctionBody);
            }
        }
        return result;
    }

    final boolean isGlobalName(String name) {
        return this.m_globals.contains(name);
    }

    final boolean isNonlocalName(String name) {
        return this.m_nonLocals.contains(name);
    }

    final void removeEntry(String name) {
        this.m_definitions.remove(name);
    }

    final void importAllFrom(IWorkerContext workerContext, Scope module, int importLine) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importAllFrom' must not be null";
        assert (module != null) : "Parameter 'module' of method 'importAllFrom' must not be null";
        NamedElement from = this.getModelObject();
        for (String name : module.m_definitions.keySet()) {
            ScopeItem target;
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            if (name.startsWith("__") || (target = module.lookupLocal(name)) == null) continue;
            this.m_definitions.remove(name);
            DependencyCreator.createDependency(from, target.getModelObject(), PythonDependencyType.IMPORT, importLine);
            this.m_definitions.put(name, target);
        }
    }

    final ScopeItem addLocalName(String name, int line) {
        ScopeItem result = new ScopeItem(this, name, line);
        this.m_definitions.put(name, result);
        return result;
    }

    Scope getInstanceScope() {
        return this;
    }

    final void incrementNumberOfStatements() {
        if (this.getModelObject() == null) {
            this.getParent().incrementNumberOfStatements();
        } else {
            ++this.m_numberOfStatements;
        }
    }

    final int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    final void incrementCcn() {
        if (this.getModelObject() == null) {
            this.getParent().incrementNumberOfStatements();
        } else {
            ++this.m_ccn;
        }
    }

    final int getCcn() {
        return this.m_ccn;
    }

    final void incrementAndOrCount() {
        if (this.getModelObject() == null) {
            this.getParent().incrementNumberOfStatements();
        } else {
            ++this.m_andOrCount;
        }
    }

    final int getAndOrCount() {
        return this.m_andOrCount;
    }

    final void parsingFinished() {
        this.m_finished = true;
    }

    final boolean hasBeenParsed() {
        return this.m_finished;
    }

    private static class MapWrapper
    extends THashMap<String, ScopeItem> {
        private MapWrapper() {
        }

        public ScopeItem put(String key, ScopeItem value) {
            ScopeItem prev = (ScopeItem)super.put((Object)key, (Object)value);
            if (prev != null) {
                PythonSourceFile source = value.getSourceFile();
                if (!source.isExternal()) {
                    LOGGER.debug(String.format("Redefinition of '%s' (%s: %d)", key, value.getSourceFile().getName(), value.getLine()));
                }
                super.put((Object)key, (Object)prev);
            }
            return prev;
        }
    }
}

