/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.python.model.workspace.PythonModuleType;
import de.schlichtherle.truezip.file.TFile;

public final class PythonWorkspaceExtension
extends Extension {
    private final SoftwareSystem m_softwareSystem;

    public PythonWorkspaceExtension(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'PythonWorkspaceExtension' must not be null";
        this.m_softwareSystem = system;
    }

    public void initPythonSystem(IWorkerContext workerContext, OperationResult result, TFile rootDirectory, TFile interpreterPath, boolean forceSkeletonGeneration) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initPythonSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initPythonSystem' must not be null";
        assert (rootDirectory != null) : "Parameter 'rootDirectory' of method 'initPythonSystem' must not be null";
        WorkspaceExtension wsExt = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        OperationResultWithOutcome moduleResult = wsExt.createModule(workerContext, (Module.IModuleType)PythonModuleType.PYTHON_MANUAL_MODULE, this.m_softwareSystem.getName(), "");
        if (moduleResult.isFailure()) {
            result.addMessagesFrom((OperationResult)moduleResult);
            return;
        }
        Module module = (Module)moduleResult.getOutcome();
        GenericRootDirectory root = new GenericRootDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)module, rootDirectory.getNormalizedAbsoluteFile());
        module.addChild((NamedElement)root);
        if (interpreterPath != null) {
            PythonSettingsExtension settingsExt = (PythonSettingsExtension)((ISoftwareSystemProvider)this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(PythonSettingsExtension.class);
            settingsExt.setSystemInterpreterPath(workerContext, this.m_softwareSystem, interpreterPath.getNormalizedAbsolutePath(), forceSkeletonGeneration);
        }
    }
}

