/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.PythonCommandId;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.PythonWorkspaceExtension;
import de.schlichtherle.truezip.file.TFile;

public class CreatePythonSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    public static final ICommandId ID = PythonCommandId.CREATE_SOFTWARE_SYSTEM;
    private final IInteraction m_interaction;

    public CreatePythonSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreatePythonSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return ID;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        PythonSystemData data = new PythonSystemData();
        if (!this.m_interaction.collectSystemData(data)) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            return;
        }
        SoftwareSystem system = this.getController().getSoftwareSystem();
        PythonWorkspaceExtension wsExt = (PythonWorkspaceExtension)system.getExtension(PythonWorkspaceExtension.class);
        OperationResult result = new OperationResult("Initializing Python System");
        wsExt.initPythonSystem(workerContext, result, data.getRootDirectory(), data.getInterpreterPath(), data.isForceSkeletonGeneration());
        if (!result.isFailure()) {
            OperationResult saveResult = this.getController().saveSoftwareSystem();
            result.addMessagesFrom(saveResult);
        }
        if (result.isFailure()) {
            this.m_interaction.processResult(result);
        }
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collectSystemData(PythonSystemData var1);

        public void processResult(OperationResult var1);
    }

    public static class PythonSystemData
    implements ICommandInteractionData {
        private TFile m_rootDirectory;
        private TFile m_interpreterPath;
        private boolean m_forceSkeletonGeneration;

        public TFile getRootDirectory() {
            return this.m_rootDirectory;
        }

        public void setRootDirectory(TFile rootDirectory) {
            this.m_rootDirectory = rootDirectory;
        }

        public TFile getInterpreterPath() {
            return this.m_interpreterPath;
        }

        public void setInterpreterPath(TFile virtualEnvironment) {
            this.m_interpreterPath = virtualEnvironment;
        }

        public boolean isForceSkeletonGeneration() {
            return this.m_forceSkeletonGeneration;
        }

        public void setForceSkeletonGeneration(boolean forceSkeletonGeneration) {
            this.m_forceSkeletonGeneration = forceSkeletonGeneration;
        }
    }
}

