/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.ErrorMessage;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JavaFileParseResult {
    private final List<JavaElement> m_topLevelElements = new ArrayList<JavaElement>();
    private final List<ErrorMessage> m_errorMessages = new ArrayList<ErrorMessage>();
    private final List<StrictPair<String, Position>> m_missingClassFiles = new ArrayList<StrictPair<String, Position>>();
    private String m_packageName = "";
    private String m_relativeFilePath = "";
    private String m_isDuplicate;

    public JavaFileParseResult() {
        this.reset();
    }

    public void reset() {
        this.m_topLevelElements.clear();
        this.m_errorMessages.clear();
        this.m_missingClassFiles.clear();
        this.m_packageName = "";
        this.m_relativeFilePath = "";
        this.m_isDuplicate = "";
    }

    public void addTopLevelElement(JavaElement type) {
        assert (type != null) : "Parameter 'type' of method 'addType' must not be null";
        assert (!this.m_topLevelElements.contains(type)) : "Already added: " + String.valueOf(type);
        this.m_topLevelElements.add(type);
    }

    public List<JavaElement> getTopLevelElements() {
        return Collections.unmodifiableList(this.m_topLevelElements);
    }

    public boolean hasTopLevelElements() {
        return this.m_topLevelElements.size() > 0;
    }

    public void setPackageName(String packageName) {
        assert (packageName != null) : "Parameter 'packageName' of method 'setPackageName' must not be null";
        this.m_packageName = packageName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public void setRelativeFilePath(String relativePath) {
        assert (relativePath != null && relativePath.length() > 0) : "Parameter 'relativePath' of method 'setRelativeFilePath' must not be empty";
        this.m_relativeFilePath = relativePath;
    }

    public String getRelativeFilePath() {
        assert (this.m_relativeFilePath != null && this.m_relativeFilePath.length() > 0) : "'m_relativeFilePath' of method 'getRelativeFilePath' must not be empty";
        return this.m_relativeFilePath;
    }

    public String isDuplicate() {
        return this.m_isDuplicate;
    }

    public void setIsDuplicate(String isDuplicate) {
        assert (isDuplicate != null) : "Parameter 'isDuplicate' of method 'setIsDuplicate' must not be null";
        this.m_isDuplicate = isDuplicate;
    }

    public void noClassFileFound(String message, Position pos) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'noClassFileFound' must not be empty";
        assert (pos != null) : "Parameter 'pos' of method 'noClassFileFound' must not be null";
        this.m_missingClassFiles.add((StrictPair<String, Position>)new StrictPair((Object)message, (Object)pos));
    }

    public boolean hasMissingClassFiles() {
        return !this.m_missingClassFiles.isEmpty();
    }

    public List<StrictPair<String, Position>> getNoClassFilesFound() {
        return Collections.unmodifiableList(this.m_missingClassFiles);
    }

    public void addErrorMessage(String message, int line, int column) {
        this.m_errorMessages.add(new ErrorMessage(message, line, column));
    }

    public boolean hasErrorMessages() {
        return this.m_errorMessages.size() > 0;
    }

    public List<ErrorMessage> getErrorMessages() {
        return Collections.unmodifiableList(this.m_errorMessages);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ErrorMessage next : this.m_errorMessages) {
            builder.append(next.toString());
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - StringUtility.LINE_SEPARATOR.length(), builder.length() - 1);
        }
        return builder.toString();
    }
}

