/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameContributor;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JavaInternalCompilationUnit
extends JavaCompilationUnit
implements IRefactorable {
    public JavaInternalCompilationUnit(NamedElement parent) {
        super(parent);
    }

    public JavaInternalCompilationUnit(IModelServiceProvider msp, NamedElement parent, String path) {
        super(msp, parent, path);
    }

    public String getPresentationKind() {
        return "Java Internal Component";
    }

    public NamedElement getOriginal() {
        return super.getOriginal(this.getModelServiceProvider());
    }

    public NamedElement getRepresentative() {
        return super.getRepresentative(this.getModelServiceProvider());
    }

    public List<NamedElement> getChildren() {
        return super.getChildren(this.getModelServiceProvider());
    }

    public String getOriginalName() {
        PhysicalRecursiveElement physicalRecursiveElement = (PhysicalRecursiveElement)this.getOriginalParent(PhysicalRecursiveElement.class);
        if (physicalRecursiveElement != null) {
            return "./" + physicalRecursiveElement.getName().replace('.', '/') + "/" + super.getShortName();
        }
        return "./" + this.getOriginalShortName();
    }

    public String getName() {
        PhysicalRecursiveElement physicalRecursiveElement = (PhysicalRecursiveElement)this.getParent(PhysicalRecursiveElement.class, new Class[0]);
        if (physicalRecursiveElement != null) {
            return "./" + physicalRecursiveElement.getName().replace('.', '/') + "/" + this.getShortName();
        }
        return "./" + this.getShortName();
    }

    public NamedElement getParent() {
        return super.getParent(this.getModelServiceProvider());
    }

    public List<JavaClassFile> getPrimaryClassFiles() {
        ArrayList<JavaClassFile> primaryClassFiles = new ArrayList<JavaClassFile>();
        for (JavaType nextType : this.getChildrenRecursively(JavaType.class, new Class[0])) {
            JavaClassFile javaClassFile = (JavaClassFile)((Object)nextType.getFirstChild(JavaClassFile.class));
            if (javaClassFile == null) continue;
            primaryClassFiles.add(javaClassFile);
        }
        return primaryClassFiles;
    }

    public JavaSourceFile getPrimarySourceFile() {
        return (JavaSourceFile)((Object)this.getFirstChild(JavaSourceFile.class));
    }

    public FilePath getPhysicalFilePath() {
        return this.getPrimarySourceFile();
    }

    public int getSize() {
        int size = 0;
        for (JavaType nextType : this.getChildrenRecursively(JavaType.class, new Class[0])) {
            JavaClassFile javaClassFile = (JavaClassFile)((Object)nextType.getFirstChild(JavaClassFile.class));
            if (javaClassFile == null) continue;
            size += javaClassFile.getSize();
        }
        return size;
    }

    @Property
    public String getWorkspaceFilterName() {
        JavaInternalCompilationUnit original;
        IModelServiceProvider modelServiceProvider = this.getModelServiceProvider();
        JavaInternalCompilationUnit javaInternalCompilationUnit = original = modelServiceProvider != null ? (JavaInternalCompilationUnit)modelServiceProvider.getCurrentModel().getOriginal((ElementWithIssues)this) : this;
        assert (original != null) : "'original' of method 'getWorkspaceFilterName' must not be null";
        IWorkspaceFilterNamePrefixProvider provider = (IWorkspaceFilterNamePrefixProvider)original.getParent(IWorkspaceFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getWorkspaceFilterName' must not be null";
        return provider.getWorkspaceFilterNamePrefix() + FileUtility.removeExtension((String)original.getName()).substring("./".length());
    }

    public String getArchitectureFilterName() {
        IArchitectureFilterNamePrefixProvider provider = (IArchitectureFilterNamePrefixProvider)this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "Parameter 'provider' of method 'getArchitectureFilterName' must not be null";
        IArchitectureFilterNameContributor contributor = (IArchitectureFilterNameContributor)this.getParent(IArchitectureFilterNameContributor.class, new Class[0]);
        return provider.getArchitectureFilterNamePrefix() + (contributor != null ? contributor.getArchitectureFilterNamePart() : "") + FileUtility.removeExtension((String)this.getShortName());
    }

    public IBaseDirectory getBaseDirectory() {
        JavaSourceFile sourceFile = this.getPrimarySourceFile();
        if (sourceFile != null) {
            return sourceFile.getBaseDirectory();
        }
        return super.getBaseDirectory();
    }

    public TFile getFile() {
        List sourceFiles = this.getChildren(JavaSourceFile.class);
        if (sourceFiles.size() > 0) {
            return ((JavaSourceFile)((Object)sourceFiles.get(0))).getFile();
        }
        return null;
    }

    public List<SourceFile> getSources() {
        return Collections.singletonList(this);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaInternalCompilationUnit(this);
        } else {
            super.accept(visitor);
        }
    }

    public String toString() {
        IModelServiceProvider modelServiceProvider = this.getModelServiceProvider();
        if (modelServiceProvider != null && modelServiceProvider.getCurrentModel().getOriginal((ElementWithIssues)this) != this) {
            StringBuilder builder = new StringBuilder("[Clone] ");
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaInternalCompilationUnit(JavaInternalCompilationUnit var1);
    }
}

