/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.LongBitFieldUtil;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaLanguage;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaStructureItem;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.IJavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.HasAnnotationDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class JavaElement
extends ProgrammingElement
implements IJavaElement {
    private ArrayList<NamedElement> m_children;
    private String m_signature;
    private long m_flags;

    protected JavaElement(NamedElement parent) {
        super(parent);
    }

    protected JavaElement(IModelServiceProvider msp, NamedElement parent, String name) {
        super(msp, parent, name);
    }

    public String getFullyQualifiedNamePart() {
        String fqNamePart = super.getFullyQualifiedNamePart();
        NamedElement parent = this.getParent();
        if (parent != null && parent.isGhost()) {
            return parent.getFullyQualifiedNamePart() + Element.INNER_NAME_PARTS_SEPARATOR + fqNamePart;
        }
        return fqNamePart;
    }

    public void aboutToReparse() {
    }

    protected final ArrayList<NamedElement> getModifiableChildrenList() {
        return this.m_children;
    }

    protected final void setModifiableChildrenList(ArrayList<NamedElement> children) {
        this.m_children = children;
    }

    public final <T extends JavaElement> Iterator<T> getChildrenIterator(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'name' of method 'getChildrenIterator' must not be null";
        if (this.m_children != null && !this.m_children.isEmpty()) {
            return new JavaElementIterator<T>(clazz, this.m_children.iterator());
        }
        return Collections.emptyIterator();
    }

    public final List<Annotation> getAnnotations() {
        return this.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.HAS_ANNOTATION}).stream().map(d -> (HasAnnotationDependencyWithContext)((Object)d)).filter(d -> d.getAnnotation() != null).map(d -> d.getAnnotation()).collect(Collectors.toList());
    }

    public final boolean isGhost() {
        return this.hasFlag(JavaElementFlag.GHOST);
    }

    public final boolean isBridge() {
        return this.hasFlag(JavaElementFlag.BRIDGE);
    }

    public final boolean isSynthetic() {
        return this.hasFlag(JavaElementFlag.SYNTHETIC);
    }

    public final Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_signature = reader.readString();
        if (this.m_signature != null) {
            this.m_signature = this.m_signature.intern();
        }
        this.m_flags = reader.getVersion() < 13 ? (long)reader.readInt() : reader.readLong();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
        writer.writeLong(this.m_flags);
    }

    public final void resetFlagsExceptKeep() {
        this.m_flags &= 1L << JavaElementFlag.KEEP.ordinal();
    }

    public final void addFlag(JavaElementFlag flag) {
        assert (flag != null) : "Parameter 'flag' of method 'addFlag' must not be null";
        this.m_flags = LongBitFieldUtil.enableFlag((long)this.m_flags, (long)(1L << flag.ordinal()));
    }

    public final void removeFlag(JavaElementFlag flag) {
        assert (flag != null) : "Parameter 'flag' of method 'removeFlag' must not be null";
        this.m_flags = LongBitFieldUtil.disableFlag((long)this.m_flags, (long)(1L << flag.ordinal()));
    }

    @Override
    public final boolean hasFlag(JavaElementFlag flag) {
        assert (flag != null) : "Parameter 'flag' of method 'hasFlag' must not be null";
        return LongBitFieldUtil.isFlagEnabled((long)this.m_flags, (long)(1L << flag.ordinal()));
    }

    protected final String getParentName(Function<NamedElement, String> f) {
        assert (f != null) : "Parameter 'f' of method 'getParentName' must not be null";
        ProgrammingElement parent = (ProgrammingElement)super.getParent(ProgrammingElement.class, new Class[0]);
        if (parent != null) {
            return f.apply((NamedElement)parent);
        }
        PhysicalRecursiveElement physicalRecursiveElement = (PhysicalRecursiveElement)this.getParent(PhysicalRecursiveElement.class, new Class[0]);
        if (physicalRecursiveElement != null) {
            return f.apply((NamedElement)physicalRecursiveElement);
        }
        return null;
    }

    public boolean isExternal() {
        return this.hasFlag(JavaElementFlag.EXTERNAL);
    }

    public final boolean isDefinedInEnclosingElement() {
        return !this.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
    }

    public final void setSignature(String signature) {
        this.m_signature = signature == null ? signature : signature.intern();
    }

    @Property
    public final String getSignature() {
        return this.m_signature;
    }

    @Property
    public final boolean isClass() {
        return this.hasFlag(JavaElementFlag.CLASS);
    }

    @Property
    public final boolean isInterface() {
        return this.hasFlag(JavaElementFlag.INTERFACE);
    }

    @Property
    public final boolean isAnnotation() {
        return this.hasFlag(JavaElementFlag.ANNOTATION);
    }

    @Property
    public final boolean isEnum() {
        return this.hasFlag(JavaElementFlag.ENUM);
    }

    @Property
    public final boolean isStatic() {
        return this.hasFlag(JavaElementFlag.STATIC);
    }

    @Property
    public final boolean isFinal() {
        return this.hasFlag(JavaElementFlag.FINAL);
    }

    @Property
    public final boolean isAbstract() {
        return this.hasFlag(JavaElementFlag.ABSTRACT) || this.hasFlag(JavaElementFlag.INTERFACE) || this.hasFlag(JavaElementFlag.ANNOTATION);
    }

    @Override
    @Property
    public boolean isNested() {
        return this.hasFlag(JavaElementFlag.NESTED);
    }

    @Property
    public boolean isInner() {
        return this.hasFlag(JavaElementFlag.INNER);
    }

    @Property
    public boolean isAnonymous() {
        return this.hasFlag(JavaElementFlag.ANONYMOUS);
    }

    @Property
    public boolean isGeneric() {
        return this.hasFlag(JavaElementFlag.GENERIC);
    }

    @Property
    public boolean isNative() {
        return this.hasFlag(JavaElementFlag.NATIVE);
    }

    @Property
    public boolean isSynchronized() {
        return this.hasFlag(JavaElementFlag.SYNCHRONIZED);
    }

    @Property
    public boolean isVolatile() {
        return this.hasFlag(JavaElementFlag.VOLATILE);
    }

    @Property
    public boolean isTransient() {
        return this.hasFlag(JavaElementFlag.TRANSIENT);
    }

    @Property
    public final boolean isPublic() {
        return this.hasFlag(JavaElementFlag.PUBLIC);
    }

    @Property
    public final boolean isPrivate() {
        return this.hasFlag(JavaElementFlag.PRIVATE);
    }

    @Property
    public final boolean isProtected() {
        return this.hasFlag(JavaElementFlag.PROTECTED);
    }

    @Property
    public final boolean isDeprecated() {
        return this.hasFlag(JavaElementFlag.DEPRECATED);
    }

    @Property
    public final boolean isCompilerGenerated() {
        return this.hasFlag(JavaElementFlag.COMPILER_GENERATED);
    }

    @Property
    public final boolean isRecord() {
        return this.hasFlag(JavaElementFlag.RECORD);
    }

    @Property
    public final boolean isSealed() {
        return this.hasFlag(JavaElementFlag.SEALED);
    }

    @Property
    public final boolean isNonsealed() {
        return this.hasFlag(JavaElementFlag.NONSEALED);
    }

    public IStructureItem getStructureItem() {
        return JavaStructureItem.PROGRAMMING_ELEMENT;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        if (this.m_signature != null) {
            builder.append("\n");
            builder.append("Signature: ");
            builder.append(this.m_signature);
        }
        JavaElementFlag[] javaElementFlagArray = JavaElementFlag.values();
        int n = javaElementFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaElementFlag nextFlag = javaElementFlagArray[n2];
            if (this.hasFlag(nextFlag)) {
                builder.append("\n").append("Flag: ").append(nextFlag.getStandardName());
            }
            ++n2;
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        JavaElementFlag[] javaElementFlagArray = JavaElementFlag.values();
        int n = javaElementFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaElementFlag nextFlag = javaElementFlagArray[n2];
            if (this.hasFlag(nextFlag)) {
                builder.append("\n").append("Flag: ").append(nextFlag.getStandardName());
            }
            ++n2;
        }
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaElement(JavaElement var1);
    }

    static final class JavaElementIterator<T extends JavaElement>
    implements Iterator<T> {
        private final Class<T> m_class;
        private final Iterator<NamedElement> m_iterator;
        private T m_next;

        JavaElementIterator(Class<T> clazz, Iterator<NamedElement> iterator) {
            assert (clazz != null) : "Parameter 'clazz' of method 'JavaElementIterator' must not be null";
            assert (iterator != null) : "Parameter 'iterator' of method 'JavaElementIterator' must not be null";
            this.m_class = clazz;
            this.m_iterator = iterator;
            this.setNext();
        }

        private void setNext() {
            this.m_next = null;
            while (this.m_iterator.hasNext() && this.m_next == null) {
                NamedElement next = this.m_iterator.next();
                if (!this.m_class.isAssignableFrom(next.getClass())) continue;
                this.m_next = (JavaElement)next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        @Override
        public T next() {
            assert (this.m_next != null) : "'m_next' of method 'next' must not be null";
            T next = this.m_next;
            this.setNext();
            return next;
        }
    }
}

