/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile;

import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import org.objectweb.asm.Opcodes;

final class AsmAccessFlagMapper
implements Opcodes {
    private AsmAccessFlagMapper() {
    }

    static void setElementFlags(int accessFlags, JavaElement element) {
        boolean isAbstract;
        assert (element != null) : "Parameter 'element' of method 'retrieveElementFlags' must not be null";
        if ((accessFlags & 1) != 0) {
            element.removeFlag(JavaElementFlag.PRIVATE);
            element.removeFlag(JavaElementFlag.PROTECTED);
            element.addFlag(JavaElementFlag.PUBLIC);
        } else if ((accessFlags & 4) != 0) {
            element.removeFlag(JavaElementFlag.PRIVATE);
            element.removeFlag(JavaElementFlag.PUBLIC);
            element.addFlag(JavaElementFlag.PROTECTED);
        } else if ((accessFlags & 2) != 0) {
            element.removeFlag(JavaElementFlag.PUBLIC);
            element.removeFlag(JavaElementFlag.PROTECTED);
            element.addFlag(JavaElementFlag.PRIVATE);
        } else {
            element.removeFlag(JavaElementFlag.PUBLIC);
            element.removeFlag(JavaElementFlag.PROTECTED);
            element.removeFlag(JavaElementFlag.PRIVATE);
        }
        boolean bl = isAbstract = (accessFlags & 0x400) != 0;
        if ((accessFlags & 0x200) != 0 || (accessFlags & 0x2000) != 0) {
            element.addFlag(JavaElementFlag.INTERFACE);
            if ((accessFlags & 0x2000) != 0) {
                element.addFlag(JavaElementFlag.ANNOTATION);
            }
            isAbstract = true;
        } else if ((accessFlags & 0x4000) != 0) {
            element.addFlag(JavaElementFlag.ENUM);
        } else if ((accessFlags & 0x10000) != 0) {
            element.addFlag(JavaElementFlag.RECORD);
        } else if (element instanceof JavaType) {
            element.addFlag(JavaElementFlag.CLASS);
        }
        if (isAbstract) {
            element.addFlag(JavaElementFlag.ABSTRACT);
        }
        if ((accessFlags & 8) != 0) {
            element.addFlag(JavaElementFlag.STATIC);
        }
        if ((accessFlags & 0x10) != 0) {
            element.addFlag(JavaElementFlag.FINAL);
        }
        if (element instanceof JavaMethod && (accessFlags & 0x20) != 0) {
            element.addFlag(JavaElementFlag.SYNCHRONIZED);
        }
        if ((accessFlags & 0x40) != 0) {
            element.addFlag(JavaElementFlag.VOLATILE);
        }
        if ((accessFlags & 0x80) != 0) {
            element.addFlag(JavaElementFlag.TRANSIENT);
        }
        if ((accessFlags & 0x100) != 0) {
            element.addFlag(JavaElementFlag.NATIVE);
        }
        if ((accessFlags & 0x1000) != 0) {
            element.addFlag(JavaElementFlag.SYNTHETIC);
        }
        if ((accessFlags & 0x40) != 0) {
            element.addFlag(JavaElementFlag.BRIDGE);
        }
        if ((accessFlags & 0x20000) != 0) {
            element.addFlag(JavaElementFlag.DEPRECATED);
        }
    }
}

