/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;

public abstract class NonInlineDependencyProcessor
extends DependencyProcessor {
    private final JavaElement m_from;
    private final int m_line;
    private final JavaDependencyContext m_context;
    private final JavaDependencyType m_type;
    private final JavaModule m_fromModule;
    private final String m_toFqTypeName;
    private JavaElementFlag[] m_flags = new JavaElementFlag[0];

    public NonInlineDependencyProcessor(JavaElement from, int line, JavaDependencyContext context, JavaDependencyType type, JavaModule fromModule, String toFqTypeName) {
        assert (from != null) : "Parameter 'from' of method 'NonInlineDependencyProcessor' must not be null";
        assert (type != null) : "Parameter 'type' of method 'NonInlineDependencyProcessor' must not be null";
        assert (fromModule != null) : "Parameter 'fromModule' of method 'NonInlineDependencyProcessor' must not be null";
        assert (toFqTypeName != null && toFqTypeName.length() > 0) : "Parameter 'toFqTypeName' of method 'NonInlineDependencyProcessor' must not be empty";
        this.m_from = from;
        this.m_line = line;
        this.m_context = context;
        this.m_type = type;
        this.m_fromModule = fromModule;
        this.m_toFqTypeName = toFqTypeName.intern();
    }

    protected final JavaElement getFrom() {
        return this.m_from;
    }

    public final int getLine() {
        return this.m_line;
    }

    protected final JavaDependencyContext getContext() {
        return this.m_context;
    }

    public final JavaDependencyType getType() {
        return this.m_type;
    }

    public final void setTargetElementFlags(JavaElementFlag ... flags) {
        assert (flags != null) : "Parameter 'flags' of method 'setTargetElementFlags' must not be null";
        this.m_flags = flags;
    }

    public String getToFqTypeName() {
        return this.m_toFqTypeName;
    }

    protected final void addTargetElementFlags(JavaElement element) {
        assert (element != null) : "Parameter 'element' of method 'addTargetElementFlags' must not be null";
        JavaElementFlag[] javaElementFlagArray = this.m_flags;
        int n = this.m_flags.length;
        int n2 = 0;
        while (n2 < n) {
            JavaElementFlag nextFlag = javaElementFlagArray[n2];
            element.addFlag(nextFlag);
            ++n2;
        }
    }

    protected final boolean dependencyAlreadyExists(JavaElement to) {
        assert (to != null) : "Parameter 'to' of method 'dependencyAlreadyExists' must not be null";
        return DependencyProcessor.dependencyAlreadyExists(this.m_from, to, this.m_context, this.m_type, this.m_line);
    }

    protected final JavaType getToType(IJavaElementAccessor accessor) {
        assert (accessor != null) : "Parameter 'accessor' of method 'getToType' must not be null";
        return NonInlineDependencyProcessor.getToType(accessor, this.m_fromModule, this.getFrom(), this.getLine(), this.m_toFqTypeName);
    }
}

