/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IKotlinProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.MethodProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaStaticBlock;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.KotlinGhostProxy;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class KotlinTypeProcessor
implements IKotlinProcessor {
    private static final Pattern m_deconstructorGetter = Pattern.compile("component(\\d+)");
    private final JavaType m_type;
    private final int m_maxLineNumber;

    public KotlinTypeProcessor(JavaType type, int maxLineNumber) {
        assert (type != null) : "Parameter 'type' of method 'TypeProcessor' must not be null";
        assert (type.hasFlag(JavaElementFlag.KOTLIN_TYPE)) : "Not a Kotlin type: " + type.getFqName();
        this.m_type = type;
        this.m_maxLineNumber = maxLineNumber;
    }

    private JavaConstructor getPrimaryConstructor(JavaType type) {
        return type.getChildren(JavaConstructor.class).stream().filter(c -> c.getLineNumber() > 0).findFirst().orElse(null);
    }

    private JavaConstructor getTargetConstructor(JavaConstructor constructor) {
        JavaConstructor target;
        assert (constructor != null) : "Parameter 'constructor' of method 'getTargetConstructor' must not be null";
        JavaType type = (JavaType)constructor.getParent(JavaType.class, new Class[0]);
        for (ParserDependency dep : constructor.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.CONSTRUCTOR_CALL})) {
            target = (JavaConstructor)dep.getTo();
            if (target.getParent() != type) continue;
            if (target.hasFlag(JavaElementFlag.SYNTHETIC)) {
                return this.getTargetConstructor(target);
            }
            constructor.removeDependency(dep);
            return target;
        }
        target = this.getPrimaryConstructor(type);
        if (target == null && constructor.getNumberOfParameters() == 0 && type.getLineNumber() > 0) {
            constructor.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            constructor.setLineNumber(type.getLineNumber());
            target = constructor;
        }
        return target;
    }

    private void processInitializer(JavaInitializer init) {
        JavaConstructor target;
        if (!(init.hasFlag(JavaElementFlag.FOUND_IN_SOURCE) || init.hasFlag(JavaElementFlag.SYNTHETIC) || init instanceof JavaStaticBlock || (target = this.getTargetConstructor((JavaConstructor)init)) == null)) {
            if (target != init) {
                init.addFlag(JavaElementFlag.GHOST);
                init.addChild(new KotlinGhostProxy((NamedElement)init, target, false));
            } else if (this.m_maxLineNumber > 0) {
                new MethodProcessor(target, this.m_maxLineNumber).process();
            }
        }
    }

    @Override
    public void process() {
        this.m_type.getChildren(JavaInitializer.class).forEach(init -> this.processInitializer((JavaInitializer)init));
        for (JavaMember element : this.m_type.getChildren(JavaMember.class)) {
            JavaMethod getter;
            List props;
            int oneBasedIndex;
            if (element.hasFlag(JavaElementFlag.FOUND_IN_SOURCE) || element.hasFlag(JavaElementFlag.GHOST)) continue;
            String name = element.getShortName();
            Matcher matcher = m_deconstructorGetter.matcher(name);
            if (element instanceof JavaMethod && matcher.matches() && !element.hasChildren(true, new Class[]{KotlinGhostProxy.class}) && (oneBasedIndex = Integer.valueOf(matcher.group(1)).intValue()) <= (props = this.m_type.getChildren(JavaField.class)).size() && (getter = (JavaMethod)((JavaField)props.get(oneBasedIndex - 1)).getFirstChild(e -> e.getShortName().equals("get"), JavaMethod.class)) != null) {
                element.addFlag(JavaElementFlag.GHOST);
                element.addChild(new KotlinGhostProxy((NamedElement)element, getter, true));
                continue;
            }
            assert (!element.hasChildren(false, new Class[]{JavaType.class}));
            element.remove();
        }
    }
}

