/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class AnonymousTypeInfo {
    private final Map<JavaMethod, List<Integer>> m_instantiatedInMethodToLine = new THashMap();
    private int m_lineNumberOfFirstInstructionInMethod = -1;

    public boolean addInstantiationInfo(JavaMethod method, int lineNumber) {
        assert (method != null) : "Parameter 'method' of method 'addInstantiationInfo' must not be null";
        assert (lineNumber > -1) : "Inavlid line in 'addInstantiationInfo': " + lineNumber;
        List<Integer> lineNumbers = this.m_instantiatedInMethodToLine.get(method);
        if (lineNumbers == null) {
            lineNumbers = new ArrayList<Integer>(2);
            lineNumbers.add(lineNumber);
            this.m_instantiatedInMethodToLine.put(method, lineNumbers);
            return true;
        }
        for (Integer nextLineNumber : lineNumbers) {
            if (lineNumber != nextLineNumber) continue;
            return false;
        }
        lineNumbers.add(lineNumber);
        return true;
    }

    public boolean hasInstantiationInfo() {
        return !this.m_instantiatedInMethodToLine.isEmpty();
    }

    public Map<JavaMethod, List<Integer>> getInstantiationInfo() {
        return Collections.unmodifiableMap(this.m_instantiatedInMethodToLine);
    }

    public void setLineNumberOfFirstInstructionInMethod(int lineNumber) {
        assert (lineNumber > -1) : "Inavlid line in 'setLineNumberOfFirstInstructionInMethod': " + lineNumber;
        assert (this.m_lineNumberOfFirstInstructionInMethod == -1) : "Line already set";
        this.m_lineNumberOfFirstInstructionInMethod = lineNumber;
    }

    public int getLineNumberOfFirstInstructionInMethod() {
        return this.m_lineNumberOfFirstInstructionInMethod;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<JavaMethod, List<Integer>> next : this.m_instantiatedInMethodToLine.entrySet()) {
            builder.append(next.getKey().getPresentationName(false));
            for (Integer nextLine : next.getValue()) {
                builder.append("\n\t").append(nextLine);
            }
        }
        return builder.toString();
    }
}

