/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModelHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModelProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaParserMessageCause;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.LocalVariableDefinitionSourceCode;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.LocalVariableInfo;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class LocalVariableInfoProcessor
extends JavaModelProcessor {
    private final List<LocalVariableDefinitionSourceCode> m_localVariableDefinitions = new ArrayList<LocalVariableDefinitionSourceCode>();
    private final Map<JavaMethod, Map<String, List<LocalVariableInfo>>> m_methodToLocVarNameToLocalVariableInfo = new THashMap();
    private final Map<Integer, LocalVariableInfo> m_endLineOfBlockToLocalVariableInfo = new TreeMap<Integer, LocalVariableInfo>();
    private final JavaIgnoreAccess m_ignoreAccess;

    LocalVariableInfoProcessor(IJavaElementAccessor elementAccessor, JavaGlobalModelHelper globalModelHelper, IWorkerContext workerContext, JavaIgnoreAccess ignoreAccess) {
        super(elementAccessor, globalModelHelper, workerContext);
        assert (ignoreAccess != null) : "Parameter 'ignoreAccess' of method 'LocalVariableInfoProcessor' must not be null";
        this.m_ignoreAccess = ignoreAccess;
    }

    void addLocalVariableInfo(JavaMethod javaMethod, String locVarName, LocalVariableInfo info) {
        List<LocalVariableInfo> localVariableInfo;
        assert (javaMethod != null) : "Parameter 'javaMethod' of method 'addLocalVariableRelatedDependencyInfo' must not be null";
        assert (locVarName != null && locVarName.length() > 0) : "Parameter 'locVarName' of method 'addLocalVariableRelatedDependencyInfo' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'addLocalVariableRelatedDependencyInfo' must not be null";
        THashMap locVarNameToLocalVariableInfo = this.m_methodToLocVarNameToLocalVariableInfo.get(javaMethod);
        if (locVarNameToLocalVariableInfo == null) {
            locVarNameToLocalVariableInfo = new THashMap();
            this.m_methodToLocVarNameToLocalVariableInfo.put(javaMethod, (Map<String, List<LocalVariableInfo>>)locVarNameToLocalVariableInfo);
        }
        if ((localVariableInfo = locVarNameToLocalVariableInfo.get(locVarName)) == null) {
            localVariableInfo = new ArrayList<LocalVariableInfo>();
            locVarNameToLocalVariableInfo.put(locVarName.intern(), localVariableInfo);
        }
        localVariableInfo.add(info);
    }

    void foundLocalVariable(JavaMethod method, String locVarName, int endLineOfBlock) {
        assert (method != null) : "Parameter 'method' of method 'foundLocalVariable' must not be null";
        assert (locVarName != null && locVarName.length() > 0) : "Parameter 'locVarName' of method 'foundLocalVariable' must not be empty";
        this.m_localVariableDefinitions.add(new LocalVariableDefinitionSourceCode(method, locVarName, endLineOfBlock));
    }

    boolean localVariableInfoAlreadyAdded(JavaMethod javaMethod, String locVarName, int endLineOfBlock) {
        List<LocalVariableInfo> localVariableInfo;
        assert (javaMethod != null) : "Parameter 'javaMethod' of method 'localVariableInfoAlreadyAdded' must not be null";
        assert (locVarName != null && locVarName.length() > 0) : "Parameter 'locVarName' of method 'localVariableInfoAlreadyAdded' must not be empty";
        Map<String, List<LocalVariableInfo>> locVarNameToLocalVariableInfo = this.m_methodToLocVarNameToLocalVariableInfo.get(javaMethod);
        if (locVarNameToLocalVariableInfo != null && (localVariableInfo = locVarNameToLocalVariableInfo.get(locVarName)) != null) {
            for (LocalVariableInfo nextLocalVariableInfo : localVariableInfo) {
                if (nextLocalVariableInfo.getEndLineOfBlock() != endLineOfBlock) continue;
                return true;
            }
        }
        return false;
    }

    void transferInfo(JavaMethod from, JavaMethod to) {
        assert (from != null) : "Parameter 'from' of method 'transferInfo' must not be null";
        assert (to != null) : "Parameter 'to' of method 'transferInfo' must not be null";
        assert (from != to) : "Same instances: " + String.valueOf(from);
        Map<String, List<LocalVariableInfo>> infoToTransfer = this.m_methodToLocVarNameToLocalVariableInfo.get(from);
        if (infoToTransfer != null) {
            Map<String, List<LocalVariableInfo>> extistingInfo = this.m_methodToLocVarNameToLocalVariableInfo.get(to);
            if (extistingInfo == null) {
                this.m_methodToLocVarNameToLocalVariableInfo.put(to, infoToTransfer);
            } else {
                for (Map.Entry<String, List<LocalVariableInfo>> nextEntryToTransfer : infoToTransfer.entrySet()) {
                    String nextLocVarName = nextEntryToTransfer.getKey();
                    List<LocalVariableInfo> localVariableInfo = extistingInfo.get(nextLocVarName);
                    if (localVariableInfo == null) {
                        localVariableInfo = new ArrayList<LocalVariableInfo>();
                        extistingInfo.put(nextLocVarName, localVariableInfo);
                    }
                    localVariableInfo.addAll((Collection<LocalVariableInfo>)nextEntryToTransfer.getValue());
                }
            }
        }
    }

    void process(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'process' must not be null";
        for (LocalVariableDefinitionSourceCode nextLocalVariableDefinition : this.m_localVariableDefinitions) {
            String nextLocVarName;
            List<LocalVariableInfo> localVariableInfo;
            Map<String, List<LocalVariableInfo>> locVarNameToInfo = this.m_methodToLocVarNameToLocalVariableInfo.get(nextLocalVariableDefinition.getMethod());
            if (locVarNameToInfo == null || (localVariableInfo = locVarNameToInfo.get(nextLocVarName = nextLocalVariableDefinition.getLocVarName())) == null) continue;
            int line = nextLocalVariableDefinition.getEndLineOfBlock();
            if (localVariableInfo.size() == 1) {
                for (LocalVariableInfo localVariableInfo2 : localVariableInfo) {
                    localVariableInfo2.setIsDeclaration(line);
                }
                continue;
            }
            for (LocalVariableInfo localVariableInfo3 : localVariableInfo) {
                int endLineOfBlock = localVariableInfo3.getEndLineOfBlock();
                this.m_endLineOfBlockToLocalVariableInfo.put(endLineOfBlock, localVariableInfo3);
            }
            for (Map.Entry entry : this.m_endLineOfBlockToLocalVariableInfo.entrySet()) {
                if (line > (Integer)entry.getKey()) continue;
                ((LocalVariableInfo)entry.getValue()).setIsDeclaration(line);
                break;
            }
            this.m_endLineOfBlockToLocalVariableInfo.clear();
        }
        if (!this.m_methodToLocVarNameToLocalVariableInfo.isEmpty()) {
            IWorkerContext workerContext = this.getWorkerContext();
            workerContext.working("Process local variable declarations", false);
            for (Map.Entry<JavaMethod, Map<String, List<LocalVariableInfo>>> nextEntry : this.m_methodToLocVarNameToLocalVariableInfo.entrySet()) {
                if (workerContext.hasBeenCanceled()) break;
                JavaMethod fromMethod = nextEntry.getKey();
                if (!fromMethod.isValid()) continue;
                for (Map.Entry<String, List<LocalVariableInfo>> nextLocVarNameToDependencyInfo : nextEntry.getValue().entrySet()) {
                    for (LocalVariableInfo localVariableInfo : nextLocVarNameToDependencyInfo.getValue()) {
                        if (!localVariableInfo.isDeclaration()) continue;
                        int line = localVariableInfo.getDeclarationLine();
                        if (!this.m_ignoreAccess.ignoreTypeAccess(null, JavaDependencyType.LOCAL_VARIABLE, localVariableInfo.getToTypeName())) {
                            try {
                                JavaType javaType = DependencyProcessor.getToType(this.getElementAccessor(), localVariableInfo.getModule(), fromMethod, line, localVariableInfo.getToTypeName());
                                if (javaType != null) {
                                    this.getModelHelper().addDependency(fromMethod, javaType, line, null, JavaDependencyType.LOCAL_VARIABLE);
                                }
                            }
                            catch (Throwable t) {
                                result.addError((OperationResult.IMessageCause)JavaParserMessageCause.LOCAL_VARIABLE_INFO_PROCESSOR_EXCEPTION, t);
                            }
                        }
                        for (Map.Entry<String, Set<JavaDependencyType>> nextContextDependency : localVariableInfo.getContextDependencies().entrySet()) {
                            if (this.m_ignoreAccess.ignoreTypeAccess(null, JavaDependencyType.LOCAL_VARIABLE, nextContextDependency.getKey())) continue;
                            try {
                                JavaType javaType = DependencyProcessor.getToType(this.getElementAccessor(), localVariableInfo.getModule(), fromMethod, line, nextContextDependency.getKey());
                                if (javaType == null) continue;
                                for (JavaDependencyType nextDependencyType : nextContextDependency.getValue()) {
                                    this.getModelHelper().addDependency(fromMethod, javaType, line, JavaDependencyContext.LOCAL_VARIABLE, nextDependencyType);
                                }
                            }
                            catch (Throwable t) {
                                result.addError((OperationResult.IMessageCause)JavaParserMessageCause.LOCAL_VARIABLE_INFO_PROCESSOR_EXCEPTION, t);
                            }
                        }
                    }
                }
            }
        }
    }

    void clear(JavaElement element) {
        this.m_methodToLocVarNameToLocalVariableInfo.remove(element);
    }
}

