/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SwitchInfo {
    private Map<String, List<Integer>> m_caseToLine;
    private final int m_start;
    private final int m_end;

    public SwitchInfo(int start, int end) {
        this.m_start = start;
        this.m_end = end;
    }

    public boolean inRange(int line) {
        return this.m_start <= line && this.m_end >= line;
    }

    public boolean isNarrower(SwitchInfo switchInfo) {
        assert (switchInfo != null) : "Parameter 'switchInfo' of method 'isNarrower' must not be null";
        return switchInfo.m_start > this.m_start && switchInfo.m_end < this.m_end;
    }

    public void add(String name, int line) {
        List<Integer> lines;
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'add' must not be empty";
        assert (this.inRange(line)) : "Not in range";
        if (this.m_caseToLine == null) {
            this.m_caseToLine = new HashMap<String, List<Integer>>();
        }
        if ((lines = this.m_caseToLine.get(name)) == null) {
            lines = new ArrayList<Integer>(1);
            this.m_caseToLine.put(name.intern(), lines);
        }
        lines.add(line);
    }

    public boolean hasCases() {
        return this.m_caseToLine != null && !this.m_caseToLine.isEmpty();
    }

    public Map<String, List<Integer>> getCases() {
        assert (this.hasCases()) : "No cases";
        return Collections.unmodifiableMap(this.m_caseToLine);
    }
}

