/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.system;

import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class LocalVariableInfo {
    private final JavaModule m_module;
    private final int m_endLineOfBlock;
    private final String m_toTypeName;
    private final Map<String, Set<JavaDependencyType>> m_contextDependencies = new HashMap<String, Set<JavaDependencyType>>();
    private Integer m_isDeclaration;

    public LocalVariableInfo(JavaModule module, int endLineOfBlock, String toTypeName) {
        assert (module != null) : "Parameter 'module' of method 'LocalVariableInfo' must not be null";
        assert (toTypeName != null && toTypeName.length() > 0) : "Parameter 'toTypeName' of method 'LocalVariableRelatedDependencyInfo' must not be empty";
        this.m_module = module;
        this.m_toTypeName = toTypeName.intern();
        this.m_endLineOfBlock = endLineOfBlock;
    }

    public JavaModule getModule() {
        return this.m_module;
    }

    public String getToTypeName() {
        return this.m_toTypeName;
    }

    public int getEndLineOfBlock() {
        return this.m_endLineOfBlock;
    }

    public void addContextDependency(String toTypeName, JavaDependencyType dependencyType) {
        assert (toTypeName != null && toTypeName.length() > 0) : "Parameter 'toTypeName' of method 'addContextDependency' must not be empty";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'addContextDependency' must not be null";
        Set<JavaDependencyType> dependencyTypes = this.m_contextDependencies.get(toTypeName);
        if (dependencyTypes == null) {
            dependencyTypes = new HashSet<JavaDependencyType>();
            this.m_contextDependencies.put(toTypeName, dependencyTypes);
        }
        dependencyTypes.add(dependencyType);
    }

    public Map<String, Set<JavaDependencyType>> getContextDependencies() {
        return Collections.unmodifiableMap(this.m_contextDependencies);
    }

    public void setIsDeclaration(int line) {
        this.m_isDeclaration = line;
    }

    public boolean isDeclaration() {
        return this.m_isDeclaration != null;
    }

    public int getDeclarationLine() {
        assert (this.isDeclaration()) : "Not a declaration";
        return this.m_isDeclaration;
    }

    public String toString() {
        return "LocalVariableInfo [m_module=" + String.valueOf((Object)this.m_module) + ", m_endLineOfBlock=" + this.m_endLineOfBlock + ", m_toTypeName=" + this.m_toTypeName + ", m_contextDependencies=" + String.valueOf(this.m_contextDependencies) + ", m_isDeclaration=" + String.valueOf(this.m_isDeclaration) + "]";
    }
}

