/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.path;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IClearable;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;

public abstract class JavaFile
extends FilePath
implements IClearable {
    private static final byte NO_FULLY_QUALIFIED_NAME_PART_SUFFIX = -1;
    private RootDirectoryPath m_baseDirectory;
    private byte m_fullyQualifiedNamePartSuffix = (byte)-1;

    public JavaFile(NamedElement parent) {
        super(parent);
    }

    public JavaFile(NamedElement parent, TFile file, RootDirectoryPath baseDirectory) {
        super(parent, file, (IBaseDirectory)baseDirectory);
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'JavaFile' must not be null";
        this.m_baseDirectory = baseDirectory;
    }

    public final RootDirectoryPath getBaseDirectory() {
        return this.m_baseDirectory;
    }

    public final void setFullyQualifiedNamePartSuffix(byte suffix) {
        assert (suffix >= 0) : "'suffix' muts be greater than 0";
        this.m_fullyQualifiedNamePartSuffix = suffix;
    }

    public String getFullyQualifiedNamePart() {
        if (this.m_fullyQualifiedNamePartSuffix == -1) {
            return super.getFullyQualifiedNamePart();
        }
        return super.getFullyQualifiedNamePart() + INNER_NAME_PARTS_SEPARATOR + Byte.toString(this.m_fullyQualifiedNamePartSuffix);
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.write((ISnapshotWriter.IStorable)this.m_baseDirectory);
        writer.writeByte(this.m_fullyQualifiedNamePartSuffix);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_baseDirectory = (RootDirectoryPath)reader.read(NamedElement.class, new SnapshotArgument[0]);
        this.m_fullyQualifiedNamePartSuffix = reader.readByte();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaFile(JavaFile var1);
    }
}

