/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.ClassPackageNameExtractor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaFilePackageNameExtractor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaPackageNameExtractor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.NonJavaFilePackageNameExtractor;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathCollector;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathDetectionConsumer;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RootDirectoryPathCollector
implements IRootDirectoryPathCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootDirectoryPathCollector.class);
    private final Set<String> m_foundClassRoots = new THashSet();
    private final Set<String> m_foundSourceRoots = new THashSet();
    private final Map<String, Module> m_classRootPathToModule = new THashMap();
    private final Map<String, Module> m_sourceRootPathToModule = new THashMap();
    private final Set<String> m_directoriesToIgnore;
    private IRootDirectoryPathDetectionConsumer m_consumer;
    private IWorkerContext m_workerContext;
    private TFile m_startDirectory;
    private boolean m_includePathsStartingWithDot;
    private boolean m_includeZips;
    private boolean m_includeNestedZips;

    RootDirectoryPathCollector(Set<String> directoriesToIgnore) {
        assert (directoriesToIgnore != null) : "Parameter 'directoriesToIgnore' of method 'RootDirectoryPathCollector' must not be null";
        this.m_directoriesToIgnore = new THashSet(directoriesToIgnore);
    }

    RootDirectoryPathCollector(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RootDirectoryPathCollector' must not be null";
        this.m_directoriesToIgnore = Collections.emptySet();
        List modules = ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(JavaModule.class);
        for (JavaModule nextModule : modules) {
            List rootDirectoryPaths = nextModule.getChildren(JavaClassRootDirectoryPath.class, true);
            for (JavaClassRootDirectoryPath nextRootDirectoryPath : rootDirectoryPaths) {
                this.m_classRootPathToModule.put(FileUtility.getIdentifyingPath((TFile)nextRootDirectoryPath.getDirectoryFile()), nextModule);
            }
            List sourceRootDirectoryPaths = nextModule.getChildren(JavaSourceRootDirectoryPath.class, true);
            for (JavaSourceRootDirectoryPath nextSourceRootDirectoryPath : sourceRootDirectoryPaths) {
                this.m_sourceRootPathToModule.put(FileUtility.getIdentifyingPath((TFile)nextSourceRootDirectoryPath.getDirectoryFile()), nextModule);
            }
        }
    }

    @Override
    public void collect(IRootDirectoryPathDetectionConsumer consumer, IWorkerContext workerContext, TFile startDirectory, boolean includePathsStartingWithDot, boolean includeZips, boolean includeNestedZips) {
        assert (consumer != null) : "Parameter 'consumer' of method 'collect' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collect' must not be null";
        assert (startDirectory != null) : "Parameter 'startDirectory' of method 'collect' must not be null";
        assert (startDirectory.exists()) : "Parameter 'startDirectory' of method 'collect' must exist";
        assert (startDirectory.isDirectory()) : "Parameter 'startDirectory' of method 'collect' must be a directory";
        this.m_consumer = consumer;
        this.m_workerContext = workerContext;
        this.m_startDirectory = startDirectory;
        this.m_includePathsStartingWithDot = includePathsStartingWithDot;
        this.m_includeZips = includeZips;
        this.m_includeNestedZips = includeNestedZips;
        this.collectRootDirectories(this.m_startDirectory, FileUtility.isArchive((TFile)this.m_startDirectory));
        this.m_consumer = null;
        this.m_workerContext = null;
        this.m_startDirectory = null;
        this.m_includePathsStartingWithDot = false;
        this.m_includeZips = false;
        this.m_includeNestedZips = false;
        this.m_foundClassRoots.clear();
        this.m_foundSourceRoots.clear();
    }

    private void detectRootDirectories(List<TFile> filesInDirectory, boolean inArchive) {
        DetectedRootDirectoryPath candidate;
        String normalizedAbsoultePath;
        assert (filesInDirectory != null) : "Parameter 'filesInDirectory' of method 'detectRootDirectories' must not be null";
        TFile detectedClassRoot = null;
        TFile detectedSourceRoot = null;
        for (TFile nextFile : filesInDirectory) {
            TFile detectedRootDirectory;
            if (this.m_workerContext.hasBeenCanceled()) {
                LOGGER.debug("Canceled");
                return;
            }
            assert (nextFile.isFile()) : "Not a file: " + String.valueOf(nextFile);
            LOGGER.debug("Process file: {}", (Object)nextFile.getAbsolutePath());
            this.m_workerContext.working("Check file", false);
            String packageName = null;
            boolean isClassRoot = false;
            JavaFileType fileType = JavaFileType.determine(nextFile.getName());
            if (fileType != null) {
                switch (fileType) {
                    case CLASS_FILE: {
                        if (detectedClassRoot != null) break;
                        LOGGER.debug("Extract package name from class file");
                        packageName = ClassPackageNameExtractor.extractPackageName(nextFile);
                        isClassRoot = true;
                        break;
                    }
                    case JAVA_FILE: {
                        if (detectedSourceRoot != null) break;
                        packageName = JavaFilePackageNameExtractor.extractPackageName(nextFile);
                        break;
                    }
                    case GROOVY_FILE: 
                    case KOTLIN_FILE: 
                    case ASPECTJ_FILE: 
                    case SCALA_FILE: {
                        if (detectedSourceRoot != null) break;
                        packageName = NonJavaFilePackageNameExtractor.extract(nextFile);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled Java file type: " + String.valueOf((Object)fileType);
                        break;
                    }
                }
            }
            if (packageName != null && (detectedRootDirectory = JavaPackageNameExtractor.determineRootDirectory(nextFile.getAbsolutePath(), packageName, '.')) != null) {
                if (isClassRoot) {
                    detectedClassRoot = detectedRootDirectory;
                } else {
                    detectedSourceRoot = detectedRootDirectory;
                }
            }
            if (detectedClassRoot != null && detectedSourceRoot != null) break;
        }
        if (detectedClassRoot != null && !this.m_consumer.ignoreClassRootDirectory(detectedClassRoot) && this.m_foundClassRoots.add(normalizedAbsoultePath = FileUtility.getIdentifyingPath(detectedClassRoot))) {
            candidate = new DetectedRootDirectoryPath(inArchive ? DetectedRootDirectoryPath.Type.CLASSES_ARCHIVE : DetectedRootDirectoryPath.Type.CLASSES_DIRECTORY, detectedClassRoot, this.m_classRootPathToModule.get(normalizedAbsoultePath));
            LOGGER.debug("Found candidate: {}", (Object)candidate.getDirectory());
            this.m_consumer.found(candidate);
        }
        if (detectedSourceRoot != null && !this.m_consumer.ignoreSourceRootDirectory(detectedSourceRoot) && this.m_foundSourceRoots.add(normalizedAbsoultePath = FileUtility.getIdentifyingPath(detectedSourceRoot))) {
            candidate = new DetectedRootDirectoryPath(inArchive ? DetectedRootDirectoryPath.Type.SOURCE_ARCHIVE : DetectedRootDirectoryPath.Type.SOURCE_DIRECTORY, detectedSourceRoot, this.m_sourceRootPathToModule.get(normalizedAbsoultePath));
            LOGGER.debug("Found candidate: {}", (Object)candidate.getDirectory());
            this.m_consumer.found(candidate);
        }
    }

    private void processFile(TFile file, boolean inArchive, List<TFile> directories, List<TFile> files) {
        assert (file != null) : "Parameter 'file' of method 'skipPath' must not be null";
        assert (directories != null) : "Parameter 'directories' of method 'skipPath' must not be null";
        assert (files != null) : "Parameter 'files' of method 'skipPath' must not be null";
        if (this.m_workerContext.hasBeenCanceled()) {
            LOGGER.debug("Canceled");
            return;
        }
        try {
            boolean isArchive;
            String fileName = file.getName();
            this.m_workerContext.working("Processing file: " + fileName, false);
            if (!this.m_includePathsStartingWithDot && fileName.startsWith(".")) {
                LOGGER.debug("Skipped (./*): {}", (Object)fileName);
                return;
            }
            boolean bl = isArchive = inArchive ? file.isArchive() : FileUtility.isArchive((TFile)file);
            if (!this.m_includeZips && isArchive) {
                LOGGER.debug("Skipped (Zip): {}", (Object)fileName);
                return;
            }
            if (!this.m_includeNestedZips && isArchive && inArchive) {
                LOGGER.debug("Skipped (Nested Zip): {}", (Object)fileName);
                return;
            }
            if (file.exists()) {
                if (file.isFile()) {
                    JavaFileType fileType = JavaFileType.determine(fileName);
                    if (fileType != null) {
                        files.add(file);
                    }
                } else if (file.isDirectory()) {
                    if (!this.m_directoriesToIgnore.contains(FileUtility.getCanonicalFilePath((TFile)file))) {
                        directories.add(file);
                    } else {
                        LOGGER.debug("Ignoring directory {}", (Object)file.getAbsolutePath());
                    }
                } else {
                    LOGGER.warn("Found file that is neither a file nor a directory: " + file.getAbsolutePath());
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to process file: " + String.valueOf(file), t);
        }
    }

    private void collectRootDirectories(TFile currentDirectory, boolean inArchive) {
        assert (currentDirectory != null) : "Parameter 'currentDirectory' of method 'collectRootDirectories' must not be null";
        if (!(currentDirectory.exists() && currentDirectory.isDirectory() && currentDirectory.canRead())) {
            return;
        }
        if (this.m_workerContext.hasBeenCanceled()) {
            LOGGER.debug("Canceled");
            return;
        }
        this.m_workerContext.working("Searching in: " + FileUtility.calculateRelativePath((TFile)currentDirectory, (TFile)this.m_startDirectory), true);
        LOGGER.debug("Process: {}", (Object)currentDirectory);
        ArrayList<TFile> directories = new ArrayList<TFile>();
        ArrayList<TFile> files = new ArrayList<TFile>();
        TFile[] filesInCurrentDirectory = currentDirectory.listFiles();
        if (filesInCurrentDirectory == null) {
            LOGGER.error("Failed to determine files in directory '{}'", (Object)currentDirectory.getAbsolutePath());
            return;
        }
        TFile[] tFileArray = filesInCurrentDirectory;
        int n = filesInCurrentDirectory.length;
        int n2 = 0;
        while (n2 < n) {
            TFile nextFile = tFileArray[n2];
            if (this.m_workerContext.hasBeenCanceled()) {
                LOGGER.debug("Canceled");
                return;
            }
            this.processFile(nextFile, inArchive, directories, files);
            ++n2;
        }
        this.detectRootDirectories(files, inArchive);
        for (TFile nextDirectory : directories) {
            if (this.m_workerContext.hasBeenCanceled()) {
                LOGGER.debug("Canceled");
                return;
            }
            boolean isArchive = inArchive ? nextDirectory.isArchive() : FileUtility.isArchive((TFile)nextDirectory);
            this.collectRootDirectories(nextDirectory, inArchive || isArchive);
        }
    }
}

