/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.foundation.utilities.ByteBitFieldUtil;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.NestingInfo;

abstract class NestedTypeInfo
extends NestingInfo {
    private static final byte SYNTHETIC = 1;
    private static final byte STATIC = 2;
    private final String m_nestedFqTypeName;
    private final String m_nestedTypeShortName;
    private byte m_flags;

    NestedTypeInfo(RootDirectoryPath rootDirectoryPath, String nestedFqTypeName, String nestedTypeShortName, boolean isSynthetic, boolean isStatic) {
        super(rootDirectoryPath);
        assert (nestedFqTypeName != null && nestedFqTypeName.length() > 0) : "Parameter 'nestedFqTypeName' of method 'NestedTypeInfo' must not be empty";
        this.m_nestedFqTypeName = nestedFqTypeName.intern();
        this.m_nestedTypeShortName = nestedTypeShortName != null ? nestedTypeShortName.intern() : nestedTypeShortName;
        this.m_flags = 0;
        if (isSynthetic) {
            this.m_flags = ByteBitFieldUtil.enableFlag((byte)this.m_flags, (byte)1);
        }
        if (isStatic) {
            this.m_flags = ByteBitFieldUtil.enableFlag((byte)this.m_flags, (byte)2);
        }
    }

    final String getNestedFqTypeName() {
        return this.m_nestedFqTypeName;
    }

    final String getNestedTypeShortName() {
        return this.m_nestedTypeShortName;
    }

    final boolean isAnonymous() {
        return this.m_nestedTypeShortName == null;
    }

    final boolean isSynthetic() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_flags, (byte)1);
    }

    final boolean isStatic() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_flags, (byte)2);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.m_nestedFqTypeName.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(this)) {
            return false;
        }
        NestedTypeInfo other = (NestedTypeInfo)obj;
        return this.m_nestedFqTypeName.equals(other.m_nestedFqTypeName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("Nested type: ").append(this.m_nestedFqTypeName);
        builder.append("\n");
        if (this.m_nestedTypeShortName != null) {
            builder.append("Nested type short name: ").append(this.m_nestedTypeShortName);
        } else {
            builder.append("Is Anonymous");
        }
        if (this.isSynthetic()) {
            builder.append("\n");
            builder.append("Is Synthetic");
        }
        if (this.isStatic()) {
            builder.append("\n");
            builder.append("Is Static");
        }
        return builder.toString();
    }
}

