/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.AmbiguousTargetTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.AnnotationInfoProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.CastInfoProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.ExternalTypeProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IndirectDependenciesProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.InternalTypeProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModelHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModelProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaTypeRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.LocalVariableInfoProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.PackageFragmentCreator;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.SwitchInfoProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IKotlinProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.InternalTypeCreationResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaParserMessageCause;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.SyntheticsHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.ClassFileParser;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.ResolvedAmbiguousTargetType;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.UnresolvedAmbiguousTargetType;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.UnknownJar;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaStaticBlock;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaSyntheticType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.KotlinGhostProxy;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.CastInfo;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.LocalVariableInfo;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaGlobalModel
implements IJavaGlobalModel,
IJavaElementAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaGlobalModel.class);
    private final Map<JavaElement, Set<AmbiguousTargetTypeInfo>> m_fromElementToAmbiguousTargetTypeInfo = new THashMap();
    private final Map<JavaMethod, List<Integer>> m_methodToLineRanges = new THashMap();
    private final Map<JavaNonInitializer, Map<Integer, Set<String>>> m_nonInitializerMethodToLineToTypeNames = new THashMap();
    private final List<Issue> m_deferredIssues = new ArrayList<Issue>();
    private final List<DependencyProcessor> m_dependencyProcessors = new ArrayList<DependencyProcessor>();
    private final List<IKotlinProcessor> m_kotlinProcessors = new ArrayList<IKotlinProcessor>();
    private final Set<JavaType> m_modifiedTypes = new LinkedHashSet<JavaType>();
    private final Set<JavaType> m_syntheticTypes = new LinkedHashSet<JavaType>();
    private final Set<JavaField> m_syntheticFields = new THashSet();
    private final Set<JavaMethod> m_syntheticMethods = new THashSet();
    private final Set<JavaMember> m_removedMembers = new THashSet();
    private final PackageFragmentCreator m_packageFragmentCreator = new PackageFragmentCreator();
    private final JavaGlobalModelHelper m_globalModelHelper;
    private final LocalVariableInfoProcessor m_localVariableInfoProcessor;
    private final CastInfoProcessor m_castInfoProcessor;
    private final SwitchInfoProcessor m_switchInfoProcessor;
    private final IndirectDependenciesProcessor m_indirectDependenciesProcessor;
    private final AnnotationInfoProcessor m_annotationInfoProcessor;
    private final InternalTypeProcessor m_internalTypeProcessor;
    private final ExternalTypeProcessor m_externalTypeProcessor;
    private final IWorkerContext m_workerContext;
    private final IModelServiceProvider m_modelServiceProvider;
    private final JavaIgnoreAccess m_ignoreAccess;
    private final JavaTypeRegistry m_registry;
    private final UnknownJar m_unknownJar;

    JavaGlobalModel(IWorkerContext workerContext, IModelServiceProvider provider, JavaIgnoreAccess ignoreAccess, JavaTypeRegistry registry, UnknownJar unknownJar) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'GlobalJavaRefreshProcessor' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'JavaGlobalModel' must not be null";
        assert (registry != null) : "Parameter 'registry' of method 'GlobalJavaRefreshProcessor' must not be null";
        assert (ignoreAccess != null) : "Parameter 'ignoreAccess' of method 'JavaGlobalModel' must not be null";
        assert (unknownJar != null) : "Parameter 'unknownJar' of method 'GlobalJavaRefreshProcessor' must not be null";
        this.m_registry = registry;
        this.m_workerContext = workerContext;
        this.m_unknownJar = unknownJar;
        this.m_ignoreAccess = ignoreAccess;
        this.m_modelServiceProvider = provider;
        this.m_globalModelHelper = new JavaGlobalModelHelper(this);
        this.m_localVariableInfoProcessor = new LocalVariableInfoProcessor(this, this.m_globalModelHelper, workerContext, ignoreAccess);
        this.m_castInfoProcessor = new CastInfoProcessor(this, this.m_globalModelHelper, workerContext);
        this.m_switchInfoProcessor = new SwitchInfoProcessor(this, this.m_globalModelHelper, workerContext);
        this.m_indirectDependenciesProcessor = new IndirectDependenciesProcessor(this, this.m_globalModelHelper, workerContext);
        this.m_annotationInfoProcessor = new AnnotationInfoProcessor(this, this.m_globalModelHelper, workerContext);
        this.m_internalTypeProcessor = new InternalTypeProcessor(this, this.m_globalModelHelper, this.m_workerContext);
        this.m_externalTypeProcessor = new ExternalTypeProcessor(this, this.m_globalModelHelper, this.m_workerContext, this, this.m_registry);
    }

    JavaTypeRegistry getTypeRegistry() {
        return this.m_registry;
    }

    @Override
    public NamedElement getUnknownJar() {
        return this.m_unknownJar;
    }

    @Override
    public IModelServiceProvider getModelServiceProvider() {
        return this.m_modelServiceProvider;
    }

    @Override
    public NamespaceFragment.INamespaceFragmentCreator getNamespaceFragmentCreator() {
        return this.m_packageFragmentCreator;
    }

    @Override
    public boolean isTypeName(String shortName) {
        return !this.m_registry.getTypesByShortName(shortName).isEmpty();
    }

    @Override
    public void addDeferredIssue(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
        this.m_deferredIssues.add(issue);
    }

    @Override
    public void addDependencyProcessor(DependencyProcessor processor) {
        assert (processor != null) : "Parameter 'processor' of method 'addDependencyProcessor' must not be null";
        this.m_dependencyProcessors.add(processor);
    }

    @Override
    public void addSyntheticType(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'addSyntheticType' must not be null";
        this.m_syntheticTypes.add(type);
        type.addFlag(JavaElementFlag.SYNTHETIC);
    }

    @Override
    public void addSyntheticField(JavaField field) {
        assert (field != null) : "Parameter 'field' of method 'addSyntheticField' must not be null";
        this.m_syntheticFields.add(field);
        field.addFlag(JavaElementFlag.SYNTHETIC);
    }

    @Override
    public void removeSyntheticField(JavaField field) {
        assert (field != null) : "Parameter 'field' of method 'addSyntheticField' must not be null";
        this.m_syntheticFields.remove(field);
    }

    @Override
    public void addSyntheticMethod(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'addSyntheticMethod' must not be null";
        this.m_syntheticMethods.add(method);
        method.addFlag(JavaElementFlag.SYNTHETIC);
    }

    @Override
    public void removeSyntheticMethod(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'removeSyntheticMethod' must not be null";
        this.m_syntheticMethods.remove(method);
        method.removeFlag(JavaElementFlag.SYNTHETIC);
    }

    @Override
    public void addRemovedMember(JavaMember member) {
        assert (member != null) : "Parameter 'member' of method 'addRemovedMember' must not be null";
        this.m_removedMembers.add(member);
        member.removeFlag(JavaElementFlag.GHOST);
    }

    @Override
    public boolean localVariableInfoAlreadyAdded(JavaMethod javaMethod, String locVarName, int endLineOfBlock) {
        return this.m_localVariableInfoProcessor.localVariableInfoAlreadyAdded(javaMethod, locVarName, endLineOfBlock);
    }

    @Override
    public void addLocalVariableInfo(JavaMethod javaMethod, String locVarName, LocalVariableInfo info) {
        this.m_localVariableInfoProcessor.addLocalVariableInfo(javaMethod, locVarName, info);
    }

    @Override
    public void foundLocalVariable(JavaMethod javaMethod, String locVarName, int line) {
        this.m_localVariableInfoProcessor.foundLocalVariable(javaMethod, locVarName, line);
    }

    @Override
    public void addProcessor(IKotlinProcessor proc) {
        assert (proc != null) : "Parameter 'proc' of method 'addReplacementProcessor' must not be null";
        this.m_kotlinProcessors.add(proc);
    }

    @Override
    public JavaInternalCompilationUnit getOrCreateInternalCompilationUnit(NamedElement inParent, String relSourcePath, String sourceName) {
        assert (inParent != null) : "Parameter 'inParent' of method 'getOrCreateInternalCompilationUnit' must not be null";
        assert (inParent instanceof NamespaceFragment || inParent instanceof RootDirectoryPath) : "Unexpected parent class: " + inParent.getClass().getName();
        assert (relSourcePath != null && relSourcePath.length() > 0) : "Parameter 'relSourcePath' of method 'getOrCreateInternalCompilationUnit' must not be empty";
        assert (sourceName != null && sourceName.length() > 0) : "Parameter 'sourceName' of method 'getOrCreateInternalCompilationUnit' must not be empty";
        JavaInternalCompilationUnit internalCompilationUnit = (JavaInternalCompilationUnit)((Object)inParent.getFirstChild((NamedElement.IFilter)new ShortNameFilter(sourceName), JavaInternalCompilationUnit.class));
        if (internalCompilationUnit == null) {
            internalCompilationUnit = new JavaInternalCompilationUnit(this.m_modelServiceProvider, inParent, relSourcePath);
            inParent.addChild((NamedElement)internalCompilationUnit);
        }
        return internalCompilationUnit;
    }

    @Override
    public JavaType getType(JavaModule module, String fqTypeName) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'getType' must not be empty";
        return this.m_registry.getType(module, fqTypeName);
    }

    private void processSyntheticType(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'processSyntheticType' must not be null";
        this.clearAdditionalInfo(type);
        type.removeDependencies(true);
        List classFiles = type.getChildren(JavaClassFile.class);
        if (!classFiles.isEmpty()) {
            NamedElement parent = type.getParent();
            assert (parent != null) : "Parameter 'parent' of method 'processSynthetics' must not be null";
            JavaSyntheticType syntheticType = null;
            for (JavaSyntheticType next : parent.getChildren(JavaSyntheticType.class)) {
                if (!next.getName().equals(type.getFqName())) continue;
                syntheticType = next;
                break;
            }
            if (syntheticType == null) {
                syntheticType = new JavaSyntheticType(parent, type.getFqName());
                parent.addChild((NamedElement)syntheticType);
            }
            for (JavaClassFile nextClassFile : classFiles) {
                nextClassFile.removeIssues();
                nextClassFile.changeParent((NamedElement)syntheticType, true);
            }
            for (JavaSyntheticType next : type.getChildren(JavaSyntheticType.class)) {
                next.changeParent((NamedElement)syntheticType, true);
            }
        }
        this.m_registry.removeType(type);
        type.remove();
    }

    private void processSynthetics() {
        if (!(this.m_syntheticTypes.isEmpty() && this.m_syntheticFields.isEmpty() && this.m_syntheticMethods.isEmpty())) {
            this.m_workerContext.working("Process synthetics", false);
            for (JavaMethod javaMethod : this.m_syntheticMethods) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                if (javaMethod.hasFlag(JavaElementFlag.BRIDGE)) {
                    this.m_globalModelHelper.processBridgeMethod(javaMethod);
                    continue;
                }
                if (javaMethod.hasFlag(JavaElementFlag.LAMBDA)) {
                    for (JavaMethod isLambdaFor : this.m_globalModelHelper.processLambdaMethod(javaMethod)) {
                        this.m_localVariableInfoProcessor.transferInfo(javaMethod, isLambdaFor);
                        this.m_switchInfoProcessor.transferInfo(javaMethod, isLambdaFor);
                        this.m_castInfoProcessor.transferInfo(javaMethod, isLambdaFor);
                    }
                    continue;
                }
                if (!(javaMethod instanceof JavaNonInitializer) || this.m_syntheticTypes.contains(javaMethod.getParent())) continue;
                this.m_globalModelHelper.processSyntheticNonInitializerOfNonSyntheticType((JavaNonInitializer)javaMethod);
            }
            for (JavaField javaField : this.m_syntheticFields) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                this.clearAdditionalInfo(javaField);
                javaField.remove();
            }
            for (JavaMethod javaMethod : this.m_syntheticMethods) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                this.clearAdditionalInfo(javaMethod);
                javaMethod.remove();
            }
            for (JavaType javaType : this.m_syntheticTypes) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                this.m_modifiedTypes.remove(javaType);
                this.processSyntheticType(javaType);
            }
            this.m_syntheticTypes.clear();
            this.m_syntheticFields.clear();
            this.m_syntheticMethods.clear();
        }
    }

    @Override
    public void clearAdditionalInfo(JavaElement element) {
        assert (element != null) : "Parameter 'element' of method 'clearAdditionalInfo' must not be null";
        this.m_castInfoProcessor.clear(element);
        this.m_localVariableInfoProcessor.clear(element);
        this.m_switchInfoProcessor.clear(element);
        this.m_fromElementToAmbiguousTargetTypeInfo.remove(element);
    }

    private List<JavaType> processModifiedTypes() {
        if (!this.m_modifiedTypes.isEmpty()) {
            ArrayList<JavaType> internalTypes = new ArrayList<JavaType>();
            ArrayList<JavaType> externalTypes = new ArrayList<JavaType>();
            this.m_workerContext.working("Finish modified types", false);
            for (JavaType nextType : this.m_modifiedTypes) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                if (nextType.isExternal()) {
                    externalTypes.add(nextType);
                    continue;
                }
                internalTypes.add(nextType);
            }
            this.m_internalTypeProcessor.processModifiedTypes(internalTypes);
            this.m_externalTypeProcessor.processModifiedTypes(externalTypes);
            Collections.sort(internalTypes, JavaModelProcessor.DEEPER_FIRST);
            Iterator iter = internalTypes.iterator();
            while (iter.hasNext()) {
                JavaInternalCompilationUnit compilationUnit;
                if (this.m_workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                JavaType nextInternalType = (JavaType)iter.next();
                byte suffix = 0;
                List classFiles = nextInternalType.getChildren(JavaClassFile.class);
                if (classFiles.size() > 1) {
                    for (JavaClassFile nextClassFile : classFiles) {
                        nextClassFile.setFullyQualifiedNamePartSuffix(suffix);
                        suffix = (byte)(suffix + 1);
                    }
                }
                if ((compilationUnit = (JavaInternalCompilationUnit)((Object)nextInternalType.getParent(JavaInternalCompilationUnit.class, new Class[0]))) != null) {
                    List sourceFiles;
                    JavaSourceFile sourceFile = compilationUnit.getPrimarySourceFile();
                    if (sourceFile != null && sourceFile.hasBeenParsedSuccessfully() && !nextInternalType.hasFlag(JavaElementFlag.FOUND_IN_SOURCE)) {
                        this.processSyntheticType(nextInternalType);
                    }
                    if ((sourceFiles = compilationUnit.getChildren(JavaSourceFile.class)).size() <= 1) continue;
                    suffix = 0;
                    for (JavaSourceFile nextSourceFile : sourceFiles) {
                        nextSourceFile.setFullyQualifiedNamePartSuffix(suffix);
                        suffix = (byte)(suffix + 1);
                    }
                    continue;
                }
                if (nextInternalType.isValid()) {
                    LOGGER.warn("'compilationUnit' of method 'processModifiedTypes' is null for valid internal type: " + nextInternalType.getFqName() + " - in parent: " + String.valueOf(nextInternalType.getParent()));
                    this.m_registry.removeType(nextInternalType);
                } else {
                    LOGGER.warn("'compilationUnit' of method 'processModifiedTypes' is null for invalid internal type: " + nextInternalType.getFqName());
                }
                nextInternalType.removeDependencies(true);
                nextInternalType.remove();
                iter.remove();
            }
            this.m_registry.modificationFinished();
            return internalTypes;
        }
        return Collections.emptyList();
    }

    private void processRemovedMembers() {
        if (!this.m_removedMembers.isEmpty()) {
            this.m_workerContext.working("Process removed members", false);
            for (JavaMember nextMember : this.m_removedMembers) {
                if (nextMember.hasIncomingDependencies()) {
                    assert (!nextMember.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE)) : "Already set 'not defined in enclosing type'";
                    nextMember.addFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
                    continue;
                }
                this.clearAdditionalInfo(nextMember);
                nextMember.remove();
            }
        }
    }

    private void processTargetTypeAmbiguities() {
        if (!this.m_fromElementToAmbiguousTargetTypeInfo.isEmpty()) {
            for (Map.Entry<JavaElement, Set<AmbiguousTargetTypeInfo>> nextEntry : this.m_fromElementToAmbiguousTargetTypeInfo.entrySet()) {
                JavaElement nextFromElement = nextEntry.getKey();
                if (nextFromElement.isValid()) {
                    for (AmbiguousTargetTypeInfo next : nextEntry.getValue()) {
                        if (next.hasBeenResolved()) {
                            nextFromElement.addIssue((Issue)new ResolvedAmbiguousTargetType((NamedElement)nextFromElement, next.createDescription(), next.getLineNumber()));
                            continue;
                        }
                        nextFromElement.addIssue((Issue)new UnresolvedAmbiguousTargetType((NamedElement)nextFromElement, next.createDescription(), next.getLineNumber()));
                    }
                    continue;
                }
                LOGGER.warn(nextFromElement.getClass().getName() + " no longer valid in 'processTargetTypeAmbiguities()'");
            }
            this.m_fromElementToAmbiguousTargetTypeInfo.clear();
        }
    }

    private void processDeferredIssues() {
        if (!this.m_deferredIssues.isEmpty()) {
            this.m_workerContext.working("Process issues", false);
            for (Issue nextIssue : this.m_deferredIssues) {
                ElementWithIssues nextElementWithIssues = (ElementWithIssues)nextIssue.getAffectedElement();
                assert (nextElementWithIssues != null) : "'nextElementWithIssues' of method 'processDeferredIssues' must not be null";
                if (!nextElementWithIssues.isValid()) continue;
                nextElementWithIssues.addIssue(nextIssue);
            }
            this.m_deferredIssues.clear();
        }
    }

    private void executeProcessors(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'executeProcessors' must not be null";
        if (!this.m_dependencyProcessors.isEmpty()) {
            this.m_workerContext.working("Execute dependency processors", false);
            for (DependencyProcessor dependencyProcessor : this.m_dependencyProcessors) {
                try {
                    dependencyProcessor.process(this);
                }
                catch (Throwable t) {
                    result.addError((OperationResult.IMessageCause)JavaParserMessageCause.DEPENDENCY_PROCESSOR_EXCEPTION, t);
                }
            }
            this.m_dependencyProcessors.clear();
        }
        if (!this.m_kotlinProcessors.isEmpty()) {
            this.m_workerContext.working("Execute Kotlin processors", false);
            for (IKotlinProcessor iKotlinProcessor : this.m_kotlinProcessors) {
                try {
                    iKotlinProcessor.process();
                }
                catch (Throwable t) {
                    result.addError((OperationResult.IMessageCause)JavaParserMessageCause.KOTLIN_PROCESSOR_EXCEPTION, t);
                }
            }
            this.m_kotlinProcessors.clear();
        }
    }

    private void processDependencyLineNumbers(JavaElement element, List<ParserDependency> toBeRemovedCollector) {
        assert (element != null) : "Parameter 'element' of method 'processDependencyLineNumbers' must not be null";
        assert (toBeRemovedCollector != null) : "Parameter 'toBeRemovedCollector' of method 'processDependencyLineNumbers' must not be null";
        Iterator nextIter = element.getDependencyIterator();
        while (nextIter.hasNext()) {
            int nextLineNumber;
            ParserDependency nextParserDependency = (ParserDependency)nextIter.next();
            if (nextParserDependency.getFrom() != element) continue;
            assert (nextParserDependency instanceof JavaDependency) : "Unexpected class in method 'processDependencyLineNumbers': " + String.valueOf(nextParserDependency);
            JavaDependency nextJavaDependency = (JavaDependency)nextParserDependency;
            int nextRawLineNumber = nextJavaDependency.getRawLineNumber();
            if (nextRawLineNumber != -1 || nextRawLineNumber == (nextLineNumber = nextJavaDependency.getLineNumber()) || !DependencyProcessor.dependencyAlreadyExists((JavaElement)nextJavaDependency.getFrom(), (JavaElement)nextJavaDependency.getTo(), nextJavaDependency.getDependencyContext(), (JavaDependencyType)nextJavaDependency.getDependencyType(), nextLineNumber)) continue;
            toBeRemovedCollector.add(nextJavaDependency);
        }
    }

    private void processDependencyLineNumbers(List<JavaType> internalTypes) {
        assert (internalTypes != null) : "Parameter 'internalTypes' of method 'processDependencyLineNumbers' must not be null";
        LOGGER.debug("Process dependency line numbers");
        ArrayList<ParserDependency> toBeRemoved = new ArrayList<ParserDependency>();
        for (JavaType nextType : internalTypes) {
            this.processDependencyLineNumbers(nextType, toBeRemoved);
            nextType.getChildren(JavaMember.class).forEach(m -> this.processDependencyLineNumbers((JavaElement)m, (List<ParserDependency>)toBeRemoved));
        }
        toBeRemoved.forEach(d -> d.getFrom().removeDependency(d));
        LOGGER.debug("Process dependency line numbers - done [removed " + toBeRemoved.size() + " parser dependencies]");
    }

    void finishModification(List<JavaModule> modules, OperationResult result) {
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'finishModification' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'finishModification' must not be null";
        LOGGER.debug("Finish modification");
        this.m_workerContext.working("Finish Java model modification", false);
        this.executeProcessors(result);
        this.processRemovedMembers();
        this.processSynthetics();
        this.m_globalModelHelper.resetCache();
        this.m_localVariableInfoProcessor.process(result);
        this.m_castInfoProcessor.process();
        this.m_switchInfoProcessor.process();
        List<JavaType> internalTypes = this.processModifiedTypes();
        this.m_globalModelHelper.resetCache();
        this.processDependencyLineNumbers(internalTypes);
        this.m_indirectDependenciesProcessor.process(internalTypes);
        this.m_annotationInfoProcessor.process(modules);
        this.processTargetTypeAmbiguities();
        this.processDeferredIssues();
        KotlinCleanupVisitor cleanupVisitor = new KotlinCleanupVisitor();
        modules.forEach(m -> m.accept(cleanupVisitor));
        cleanupVisitor.getEmptyKotlinCompilationUnits().forEach(k -> k.remove());
        LOGGER.debug("Finish modification - done");
    }

    void aboutToReparse(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'aboutToReparse' must not be null";
        if (!type.isExternal()) {
            for (ParserDependency next : type.getOutgoingDependenciesRecursively()) {
                JavaType toType = (JavaType)next.getOriginalTo().getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT);
                if (toType == null) {
                    LOGGER.warn("'toType' not found for outgoing dependency: " + String.valueOf(next));
                    continue;
                }
                if (!toType.isExternal()) continue;
                this.m_modifiedTypes.add(toType);
            }
        }
        this.m_indirectDependenciesProcessor.initializeAsUnparsed(type);
        ClassFileParser.initializeAsUnparsed(type, true);
        type.aboutToReparse();
        Iterator<JavaMember> iter = type.getChildrenIterator(JavaMember.class);
        while (iter.hasNext()) {
            iter.next().aboutToReparse();
        }
        this.m_modifiedTypes.add(type);
    }

    @Override
    public List<JavaTypeInfo> getTypeInfo(String fqName) {
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'addType' must not be empty";
        List<JavaTypeInfo> typeInfos = this.m_registry.getTypes(fqName);
        if (!typeInfos.isEmpty()) {
            return typeInfos;
        }
        String packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(fqName);
        String shortName = packageName.isEmpty() ? fqName : fqName.substring(packageName.length() + 1);
        JavaType type = new JavaType(this.m_modelServiceProvider, (NamedElement)this.m_unknownJar, shortName, fqName);
        this.m_unknownJar.addChild((NamedElement)type);
        ClassFileParser.initializeAsUnparsed(type, false);
        List<JavaTypeInfo> typeInfo = this.m_registry.addType(null, type);
        this.m_modifiedTypes.add(type);
        return typeInfo;
    }

    void removedFromInternalCompilationUnit(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'removedFromInternalCompilationUnit' must not be null";
        for (ParserDependency nextOutgoingDependency : type.getOutgoingDependenciesRecursively()) {
            ProgrammingElement nextTo = nextOutgoingDependency.getOriginalTo();
            if (!nextTo.isExternal()) continue;
            JavaType nextToTypeParent = (JavaType)nextTo.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (nextToTypeParent != null) : "'nextToTypeParent' of method 'removedFromInternalCompilationUnit' must not be null";
            this.m_modifiedTypes.add(nextToTypeParent);
        }
        this.m_registry.removeType(type);
        this.m_registry.addType(null, type);
        type.getParent().removeChild((NamedElement)type);
        type.setParent(null);
        this.m_indirectDependenciesProcessor.initializeAsUnparsed(type);
        ClassFileParser.initializeAsUnparsed(type, true);
        this.m_modifiedTypes.add(type);
    }

    @Override
    public InternalTypeCreationResult addInternalType(JavaModule module, RootDirectoryPath rootDirectoryPath, Set<JavaType> typesToBeReparsed, String fqTypeName, String signature) {
        assert (module != null) : "Parameter 'module' of method 'addInternalType' must not be null";
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'addType' must not be null";
        assert (typesToBeReparsed != null) : "Parameter 'typesToBeReparsed' of method 'addInternalType' must not be null";
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'addType' must not be empty";
        boolean isDuplicate = false;
        JavaType type = this.m_registry.getType(null, fqTypeName);
        if (type != null) {
            this.m_indirectDependenciesProcessor.initializeAsUnparsed(type);
            ClassFileParser.initializeAsUnparsed(type, true);
            this.m_modifiedTypes.add(type);
            type = null;
        }
        if ((type = this.m_registry.getType(module, fqTypeName)) == null) {
            String packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(fqTypeName);
            NamedElement tempTypeParent = NamespaceFragment.getNamespaceFragmentOrSpecifiedParent((IModelServiceProvider)this.m_modelServiceProvider, (NamedElement)rootDirectoryPath, (String)packageName, (NamespaceFragment.INamespaceFragmentCreator)this.m_packageFragmentCreator);
            String shortName = packageName.isEmpty() ? fqTypeName : fqTypeName.substring(packageName.length() + 1);
            type = new JavaType(this.m_modelServiceProvider, tempTypeParent, shortName, fqTypeName);
            tempTypeParent.addChild((NamedElement)type);
            ClassFileParser.initializeAsUnparsed(type, false);
            this.m_registry.addType(module, type);
            this.m_modifiedTypes.add(type);
            if (signature != null && signature.length() > 0) {
                type.setSignature(signature);
            }
        } else if (!typesToBeReparsed.remove(type)) {
            isDuplicate = true;
            this.m_modifiedTypes.add(type);
        }
        return new InternalTypeCreationResult(type, isDuplicate);
    }

    @Override
    public void addPotentialInlineField(JavaField javaField) {
        this.m_registry.addPotentialInlineField(javaField);
    }

    @Override
    public void addCast(JavaElement element, CastInfo castInfo) {
        this.m_castInfoProcessor.addCastInfo(element, castInfo);
    }

    @Override
    public List<JavaField> getInlineFields(String fieldName) {
        return this.m_registry.getInlineFields(fieldName);
    }

    @Override
    public Collection<JavaType> getTypesByShortName(String shortName) {
        return this.m_registry.getTypesByShortName(shortName);
    }

    @Override
    public boolean memberHasBeenRemoved(JavaMember member) {
        assert (member != null) : "Parameter 'member' of method 'memberHasBeenRemoved' must not be null";
        return this.m_removedMembers.contains(member);
    }

    @Override
    public void addSwitchInformation(JavaMethod method, int startLineNumber, int endLineNumber) {
        this.m_switchInfoProcessor.addSwitchInformation(method, startLineNumber, endLineNumber);
    }

    @Override
    public void addSwitchCaseInformation(JavaMethod method, String name, int line) {
        this.m_switchInfoProcessor.addSwitchCaseInformation(method, name, line);
    }

    @Override
    public JavaField addField(JavaType type, String name, String signature) {
        return this.getField(type, name, signature, null);
    }

    private JavaField getField(JavaType type, String name, String signature, IJavaElementAccessor.IMemberInitializer initializer) {
        assert (type != null) : "Parameter 'type' of method 'addField' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addField' must not be empty";
        JavaField field = this.m_globalModelHelper.getField(type, name);
        if (field == null) {
            field = new JavaField(this.m_modelServiceProvider, (NamedElement)type, name);
            this.m_globalModelHelper.addField(type, name, field);
            if (SyntheticsHelper.isFieldSynthetic(name)) {
                this.addSyntheticField(field);
            }
            if (signature != null && signature.length() > 0) {
                field.setSignature(signature);
            }
            type.addChild((NamedElement)field);
            this.m_modifiedTypes.add(type);
            ClassFileParser.initializeNewlyCreatedField(field);
            if (initializer != null) {
                initializer.initialize(field);
            }
        }
        return field;
    }

    @Override
    public JavaMethod getMethod(JavaType type, String methodName, String descriptor, boolean omitReturnTypeInLookup, IJavaElementAccessor.IMemberInitializer initializer) {
        assert (type != null) : "Parameter 'type' of method 'addMethod' must not be null";
        assert (methodName != null && methodName.length() > 0) : "Parameter 'methodName' of method 'addMethod' must not be empty";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addMethod' must not be null";
        JavaGlobalModelHelper.MethodType methodType = JavaGlobalModelHelper.getMethodType(methodName);
        JavaMethod method = this.m_globalModelHelper.getMethod(type, methodName, descriptor, methodType, omitReturnTypeInLookup);
        if (method == null) {
            switch (methodType) {
                case NON_INITIALIZER: {
                    method = new JavaNonInitializer(this.m_modelServiceProvider, (NamedElement)type, methodName, descriptor);
                    if (!SyntheticsHelper.isMethodSynthetic(type.getFqName(), methodName, true)) break;
                    this.addSyntheticMethod(method);
                    break;
                }
                case CONSTRUCTOR: {
                    method = new JavaConstructor(this.m_modelServiceProvider, (NamedElement)type, type.getShortName(), descriptor);
                    break;
                }
                case STATIC_BLOCK: {
                    method = new JavaStaticBlock(this.m_modelServiceProvider, (NamedElement)type, descriptor);
                    break;
                }
                default: {
                    assert (false) : "Unhandled method type: " + String.valueOf((Object)methodType);
                    break;
                }
            }
            this.m_globalModelHelper.addMethod(type, methodName, descriptor, method, methodType);
            type.addChild((NamedElement)method);
            this.m_modifiedTypes.add(type);
            ClassFileParser.initializeNewlyCreatedMethod(method);
            if (initializer != null) {
                initializer.initialize(method);
            }
        }
        return method;
    }

    @Override
    public JavaMethod addMethod(JavaType type, String name, String descriptor, String signature) {
        JavaMethod method = this.getMethod(type, name, descriptor, false, null);
        if (signature != null && signature.length() > 0) {
            method.setSignature(signature);
        }
        return method;
    }

    @Override
    public JavaIgnoreAccess getIgnoreAccess() {
        return this.m_ignoreAccess;
    }

    @Override
    public void addTargetTypeAmbiguity(JavaElement fromElement, String fqTargetTypeName, List<JavaTypeInfo> availableTargets, int line, JavaModule resolvedWith) {
        assert (fromElement != null) : "Parameter 'fromElement' of method 'addTargetTypeAmbiguity' must not be null";
        assert (fqTargetTypeName != null && fqTargetTypeName.length() > 0) : "Parameter 'fqTargetTypeName' of method 'addTargetTypeAmbiguity' must not be empty";
        assert (availableTargets != null) : "Parameter 'availableTargets' of method 'addTargetTypeAmbiguity' must not be null";
        THashSet targets = this.m_fromElementToAmbiguousTargetTypeInfo.get(fromElement);
        if (targets == null) {
            targets = new THashSet();
            this.m_fromElementToAmbiguousTargetTypeInfo.put(fromElement, (Set<AmbiguousTargetTypeInfo>)targets);
        }
        targets.add(new AmbiguousTargetTypeInfo(fqTargetTypeName, availableTargets, line, resolvedWith));
    }

    @Override
    public JavaField getField(JavaType type, String name) {
        return this.getField(type, name, null, null);
    }

    @Override
    public JavaField getField(JavaType type, String name, IJavaElementAccessor.IMemberInitializer initializer) {
        assert (initializer != null) : "Parameter 'initializer' of method 'getField' must not be null";
        return this.getField(type, name, null, initializer);
    }

    @Override
    public boolean isDerivedFrom(JavaType type, JavaType derivedFrom) {
        return this.m_globalModelHelper.isDerivedFrom(type, derivedFrom);
    }

    @Override
    public boolean isAccessibleFrom(JavaField field, JavaType accessibleFrom) {
        return this.m_globalModelHelper.isAccessibleFrom(field, accessibleFrom);
    }

    @Override
    public void addLineRange(JavaMethod method, int from, int to) {
        assert (method != null) : "Parameter 'method' of method 'addLineRange' must not be null";
        List<Integer> ranges = this.m_methodToLineRanges.get(method);
        if (ranges == null) {
            assert (from == method.getLineNumber()) : "'from' line does not match line number";
            ranges = new ArrayList<Integer>(2);
            this.m_methodToLineRanges.put(method, ranges);
        }
        ranges.add(from);
        ranges.add(to);
    }

    @Override
    public List<Integer> getRangeInfo(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'getRangeInfo' must not be null";
        return this.m_methodToLineRanges.get(method);
    }

    @Override
    public boolean isSynthetic(JavaElement element) {
        assert (element != null) : "Parameter 'element ' of method 'isSynthetic' must not be null";
        return element.hasFlag(JavaElementFlag.SYNTHETIC) || this.m_syntheticFields.contains(element) || this.m_syntheticMethods.contains(element) || this.m_syntheticTypes.contains(element);
    }

    @Override
    public void addCatchedTypeNameAt(JavaNonInitializer nonInitializer, String shortTypeName, int line) {
        Integer lineAsInteger;
        LinkedHashSet<String> typeNames;
        assert (nonInitializer != null) : "Parameter 'method' of method 'addCatch' must not be null";
        assert (shortTypeName != null && shortTypeName.length() > 0) : "Parameter 'typeName' of method 'addCatch' must not be empty";
        assert (shortTypeName.indexOf(46) == -1) : "Short name expected: " + shortTypeName;
        assert (line > 0) : "Unexpected line: " + line;
        THashMap lineToTypeNames = this.m_nonInitializerMethodToLineToTypeNames.get(nonInitializer);
        if (lineToTypeNames == null) {
            lineToTypeNames = new THashMap();
            this.m_nonInitializerMethodToLineToTypeNames.put(nonInitializer, (Map<Integer, Set<String>>)lineToTypeNames);
        }
        if ((typeNames = (LinkedHashSet<String>)lineToTypeNames.get(lineAsInteger = Integer.valueOf(line))) == null) {
            typeNames = new LinkedHashSet<String>();
            lineToTypeNames.put(lineAsInteger, typeNames);
        }
        typeNames.add(shortTypeName.intern());
    }

    @Override
    public Set<String> getCatchedTypeNamesAt(JavaNonInitializer nonInitializer, int lineNumber) {
        assert (nonInitializer != null) : "Parameter 'nonInitializer' of method 'getCatchInfo' must not be null";
        Set<String> typeNames = null;
        Map<Integer, Set<String>> lineToTypeNames = this.m_nonInitializerMethodToLineToTypeNames.get(nonInitializer);
        if (lineToTypeNames != null) {
            typeNames = lineToTypeNames.get(lineNumber);
        }
        return typeNames == null ? Collections.emptySet() : Collections.unmodifiableSet(typeNames);
    }

    @Override
    public void addKotlinHelperClass(String name) {
        assert (name != null);
        this.m_registry.addKotlinHelperClass(name);
    }

    @Override
    public JavaType findKotlinHelperClass(JavaModule module, String lowerCaseName, String packageName) {
        assert (module != null) : "Parameter 'module' of method 'findKotlinHelperClass' must not be null";
        assert (lowerCaseName != null && lowerCaseName.length() > 0) : "Parameter 'lowerCaseName' of method 'findKotlinHelperClass' must not be empty";
        return this.m_registry.findKotlinHelperClass(module, lowerCaseName, packageName);
    }

    private static final class KotlinCleanupVisitor
    extends NamedElementVisitor
    implements KotlinGhostProxy.IVisitor,
    JavaCompilationUnit.IVisitor,
    JavaElement.IVisitor {
        private final List<JavaCompilationUnit> m_emptyKotlinCompilationUnits = new ArrayList<JavaCompilationUnit>();

        KotlinCleanupVisitor() {
        }

        @Override
        public void visitKotlinGhostProxy(KotlinGhostProxy element) {
            assert (element != null) : "Parameter 'element' of method 'visitKotlinGhostProxy' must not be null";
            JavaElement source = (JavaElement)element.getParent(JavaElement.class, new Class[0]);
            JavaElement target = element.getTarget();
            if (element.transferOnlyIncomingDependencies()) {
                source.transferIncomingDependenciesTo(target);
                source.removeDependencies(false);
            } else {
                target.mergeDependenciesFrom(source);
            }
        }

        @Override
        public void visitJavaElement(JavaElement element) {
            this.visitChildrenOf((NamedElement)element);
            if (element.isGhost()) {
                element.removeDependencies(false);
            }
        }

        @Override
        public void visitJavaCompilationUnit(JavaCompilationUnit element) {
            assert (element != null) : "Parameter 'element' of method 'visitJavaCompilationUnit' must not be null";
            if (JavaFileType.KOTLIN_FILE == JavaFileType.determine(element.getIdentifyingPath()) && !element.hasChildren()) {
                this.m_emptyKotlinCompilationUnits.add(element);
            }
            this.visitChildrenOf((NamedElement)element);
        }

        List<JavaCompilationUnit> getEmptyKotlinCompilationUnits() {
            return this.m_emptyKotlinCompilationUnits;
        }
    }
}

