/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.ClassAnnotation;
import com.hello2morrow.sonargraph.core.model.annotation.EnumAnnotationValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModelHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModelProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotationInfoProcessor
extends JavaModelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationInfoProcessor.class);

    AnnotationInfoProcessor(IJavaElementAccessor elementAccessor, JavaGlobalModelHelper globalModelHelper, IWorkerContext workerContext) {
        super(elementAccessor, globalModelHelper, workerContext);
    }

    void process(List<JavaModule> modules) {
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'process' must not be empty";
        LOGGER.debug("Finish Java annotation model");
        PostRefreshAnnotationVisitor visitor = new PostRefreshAnnotationVisitor();
        for (JavaModule nextModule : modules) {
            visitor.setModule(nextModule);
            nextModule.accept((NamedElement.INamedElementVisitor)visitor);
        }
        LOGGER.debug("Finish Java annotation model - done");
    }

    private class PostRefreshAnnotationVisitor
    extends AnnotationValue.AnnotationVisitor
    implements Annotation.IVisitor,
    ClassAnnotation.IVisitor,
    EnumAnnotationValue.IVisitor,
    ProgrammingElement.IVisitor {
        private JavaModule m_module;
        private JavaElement m_programmingElement;

        PostRefreshAnnotationVisitor() {
        }

        void setModule(JavaModule module) {
            this.m_module = module;
        }

        public void visitChildrenOf(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
            if (!element.isProxy()) {
                for (NamedElement next : element.getChildren()) {
                    next.accept((NamedElement.INamedElementVisitor)this);
                }
            }
        }

        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            this.visitChildrenOf(element);
        }

        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null && element instanceof JavaElement) : "Unexpected class in method 'visitProgrammingElement': " + String.valueOf(element);
            this.m_programmingElement = (JavaElement)element;
            element.getAnnotations().forEach(a -> a.accept((AnnotationValue.AnnotationVisitor)this));
            this.m_programmingElement = null;
            this.visitChildrenOf((NamedElement)element);
        }

        public void visitAnnotationValue(AnnotationValue value) {
            assert (value != null) : "Parameter 'value' of method 'visitAnnotationValue' must not be null";
            value.visitChildren((AnnotationValue.AnnotationVisitor)this);
        }

        public void visitAnnotation(Annotation annotation) {
            assert (this.m_module != null) : "'m_module' of method 'visitAnnotation' must not be null";
            assert (this.m_programmingElement != null) : "'m_programmingElement' of method 'visitAnnotation' must not be null";
            assert (annotation != null) : "Parameter 'annotation' of method 'visitAnnotation' must not be null";
            NamedElement element = annotation.getAnnotationClass();
            if (element != null && !element.isValid()) {
                JavaType type;
                annotation.setAnnotationClass(null);
                String className = annotation.getAnnotationClassName();
                if (className != null && !className.isEmpty() && (type = DependencyProcessor.getToType(AnnotationInfoProcessor.this.getElementAccessor(), this.m_module, this.m_programmingElement, annotation.getLineNumber(), className)) != null) {
                    annotation.setAnnotationClass((NamedElement)type);
                }
            }
            this.visitAnnotationValue((AnnotationValue)annotation);
        }

        public void visitClassAnnotation(ClassAnnotation annotation) {
            assert (this.m_module != null) : "'m_module' of method 'visitClassAnnotation' must not be null";
            assert (this.m_programmingElement != null) : "'m_programmingElement' of method 'visitClassAnnotation' must not be null";
            assert (annotation != null) : "Parameter 'annotation' of method 'visitClassAnnotation' must not be null";
            NamedElement element = annotation.getType();
            if (element != null && !element.isValid()) {
                JavaType type;
                annotation.setType(null);
                String className = annotation.getClassName();
                if (className != null && !className.isEmpty() && (type = DependencyProcessor.getToType(AnnotationInfoProcessor.this.getElementAccessor(), this.m_module, this.m_programmingElement, annotation.getLineNumber(), className)) != null) {
                    annotation.setType((NamedElement)type);
                }
            }
            this.visitAnnotationValue((AnnotationValue)annotation);
        }

        public void visitEnumAnnotationValue(EnumAnnotationValue annotation) {
            assert (this.m_module != null) : "'m_module' of method 'visitEnumAnnotationValue' must not be null";
            assert (this.m_programmingElement != null) : "'m_programmingElement' of method 'visitEnumAnnotationValue' must not be null";
            assert (annotation != null) : "Parameter 'annotation' of method 'visitEnumAnnotationValue' must not be null";
            NamedElement element = annotation.getEnumConstant();
            if (element != null && !element.isValid()) {
                String enumString;
                NamedElement parent = element.getParent();
                annotation.setEnumConstant(null);
                if (parent instanceof JavaType && (enumString = annotation.getEnumString()) != null && !enumString.isEmpty()) {
                    JavaField enumField;
                    String fqTypeName = ((JavaType)parent).getFqName();
                    int dot = enumString.lastIndexOf(46);
                    String constantName = dot != -1 ? enumString.substring(dot + 1) : enumString;
                    LOGGER.debug("Enum constant: " + fqTypeName + ":" + constantName);
                    JavaType enumType = DependencyProcessor.getToType(AnnotationInfoProcessor.this.getElementAccessor(), this.m_module, this.m_programmingElement, annotation.getLineNumber(), fqTypeName);
                    if (enumType != null && (enumField = (JavaField)enumType.getFirstChild(e -> e.getShortName().equals(constantName), JavaField.class)) != null) {
                        annotation.setEnumConstant((NamedElement)enumField);
                    }
                }
            }
            this.visitAnnotationValue((AnnotationValue)annotation);
        }
    }
}

