/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile;

import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Node;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IImportRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaFileParseResult;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;

final class JavaSyntaxTreeVisitorUtility {
    static final String FORMAL_PARAMETER_TYPE_LIST = "fptl";

    private JavaSyntaxTreeVisitorUtility() {
    }

    static void calculateRelativeSourcePath(IJavaModuleModel model, TFile file, String packageName, JavaFileParseResult result) {
        assert (model != null) : "Parameter 'model' of method 'calculateRelativeSourcePath' must not be null";
        assert (file != null) : "Parameter 'file' of method 'calculateRelativeSourcePath' must not be null";
        assert (result != null) : "Parameter 'result' of method 'calculateRelativeSourcePath' must not be null";
        String fileName = file.getName();
        StringBuilder relativePathBuilder = new StringBuilder(".");
        relativePathBuilder.append('/');
        if (packageName != null && packageName.length() > 0) {
            relativePathBuilder.append(packageName.replace('.', '/'));
            relativePathBuilder.append('/');
            relativePathBuilder.append(fileName);
            result.setPackageName(packageName);
        } else {
            relativePathBuilder.append(fileName);
        }
        String relativePath = relativePathBuilder.toString();
        result.setRelativeFilePath(relativePath);
        JavaInternalCompilationUnit internalCompilationUnit = model.getInternalCompilationUnit(relativePath);
        if (internalCompilationUnit != null) {
            StringBuilder description = new StringBuilder("Ignoring Java source file ''");
            description.append(file.getAbsolutePath()).append("'. Java source file for relative path '").append(relativePath).append("' already added");
            JavaSourceFile sourceFile = internalCompilationUnit.getPrimarySourceFile();
            if (sourceFile != null) {
                description.append(" from '").append(sourceFile.getAbsolutePath()).append("'");
            }
            description.append(".");
            result.setIsDuplicate(description.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean parameterTypeMatches(IImportRegistry importRegistry, Type parameterType, String sourceType) {
        if (!JavaSyntaxTreeVisitorUtility.$assertionsDisabled && parameterType == null) {
            throw new AssertionError((Object)"Parameter 'parameterType' of method 'parameterTypeMatches' must not be null");
        }
        if (!JavaSyntaxTreeVisitorUtility.$assertionsDisabled && sourceType == null) {
            throw new AssertionError((Object)"Parameter 'sourceType' of method 'parameterTypeMatches' must not be null");
        }
        descriptorType = parameterType.getDescriptor();
        semicolonPos = descriptorType.lastIndexOf(59);
        topLevelType = null;
        if (semicolonPos > 0) {
            startPos = descriptorType.indexOf(76);
            descriptorType = startPos > 0 ? descriptorType.substring(0, startPos) + descriptorType.substring(startPos + 1, semicolonPos) : descriptorType.substring(1, semicolonPos);
            dollarPos = (descriptorType = descriptorType.replace('/', '.')).indexOf(36);
            if (dollarPos > 0) {
                topLevelType = descriptorType.substring(0, dollarPos);
                descriptorType = descriptorType.replace('$', '.');
            } else {
                topLevelType = descriptorType;
            }
        }
        if (descriptorType.equals(sourceType)) {
            return true;
        }
        if (descriptorType.indexOf(46) == -1) {
            return false;
        }
        if (JavaSyntaxTreeVisitorUtility.$assertionsDisabled || topLevelType != null) ** GOTO lbl26
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            descriptorType = descriptorType.substring(1);
            sourceType = sourceType.substring(1);
            topLevelType = topLevelType.substring(1);
lbl26:
            // 2 sources

            ** while (descriptorType.startsWith((String)"[") && sourceType.startsWith((String)"["))
        }
lbl27:
        // 1 sources

        if (descriptorType.startsWith("[") || sourceType.startsWith("[")) {
            return false;
        }
        if (importRegistry.isImported((String)topLevelType, (String)descriptorType)) {
            return descriptorType.endsWith("." + sourceType);
        }
        descriptor = parameterType.getDescriptor();
        if (JavaNameUtility.isPotentialNestedType(descriptor)) {
            if (descriptor.startsWith("L")) {
                descriptor = descriptor.substring(1);
            }
            if (descriptor.endsWith(";")) {
                descriptor = descriptor.substring(0, descriptor.length() - 1);
            }
            if (!(packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(descriptor = descriptor.replace('/', '.'))).isEmpty() && importRegistry.importsTypeFromPackage(packageName)) {
                return descriptor.endsWith("$" + sourceType);
            }
        }
        return false;
    }

    static final JavaMethod matchParameterTypes(IImportRegistry importRegistry, List<JavaMethod> candidates, List<String> formalParameterTypes) {
        assert (candidates != null) : "Parameter 'candidates' of method 'matchParameterTypes' must not be null";
        assert (formalParameterTypes != null) : "Parameter 'formalParameterTypes' of method 'matchParameterTypes' must not be null";
        JavaMethod bestMatch = null;
        int bestMatchCount = 0;
        for (JavaMethod method : candidates) {
            Type[] parameterTypes = method.getParameterTypes();
            assert (parameterTypes.length == formalParameterTypes.size());
            int matchCount = 0;
            int i = 0;
            while (i < parameterTypes.length) {
                if (JavaSyntaxTreeVisitorUtility.parameterTypeMatches(importRegistry, parameterTypes[i], formalParameterTypes.get(i))) {
                    ++matchCount;
                }
                ++i;
            }
            if (matchCount <= bestMatchCount) continue;
            bestMatch = method;
            bestMatchCount = matchCount;
        }
        return bestMatch;
    }

    private static boolean useForMatching(IJavaGlobalModel model, JavaMethod method) {
        assert (model != null) : "Parameter 'model' of method 'useForMatching' must not be null";
        assert (method != null) : "Parameter 'method' of method 'isSynthetic' must not be null";
        return method.isDefinedInEnclosingElement() && !method.hasFlag(JavaElementFlag.BRIDGE) && !method.hasFlag(JavaElementFlag.SYNTHETIC) && !model.memberHasBeenRemoved(method) && method.getLineNumber() == -1;
    }

    public static List<JavaMethod> getMethodsByName(IJavaGlobalModel model, ProgrammingElement type, String name) {
        assert (type != null) : "Parameter 'type' of method 'getMethodsByName' must not be null";
        assert (name != null) : "Parameter 'name' of method 'getMethodsByName' must not be null";
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>();
        List methods = type.getChildren(JavaNonInitializer.class, true);
        for (JavaMethod nextMethod : methods) {
            if (!JavaSyntaxTreeVisitorUtility.useForMatching(model, nextMethod) || !nextMethod.getShortName().equals(name)) continue;
            result.add(nextMethod);
        }
        return result;
    }

    private static List<JavaMethod> getConstructors(IJavaGlobalModel model, ProgrammingElement type) {
        assert (type != null) : "Parameter 'type' of method 'getConstructors' must not be null";
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>();
        List constructors = type.getChildren(JavaConstructor.class);
        for (JavaConstructor nextConstructor : constructors) {
            if (!JavaSyntaxTreeVisitorUtility.useForMatching(model, nextConstructor)) continue;
            result.add(nextConstructor);
        }
        return result;
    }

    static JavaField matchField(InnerNode arg, JavaElement parent, JavaFileParseResult result) {
        assert (arg != null) : "Parameter 'arg' of method 'matchField' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'matchField' must not be null";
        assert (result != null) : "Parameter 'result' of method 'matchField' must not be null";
        Node nameNode = arg.getChild("IDENT");
        assert (nameNode != null);
        String name = nameNode.getLexeme();
        Position pos = nameNode.getPosition();
        JavaField field = (JavaField)parent.getFirstChild((NamedElement.IFilter)new ShortNameFilter(name), JavaField.class);
        if (field != null) {
            field.setLineNumber(pos.getLine());
        } else {
            result.addErrorMessage("Cannot match field '" + name + "'", pos.getLine(), pos.getColumn());
        }
        return field;
    }

    static JavaMethod matchMethod(IImportRegistry importRegistry, String name, Node returnType, Node formalParameters, JavaElement parent, IJavaGlobalModel globalModel, boolean forRecords) {
        List<JavaMethod> methods;
        assert (formalParameters != null) : "Parameter 'formalParameters' of method 'matchMethod' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'matchMethod' must not be null";
        assert (globalModel != null) : "Parameter 'globalModel' of method 'matchMethod' must not be null";
        JavaMethod match = null;
        if (returnType != null) {
            assert (name != null) : "Parameter 'name' of method 'matchMethod' must not be null";
            methods = JavaSyntaxTreeVisitorUtility.getMethodsByName(globalModel, parent, name);
        } else {
            methods = forRecords ? parent.getChildren(JavaConstructor.class) : JavaSyntaxTreeVisitorUtility.getConstructors(globalModel, parent);
        }
        if (methods.size() == 1) {
            match = methods.get(0);
        } else if (methods.size() > 1) {
            List formalParameterTypes = (List)formalParameters.getAttribute(FORMAL_PARAMETER_TYPE_LIST);
            ArrayList<JavaMethod> parameterCountMatches = new ArrayList<JavaMethod>();
            for (JavaMethod method : methods) {
                if (method.getNumberOfParameters() != formalParameterTypes.size()) continue;
                parameterCountMatches.add(method);
            }
            if (parameterCountMatches.size() == 1) {
                match = (JavaMethod)parameterCountMatches.get(0);
            } else if (parameterCountMatches.size() > 1) {
                match = JavaSyntaxTreeVisitorUtility.matchParameterTypes(importRegistry, parameterCountMatches, formalParameterTypes);
            }
        }
        return match;
    }
}

