/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile;

import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Leaf;
import com.hello2morrow.javapg.runtime.tree.Node;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValueList;
import com.hello2morrow.sonargraph.core.model.annotation.BooleanAnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.ClassAnnotation;
import com.hello2morrow.sonargraph.core.model.annotation.EnumAnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.NumericAnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.StringAnnotationValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.AnonymousNestedTypesHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.AnonymousTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.FormalParameterLocationProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.InlineDependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaFileParseResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.LocationProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.DataType;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.FqTypeNameFilter;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.GenericParameterTable;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaSyntaxTreeVisitorUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.JavaVisitor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.UserTypeNameCollector;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaStaticBlock;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.CastInfo;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaSyntaxTreeVisitor
extends JavaVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSyntaxTreeVisitor.class);
    private static final String CLASS_BODY = "ClassBody";
    private static final String BLOCK = "Block";
    private static final String FORMAL_PARAMETERS = "FormalParameters";
    private static final String JAVA_LANG_OVERRIDE = "java.lang.Override";
    private static final String OVERRIDE = "Override";
    private static final String NAME = "name";
    private static final String TYPE_NAME = "type_name";
    private static final String IS_MEMBER = "is_member";
    private static final String PARAMETER_NAME_LIST = "pnl";
    private static final String IS_DOT_CLASS = "idc";
    private static final String HAS_CASE = "hasCase";
    private static final String HAS_BLOCK = "hasBlock";
    private static final String IS_BASIC_TYPE = "isBasic";
    private static final String ANNOTATION = "annotation";
    private static final String LIST = "list";
    private final Set<String> m_parametersAndLocals = new THashSet();
    private final List<String> m_currentAnnotations = new ArrayList<String>();
    private final Map<JavaType, List<JavaType>> m_typeToNestedAnonymousTypes = new THashMap();
    private final InlineDependencyProcessor m_inlineDependencyProcessor = new InlineDependencyProcessor();
    private final JavaFileParseResult m_result;
    private final IJavaGlobalModel m_globalModel;
    private final IJavaModuleModel m_moduleModel;
    private final TFile m_sourceFile;
    private GenericParameterTable m_genericTable = new GenericParameterTable(null);
    private String m_packageName;
    private JavaElement m_currentParent;
    private JavaMethod m_currentMethod;
    private Node m_currentModifiers;
    private boolean m_relativePathCalculated;
    private boolean m_inSwitchLabel;
    private Position m_catchTypeAt;
    private NestingInfo m_nestingInfo;
    private InnerNode m_recordFormalParameters;

    JavaSyntaxTreeVisitor(TFile sourceFile, IJavaGlobalModel globalModel, IJavaModuleModel moduleModel, JavaFileParseResult result) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'JavaSyntaxTreeVisitor' must not be null";
        assert (globalModel != null) : "Parameter 'globalModel' of method 'JavaSyntaxTreeVisitor' must not be null";
        assert (moduleModel != null) : "Parameter 'moduleModel' of method 'JavaSyntaxTreeVisitor' must not be null";
        assert (result != null) : "Parameter 'result' of method 'JavaSyntaxTreeVisitor' must not be null";
        this.m_globalModel = globalModel;
        this.m_moduleModel = moduleModel;
        this.m_sourceFile = sourceFile;
        this.m_result = result;
    }

    private JavaType getCurrentType() {
        if (this.m_currentParent == null) {
            return null;
        }
        if (this.m_currentParent instanceof JavaType) {
            return (JavaType)this.m_currentParent;
        }
        return (JavaType)this.m_currentParent.getParent(JavaType.class, new Class[0]);
    }

    private void incNesting() {
        if (this.m_nestingInfo != null) {
            this.m_nestingInfo.increment();
        }
    }

    private void decNesting() {
        if (this.m_nestingInfo != null) {
            this.m_nestingInfo.decrement();
        }
    }

    @Override
    public void visitImport(InnerNode arg) {
        Node identNode = arg.getChild("Name");
        arg.visitChildren((Visitor)this, new Node[0]);
        if (identNode != null) {
            this.m_inlineDependencyProcessor.processImport(arg.getChild("STATIC") != null, arg.getChild("MULT") != null, identNode.getString(NAME));
        }
    }

    private void calculateRelativePath() {
        if (!this.m_relativePathCalculated) {
            JavaSyntaxTreeVisitorUtility.calculateRelativeSourcePath(this.m_moduleModel, this.m_sourceFile, this.m_packageName, this.m_result);
            this.m_relativePathCalculated = true;
        }
    }

    @Override
    public void visitPackageSpec(InnerNode arg) {
        Node nameNode = arg.getChild("Name");
        nameNode.accept((Visitor)this);
        this.m_packageName = (String)arg.getAttribute("Name", NAME);
        assert (this.m_packageName != null);
        this.m_inlineDependencyProcessor.processImport(false, true, this.m_packageName);
        this.calculateRelativePath();
        if (this.m_sourceFile.getName().equals("package-info.java")) {
            String typeName = this.m_packageName + ".package-info";
            JavaType type = this.m_globalModel.getType(this.m_moduleModel.getModule(), typeName);
            Position pos = nameNode.getPosition();
            if (type != null) {
                type.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                type.setLineNumber(pos.getLine());
                this.m_result.addTopLevelElement(type);
                Node node = arg.getChild("Annotations");
                if (node != null) {
                    this.m_currentParent = type;
                    node.accept((Visitor)this);
                    List annotations = (List)node.getAttribute(LIST);
                    assert (annotations != null);
                    annotations.forEach(a -> this.m_inlineDependencyProcessor.addAnnotation(type, (Annotation)a));
                    this.m_currentParent = null;
                }
            } else {
                this.m_result.noClassFileFound("Missing class file for type '" + typeName + "'", pos);
            }
        }
    }

    @Override
    public void visitTopLevelTypeDecl(InnerNode arg) {
        if (arg.getChild("MemberDecl") != null) {
            String implicitClassName = FileUtility.removeExtension((String)this.m_sourceFile.getName());
            JavaType newCurrentType = this.m_globalModel.getType(this.m_moduleModel.getModule(), implicitClassName);
            if (newCurrentType != null) {
                newCurrentType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                newCurrentType.setLineNumber(1);
                this.m_result.addTopLevelElement(newCurrentType);
            } else {
                this.m_result.noClassFileFound("Missing class file for implicit type '" + implicitClassName + "'", arg.getPosition());
            }
            if (newCurrentType != null) {
                this.m_currentParent = newCurrentType;
                super.visitTopLevelTypeDecl(arg);
                this.m_currentParent = null;
            }
        } else {
            super.visitTopLevelTypeDecl(arg);
        }
    }

    @Override
    public void visitName(InnerNode arg) {
        String name = arg.getChildAt(0).getLexeme();
        arg.setAttribute(NAME, (Object)name);
    }

    private boolean enterType(InnerNode arg) {
        this.calculateRelativePath();
        if (!this.m_result.isDuplicate().isEmpty()) {
            return false;
        }
        Node node = arg.getChild("IDENT");
        assert (node != null);
        String name = node.getLexeme();
        JavaType currentType = this.getCurrentType();
        JavaType newCurrentType = null;
        Position pos = node.getPosition();
        if (currentType != null) {
            String nestedName = String.format("%s$%s", currentType.getFqName(), name);
            if (this.m_currentParent instanceof JavaType) {
                newCurrentType = (JavaType)this.m_currentParent.getFirstChild(new FqTypeNameFilter(nestedName), JavaType.class);
                if (newCurrentType != null) {
                    newCurrentType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                }
            } else {
                assert (this.m_currentParent instanceof JavaMethod);
                List nestedTypes = currentType.getChildren((NamedElement.IFilter)new ShortNameFilter(name), JavaType.class);
                int lowestIndex = Integer.MAX_VALUE;
                for (JavaType javaType : nestedTypes) {
                    int index;
                    String n;
                    int dollarPos;
                    if (javaType.getFqName().equals(nestedName) || javaType.getLineNumber() > 0 || (dollarPos = (n = javaType.getFqName()).lastIndexOf(36)) + 1 > n.length() - name.length()) continue;
                    String numberString = n.substring(dollarPos + 1, n.length() - name.length());
                    try {
                        index = Integer.parseInt(numberString);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (index >= lowestIndex) continue;
                    newCurrentType = javaType;
                    lowestIndex = index;
                }
                if (newCurrentType != null) {
                    newCurrentType.changeParent((NamedElement)this.m_currentParent, true);
                    newCurrentType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                }
            }
            if (newCurrentType == null) {
                this.m_result.noClassFileFound("Missing class file for type '" + nestedName + "'", pos);
            }
        } else {
            Object typeName = this.m_packageName != null ? this.m_packageName + "." + name : name;
            newCurrentType = this.m_globalModel.getType(this.m_moduleModel.getModule(), (String)typeName);
            if (newCurrentType != null) {
                newCurrentType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                this.m_result.addTopLevelElement(newCurrentType);
            } else {
                this.m_result.noClassFileFound("Missing class file for type '" + (String)typeName + "'", pos);
            }
        }
        if (newCurrentType != null) {
            this.m_currentParent = newCurrentType;
            if (this.m_currentModifiers != null) {
                this.m_currentModifiers.accept((Visitor)this);
                List annotations = (List)this.m_currentModifiers.getAttribute(LIST);
                assert (annotations != null);
                annotations.forEach(a -> this.m_inlineDependencyProcessor.addAnnotation(this.m_currentParent, (Annotation)a));
                this.m_currentModifiers = null;
            }
            newCurrentType.setLineNumber(pos.getLine());
            InnerNode nameList = (InnerNode)arg.getChild("NameList");
            if (nameList != null) {
                nameList.accept((Visitor)this);
                UserTypeNameCollector collector = new UserTypeNameCollector();
                nameList.accept((Visitor)collector);
                List<InnerNode> userTypeNames = collector.getUserTypeNames();
                if (this.spansMultipleLines(this.m_currentParent.getLineNumber(), userTypeNames)) {
                    for (Node node2 : userTypeNames) {
                        Position position;
                        String userTypeName = (String)node2.getAttribute(NAME);
                        if (userTypeName == null) {
                            userTypeName = ((InnerNode)node2).getChildAt(0).getLexeme();
                        }
                        if (userTypeName == null || (position = node2.getPosition()) == null) continue;
                        int lineNumber = position.getLine();
                        LocationProcessor processor = new LocationProcessor(newCurrentType, userTypeName, lineNumber, new IParserDependencyType[0]);
                        this.m_globalModel.addDependencyProcessor(processor);
                    }
                }
            }
        }
        return newCurrentType != null;
    }

    private void leaveType() {
        assert (this.m_currentParent != null) : "Parameter 'm_currentParent' of method 'leaveType' must not be null";
        this.m_currentParent = (JavaElement)this.m_currentParent.getParent(JavaElement.class, new Class[0]);
        if (this.m_currentParent instanceof JavaMethod) {
            this.m_currentMethod = (JavaMethod)this.m_currentParent;
        }
    }

    @Override
    public void visitTypeDeclaration(InnerNode arg) {
        if (arg.size() == 2) {
            this.m_currentModifiers = arg.getChildAt(0);
        }
        arg.getChildAt(arg.size() - 1).accept((Visitor)this);
    }

    @Override
    public void visitITypeDeclaration(InnerNode arg) {
        if (arg.size() == 2) {
            this.m_currentModifiers = arg.getChildAt(0);
        }
        arg.getChildAt(arg.size() - 1).accept((Visitor)this);
    }

    @Override
    public void visitClassDecl(InnerNode arg) {
        if (this.enterType(arg)) {
            this.m_genericTable = new GenericParameterTable(this.m_genericTable);
            arg.visitChildren((Visitor)this, new Node[0]);
            this.leaveType();
            this.m_genericTable = this.m_genericTable.pop();
        }
    }

    @Override
    public void visitRecordDecl(InnerNode arg) {
        if (this.enterType(arg)) {
            JavaMethod currentMethod;
            this.m_genericTable = new GenericParameterTable(this.m_genericTable);
            InnerNode formalParams = (InnerNode)arg.getChild(FORMAL_PARAMETERS);
            InnerNode oldRecordFormalParameters = this.m_recordFormalParameters;
            this.m_recordFormalParameters = formalParams;
            arg.visitChildren((Visitor)this, new Node[0]);
            if (this.m_recordFormalParameters != null && (currentMethod = JavaSyntaxTreeVisitorUtility.matchMethod(this.m_inlineDependencyProcessor, null, null, (Node)formalParams, this.m_currentParent, this.m_globalModel, true)) != null) {
                currentMethod.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                this.setInitializerInfo(arg, arg.getChild("IDENT").getPosition(), (JavaInitializer)currentMethod);
            }
            this.m_recordFormalParameters = oldRecordFormalParameters;
            for (Node child : formalParams.getChildren()) {
                if (!child.getNodeName().equals("FormalParameter")) continue;
                InnerNode param = (InnerNode)child;
                JavaSyntaxTreeVisitorUtility.matchField(param, this.m_currentParent, this.m_result);
            }
            this.leaveType();
            this.m_genericTable = this.m_genericTable.pop();
        }
    }

    @Override
    public void visitEnumDecl(InnerNode arg) {
        if (this.enterType(arg)) {
            arg.visitChildren((Visitor)this, new Node[0]);
            this.leaveType();
        }
    }

    @Override
    public void visitInterfaceDecl(InnerNode arg) {
        if (this.enterType(arg)) {
            this.m_genericTable = new GenericParameterTable(this.m_genericTable);
            arg.visitChildren((Visitor)this, new Node[0]);
            this.leaveType();
            this.m_genericTable = this.m_genericTable.pop();
        }
    }

    @Override
    public void visitAnnotationDecl(InnerNode arg) {
        if (this.enterType(arg)) {
            arg.visitChildren((Visitor)this, new Node[0]);
            this.leaveType();
        }
    }

    @Override
    public void visitModifiers(InnerNode arg) {
        arg.setAttribute(LIST, new ArrayList());
        arg.visitChildren((Visitor)this, new Node[0]);
    }

    @Override
    public void visitIModifiers(InnerNode arg) {
        arg.setAttribute(LIST, new ArrayList());
        arg.visitChildren((Visitor)this, new Node[0]);
    }

    @Override
    public void visitAnnotations(InnerNode arg) {
        ArrayList<Annotation> list = (ArrayList<Annotation>)this.getInheritedAttribute(LIST);
        if (list == null) {
            list = new ArrayList<Annotation>();
            arg.setAttribute(LIST, list);
        }
        arg.visitChildren((Visitor)this, new Node[0]);
        for (Node child : arg.getChildren()) {
            Annotation annotation = (Annotation)child.getAttribute(ANNOTATION);
            assert (annotation != null);
            list.add(annotation);
        }
    }

    @Override
    public void visitModifier(InnerNode arg) {
        List list;
        arg.visitChildren((Visitor)this, new Node[0]);
        Node annoNode = arg.getChild("Annotation");
        if (annoNode != null && (list = (List)this.getInheritedAttribute(LIST)) != null) {
            list.add((Annotation)annoNode.getAttribute(ANNOTATION));
        }
    }

    @Override
    public void visitAnnotation(InnerNode arg) {
        Node annotationNode = arg.getChildAt(0);
        Node nameNode = arg.getChild("Name");
        Object annotationName = annotationNode.getLexeme().substring(1);
        if (nameNode != null) {
            nameNode.accept((Visitor)this);
            annotationName = (String)annotationName + "." + nameNode.getString(NAME);
        }
        this.m_currentAnnotations.add((String)annotationName);
        Annotation annotation = new Annotation((String)annotationName, annotationNode.getPosition().getLine());
        arg.setAttribute(ANNOTATION, (Object)annotation);
        InnerNode node = (InnerNode)arg.getChild("ElementValue");
        if (node != null) {
            node.setAttribute(NAME, (Object)"value");
            node.setAttribute(ANNOTATION, (Object)annotation);
            node.accept((Visitor)this);
        } else {
            node = (InnerNode)arg.getChild("ElementValuePairs");
            if (node != null) {
                node.getChildren().forEach(n -> {
                    Object object = n.setAttribute(ANNOTATION, (Object)annotation);
                });
                node.accept((Visitor)this);
            }
        }
    }

    @Override
    public void visitElementValuePair(InnerNode arg) {
        String name = arg.getChildAt(0).getLexeme();
        Node elementValue = arg.getChild("ElementValue");
        elementValue.setAttribute(NAME, (Object)name);
        elementValue.setAttribute(ANNOTATION, arg.getAttribute(ANNOTATION));
        elementValue.accept((Visitor)this);
    }

    @Override
    public void visitElementValue(InnerNode arg) {
        String name = arg.getString(NAME);
        AnnotationValueList list = name == null ? (AnnotationValueList)this.getInheritedAttribute(LIST) : null;
        Annotation annotation = name != null ? (Annotation)arg.getAttribute(ANNOTATION) : null;
        AnnotationValueList value = null;
        if (arg.size() == 0) {
            value = new AnnotationValueList();
            arg.setAttribute(LIST, (Object)value);
            return;
        }
        Node first = arg.getChildAt(0);
        if (first.getNodeName().equals("Annotation")) {
            first.accept((Visitor)this);
            value = (AnnotationValue)first.getAttribute(ANNOTATION);
        } else if (first.getNodeName().equals("ElementValue")) {
            value = new AnnotationValueList();
            arg.setAttribute(LIST, (Object)value);
            arg.visitChildren((Visitor)this, new Node[0]);
        } else {
            first.accept((Visitor)this);
            List terminals = first.collectTerminals();
            if (terminals.size() == 1) {
                Node term = (Node)terminals.get(0);
                switch (term.getType()) {
                    case 6: {
                        value = new NumericAnnotationValue((Number)Long.decode(StringUtility.removeTrailingNonDigitsAndUnderscores((String)term.getLexeme())));
                        break;
                    }
                    case 7: {
                        value = new NumericAnnotationValue((Number)Double.valueOf(StringUtility.removeTrailingNonDigitsAndUnderscores((String)term.getLexeme())));
                        break;
                    }
                    case 38: {
                        value = new BooleanAnnotationValue(true);
                        break;
                    }
                    case 18: {
                        value = new BooleanAnnotationValue(false);
                        break;
                    }
                    case 5: {
                        value = new StringAnnotationValue(StringUtility.decodeStringLiteral((String)StringUtility.removeFirstAndLastChar((String)term.getLexeme())));
                        break;
                    }
                    case 4: {
                        value = new NumericAnnotationValue((Number)StringUtility.decodeStringLiteral((String)StringUtility.removeFirstAndLastChar((String)term.getLexeme())).charAt(0));
                        break;
                    }
                    case 2: 
                    case 10: {
                        value = new EnumAnnotationValue(term.getLexeme(), term.getPosition().getLine());
                    }
                }
            } else if (terminals.size() == 2 && ((Node)terminals.get(1)).getType() == 41) {
                Node nameNode = (Node)terminals.get(0);
                if (nameNode.getLexeme() == null) {
                    String basicType = nameNode.getNodeName().toLowerCase();
                    value = new StringAnnotationValue(basicType + ".class");
                } else {
                    value = new ClassAnnotation(nameNode.getLexeme(), nameNode.getPosition().getLine());
                }
            }
        }
        if (value != null) {
            if (name != null) {
                assert (annotation != null);
                annotation.addValue(name, (AnnotationValue)value);
            } else if (list != null) {
                list.addValue((AnnotationValue)value);
            }
        }
    }

    @Override
    public void visitAnnoElementRest(InnerNode arg) {
        Position position;
        Node child;
        if (arg != null && this.m_currentParent instanceof JavaType && this.m_currentParent.hasFlag(JavaElementFlag.ANNOTATION) && (child = arg.getChild("IDENT")) != null && (position = child.getPosition()) != null) {
            List<JavaMethod> methods = JavaSyntaxTreeVisitorUtility.getMethodsByName(this.m_globalModel, this.m_currentParent, child.getLexeme());
            if (methods.size() == 1) {
                JavaMethod method = methods.get(0);
                if (method.getNumberOfParameters() == 0) {
                    method.setLineNumber(position.getLine());
                }
            } else {
                this.m_result.addErrorMessage("Annotation method '" + child.getLexeme() + "' not found in byte code", position.getLine(), position.getColumn());
            }
        }
        super.visitAnnoElementRest(arg);
    }

    private List<JavaType> getNestedAnonymousTypes(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getNestedAnonymousTypes' must not be null";
        List<JavaType> nestedAnonymousTypes = this.m_typeToNestedAnonymousTypes.get(type);
        if (nestedAnonymousTypes == null) {
            nestedAnonymousTypes = AnonymousNestedTypesHelper.getNestedAnonymousTypes(type);
            this.m_typeToNestedAnonymousTypes.put(type, nestedAnonymousTypes);
        }
        return nestedAnonymousTypes;
    }

    private JavaType matchNonSyntheticNestedAnonymousType(InnerNode classBody, JavaType type, int line) {
        JavaType result;
        assert (classBody != null) : "Parameter 'classBody' of method 'matchNonSyntheticNestedAnonymousType' must not be null";
        assert (type != null) : "Parameter 'type' of method 'matchNonSyntheticNestedAnonymousType' must not be null";
        List<JavaType> nestedAnonymousTypes = this.getNestedAnonymousTypes(type);
        if (nestedAnonymousTypes.size() == 1) {
            JavaType result2 = nestedAnonymousTypes.get(0);
            nestedAnonymousTypes.remove(result2);
            return result2;
        }
        for (JavaType nextNestedType : nestedAnonymousTypes) {
            int firstMethodLine;
            AnonymousTypeInfo nextInfo = this.m_moduleModel.getAnonymousTypeInfo(nextNestedType);
            if (nextInfo == null || (firstMethodLine = nextInfo.getLineNumberOfFirstInstructionInMethod()) <= 0) continue;
            for (Node node : classBody.getChildren()) {
                Position last;
                Position first;
                if (node.isLeaf() || firstMethodLine < (first = node.getPosition()).getLine() || firstMethodLine > (last = node.getEndPosition()).getLine()) continue;
                nestedAnonymousTypes.remove(nextNestedType);
                return nextNestedType;
            }
        }
        ArrayList<JavaType> candidates = new ArrayList<JavaType>();
        block2: for (JavaType nextNestedType : nestedAnonymousTypes) {
            AnonymousTypeInfo nextInfo = this.m_moduleModel.getAnonymousTypeInfo(nextNestedType);
            if (nextInfo == null) continue;
            for (Map.Entry entry : nextInfo.getInstantiationInfo().entrySet()) {
                if (this.m_currentMethod != entry.getKey()) continue;
                for (Integer nextLine : (List)entry.getValue()) {
                    if (line != nextLine) continue;
                    candidates.add(nextNestedType);
                    continue block2;
                }
            }
        }
        if (candidates.size() == 1) {
            result = (JavaType)candidates.get(0);
            nestedAnonymousTypes.remove(result);
            return result;
        }
        if (nestedAnonymousTypes.isEmpty()) {
            return null;
        }
        result = nestedAnonymousTypes.get(0);
        nestedAnonymousTypes.remove(result);
        return result;
    }

    @Override
    public void visitEnumConstant(InnerNode arg) {
        JavaField field = JavaSyntaxTreeVisitorUtility.matchField(arg, this.m_currentParent, this.m_result);
        if (field != null) {
            field.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            Node body = arg.getChild(CLASS_BODY);
            JavaType currentType = (JavaType)field.getParent();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (Node child : arg.getChildren()) {
                if (child == body) {
                    Position pos = arg.getChild("IDENT").getPosition();
                    assert (pos != null) : "'pos' of method 'visitEnumConstant' must not be null";
                    JavaType matchedType = this.matchNonSyntheticNestedAnonymousType((InnerNode)body, currentType, pos.getLine());
                    if (matchedType == null) {
                        this.m_result.noClassFileFound("Missing class file for anonymous type", pos);
                        continue;
                    }
                    matchedType.setLineNumber(pos.getLine());
                    JavaElement currentParent = this.m_currentParent;
                    matchedType.changeParent((NamedElement)field, true);
                    matchedType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                    this.m_currentParent = matchedType;
                    assert (this.m_currentMethod == null) : "'m_currentMethod' must be 'null'";
                    body.accept((Visitor)this);
                    this.m_currentParent = currentParent;
                    continue;
                }
                child.accept((Visitor)this);
                if (!child.getNodeName().equals("Annotation")) continue;
                annotations.add((Annotation)child.getAttribute(ANNOTATION));
            }
            annotations.forEach(a -> this.m_inlineDependencyProcessor.addAnnotation(field, (Annotation)a));
        }
    }

    @Override
    public void visitFormalParameter(InnerNode arg) {
        super.visitFormalParameter(arg);
        Node typeNode = arg.getChild("NakedType");
        Object typeName = typeNode.getString(NAME);
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        assert (typeName != null);
        List bracketNodes = arg.getChildren("EMPTY_BRACKETS");
        for (Node bracketsNode : bracketNodes) {
            String brackets = bracketsNode.getLexeme();
            int i = brackets.length();
            while (i > 0) {
                typeName = "[" + (String)typeName;
                i -= 2;
            }
        }
        arg.setAttribute(TYPE_NAME, typeName);
        arg.setAttribute(NAME, (Object)name);
        arg.setAttribute(IS_BASIC_TYPE, typeNode.getAttribute(IS_BASIC_TYPE));
    }

    @Override
    public void visitFormalParameters(InnerNode arg) {
        super.visitFormalParameters(arg);
        ArrayList<String> formalParameterTypes = new ArrayList<String>();
        ArrayList<String> formalParameterNames = new ArrayList<String>();
        int i = 0;
        while (i < arg.size()) {
            Node node = arg.getChildAt(i);
            if (node.getNodeName().equals("FormalParameter")) {
                formalParameterTypes.add(node.getString(TYPE_NAME));
                formalParameterNames.add(node.getString(NAME));
            }
            ++i;
        }
        arg.setAttribute("fptl", formalParameterTypes);
        arg.setAttribute(PARAMETER_NAME_LIST, formalParameterNames);
    }

    @Override
    public void visitBasicType(InnerNode arg) {
        DataType type = DataType.valueOf(arg.getChildAt(0).getNodeName());
        assert (type != null);
        arg.setAttribute(NAME, (Object)type.getCharAsString());
        arg.setAttribute(IS_BASIC_TYPE, (Object)Boolean.TRUE);
    }

    @Override
    public void visitFormalTypeArg(InnerNode arg) {
        Node identNode = arg.getChildAt(0);
        Node typeNameNode = arg.getChild("UserTypeName");
        String typeBoundary = "java.lang.Object";
        if (typeNameNode != null) {
            typeNameNode.accept((Visitor)this);
            typeBoundary = typeNameNode.getString(NAME);
        }
        this.m_genericTable.define(identNode.getLexeme(), typeBoundary);
    }

    private int getEndLine(InnerNode node, int currentLine) {
        assert (node != null) : "Parameter 'node' of method 'getEndLine' must not be null";
        int line = currentLine;
        Position pos = node.getEndPosition();
        if (pos != null) {
            line = Math.max(line, pos.getLine());
        }
        for (Node nextChild : node.getChildren()) {
            if (!(nextChild instanceof InnerNode)) continue;
            line = Math.max(line, this.getEndLine((InnerNode)nextChild, line));
        }
        return line;
    }

    private void setInitializerInfo(InnerNode innerNode, Position position, JavaInitializer initializer) {
        assert (innerNode != null) : "Parameter 'innerNode' of method 'setInitializerInfo' must not be null";
        assert (initializer != null) : "Parameter 'initializer' of method 'setInitializerInfo' must not be null";
        initializer.setLineNumber(position.getLine());
        Node block = innerNode.getChild(BLOCK);
        if (block != null && block instanceof InnerNode && !((InnerNode)block).getChildren().isEmpty()) {
            int endLine = this.getEndLine((InnerNode)block, -1);
            this.m_globalModel.addLineRange(initializer, position.getLine(), endLine);
        } else {
            initializer.addFlag(JavaElementFlag.EMPTY);
        }
    }

    @Override
    public void visitClassBodyDecl(InnerNode arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitClassBodyDecl' must not be null";
        if (arg.getChild("STATIC") != null) {
            JavaStaticBlock staticInitializer = (JavaStaticBlock)this.m_currentParent.getUniqueChild(JavaStaticBlock.class);
            Position pos = arg.getChildAt(0).getPosition();
            if (staticInitializer != null) {
                staticInitializer.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                this.m_currentParent = staticInitializer;
                this.m_currentMethod = staticInitializer;
                this.m_currentMethod.initMetrics();
                NestingInfo oldNestingInfo = this.m_nestingInfo;
                this.m_nestingInfo = new NestingInfo();
                arg.visitChildren((Visitor)this, new Node[0]);
                this.m_currentMethod.setMaxNesting(this.m_nestingInfo.m_maxNesting);
                this.m_nestingInfo = oldNestingInfo;
                this.m_currentParent = this.getCurrentType();
                this.m_currentMethod = null;
                this.setInitializerInfo(arg, pos, staticInitializer);
            } else {
                Node block = arg.getChild(BLOCK);
                if (block != null && block instanceof InnerNode && !((InnerNode)block).getChildren().isEmpty()) {
                    this.m_result.addErrorMessage("Static initializer not found in byte code", pos.getLine(), pos.getColumn());
                }
                arg.visitChildren((Visitor)this, new Node[0]);
            }
        } else if (arg.getChild(BLOCK) == null) {
            arg.visitChildren((Visitor)this, new Node[0]);
        }
    }

    private void processMember(InnerNode innerNode, boolean inInterface) {
        Node members;
        assert (innerNode != null) : "Parameter 'innerNode' of method 'processMember' must not be null";
        Node modifiers = inInterface ? innerNode.getChild("IModifiers") : innerNode.getChild("Modifiers");
        Node classOrInterface = innerNode.getChild("ClassOrInterface");
        List annotations = null;
        this.m_currentAnnotations.clear();
        if (classOrInterface != null) {
            this.m_currentModifiers = modifiers;
        } else if (modifiers == null) {
            annotations = Collections.emptyList();
        } else {
            modifiers.accept((Visitor)this);
            annotations = (List)modifiers.getAttribute(LIST);
            assert (annotations != null);
        }
        this.m_genericTable = new GenericParameterTable(this.m_genericTable);
        Node node = members = inInterface ? innerNode.getChild("ConstantDecls") : innerNode.getChild("VariableDecls");
        if (members != null) {
            assert (annotations != null);
            innerNode.setAttribute(LIST, (Object)annotations);
            members.setAttribute(IS_MEMBER, (Object)Boolean.TRUE);
        }
        this.pushParent(innerNode);
        Node blockNode = innerNode.getChild(BLOCK);
        Node throwList = innerNode.getChild("ThrowList");
        int i = 0;
        while (i < innerNode.size()) {
            Node node2 = innerNode.getChildAt(i);
            if (node2 != blockNode && node2 != modifiers && node2 != throwList) {
                node2.accept((Visitor)this);
            }
            ++i;
        }
        InnerNode formalParameters = (InnerNode)innerNode.getChild(FORMAL_PARAMETERS);
        if (blockNode != null && formalParameters == null) {
            formalParameters = this.m_recordFormalParameters;
            this.m_recordFormalParameters = null;
        }
        if (formalParameters != null) {
            String methodName;
            JavaMethod currentMethod;
            Node idNode = innerNode.getChild("IDENT");
            Position pos = idNode.getPosition();
            Node returnType = innerNode.getChild("NakedType");
            if (returnType == null) {
                returnType = innerNode.getChild("Type");
            }
            if ((currentMethod = JavaSyntaxTreeVisitorUtility.matchMethod(this.m_inlineDependencyProcessor, methodName = idNode.getLexeme(), returnType, (Node)formalParameters, this.m_currentParent, this.m_globalModel, false)) == null) {
                if (blockNode != null && blockNode instanceof InnerNode && !((InnerNode)blockNode).getChildren().isEmpty()) {
                    this.m_result.addErrorMessage("Method '" + methodName + "' not found in byte code", pos.getLine(), pos.getColumn());
                }
            } else {
                assert (annotations != null);
                annotations.forEach(a -> this.m_inlineDependencyProcessor.addAnnotation(currentMethod, (Annotation)a));
                this.m_currentParent = currentMethod;
                this.m_currentMethod = currentMethod;
                this.m_currentMethod.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                if (throwList != null) {
                    throwList.accept((Visitor)this);
                }
                if (blockNode != null && blockNode instanceof InnerNode) {
                    this.m_parametersAndLocals.addAll((List)formalParameters.getAttribute(PARAMETER_NAME_LIST));
                    if (this.m_currentAnnotations.contains(OVERRIDE) || this.m_currentAnnotations.contains(JAVA_LANG_OVERRIDE)) {
                        this.m_currentMethod.addFlag(JavaElementFlag.OVERRIDES);
                    }
                    this.m_currentMethod.initMetrics();
                    if (this.m_currentMethod instanceof JavaInitializer) {
                        this.setInitializerInfo(innerNode, pos, (JavaInitializer)this.m_currentMethod);
                    } else {
                        assert (this.m_currentMethod instanceof JavaNonInitializer) : "Unexpected class in method 'processMember': " + String.valueOf(this.m_currentMethod);
                        this.m_currentMethod.setLineNumber(pos.getLine());
                        if (blockNode instanceof InnerNode && !((InnerNode)blockNode).getChildren().isEmpty()) {
                            int endLine = this.getEndLine((InnerNode)blockNode, -1);
                            this.m_globalModel.addLineRange(this.m_currentMethod, pos.getLine(), endLine);
                            ((JavaNonInitializer)this.m_currentMethod).setEndLineNumber(endLine);
                        }
                    }
                    NestingInfo oldNestingInfo = this.m_nestingInfo;
                    this.m_nestingInfo = new NestingInfo();
                    blockNode.accept((Visitor)this);
                    this.m_currentMethod.setMaxNesting(this.m_nestingInfo.m_maxNesting);
                    this.m_nestingInfo = oldNestingInfo;
                    this.m_parametersAndLocals.clear();
                } else {
                    this.m_currentMethod.addFlag(JavaElementFlag.ABSTRACT);
                    if (pos != null) {
                        currentMethod.setLineNumber(pos.getLine());
                    }
                }
                if (this.spansMultipleLines(this.m_currentMethod.getLineNumber(), formalParameters.getChildren())) {
                    for (Node formalParameter : formalParameters.getChildren()) {
                        List parameterAnnotations;
                        if (formalParameter.getAttribute(IS_BASIC_TYPE) == null) {
                            String typeName = (String)formalParameter.getAttribute(TYPE_NAME);
                            typeName = typeName.replace("[", "");
                            int line = ((InnerNode)formalParameter).getChild("NakedType").getPosition().getLine();
                            FormalParameterLocationProcessor proc = new FormalParameterLocationProcessor(this.m_currentMethod, typeName, line, JavaDependencyType.PARAMETER);
                            this.m_globalModel.addDependencyProcessor(proc);
                            UserTypeNameCollector collector = new UserTypeNameCollector();
                            formalParameter.accept((Visitor)collector);
                            for (InnerNode node3 : collector.getUserTypeNames()) {
                                int line1 = node3.getPosition().getLine();
                                String userTypeName = (String)node3.getAttribute(NAME);
                                if (userTypeName == null) {
                                    userTypeName = node3.getChildAt(0).getLexeme();
                                }
                                if (userTypeName != null) {
                                    FormalParameterLocationProcessor proc1 = new FormalParameterLocationProcessor(this.m_currentMethod, userTypeName, line1, JavaDependencyType.TYPE_ARGUMENT);
                                    this.m_globalModel.addDependencyProcessor(proc1);
                                    continue;
                                }
                                LOGGER.warn("userTypeName shouldn't be null");
                            }
                        }
                        if ((parameterAnnotations = (List)((InnerNode)formalParameter).getAttribute("Modifiers", LIST)) == null) continue;
                        for (Annotation parameterAnnotation : parameterAnnotations) {
                            FormalParameterLocationProcessor proc2 = new FormalParameterLocationProcessor(this.m_currentMethod, parameterAnnotation.getAnnotationClassName(), parameterAnnotation.getLineNumber(), JavaDependencyType.HAS_ANNOTATION);
                            this.m_globalModel.addDependencyProcessor(proc2);
                        }
                    }
                }
                this.m_currentParent = this.getCurrentType();
                this.m_currentMethod = null;
            }
        }
        this.m_genericTable = this.m_genericTable.pop();
        this.popParent();
    }

    private boolean spansMultipleLines(int lineNumber, List<? extends Node> nodes) {
        assert (nodes != null) : "Parameter 'nodes' of method 'spansMultipleLines' must not be null";
        for (Node node : nodes) {
            if (node.getAttribute(IS_BASIC_TYPE) == Boolean.TRUE || node.getPosition().getLine() == lineNumber) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitMemberDecl(InnerNode arg) {
        this.processMember(arg, false);
    }

    @Override
    public void visitInterfaceBodyDecl(InnerNode arg) {
        this.processMember(arg, true);
    }

    @Override
    public void visitConstantDecl(InnerNode arg) {
        JavaField field;
        if (this.getParentNode().getAttribute(IS_MEMBER) != null && (field = JavaSyntaxTreeVisitorUtility.matchField(arg, this.m_currentParent, this.m_result)) != null) {
            List annotations = (List)this.getInheritedAttribute(LIST);
            annotations.forEach(a -> this.m_inlineDependencyProcessor.addAnnotation(field, (Annotation)a));
            field.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
        }
        arg.visitChildren((Visitor)this, new Node[0]);
    }

    @Override
    public void visitVariableDecl(InnerNode arg) {
        JavaField field;
        if (this.getParentNode().getAttribute(IS_MEMBER) != null && (field = JavaSyntaxTreeVisitorUtility.matchField(arg, this.m_currentParent, this.m_result)) != null) {
            List annotations = (List)this.getInheritedAttribute(LIST);
            annotations.forEach(a -> this.m_inlineDependencyProcessor.addAnnotation(field, (Annotation)a));
            field.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
            JavaElement parent = this.m_currentParent;
            this.m_currentParent = field;
            try {
                arg.visitChildren((Visitor)this, new Node[0]);
            }
            finally {
                this.m_currentParent = parent;
            }
        }
        if (this.m_currentParent instanceof JavaMethod) {
            Node identNode = arg.getChild("IDENT");
            String name = identNode.getLexeme();
            Position pos = identNode.getPosition();
            this.m_globalModel.foundLocalVariable((JavaMethod)this.m_currentParent, name, pos.getLine());
            this.m_parametersAndLocals.add(name);
            arg.visitChildren((Visitor)this, new Node[0]);
        }
    }

    @Override
    public void visitCatch(InnerNode arg) {
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        this.m_parametersAndLocals.add(name);
        super.visitCatch(arg);
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
        }
    }

    @Override
    public void visitType(InnerNode arg) {
        super.visitType(arg);
        Object name = arg.getChildAt(0).getString(NAME);
        List nodes = arg.getChildren("EMPTY_BRACKETS");
        for (Node node : nodes) {
            int arrayDimensions = node.getLexeme().length() / 2;
            int i = 0;
            while (i < arrayDimensions) {
                name = "[" + (String)name;
                ++i;
            }
        }
        if (arg.getChild("VARARGS") != null) {
            name = "[" + (String)name;
        }
        arg.setAttribute(NAME, name);
    }

    @Override
    public void visitNakedType(InnerNode arg) {
        this.visitType(arg);
        Node node = arg.getChildAt(0);
        if (node.getAttribute(IS_BASIC_TYPE) != null) {
            arg.setAttribute(IS_BASIC_TYPE, (Object)Boolean.TRUE);
        }
    }

    @Override
    public void visitTypeName(InnerNode arg) {
        super.visitTypeName(arg);
        arg.setAttribute(NAME, arg.getChildAt(arg.size() - 1).getAttribute(NAME));
    }

    @Override
    public void visitNakedTypeName(InnerNode arg) {
        this.visitTypeName(arg);
        Node node = arg.getChildAt(0);
        if (node.getAttribute(IS_BASIC_TYPE) != null) {
            arg.setAttribute(IS_BASIC_TYPE, (Object)Boolean.TRUE);
        }
    }

    @Override
    public void visitThrowList(InnerNode arg) {
        super.visitThrowList(arg);
        InnerNode nameList = (InnerNode)arg.getChild("NameList");
        List userTypeNames = nameList.getChildren();
        assert (this.m_currentMethod != null) : "'m_currentMethod' in method 'visitThrowList' must not be null";
        if (this.spansMultipleLines(this.m_currentMethod.getLineNumber(), userTypeNames)) {
            for (Node userType : userTypeNames) {
                Position position;
                String userTypeName = (String)userType.getAttribute(NAME);
                if (userTypeName == null || (position = userType.getPosition()) == null) continue;
                int lineNumber = position.getLine();
                LocationProcessor processor = new LocationProcessor(this.m_currentMethod, userTypeName, lineNumber, JavaDependencyType.THROWS);
                this.m_globalModel.addDependencyProcessor(processor);
            }
        }
    }

    @Override
    public void visitUserTypeName(InnerNode arg) {
        super.visitUserTypeName(arg);
        String name = arg.getChildAt(0).getString(NAME);
        String translatedName = this.m_genericTable.lookup(name);
        if (translatedName != null) {
            name = translatedName;
        }
        LOGGER.debug("visitUserTypeName {}", (Object)name);
        StringBuilder sb = new StringBuilder(name);
        int i = 1;
        while (i < arg.size()) {
            Node node = arg.getChildAt(i);
            sb.append('.').append(node.getString(NAME));
            ++i;
        }
        arg.setAttribute(NAME, (Object)sb.toString());
    }

    @Override
    public void visitNakedUserTypeName(InnerNode arg) {
        this.visitUserTypeName(arg);
    }

    @Override
    public void visitNakedComplexType(InnerNode arg) {
        this.visitComplexType(arg);
    }

    @Override
    public void visitNakedTypeNameElement(InnerNode arg) {
        this.visitTypeNameElement(arg);
    }

    @Override
    public void visitComplexType(InnerNode arg) {
        super.visitComplexType(arg);
        String firstName = arg.getChildAt(0).getString(NAME);
        LOGGER.debug("visitComplexType {}", (Object)firstName);
        StringBuilder nameBuffer = new StringBuilder(firstName);
        int i = 1;
        while (i < arg.size()) {
            Node node = arg.getChildAt(i);
            String name = node.getString(NAME);
            if (name != null) {
                nameBuffer.append('.').append(name);
            }
            ++i;
        }
        arg.setAttribute(NAME, (Object)nameBuffer.toString());
    }

    @Override
    public void visitTypeNameElement(InnerNode arg) {
        super.visitTypeNameElement(arg);
        Node idNode = arg.getChild("IDENT");
        if (idNode == null) {
            idNode = arg.getChild("QIDENT");
        }
        String name = idNode.getLexeme();
        LOGGER.debug("visitTypeNameElement {}", (Object)name);
        arg.setAttribute(NAME, (Object)name);
    }

    @Override
    public void visitIDENT(Leaf arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitIDENT' must not be null";
        arg.setAttribute(NAME, (Object)arg.getLexeme());
        if (this.m_catchTypeAt != null) {
            assert (this.m_currentMethod instanceof JavaNonInitializer) : "Unexpected class in method 'visitIDENT': " + String.valueOf(this.m_currentMethod);
            this.m_globalModel.addCatchedTypeNameAt((JavaNonInitializer)this.m_currentMethod, JavaNameUtility.getTypeNameFromFqTypeName(arg.getLexeme()), this.m_catchTypeAt.getLine());
        }
    }

    @Override
    public void visitQIDENT(Leaf arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitQIDENT' must not be null";
        arg.setAttribute(NAME, (Object)arg.getLexeme());
    }

    @Override
    public void visitTerm(InnerNode arg) {
        super.visitTerm(arg);
        if (arg.size() >= 2) {
            Node firstChild = arg.getChildAt(0);
            Node secondChild = arg.getChildAt(1);
            if (firstChild.getNodeName().equals("Primary") && secondChild.getNodeName().equals("Selector")) {
                String name;
                if (secondChild.getAttribute(IS_DOT_CLASS) != null && (name = firstChild.getString(NAME)) != null) {
                    JavaType currentType = this.getCurrentType();
                    this.m_inlineDependencyProcessor.addDotClassUsage(this.m_moduleModel.getModule(), this.getFromElementForInlineDependency(this.m_currentParent, this.getCurrentType()), currentType, name, firstChild.getPosition().getLine());
                }
            } else if (firstChild.getType() == 96) {
                Position position = firstChild.getPosition();
                assert (position != null) : "'position' of method 'visitTerm' must not be null";
                assert (this.m_currentParent != null) : "'m_currentParent' of method 'visitTerm' must not be null";
                int i = 1;
                while (i < arg.size()) {
                    String nextTypeName;
                    Node nextNode = arg.getChildAt(i);
                    if (nextNode.getType() == 97) break;
                    if (nextNode.getNodeName().equals("Type") && nextNode.getAttribute(IS_BASIC_TYPE) == null && (nextTypeName = (String)nextNode.getAttribute(NAME)) != null && !nextTypeName.isEmpty()) {
                        this.m_globalModel.addCast(this.m_currentParent, new CastInfo(nextTypeName, position.getLine()));
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void visitCatchType(InnerNode arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitCatchType' must not be null";
        if (this.m_currentMethod instanceof JavaNonInitializer) {
            this.m_catchTypeAt = arg.getPosition();
        }
        super.visitCatchType(arg);
        this.m_catchTypeAt = null;
    }

    @Override
    public void visitSelector(InnerNode arg) {
        super.visitSelector(arg);
        if (arg.size() >= 1 && arg.getChildAt(arg.size() - 1).getNodeName().equals("CLASS")) {
            arg.setAttribute(IS_DOT_CLASS, (Object)Boolean.TRUE);
        }
    }

    private void handleSwitchLabel(InnerNode node) {
        String name;
        Node identChild;
        assert (node != null) : "Parameter 'node' of method 'handleSwitchLabel' must not be null";
        if (this.m_currentMethod != null && (identChild = node.getChild("IDENT")) != null && (name = identChild.getLexeme()) != null && !name.isEmpty()) {
            this.m_globalModel.addSwitchCaseInformation(this.m_currentMethod, identChild.getLexeme(), identChild.getPosition().getLine());
        }
    }

    private JavaElement getFromElementForInlineDependency(JavaElement from, JavaType type) {
        assert (from != null) : "Parameter 'from' of method 'getFromElementForInlineDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'getFromElementForInlineDependency' must not be null";
        if (from instanceof JavaField) {
            assert (from.hasAsParent((NamedElement)type, true)) : "Field is not a direct child of '" + type.getFullyQualifiedName() + "'";
            return type;
        }
        return from;
    }

    @Override
    public void visitPrimary(InnerNode arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitPrimary' must not be null";
        Node body = arg.getChild(CLASS_BODY);
        if (body != null) {
            Node typeName = arg.getChild("TypeName");
            JavaType currentType = this.getCurrentType();
            for (Node child : arg.getChildren()) {
                if (child == body) {
                    Position pos = typeName.getPosition();
                    assert (pos != null) : "'pos' of method 'visitPrimary' must not be null";
                    JavaType matchedType = this.matchNonSyntheticNestedAnonymousType((InnerNode)body, currentType, pos.getLine());
                    if (matchedType == null) {
                        this.m_result.noClassFileFound("Missing class file for anonymous type", pos);
                        continue;
                    }
                    matchedType.setLineNumber(pos.getLine());
                    if (this.m_currentParent != matchedType.getParent()) {
                        matchedType.changeParent((NamedElement)this.m_currentParent, true);
                    }
                    matchedType.addFlag(JavaElementFlag.FOUND_IN_SOURCE);
                    this.m_currentParent = matchedType;
                    this.m_currentMethod = null;
                    body.accept((Visitor)this);
                    this.m_currentParent = (JavaElement)this.m_currentParent.getParent(JavaElement.class, new Class[0]);
                    if (!(this.m_currentParent instanceof JavaMethod)) continue;
                    this.m_currentMethod = (JavaMethod)this.m_currentParent;
                    continue;
                }
                child.accept((Visitor)this);
            }
        } else {
            Node node;
            String nodeName;
            arg.visitChildren((Visitor)this, new Node[0]);
            if (arg.size() == 1) {
                Node node2 = arg.getChildAt(0);
                String name = node2.getLexeme();
                if (name != null && !name.isEmpty()) {
                    String nodeName2 = node2.getNodeName();
                    Position pos = node2.getPosition();
                    if (nodeName2.equals("IDENT") && !this.m_parametersAndLocals.contains(name)) {
                        this.m_inlineDependencyProcessor.addSimplePotentialInlineDependency(this.m_moduleModel.getModule(), this.getFromElementForInlineDependency(this.m_currentParent, this.getCurrentType()), this.getCurrentType(), name, pos.getLine());
                    } else if (nodeName2.equals("QIDENT")) {
                        this.m_inlineDependencyProcessor.addQualifiedPotentialInlineDependency(this.m_moduleModel.getModule(), this.getFromElementForInlineDependency(this.m_currentParent, this.getCurrentType()), this.getCurrentType(), name, pos.getLine());
                    }
                    arg.setAttribute(NAME, (Object)name);
                }
            } else if (arg.size() > 1 && arg.getChildAt(1).getType() != 91 && (nodeName = (node = arg.getChildAt(0)).getNodeName()).equals("QIDENT")) {
                String name = node.getLexeme();
                Position position = node.getPosition();
                int pos = name.lastIndexOf(46);
                if (pos > 0) {
                    String potName = name.substring(0, pos);
                    if (StringUtility.countChar((char)'.', (String)potName) == 0) {
                        this.m_inlineDependencyProcessor.addSimplePotentialInlineDependency(this.m_moduleModel.getModule(), this.getFromElementForInlineDependency(this.m_currentParent, this.getCurrentType()), this.getCurrentType(), potName, position.getLine());
                    } else {
                        this.m_inlineDependencyProcessor.addQualifiedPotentialInlineDependency(this.m_moduleModel.getModule(), this.getFromElementForInlineDependency(this.m_currentParent, this.getCurrentType()), this.getCurrentType(), potName, position.getLine());
                    }
                }
            }
        }
        if (this.m_inSwitchLabel) {
            this.handleSwitchLabel(arg);
        }
    }

    @Override
    public void visitForStatement(InnerNode arg) {
        this.incNesting();
        super.visitForStatement(arg);
        this.decNesting();
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
    }

    @Override
    public void visitIfStatement(InnerNode arg) {
        if (arg.size() == 3) {
            arg.getChildAt(0).accept((Visitor)this);
            this.incNesting();
            arg.getChildAt(1).accept((Visitor)this);
            this.decNesting();
            InnerNode elseNode = (InnerNode)arg.getChildAt(2);
            if (elseNode.getChildAt(0).getNodeName().equals("IfStatement")) {
                elseNode.accept((Visitor)this);
            } else {
                this.incNesting();
                elseNode.accept((Visitor)this);
                this.decNesting();
            }
        } else {
            this.incNesting();
            super.visitIfStatement(arg);
            this.decNesting();
        }
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
    }

    @Override
    public void visitTryBlock(InnerNode arg) {
        this.incNesting();
        super.visitTryBlock(arg);
        this.decNesting();
    }

    @Override
    public void visitSynchronizedBlock(InnerNode arg) {
        this.incNesting();
        super.visitTryBlock(arg);
        this.decNesting();
    }

    @Override
    public void visitDoStatement(InnerNode arg) {
        this.incNesting();
        super.visitDoStatement(arg);
        this.decNesting();
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
    }

    @Override
    public void visitSwitch(InnerNode arg) {
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
        int caseLabels = 0;
        this.incNesting();
        for (Node child : arg.getChildren()) {
            child.accept((Visitor)this);
            if (this.m_currentMethod == null || !child.getNodeName().equals("SwitchGroup")) continue;
            if (child.getAttribute(HAS_CASE) != null) {
                ++caseLabels;
            }
            if (child.getAttribute(HAS_BLOCK) == null || caseLabels <= 0) continue;
            this.m_currentMethod.incrementCyclomaticComplexity();
            caseLabels = 0;
        }
        this.decNesting();
    }

    @Override
    public void visitSwitchGroup(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        InnerNode label = (InnerNode)arg.getChildAt(0);
        if (label.size() > 1 && label.getChildAt(0).getType() == 14) {
            arg.setAttribute(HAS_CASE, (Object)Boolean.TRUE);
        }
        if (arg.size() > 1) {
            arg.setAttribute(HAS_BLOCK, (Object)Boolean.TRUE);
        }
    }

    @Override
    public void visitSwitchLabel(InnerNode arg) {
        this.m_inSwitchLabel = true;
        Node identNode = arg.getChild("IDENT");
        if (identNode != null) {
            this.m_parametersAndLocals.add(identNode.getLexeme());
        }
        super.visitSwitchLabel(arg);
        this.m_inSwitchLabel = false;
    }

    @Override
    public void visitSwitchArrowLabel(InnerNode arg) {
        this.m_inSwitchLabel = true;
        Node identNode = arg.getChild("IDENT");
        if (identNode != null) {
            this.m_parametersAndLocals.add(identNode.getLexeme());
        }
        super.visitSwitchArrowLabel(arg);
        this.m_inSwitchLabel = false;
    }

    @Override
    public void visitSwitchArg(InnerNode arg) {
        Node identNode = arg.getChild("IDENT");
        if (identNode != null) {
            this.m_parametersAndLocals.add(identNode.getLexeme());
        }
        super.visitSwitchArg(arg);
    }

    @Override
    public void visitWhileStatement(InnerNode arg) {
        this.incNesting();
        super.visitWhileStatement(arg);
        this.decNesting();
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementCyclomaticComplexity();
            this.m_currentMethod.incrementModifiedCyclomaticComplexity();
        }
    }

    @Override
    public void visitBlockStatement(InnerNode arg) {
        super.visitBlockStatement(arg);
        if (this.m_currentMethod != null && arg.getChild("LocalVarDecl") != null) {
            this.m_currentMethod.incrementNumberOfStatements();
        }
    }

    @Override
    public void visitStatement(InnerNode arg) {
        super.visitStatement(arg);
        if (this.m_currentMethod != null) {
            this.m_currentMethod.incrementNumberOfStatements();
        }
    }

    @Override
    public void visitBinary(InnerNode arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitBinary' must not be null";
        arg.visitChildren((Visitor)this, new Node[0]);
        if (this.m_currentMethod != null && (arg.getChild("LOG_AND") != null || arg.getChild("LOG_OR") != null)) {
            this.m_currentMethod.incrementNumberOfLogicalOperations();
        }
    }

    public void finished() {
        if (!this.m_inlineDependencyProcessor.isEmpty()) {
            this.m_globalModel.addDependencyProcessor(this.m_inlineDependencyProcessor);
        }
    }

    private static class NestingInfo {
        private int m_nesting = 0;
        private int m_maxNesting = 0;

        private NestingInfo() {
        }

        private void increment() {
            ++this.m_nesting;
            this.m_maxNesting = Math.max(this.m_nesting, this.m_maxNesting);
        }

        private void decrement() {
            --this.m_nesting;
            assert (this.m_nesting >= 0);
        }
    }
}

