/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToTypeProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.IClassFileParserContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SignatureVisitorImpl
extends SignatureVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureVisitorImpl.class);
    private final IClassFileParserContext m_classFileParserContext;
    private final JavaDependencyContext m_dependencyContext;
    private JavaDependencyType m_currentDependencyType;
    private String m_currentTypeName;

    SignatureVisitorImpl(IClassFileParserContext classFileParserContext, JavaDependencyContext dependencyContext, JavaDependencyType dependencyType) {
        super(589824);
        assert (classFileParserContext != null) : "Parameter 'classFileParserContext' of method 'SignatureVisitorImpl' must not be null";
        this.m_classFileParserContext = classFileParserContext;
        this.m_dependencyContext = dependencyContext;
        this.m_currentDependencyType = dependencyType;
    }

    protected final IClassFileParserContext getClassFileParserContext() {
        return this.m_classFileParserContext;
    }

    protected final JavaDependencyContext getDependencyContext() {
        return this.m_dependencyContext;
    }

    protected final void setCurrentDependencyType(JavaDependencyType dependencyType) {
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'startType' must not be null";
        this.m_currentDependencyType = dependencyType;
    }

    protected final JavaDependencyType getCurrentDependencyType() {
        return this.m_currentDependencyType;
    }

    protected int getLine() {
        return -1;
    }

    public final void visitFormalTypeParameter(String name) {
    }

    public final void visitTypeVariable(String name) {
    }

    public final void visitTypeArgument() {
    }

    public final SignatureVisitor visitClassBound() {
        this.setCurrentDependencyType(JavaDependencyType.CLASS_BOUND);
        return this;
    }

    public final SignatureVisitor visitInterfaceBound() {
        this.setCurrentDependencyType(JavaDependencyType.INTERFACE_BOUND);
        return this;
    }

    public final SignatureVisitor visitTypeArgument(char tag) {
        if (tag == '+') {
            this.setCurrentDependencyType(JavaDependencyType.TYPE_ARGUMENT_EXTENDS);
        } else if (tag == '-') {
            this.setCurrentDependencyType(JavaDependencyType.TYPE_ARGUMENT_SUPER);
        } else {
            this.setCurrentDependencyType(JavaDependencyType.TYPE_ARGUMENT);
        }
        return this;
    }

    public final void visitBaseType(char descriptor) {
    }

    public final SignatureVisitor visitArrayType() {
        return this;
    }

    public abstract SignatureVisitor visitSuperclass();

    public abstract SignatureVisitor visitInterface();

    public abstract SignatureVisitor visitParameterType();

    public abstract SignatureVisitor visitReturnType();

    public abstract SignatureVisitor visitExceptionType();

    private void addDependency(String fqName) {
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'addDependency' must not be empty";
        assert (this.m_currentDependencyType != null) : "'m_CurrentDependencyType' of method 'addDependency' must not be null";
        this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToTypeProcessor(this.m_classFileParserContext.getCurrentJavaElement(), this.getLine(), this.m_dependencyContext, this.m_currentDependencyType, this.m_classFileParserContext.getCurrentModule(), fqName));
    }

    protected boolean addDependency(JavaDependencyContext dependencyContext, JavaDependencyType dependencyType, String convertedFqName) {
        return !this.m_classFileParserContext.getGlobalModel().getIgnoreAccess().ignoreTypeAccess(this.m_dependencyContext, this.m_currentDependencyType, convertedFqName);
    }

    public final void visitClassType(String name) {
        String convertedFqName;
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'visitClassType' must not be empty";
        this.m_currentTypeName = name;
        if (this.m_currentDependencyType != null && this.addDependency(this.m_dependencyContext, this.m_currentDependencyType, convertedFqName = this.m_classFileParserContext.convertToFqName(name))) {
            this.addDependency(convertedFqName);
        }
    }

    public final void visitInnerClassType(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'visitInnerClassType' must not be empty";
        if (this.m_currentDependencyType != null) {
            JavaType javaType;
            String outerClassName = this.m_currentTypeName;
            if ((outerClassName == null || outerClassName.length() == 0) && (javaType = this.m_classFileParserContext.getCurrentJavaType()) != null) {
                outerClassName = javaType.getFqName();
            }
            if (outerClassName != null && outerClassName.length() > 0) {
                String innerClassFqName = outerClassName + "$" + name;
                String convertedInnerClassName = this.m_classFileParserContext.convertToFqName(innerClassFqName);
                if (this.addDependency(this.m_dependencyContext, this.m_currentDependencyType, convertedInnerClassName)) {
                    this.addDependency(convertedInnerClassName);
                }
            } else {
                LOGGER.warn("Unable to determine outer class for '" + name + "' in: " + String.valueOf(this.m_classFileParserContext.getCurrentClassFile()));
            }
        }
    }

    public final void visitEnd() {
        this.m_currentTypeName = null;
    }
}

