/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaAttributeRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import java.util.List;

public final class JavaBelongsToAggregateRootRetriever
extends JavaAttributeRetriever {
    public String getName() {
        return "JavaBelongsToAggregateRoot";
    }

    public String getShortName() {
        return "BelongsToAggregateRoot";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches jMolecules aggregate roots and associated entities.\n\nIn a physical model only the Java main type (i.e. the type matching the component's name) is considered. This only works on 'internal' types.\n\nPlease note that \u201c*\u201d will match anything except dots ('.').\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    private boolean isEntityImplementation(JavaType type) {
        List implementedInterfaces = type.getOutgoingDependencies(new IParserDependencyType[]{CoreParserDependencyType.IMPLEMENTS});
        for (ParserDependency dep : implementedInterfaces) {
            if (!dep.getTo().getName().equals("org.jmolecules.ddd.types.Entity")) continue;
            return true;
        }
        return false;
    }

    private boolean isAggregateRoot(JavaType type) {
        List implementedInterfaces = type.getOutgoingDependencies(new IParserDependencyType[]{CoreParserDependencyType.IMPLEMENTS});
        for (ParserDependency dep : implementedInterfaces) {
            if (!dep.getTo().getName().equals("org.jmolecules.ddd.types.AggregateRoot")) continue;
            return true;
        }
        List annotations = type.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.HAS_ANNOTATION});
        for (ParserDependency dep : annotations) {
            if (!dep.getTo().getName().equals("org.jmolecules.ddd.annotation.AggregateRoot")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String computeAttributeForJavaType(IWorkerContext workerContext, JavaType type, String[] params) {
        String filterName = this.getDatum((NamedElement)type);
        if (filterName == null) {
            if (this.isAggregateRoot(type)) {
                filterName = type.getName();
                this.setDatum((NamedElement)type, filterName);
                return filterName;
            }
            if (this.isEntityImplementation(type)) {
                List typeArgs = type.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.TYPE_ARGUMENT});
                for (ParserDependency dep : typeArgs) {
                    JavaType target = (JavaType)dep.getTo();
                    if (!this.isAggregateRoot(target)) continue;
                    filterName = target.getName();
                }
            }
        }
        return filterName;
    }
}

