/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModelHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModelProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaNonInitializer;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IndirectDependenciesProcessor
extends JavaModelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndirectDependenciesProcessor.class);

    IndirectDependenciesProcessor(IJavaElementAccessor elementAccessor, JavaGlobalModelHelper globalModelHelper, IWorkerContext workerContext) {
        super(elementAccessor, globalModelHelper, workerContext);
    }

    private void addViaSubtypeSelfDependencies(JavaMember fromMember, JavaMember toMember, Map<Integer, Set<JavaDependencyType>> selfReferencingDependencies) {
        assert (fromMember != null) : "Parameter 'fromMember' of method 'addViaSubtypeSelfDependencies' must not be null";
        assert (toMember != null) : "Parameter 'toMember' of method 'addViaSubtypeSelfDependencies' must not be null";
        assert (fromMember != toMember) : "Same instances: " + String.valueOf(fromMember);
        assert (selfReferencingDependencies != null && !selfReferencingDependencies.isEmpty()) : "Parameter 'selfReferencingDependencies' of method 'addViaSubtypeSelfDependencies' must not be empty";
        for (Map.Entry<Integer, Set<JavaDependencyType>> nextEntry : selfReferencingDependencies.entrySet()) {
            int nextLineNumberAsInt = nextEntry.getKey();
            for (JavaDependencyType nextDependencyType : nextEntry.getValue()) {
                if (DependencyProcessor.dependencyAlreadyExists(fromMember, toMember, JavaDependencyContext.VIA_SUBTYPE_SELF, nextDependencyType, nextLineNumberAsInt)) continue;
                fromMember.addDependency(DependencyCreator.create(JavaDependencyContext.VIA_SUBTYPE_SELF, nextDependencyType, fromMember, toMember, nextLineNumberAsInt));
            }
        }
    }

    private void addViaSubtypeDependencies(JavaMember fromMember, JavaMember toMember, Set<JavaDependencyType> dependencyTypes) {
        assert (fromMember != null) : "Parameter 'fromMember' of method 'addViaSubtypeDependencies' must not be null";
        assert (toMember != null) : "Parameter 'toMember' of method 'addViaSubtypeDependencies' must not be null";
        assert (fromMember != toMember) : "Same instance: " + String.valueOf(fromMember);
        assert (dependencyTypes != null && !dependencyTypes.isEmpty()) : "Parameter 'dependencyTypes' of method 'addViaSubtypeDependencies' must not be empty";
        for (JavaDependencyType nextDependencyType : dependencyTypes) {
            if (DependencyProcessor.dependencyAlreadyExists(fromMember, toMember, JavaDependencyContext.VIA_SUBTYPE, nextDependencyType, -1)) continue;
            fromMember.addDependency(DependencyCreator.create(JavaDependencyContext.VIA_SUBTYPE, nextDependencyType, fromMember, toMember, -1));
        }
    }

    private void addMemberLookupDependency(JavaMember startMember, ArrayDeque<JavaType> typeStack, JavaMember endMember) {
        assert (startMember != null) : "Parameter 'startMember' of method 'addMemberLookupDependency' must not be null";
        assert (typeStack != null) : "Parameter 'typeStack' of method 'addMemberLookupDependency' must not be null";
        assert (typeStack.size() >= 2) : "At least 2 entries expected";
        assert (endMember != null) : "Parameter 'endMember' of method 'addMemberLookupDependency' must not be null";
        assert (startMember != endMember) : "Same instances";
        LinkedHashSet<JavaDependencyType> dependencyTypes = new LinkedHashSet<JavaDependencyType>();
        JavaType nextStartMemberParent = (JavaType)startMember.getParent(JavaType.class, new Class[0]);
        assert (nextStartMemberParent != null) : "'nextStartMemberParent' of method 'addMemberLookupDependency' must not be null";
        TreeMap<Integer, Set<JavaDependencyType>> selfReferencingDependencies = new TreeMap<Integer, Set<JavaDependencyType>>();
        Iterator incoming = startMember.getIncomingDependencyIterator();
        int numberOfDependencies = 0;
        while (incoming.hasNext()) {
            ParserDependency nextParserDependency = (ParserDependency)incoming.next();
            IParserDependencyType nextDependencyType = nextParserDependency.getDependencyType();
            assert (nextDependencyType instanceof JavaDependencyType) : "Unexpected class in method 'addMemberLookupDependency': " + String.valueOf(nextDependencyType);
            ProgrammingElement nextFrom = nextParserDependency.getOriginalFrom();
            JavaType nextFromParent = (JavaType)nextFrom.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (nextFromParent != null) : "'nextFromParent' of method 'addMemberLookupDependency' must not be null";
            if (nextFromParent == nextStartMemberParent) {
                Integer nextLineNumber = nextParserDependency.getLineNumber();
                LinkedHashSet<JavaDependencyType> nextDependencyTypes = (LinkedHashSet<JavaDependencyType>)selfReferencingDependencies.get(nextLineNumber);
                if (nextDependencyTypes == null) {
                    nextDependencyTypes = new LinkedHashSet<JavaDependencyType>();
                    selfReferencingDependencies.put(nextLineNumber, nextDependencyTypes);
                }
                nextDependencyTypes.add((JavaDependencyType)nextDependencyType);
            }
            dependencyTypes.add((JavaDependencyType)nextDependencyType);
            ++numberOfDependencies;
        }
        if (numberOfDependencies > 0) {
            boolean isField;
            if (startMember instanceof JavaField) {
                assert (endMember instanceof JavaField) : "Unexpected class in method 'addMemberLookupDependency': " + String.valueOf(endMember);
                isField = true;
            } else {
                assert (startMember instanceof JavaNonInitializer) : "Unexpected class in method 'addMemberLookupDependency': " + String.valueOf(startMember);
                assert (endMember instanceof JavaNonInitializer) : "Unexpected class in method 'addMemberLookupDependency': " + String.valueOf(endMember);
                isField = false;
            }
            boolean onlySelfReferencesFound = numberOfDependencies == selfReferencingDependencies.size();
            Iterator<JavaType> iterator = typeStack.descendingIterator();
            int size = typeStack.size();
            int i = 0;
            JavaMember currentMember = startMember;
            while (iterator.hasNext()) {
                JavaType nextType = iterator.next();
                if (i != 0) {
                    if (i == size - 1) {
                        if (i == 1 && !selfReferencingDependencies.isEmpty()) {
                            this.addViaSubtypeSelfDependencies(currentMember, endMember, selfReferencingDependencies);
                        }
                        if (i != 1 || !onlySelfReferencesFound) {
                            this.addViaSubtypeDependencies(currentMember, endMember, dependencyTypes);
                        }
                    } else {
                        JavaMember nextMember = isField ? this.getElementAccessor().getField(nextType, currentMember.getShortName(), m -> m.addFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY)) : this.getElementAccessor().getMethod(nextType, currentMember.getShortName(), ((JavaNonInitializer)currentMember).getDescriptor(), true, m -> m.addFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY));
                        if (nextMember.hasFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY)) {
                            if (nextType.isExternal()) {
                                nextMember.removeFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
                            } else {
                                nextMember.removeFlag(JavaElementFlag.EXTERNAL);
                            }
                        }
                        if (i == 1 && !selfReferencingDependencies.isEmpty()) {
                            this.addViaSubtypeSelfDependencies(currentMember, nextMember, selfReferencingDependencies);
                        }
                        if (i != 1 || !onlySelfReferencesFound) {
                            this.addViaSubtypeDependencies(currentMember, nextMember, dependencyTypes);
                        }
                        currentMember = nextMember;
                    }
                }
                ++i;
            }
        }
    }

    private JavaMethod findNonPrivateMethod(JavaType type, String name, String methodDescriptor) {
        assert (type != null) : "Parameter 'type' of method 'findNonPrivateMethod' must not be null";
        assert (name != null) : "Parameter 'name' of method 'findNonPrivateMethod' must not be null";
        JavaMethod method = this.getModelHelper().getMethod(type, name, methodDescriptor, JavaGlobalModelHelper.getMethodType(name), true);
        if (!(method == null || method.hasFlag(JavaElementFlag.PRIVATE) || method.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE) && !method.isExternal())) {
            return method;
        }
        return null;
    }

    private JavaField findNonPrivateField(JavaType type, String name) {
        assert (type != null) : "Parameter 'type' of method 'findNonPrivateField' must not be null";
        assert (name != null) : "Parameter 'name' of method 'findNonPrivateField' must not be null";
        JavaField field = this.getModelHelper().getField(type, name);
        if (!(field == null || field.hasFlag(JavaElementFlag.PRIVATE) || field.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE) && !field.isExternal())) {
            return field;
        }
        return null;
    }

    private void processSuperType(ArrayDeque<JavaType> typeStack, JavaType type, List<JavaField> fieldsNotDefinedInEnclosingType, List<JavaNonInitializer> nonInitializersDefinedInEnclosingType, List<JavaNonInitializer> nonInitializersNotDefinedInEnclosingType, Set<JavaMember> membersNotDefinedInEnclosingTypeWithoutInternalDefinition, Map<JavaType, List<ArrayDeque<JavaType>>> reachedExternals) {
        JavaNonInitializer nextNonInitializer;
        Iterator<JavaNonInitializer> nextNonInitializerIterator;
        assert (typeStack != null) : "Parameter 'typeStack' of method 'processSuperType' must not be null";
        assert (type != null) : "Parameter 'type' of method 'processSuperType' must not be null";
        assert (fieldsNotDefinedInEnclosingType != null) : "Parameter 'fieldsNotDefinedInEnclosingType' of method 'processSuperType' must not be null";
        assert (nonInitializersDefinedInEnclosingType != null) : "Parameter 'nonInitializersDefinedInEnclosingType' of method 'processSuperType' must not be null";
        assert (nonInitializersNotDefinedInEnclosingType != null) : "Parameter 'nonInitializersNotDefinedInEnclosingType' of method 'processSuperType' must not be null";
        assert (membersNotDefinedInEnclosingTypeWithoutInternalDefinition != null) : "Parameter 'membersNotDefinedInEnclosingTypeWithoutInternalDefinition' of method 'processSuperType' must not be null";
        assert (reachedExternals != null) : "Parameter 'reachedExternals' of method 'processSuperType' must not be null";
        typeStack.push(type);
        if (!fieldsNotDefinedInEnclosingType.isEmpty()) {
            Iterator<JavaField> nextFieldIterator = fieldsNotDefinedInEnclosingType.iterator();
            while (nextFieldIterator.hasNext()) {
                JavaField nextField = nextFieldIterator.next();
                JavaField fieldInSuperType = this.findNonPrivateField(type, nextField.getShortName());
                if (fieldInSuperType == null) continue;
                if (!DependencyProcessor.dependencyAlreadyExists(nextField, fieldInSuperType, null, JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY, -1)) {
                    nextField.addDependency(DependencyCreator.create(null, JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY, nextField, fieldInSuperType, -1));
                    this.addMemberLookupDependency(nextField, new ArrayDeque<JavaType>(typeStack), fieldInSuperType);
                }
                membersNotDefinedInEnclosingTypeWithoutInternalDefinition.remove(nextField);
                nextFieldIterator.remove();
            }
        }
        if (!nonInitializersDefinedInEnclosingType.isEmpty()) {
            nextNonInitializerIterator = nonInitializersDefinedInEnclosingType.iterator();
            while (nextNonInitializerIterator.hasNext()) {
                nextNonInitializer = nextNonInitializerIterator.next();
                JavaMethod foundMethodInSuperType = this.findNonPrivateMethod(type, nextNonInitializer.getShortName(), nextNonInitializer.getDescriptor());
                if (foundMethodInSuperType == null) continue;
                int lineNumber = nextNonInitializer.getLineNumber();
                if (!DependencyProcessor.dependencyAlreadyExists(nextNonInitializer, foundMethodInSuperType, null, JavaDependencyType.OVERRIDES, lineNumber)) {
                    nextNonInitializer.addDependency(DependencyCreator.create(null, JavaDependencyType.OVERRIDES, nextNonInitializer, foundMethodInSuperType, lineNumber));
                }
                nextNonInitializerIterator.remove();
            }
        }
        if (!nonInitializersNotDefinedInEnclosingType.isEmpty()) {
            nextNonInitializerIterator = nonInitializersNotDefinedInEnclosingType.iterator();
            while (nextNonInitializerIterator.hasNext()) {
                nextNonInitializer = nextNonInitializerIterator.next();
                JavaMethod methodInSuperType = this.findNonPrivateMethod(type, nextNonInitializer.getShortName(), nextNonInitializer.getDescriptor());
                if (methodInSuperType == null) continue;
                if (!DependencyProcessor.dependencyAlreadyExists(nextNonInitializer, methodInSuperType, null, JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY, -1)) {
                    nextNonInitializer.addDependency(DependencyCreator.create(null, JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY, nextNonInitializer, methodInSuperType, -1));
                    this.addMemberLookupDependency(nextNonInitializer, new ArrayDeque<JavaType>(typeStack), methodInSuperType);
                }
                membersNotDefinedInEnclosingTypeWithoutInternalDefinition.remove(nextNonInitializer);
                nextNonInitializerIterator.remove();
            }
        }
        if (!(fieldsNotDefinedInEnclosingType.isEmpty() && nonInitializersDefinedInEnclosingType.isEmpty() && nonInitializersNotDefinedInEnclosingType.isEmpty())) {
            Set<JavaType> directSuperTypes = this.getModelHelper().getDirectSuperTypes(type);
            if (!directSuperTypes.isEmpty()) {
                for (JavaType nextSuperType : directSuperTypes) {
                    this.processSuperType(typeStack, nextSuperType, new ArrayList<JavaField>(fieldsNotDefinedInEnclosingType), new ArrayList<JavaNonInitializer>(nonInitializersDefinedInEnclosingType), new ArrayList<JavaNonInitializer>(nonInitializersNotDefinedInEnclosingType), membersNotDefinedInEnclosingTypeWithoutInternalDefinition, reachedExternals);
                }
            } else if (type.isExternal()) {
                List<ArrayDeque<JavaType>> stacks = reachedExternals.get(type);
                if (stacks == null) {
                    stacks = new ArrayList<ArrayDeque<JavaType>>(2);
                    reachedExternals.put(type, stacks);
                }
                stacks.add(new ArrayDeque<JavaType>(typeStack));
            }
        } else assert (membersNotDefinedInEnclosingTypeWithoutInternalDefinition.isEmpty()) : "'membersNotDefinedInEnclosingTypeWithoutInternalDefinition' not empty";
        typeStack.pop();
    }

    private void collectNonInitializers(JavaType type, ArrayList<JavaNonInitializer> definedInEnclosingType, ArrayList<JavaNonInitializer> notDefinedInEnclosingType) {
        assert (type != null) : "Parameter 'type' of method 'collectNonInitializers' must not be null";
        assert (definedInEnclosingType != null) : "Parameter 'definedInEnclosingType' of method 'collectNonInitializers' must not be null";
        assert (definedInEnclosingType.isEmpty()) : "Not empty";
        assert (notDefinedInEnclosingType != null) : "Parameter 'fieldsNotDefinedInEnclosingType' of method 'collectNonInitializers' must not be null";
        assert (notDefinedInEnclosingType.isEmpty()) : "Not empty";
        for (JavaNonInitializer next : type.getChildren(JavaNonInitializer.class)) {
            if (next.hasFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY)) continue;
            if (next.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE)) {
                notDefinedInEnclosingType.add(next);
                continue;
            }
            definedInEnclosingType.add(next);
        }
        definedInEnclosingType.trimToSize();
        notDefinedInEnclosingType.trimToSize();
    }

    private void collectFields(JavaType type, ArrayList<JavaField> notDefinedInEnclosingType) {
        assert (type != null) : "Parameter 'type' of method 'collectFields' must not be null";
        assert (notDefinedInEnclosingType != null) : "Parameter 'notDefinedInEnclosingType' of method 'collectFields' must not be null";
        assert (notDefinedInEnclosingType.isEmpty()) : "Not empty";
        for (JavaField next : type.getChildren(JavaField.class)) {
            if (!next.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE) || next.hasFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY)) continue;
            notDefinedInEnclosingType.add(next);
        }
        notDefinedInEnclosingType.trimToSize();
    }

    private void addIndirectDependencies(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'addIndirectDependencies' must not be null";
        Set<JavaType> nextDirectSuperTypes = this.getModelHelper().getDirectSuperTypes(type);
        if (!nextDirectSuperTypes.isEmpty()) {
            ArrayList<JavaField> fieldsNotDefinedInEnclosingType = new ArrayList<JavaField>();
            this.collectFields(type, fieldsNotDefinedInEnclosingType);
            ArrayList<JavaNonInitializer> nonInitializersDefinedInEnclosingType = new ArrayList<JavaNonInitializer>();
            ArrayList<JavaNonInitializer> nonInitializersNotDefinedInEnclosingType = new ArrayList<JavaNonInitializer>();
            this.collectNonInitializers(type, nonInitializersDefinedInEnclosingType, nonInitializersNotDefinedInEnclosingType);
            if (!(fieldsNotDefinedInEnclosingType.isEmpty() && nonInitializersDefinedInEnclosingType.isEmpty() && nonInitializersNotDefinedInEnclosingType.isEmpty())) {
                THashSet membersNotDefinedInEnclosingTypeWithoutInternalDefinition = new THashSet();
                membersNotDefinedInEnclosingTypeWithoutInternalDefinition.addAll(fieldsNotDefinedInEnclosingType);
                membersNotDefinedInEnclosingTypeWithoutInternalDefinition.addAll(nonInitializersNotDefinedInEnclosingType);
                LinkedHashMap<JavaType, List<ArrayDeque<JavaType>>> reachedExternals = new LinkedHashMap<JavaType, List<ArrayDeque<JavaType>>>();
                ArrayDeque<JavaType> typeStack = new ArrayDeque<JavaType>();
                typeStack.push(type);
                for (JavaType nextSuperType : nextDirectSuperTypes) {
                    this.processSuperType(typeStack, nextSuperType, new ArrayList<JavaField>(fieldsNotDefinedInEnclosingType), new ArrayList<JavaNonInitializer>(nonInitializersDefinedInEnclosingType), new ArrayList<JavaNonInitializer>(nonInitializersNotDefinedInEnclosingType), (Set<JavaMember>)membersNotDefinedInEnclosingTypeWithoutInternalDefinition, reachedExternals);
                }
                typeStack.pop();
                if (!membersNotDefinedInEnclosingTypeWithoutInternalDefinition.isEmpty()) {
                    Map.Entry external = null;
                    if (reachedExternals.size() == 1) {
                        external = reachedExternals.entrySet().iterator().next();
                    } else {
                        for (Map.Entry nextEntry : reachedExternals.entrySet()) {
                            if (!((JavaType)nextEntry.getKey()).hasFlag(JavaElementFlag.CLASS)) continue;
                            if (external == null) {
                                external = nextEntry;
                                continue;
                            }
                            external = null;
                            break;
                        }
                    }
                    if (external != null) {
                        for (JavaMember nextMember : membersNotDefinedInEnclosingTypeWithoutInternalDefinition) {
                            JavaMember nextMemberInSuperType;
                            if (nextMember instanceof JavaField) {
                                nextMemberInSuperType = this.getElementAccessor().getField((JavaType)external.getKey(), nextMember.getShortName(), m -> m.addFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY));
                            } else {
                                assert (nextMember instanceof JavaNonInitializer) : "Unexpected class in method 'addIndirectDependencies': " + String.valueOf(nextMember);
                                nextMemberInSuperType = this.getElementAccessor().getMethod((JavaType)external.getKey(), nextMember.getShortName(), ((JavaMethod)nextMember).getDescriptor(), true, m -> m.addFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY));
                            }
                            nextMemberInSuperType.removeFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
                            if (!DependencyProcessor.dependencyAlreadyExists(nextMember, nextMemberInSuperType, null, JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY, -1)) {
                                nextMember.addDependency(DependencyCreator.create(null, JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY, nextMember, nextMemberInSuperType, -1));
                            }
                            for (ArrayDeque nextTypeStack : (List)external.getValue()) {
                                this.addMemberLookupDependency(nextMember, nextTypeStack, nextMemberInSuperType);
                            }
                        }
                    }
                }
            }
        }
    }

    private void reset(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'reset' must not be null";
        for (JavaMember nextMember : type.getChildren(JavaMember.class)) {
            if (nextMember.hasFlag(JavaElementFlag.MEMBER_LOOKUP_ONLY)) {
                nextMember.remove();
                continue;
            }
            for (ParserDependency nextParserDependency : new ArrayList(nextMember.getDependencies())) {
                assert (nextParserDependency instanceof JavaDependency) : "Unexpected class in method 'reset': " + String.valueOf(nextParserDependency);
                IParserDependencyType nextDependencyType = nextParserDependency.getDependencyType();
                if (nextDependencyType != JavaDependencyType.OVERRIDES && nextDependencyType != JavaDependencyType.MEMBER_DEFINITION_PROVIDED_BY && nextParserDependency.getDependencyContext() != JavaDependencyContext.VIA_SUBTYPE) continue;
                nextParserDependency.getOriginalFrom().removeDependency(nextParserDependency);
            }
        }
    }

    void initializeAsUnparsed(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'initializeAsUnparsed' must not be null";
        this.reset(type);
        this.getModelHelper().getSuperTypes(type).forEach(superType -> this.reset((JavaType)superType));
        this.getModelHelper().getSubTypes(type).forEach(subType -> this.reset((JavaType)subType));
    }

    void process(List<JavaType> internalTypes) {
        assert (internalTypes != null) : "Parameter 'internalTypes' of method 'process' must not be null";
        if (!internalTypes.isEmpty()) {
            LOGGER.debug("Process indirect dependencies");
            IWorkerContext workerContext = this.getWorkerContext();
            LinkedHashSet<JavaType> internalTypesAsSet = new LinkedHashSet<JavaType>(internalTypes);
            ArrayList inheritanceGroups = new ArrayList();
            LOGGER.debug("Build inheritance groups based on " + internalTypes.size() + " internal type(s)");
            int iteration = 0;
            while (!internalTypesAsSet.isEmpty()) {
                int nextGroupSize;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                LOGGER.debug("<<Iteration " + ++iteration + ">>");
                JavaType javaType = (JavaType)internalTypesAsSet.iterator().next();
                LOGGER.trace("Build inheritance group for type '" + javaType.getFqName() + "'");
                ArrayList<JavaType> nextGroup = new ArrayList<JavaType>();
                nextGroup.addAll(this.getModelHelper().getSubTypes(javaType));
                Collections.reverse(nextGroup);
                nextGroup.add(javaType);
                nextGroup.addAll(this.getModelHelper().getSuperTypes(javaType));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Build inheritance group for type '" + javaType.getFqName() + "' - done - types in group in processing order: ");
                    int index = 0;
                    for (JavaType nextInGroup : nextGroup) {
                        LOGGER.trace("[" + ++index + "] Type in group '" + nextInGroup.getFqName() + "'");
                    }
                }
                if ((nextGroupSize = nextGroup.size()) > 1) {
                    inheritanceGroups.add(nextGroup);
                    LOGGER.trace("Added inheritance group of " + nextGroupSize + " for type '" + javaType.getFqName() + "'");
                } else {
                    LOGGER.trace("Discarded single element inheritance group for type '" + javaType.getFqName() + "'");
                }
                internalTypesAsSet.removeAll(nextGroup);
            }
            LOGGER.debug("Build inheritance groups based on " + internalTypes.size() + " internal type(s) - done");
            LOGGER.debug("Add indirect dependencies based on " + inheritanceGroups.size() + " inheritance group(s)");
            for (List list : inheritanceGroups) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                for (JavaType nextType : list) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.addIndirectDependencies(nextType);
                }
            }
            LOGGER.debug("Add indirect dependencies based on " + inheritanceGroups.size() + " inheritance group(s) - done");
            LOGGER.debug("Process indirect dependencies - done");
        }
    }
}

