/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.IJavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaTypeSignatureWriter;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaType
extends JavaElement
implements IJavaType,
IType,
IRefactorable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaType.class);
    private static final String ANONYMOUS_NAME_SUFFIX = "() {...}";
    private String m_fqName;

    public JavaType(NamedElement parent) {
        super(parent);
    }

    public JavaType(IModelServiceProvider msp, NamedElement parent, String shortName, String fqName) {
        super(msp, parent, shortName);
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'JavaType' must not be empty";
        this.m_fqName = fqName.intern();
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_fqName = reader.readString().intern();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_fqName);
    }

    public ProgrammingElement getOriginal() {
        if (!this.isExternal()) {
            return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
        }
        return this;
    }

    public ProgrammingElement getRepresentative() {
        if (!this.isExternal()) {
            return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
        }
        return this;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        String fqNamePart = super.getFullyQualifiedNamePart();
        if (this.isAnonymous()) {
            if (fqNamePart.isEmpty()) {
                return JavaNameUtility.getTypeNameFromFqTypeName(this.getName());
            }
            return fqNamePart + INNER_NAME_PARTS_SEPARATOR + JavaNameUtility.getTypeNameFromFqTypeName(this.getName());
        }
        return fqNamePart;
    }

    public String getImageResourceName() {
        if (this.hasFlag(JavaElementFlag.ENUM)) {
            return "JavaEnum";
        }
        if (this.hasFlag(JavaElementFlag.ANNOTATION)) {
            return "JavaAnnotation";
        }
        if (this.hasFlag(JavaElementFlag.INTERFACE)) {
            return "JavaInterface";
        }
        if (this.hasFlag(JavaElementFlag.RECORD)) {
            return "JavaRecord";
        }
        return "JavaClass";
    }

    @IntProperty
    public int getNumberOfMethods() {
        return (int)this.getChildren(JavaMethod.class).stream().filter(m -> m.isDefinedInEnclosingElement()).count();
    }

    public boolean isMember() {
        return false;
    }

    public String getFqName() {
        return this.m_fqName;
    }

    public int getNumberOfGenericTypeParameters() {
        String signature = this.getSignature();
        if (signature != null && !signature.isEmpty()) {
            try {
                int endPos;
                int startPos = signature.indexOf(60);
                if (startPos != -1 && (endPos = signature.lastIndexOf(62)) != -1) {
                    String relevant = signature.substring(startPos + 1, endPos);
                    return StringUtility.countChar((char)';', (String)relevant);
                }
            }
            catch (Throwable t) {
                LOGGER.error("Unable to process signature '" + signature + "' of type: " + this.m_fqName, t);
            }
        }
        return 0;
    }

    public JavaType getTopMostType() {
        JavaType currentType = this;
        JavaType rootType = (JavaType)currentType.getParent(JavaType.class, new Class[0]);
        while (rootType != null) {
            currentType = rootType;
            rootType = (JavaType)currentType.getParent(JavaType.class, new Class[0]);
        }
        return currentType;
    }

    public final String getFullyQualifiedTypeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (!this.isExternal()) {
            if (!this.isNested()) {
                PhysicalRecursiveElement physicalRecursiveElement = (PhysicalRecursiveElement)this.getParent(PhysicalRecursiveElement.class, new Class[0]);
                if (physicalRecursiveElement != null) {
                    return physicalRecursiveElement.getName() + "." + this.getShortName();
                }
            } else {
                JavaType topMostType = this.getTopMostType();
                if (topMostType != this) {
                    String topMostTypeFqName = topMostType.getFqName();
                    String topMostTypeRefactoredName = topMostType.getName();
                    String ownFqName = this.getFqName();
                    String ownShortName = this.getShortName();
                    try {
                        String inbetweenPart = ownFqName.substring(topMostTypeFqName.length(), ownFqName.length() - ownShortName.length());
                        return topMostTypeRefactoredName + inbetweenPart + ownShortName;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        LOGGER.warn("Unable to determine name of nested type with original fq name '" + this.m_fqName + "'");
                        LOGGER.warn("- topMostTypeFqName: '" + topMostTypeFqName + "'");
                        LOGGER.warn("- topMostTypeRefactoredName: '" + topMostTypeRefactoredName + "'");
                        LOGGER.warn("- ownFqName: '" + ownFqName + "'");
                        LOGGER.warn("- ownShortName: '" + ownShortName + "'");
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Considered nested but no outer type present for type with original fq name '" + this.m_fqName + "'");
                }
            }
        }
        return this.m_fqName;
    }

    private List<JavaType> getInterfaceTypes() {
        ArrayList<JavaType> interfaces = null;
        Iterator iterator = this.getOutgoingDependencyIterator(new IStandardEnumeration[]{JavaDependencyType.IMPLEMENTS});
        if (iterator.hasNext()) {
            interfaces = new ArrayList<JavaType>(5);
            while (iterator.hasNext()) {
                ParserDependency dependency = (ParserDependency)iterator.next();
                interfaces.add((JavaType)dependency.getTo());
            }
        }
        if (interfaces == null) {
            return Collections.emptyList();
        }
        return interfaces;
    }

    private JavaType getBaseType() {
        Iterator iterator = this.getOutgoingDependencyIterator(new IStandardEnumeration[]{JavaDependencyType.EXTENDS});
        if (iterator.hasNext()) {
            ParserDependency dependency = (ParserDependency)iterator.next();
            return (JavaType)dependency.getTo();
        }
        return null;
    }

    private String getNameForPresentationName(boolean isShortName) {
        if (this.hasFlag(JavaElementFlag.ANONYMOUS)) {
            String nameAddition;
            JavaType baseClass = this.getBaseType();
            JavaType parent = (JavaType)this.getParent(JavaType.class, new Class[0]);
            String string = nameAddition = parent != null ? parent.getName() + "." : "";
            if (baseClass != null) {
                return (isShortName ? "" : nameAddition) + "new " + baseClass.getShortName() + ANONYMOUS_NAME_SUFFIX;
            }
            List<JavaType> interfaces = this.getInterfaceTypes();
            if (!interfaces.isEmpty()) {
                return (isShortName ? "" : nameAddition) + "new " + interfaces.get(0).getShortName() + ANONYMOUS_NAME_SUFFIX;
            }
            return (isShortName ? "" : nameAddition) + "new Object() {...}";
        }
        return isShortName ? this.getShortName() : this.getName();
    }

    public String getRawPresentationName(boolean shortName) {
        if (!this.hasFlag(JavaElementFlag.ANONYMOUS)) {
            return this.getNameForPresentationName(shortName);
        }
        return shortName ? JavaNameUtility.getTypeNameFromFqTypeName(this.getFqName()) : this.getFqName();
    }

    public String getPresentationName(boolean shortName) {
        String signature = this.getSignature();
        if (signature == null) {
            return shortName ? this.getNameForPresentationName(true) : this.getNameForPresentationName(false);
        }
        StringBuilder builder = new StringBuilder(shortName ? this.getNameForPresentationName(true) : this.getNameForPresentationName(false));
        JavaTypeSignatureWriter signatureVisitorImpl = new JavaTypeSignatureWriter(this.isInterface());
        SignatureReader signatureReader = new SignatureReader(signature);
        signatureReader.accept((SignatureVisitor)signatureVisitorImpl);
        builder.append(signatureVisitorImpl.getDeclaration());
        return builder.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaType(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("FqName: ");
        builder.append(this.m_fqName);
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaType(JavaType var1);
    }
}

