/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.buildunits;

import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class BuildUnitData {
    private final Set<String> m_defaultClassRootSegments = new TreeSet<String>(Arrays.asList("/target", "/build", "/classes", "/cls"));
    private final Set<String> m_defaultSourceRootSegments = new TreeSet<String>(Arrays.asList("/target", "/build", "/sources", "/src"));
    private final Set<String> m_classRootSegments = new TreeSet<String>(this.m_defaultClassRootSegments);
    private final Set<String> m_sourceRootSegments = new TreeSet<String>(this.m_defaultSourceRootSegments);
    private final TFile m_startDirectory;
    private final Set<TFile> m_detectedClassRoots;
    private final Set<TFile> m_detectedSourceRoots;
    private final Set<String> m_existingModules;
    private final Set<String> m_defaultClassRootDefinitions = new TreeSet<String>();
    private final Set<String> m_defaultSourceRootDefinitions = new TreeSet<String>();
    private final Set<String> m_classRootDefinitions = new TreeSet<String>();
    private final Set<String> m_sourceRootDefinitions = new TreeSet<String>();
    private boolean m_rootDefinitionsDetectionHasBeenRun;
    private final Set<String> m_unassignedClassRoots = new TreeSet<String>();
    private final Set<String> m_unassignedSourceRoots = new TreeSet<String>();
    private final Set<String> m_assignedClassRoots = new TreeSet<String>();
    private final Set<String> m_assignedSourceRoots = new TreeSet<String>();
    private final Map<TFile, ImportModuleCandidate> m_rootToModuleCandidate = new LinkedHashMap<TFile, ImportModuleCandidate>();
    private boolean m_importCandidatesDetectionHasBeenRun;

    public BuildUnitData(TFile startDirectory, Collection<TFile> detectedClassRoots, Collection<TFile> detectedSourceRoots, Set<String> existingModules) {
        this.m_startDirectory = startDirectory;
        this.m_detectedClassRoots = new THashSet(detectedClassRoots);
        this.m_detectedSourceRoots = new THashSet(detectedSourceRoots);
        this.m_existingModules = new THashSet(existingModules);
    }

    public Set<String> getClassRootSegments() {
        return Collections.unmodifiableSet(this.m_classRootSegments);
    }

    public Set<String> getSourceRootSegments() {
        return Collections.unmodifiableSet(this.m_sourceRootSegments);
    }

    private void resetImportCandidatesInfo() {
        this.m_unassignedClassRoots.addAll(this.m_assignedClassRoots);
        this.m_assignedClassRoots.clear();
        this.m_unassignedSourceRoots.addAll(this.m_assignedSourceRoots);
        this.m_assignedSourceRoots.clear();
        this.m_rootToModuleCandidate.clear();
    }

    private void resetRootDefinitionInfo() {
        this.m_defaultClassRootDefinitions.clear();
        this.m_defaultSourceRootDefinitions.clear();
        this.m_classRootDefinitions.clear();
        this.m_sourceRootDefinitions.clear();
        this.m_unassignedClassRoots.clear();
        this.m_unassignedSourceRoots.clear();
        this.m_assignedClassRoots.clear();
        this.m_assignedSourceRoots.clear();
        this.m_rootToModuleCandidate.clear();
    }

    public void startRootDefinitionsDetection() {
        this.resetRootDefinitionInfo();
        this.m_importCandidatesDetectionHasBeenRun = false;
    }

    public void addClassRootSegment(String segment) {
        assert (segment != null && segment.length() > 0) : "Parameter 'segment' of method 'addClassRootSegment' must not be empty";
        assert (!this.m_classRootSegments.contains(segment)) : "Already present: " + segment;
        this.m_classRootSegments.add(segment);
        this.resetRootDefinitionInfo();
        this.m_rootDefinitionsDetectionHasBeenRun = false;
    }

    public void deleteClassRootSegments(List<String> segments) {
        assert (segments != null && !segments.isEmpty()) : "Parameter 'segments' of method 'deleteClassRootSegments' must not be empty";
        this.m_classRootSegments.removeAll(segments);
        this.resetRootDefinitionInfo();
        this.m_rootDefinitionsDetectionHasBeenRun = false;
    }

    public void addSourceRootSegment(String segment) {
        assert (segment != null && segment.length() > 0) : "Parameter 'segment' of method 'addSourceRootSegment' must not be empty";
        assert (!this.m_sourceRootSegments.contains(segment)) : "Already present: " + segment;
        this.m_sourceRootSegments.add(segment);
        this.resetRootDefinitionInfo();
        this.m_rootDefinitionsDetectionHasBeenRun = false;
    }

    public void deleteSourceRootSegments(List<String> segments) {
        assert (segments != null && !segments.isEmpty()) : "Parameter 'segments' of method 'deleteSourceRootSegments' must not be empty";
        this.m_sourceRootSegments.removeAll(segments);
        this.resetRootDefinitionInfo();
        this.m_rootDefinitionsDetectionHasBeenRun = false;
    }

    public boolean haveRootSegmentsBeenModified() {
        return !this.m_defaultClassRootSegments.equals(this.m_classRootSegments) || !this.m_defaultSourceRootSegments.equals(this.m_sourceRootSegments);
    }

    public void finishRootDefinitionsDetection(Collection<String> classRootDefinitions, Collection<String> sourceRootDefinitions, Collection<String> unassignedClassRoots, Collection<String> unassignedSourceRoots) {
        assert (classRootDefinitions != null) : "Parameter 'classRootDefinitions' of method 'finishRootDefinitionsDetection' must not be null";
        assert (sourceRootDefinitions != null) : "Parameter 'sourceRootDefinitions' of method 'finishRootDefinitionsDetection' must not be null";
        assert (unassignedClassRoots != null) : "Parameter 'unassignedClassRoots' of method 'finishRootDefinitionsDetection' must not be null";
        assert (unassignedSourceRoots != null) : "Parameter 'unassignedSourceRoots' of method 'finishRootDefinitionsDetection' must not be null";
        this.m_defaultClassRootDefinitions.addAll(classRootDefinitions);
        this.m_defaultSourceRootDefinitions.addAll(sourceRootDefinitions);
        this.m_classRootDefinitions.addAll(classRootDefinitions);
        this.m_sourceRootDefinitions.addAll(sourceRootDefinitions);
        this.m_unassignedClassRoots.addAll(unassignedClassRoots);
        this.m_unassignedSourceRoots.addAll(unassignedSourceRoots);
        this.m_rootDefinitionsDetectionHasBeenRun = true;
    }

    public void finishRootDefinitionsDetection() {
        this.m_rootDefinitionsDetectionHasBeenRun = true;
    }

    public boolean hasRootDefinitionsDetectionBeenRun() {
        return this.m_rootDefinitionsDetectionHasBeenRun;
    }

    public TFile getStartDirectory() {
        return this.m_startDirectory;
    }

    public String getStartDirectoryAsString() {
        return this.m_startDirectory != null ? this.m_startDirectory.getNormalizedAbsolutePath() : "";
    }

    public Set<TFile> getDetectedClassRoots() {
        return Collections.unmodifiableSet(this.m_detectedClassRoots);
    }

    public Set<TFile> getDetectedSourceRoots() {
        return Collections.unmodifiableSet(this.m_detectedSourceRoots);
    }

    public boolean hasDetectedRoots() {
        return !this.m_detectedClassRoots.isEmpty() || !this.m_detectedSourceRoots.isEmpty();
    }

    public int getNumberOfDetectedClassRoots() {
        return this.m_detectedClassRoots.size();
    }

    public int getNumberOfDetectedSourceRoots() {
        return this.m_detectedSourceRoots.size();
    }

    public Set<String> getExistingModules() {
        return Collections.unmodifiableSet(this.m_existingModules);
    }

    public Collection<String> getClassRootDefinitions() {
        return Collections.unmodifiableSet(this.m_classRootDefinitions);
    }

    public int getNumberOfClassRootDefinitions() {
        return this.m_classRootDefinitions.size();
    }

    public Collection<String> getSourceRootDefinitions() {
        return Collections.unmodifiableSet(this.m_sourceRootDefinitions);
    }

    public int getNumberOfSourceRootDefinitions() {
        return this.m_sourceRootDefinitions.size();
    }

    public void addClassRootDefintion(String root) {
        assert (root != null && root.length() > 0) : "Parameter 'root' of method 'addClassRootDefintion' must not be empty";
        assert (!this.m_classRootDefinitions.contains(root)) : "Already present: " + root;
        this.m_classRootDefinitions.add(root);
        this.resetImportCandidatesInfo();
    }

    public void deleteClassRootDefintions(List<String> roots) {
        assert (roots != null && !roots.isEmpty()) : "Parameter 'roots' of method 'deleteClassRootDefintions' must not be empty";
        this.m_classRootDefinitions.removeAll(roots);
        this.resetImportCandidatesInfo();
    }

    public void addSourceRootDefinition(String root) {
        assert (root != null && root.length() > 0) : "Parameter 'root' of method 'addSourceRootDefinition' must not be empty";
        assert (!this.m_sourceRootDefinitions.contains(root)) : "Already present: " + root;
        this.m_sourceRootDefinitions.add(root);
        this.resetImportCandidatesInfo();
    }

    public void deleteSourceRootDefinitions(List<String> roots) {
        assert (roots != null && !roots.isEmpty()) : "Parameter 'roots' of method 'deleteSourceRootDefinitions' must not be empty";
        this.m_sourceRootDefinitions.removeAll(roots);
        this.resetImportCandidatesInfo();
    }

    public Collection<String> getUnassignedClassRoots() {
        return Collections.unmodifiableSet(this.m_unassignedClassRoots);
    }

    public Collection<String> getUnassignedSourceRoots() {
        return Collections.unmodifiableSet(this.m_unassignedSourceRoots);
    }

    public void addAssignedClassRoot(String root) {
        assert (root != null && root.length() > 0) : "Parameter 'root' of method 'addAssignedClassRoot' must not be empty";
        boolean success = this.m_unassignedClassRoots.remove(root);
        assert (success) : "Class root not found: " + root;
        this.m_assignedClassRoots.add(root);
    }

    public void addAssignedSourceRoot(String root) {
        assert (root != null && root.length() > 0) : "Parameter 'root' of method 'addAssignedSourceRoot' must not be empty";
        boolean success = this.m_unassignedSourceRoots.remove(root);
        assert (success) : "Source root not found: " + root;
        this.m_assignedSourceRoots.add(root);
    }

    public void addModuleCandidate(ImportModuleCandidate moduleCandidate) {
        assert (moduleCandidate != null) : "Parameter 'moduleCandidate' of method 'addModuleCandidate' must not be null";
        ImportModuleCandidate previous = this.m_rootToModuleCandidate.put(moduleCandidate.getFile(), moduleCandidate);
        assert (previous == null) : "'previous' of method 'addModuleCandidate' must  be null";
    }

    public void editModule(String from, String to) {
        assert (from != null && from.length() > 0) : "Parameter 'from' of method 'editModule' must not be empty";
        assert (to != null && to.length() > 0) : "Parameter 'to' of method 'editModule' must not be empty";
        assert (!from.equals(to)) : "name not different";
        for (ImportModuleCandidate next : this.m_rootToModuleCandidate.values()) {
            if (!next.getName().equalsIgnoreCase(from)) continue;
            next.setName(to);
            return;
        }
    }

    public Map<TFile, ImportModuleCandidate> getRootToImportCandidates() {
        return Collections.unmodifiableMap(this.m_rootToModuleCandidate);
    }

    public void removeImportCandidates(Set<TFile> remove) {
        assert (remove != null) : "Parameter 'remove' of method 'removeImportCandidates' must not be null";
        remove.forEach(r -> {
            ImportModuleCandidate importModuleCandidate = this.m_rootToModuleCandidate.remove(r);
        });
    }

    public boolean hasImportCandidates() {
        return !this.m_rootToModuleCandidate.isEmpty();
    }

    public Set<ImportModuleCandidate> getModuleCandidates() {
        if (!this.hasImportCandidates()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<ImportModuleCandidate>(this.m_rootToModuleCandidate.values());
    }

    public void startImportCandidatesDetection() {
        this.m_importCandidatesDetectionHasBeenRun = false;
        this.resetImportCandidatesInfo();
    }

    public void finishImportCandidatesDetection() {
        this.m_importCandidatesDetectionHasBeenRun = true;
    }

    public boolean haveRootDefinitionsBeenModified() {
        return !this.m_defaultClassRootDefinitions.equals(this.m_classRootDefinitions) || !this.m_defaultSourceRootDefinitions.equals(this.m_sourceRootDefinitions);
    }

    public boolean hasImportCandidatesDetectionBeenRun() {
        return this.m_importCandidatesDetectionHasBeenRun;
    }

    public boolean isImportCandidatesDetectionPossible() {
        return this.hasRootDefinitionsDetectionBeenRun() && this.hasDetectedRoots();
    }
}

