/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;

public final class SyntheticsHelper {
    private static final String METHOD_NAME_ACCESS = "access$";
    private static final String LAMBDA = "lambda$";
    private static final String FIELD_NAME_ASSERTIONS_DISABLED = "$assertionsDisabled";
    private static final String FIELD_NAME_ENUM_VALUES = "ENUM$VALUES";
    private static final String METHOD_NAME_DESIRED_ASSERTION_STATUS = "desiredAssertionStatus";
    private static final String METHOD_NAME_SWITCH_TABLE = "$SWITCH_TABLE";
    private static final String ENUM_METHOD_VALUE_OF = "valueOf";
    private static final String ENUM_METHOD_VALUES = "values";
    private static final String THIS = "this";
    private static final String THIS_$ = "this$";

    private SyntheticsHelper() {
    }

    public static boolean isLocalVariableSynthetic(String name) {
        assert (name != null) : "Parameter 'name' of method 'isLocalVariableSynthetic' must not be null";
        return THIS.equals(name);
    }

    public static boolean isSynthetic(int accessFlags) {
        return (accessFlags & 0x1000) != 0 || (accessFlags & 0x40) != 0;
    }

    public static boolean isLambdaMethod(String name) {
        return name != null && !name.isEmpty() && name.toLowerCase().startsWith(LAMBDA) && Character.isDigit(name.charAt(name.length() - 1));
    }

    public static boolean isBridge(int accessFlags, String methodName) {
        return (accessFlags & 0x40) != 0 || methodName.startsWith(METHOD_NAME_ACCESS);
    }

    public static boolean isFieldSynthetic(String fieldName) {
        assert (fieldName != null) : "Parameter 'fieldName' of method 'isFieldSynthetic' must not be null";
        if (fieldName.startsWith(THIS_$)) {
            String rest = fieldName.substring(THIS_$.length());
            return rest.length() == 1 && Character.isDigit(rest.charAt(0));
        }
        return FIELD_NAME_ASSERTIONS_DISABLED.equals(fieldName) || FIELD_NAME_ENUM_VALUES.equals(fieldName);
    }

    public static boolean isMethodSynthetic(String typeName, String methodName, boolean includeBridgeMethods) {
        assert (typeName != null) : "Parameter 'typeName' of method 'isMethodSynthetic' must not be null";
        assert (methodName != null) : "Parameter 'methodName' of method 'isMethodSynthetic' must not be null";
        if (includeBridgeMethods && methodName.startsWith(METHOD_NAME_ACCESS)) {
            String rest = methodName.substring(METHOD_NAME_ACCESS.length());
            return rest.length() == 1 && Character.isDigit(rest.charAt(0));
        }
        if ("java.lang.Class".equals(typeName) && METHOD_NAME_DESIRED_ASSERTION_STATUS.equals(methodName)) {
            return true;
        }
        return methodName.startsWith(METHOD_NAME_SWITCH_TABLE);
    }

    public static boolean isCompilerGeneratedMethod(JavaType type, String methodName, int accessFlags, String descriptor) {
        assert (type != null) : "Parameter 'type' of method 'isMethodSynthetic' must not be null";
        assert (methodName != null) : "Parameter 'methodName' of method 'isMethodSynthetic' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'isCompilerGeneratedEnumMethod' must not be null";
        if ((accessFlags & 8) != 0 && type.hasFlag(JavaElementFlag.ENUM)) {
            if (ENUM_METHOD_VALUE_OF.equals(methodName)) {
                return descriptor.startsWith("(Ljava/lang/String;)L");
            }
            if (ENUM_METHOD_VALUES.equals(methodName)) {
                return descriptor.startsWith("()[L");
            }
        }
        return false;
    }

    public static boolean isOuterClassReference(String fieldName) {
        assert (fieldName != null) : "Parameter 'fieldName' of method 'isOuterClassReference' must not be null";
        int pos = fieldName.indexOf(THIS_$);
        if (pos != -1 && fieldName.length() > pos + THIS_$.length()) {
            String rest = fieldName.substring(pos + THIS_$.length());
            try {
                Integer.parseInt(rest);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDependencySynthetic(JavaElement from, JavaType toType, JavaMethod toMethod, String toMethodDescriptor, JavaDependencyType type) {
        String methodName;
        assert (from != null) : "Parameter 'from' of method 'isDependencySynthetic' must not be null";
        assert (toType != null) : "Parameter 'toType' of method 'isSynthetic' must not be null";
        assert (toMethod != null) : "Parameter 'toMethod' of method 'isSynthetic' must not be null";
        assert (toMethodDescriptor != null && toMethodDescriptor.length() > 0) : "Parameter 'toMethodDescriptor' of method 'isDependencySynthetic' must not be empty";
        assert (type != null) : "Parameter 'type' of method 'isDependencySynthetic' must not be null";
        if (from instanceof JavaMethod && type == JavaDependencyType.STATIC_METHOD_CALL && (ENUM_METHOD_VALUES.equals(methodName = from.getShortName()) || ENUM_METHOD_VALUE_OF.equals(methodName))) {
            JavaType fromType = (JavaType)from.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (fromType != null) : "Parameter 'fromType' of method 'isDependencySynthetic' must not be null";
            return fromType.hasFlag(JavaElementFlag.ENUM) && (toType.getFqName().equals("java.lang.System") || toType.getFqName().equals("java.lang.Enum"));
        }
        return false;
    }

    public static boolean isDependencySynthetic(JavaElement from, JavaElement to, JavaDependencyType type) {
        JavaType toType;
        JavaType fromType;
        assert (from != null) : "Parameter 'from' of method 'isDependencySynthetic' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isDependencySynthetic' must not be null";
        assert (type != null) : "Parameter 'type' of method 'isDependencySynthetic' must not be null";
        if (from instanceof JavaMethod && from.hasFlag(JavaElementFlag.STATIC)) {
            JavaType toType2;
            JavaType fromType2;
            String fromMethodName = from.getShortName();
            if ((ENUM_METHOD_VALUES.equals(fromMethodName) || ENUM_METHOD_VALUE_OF.equals(fromMethodName)) && (fromType2 = (JavaType)from.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT)).hasFlag(JavaElementFlag.ENUM) && fromType2 == (toType2 = (JavaType)to.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT))) {
                String methodDescriptor = ((JavaMethod)from).getDescriptor();
                String typeName = fromType2.getFqName().replace('.', '/');
                if (ENUM_METHOD_VALUES.equals(fromMethodName)) {
                    return methodDescriptor.equals("()[L" + typeName + ";");
                }
                if (ENUM_METHOD_VALUE_OF.equals(fromMethodName)) {
                    return methodDescriptor.equals("(Ljava/lang/String;)L" + typeName + ";");
                }
            }
        } else if (type == JavaDependencyType.FIELD && from instanceof JavaField ? (fromType = (JavaType)from.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT)) != null && fromType.hasFlag(JavaElementFlag.ENUM) && fromType == (toType = (JavaType)to.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT)) : from instanceof JavaType && from.hasFlag(JavaElementFlag.ENUM) && type == JavaDependencyType.TYPE_ARGUMENT && (fromType = (JavaType)from) == (toType = (JavaType)to.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT))) {
            return true;
        }
        return false;
    }

    public static boolean isDependencySyntheticOfToBeRemovedInitializer(JavaDependency dependency) {
        JavaElement to;
        JavaType toType;
        assert (dependency != null) : "Parameter 'dependency' of method 'isDependencySynthetic' must not be null";
        JavaElement from = (JavaElement)dependency.getOriginalFrom();
        assert (from != null && from instanceof JavaMethod) : "Unexpected class in method 'isDependencySyntheticOfToBeRemovedInitializer': " + String.valueOf(from);
        assert (((JavaMethod)from).isInitializer()) : "Not an initializer: " + String.valueOf(from);
        JavaType fromType = (JavaType)from.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT);
        return fromType.hasFlag(JavaElementFlag.ENUM) && fromType == (toType = (JavaType)(to = (JavaElement)dependency.getOriginalTo()).getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT));
    }
}

