/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.annotation.ClassAnnotation;
import com.hello2morrow.sonargraph.core.model.annotation.EnumAnnotationValue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IImportRegistry;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaElementInfoDump;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.SyntheticsHelper;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaFileParseError;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.AnnotationDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InlineDependencyProcessor
extends DependencyProcessor
implements IImportRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlineDependencyProcessor.class);
    private ArrayList<String> m_staticImports;
    private ArrayList<String> m_packageImports;
    private Set<String> m_classImports;
    private Map<String, String> m_staticNameMap;
    private ArrayList<DependencyInfo> m_simple;
    private ArrayList<DependencyInfo> m_qualified;
    private ArrayList<DependencyInfo> m_dotClass;
    private MultipleValueMap<JavaElement, Annotation> m_annotations;

    private void addPackageImport(String packageName) {
        assert (packageName != null && packageName.length() > 0) : "Parameter 'packageName' of method 'addPackageImport' must not be empty";
        if (this.m_packageImports == null) {
            this.m_packageImports = new ArrayList(5);
        }
        this.m_packageImports.add(packageName);
    }

    private void addClassImport(String className) {
        assert (className != null && className.length() > 0) : "Parameter 'className' of method 'addClassImport' must not be empty";
        if (this.m_classImports == null) {
            this.m_classImports = new LinkedHashSet<String>(5);
        }
        this.m_classImports.add(className.intern());
    }

    private void addStaticClassImport(String className) {
        assert (className != null && className.length() > 0) : "Parameter 'className' of method 'addStaticClassImport' must not be empty";
        if (this.m_staticImports == null) {
            this.m_staticImports = new ArrayList(5);
        }
        this.m_staticImports.add(className.intern());
    }

    private void addStaticNameImport(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addStaticNameImport' must not be empty";
        int dotPos = name.lastIndexOf(46);
        assert (dotPos != -1) : "Invalid name: " + name;
        String namePart = name.substring(dotPos + 1);
        String className = name.substring(0, dotPos);
        if (this.m_staticNameMap == null) {
            this.m_staticNameMap = new THashMap();
        }
        this.m_staticNameMap.put(namePart.intern(), className.intern());
    }

    public void addAnnotation(JavaElement element, Annotation annotation) {
        assert (element != null) : "Parameter 'element' of method 'addAnnotations' must not be null";
        assert (annotation != null) : "Parameter 'annotation' of method 'addAnnotations' must not be null";
        if (this.m_annotations == null) {
            this.m_annotations = new MultipleValueMap();
        }
        this.m_annotations.put((Object)element, (Object)annotation);
    }

    public void processImport(boolean isStatic, boolean isPackageImport, String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'processImport' must not be empty";
        if (isStatic) {
            if (isPackageImport) {
                this.addStaticClassImport(name);
            } else {
                this.addStaticNameImport(name);
            }
        } else if (isPackageImport) {
            this.addPackageImport(name);
        } else {
            this.addClassImport(name);
        }
    }

    private List<JavaType> getTypesToCheck(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getTypesToCheck' must not be null";
        if (!type.isNested()) {
            return Collections.singletonList(type);
        }
        ArrayList<JavaType> types = new ArrayList<JavaType>(5);
        JavaType currentType = type;
        while (currentType != null) {
            types.add(currentType);
            currentType = (JavaType)currentType.getParent(JavaType.class, new Class[0]);
        }
        return types;
    }

    private void resolveSimplePotentialInlineDependency(IJavaElementAccessor accessor, JavaModule fromModule, JavaElement from, JavaType type, String name, int line) {
        assert (accessor != null) : "Parameter 'accessor' of method 'resolveSimplePotentialInlineDependency' must not be null";
        assert (fromModule != null) : "Parameter 'fromModule' of method 'resolveSimplePotentialInlineDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'resolveSimplePotentialInlineDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'resolveSimplePotentialInlineDependency' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'resolveSimplePotentialInlineDependency' must not be empty";
        ArrayList<JavaField> targetFieldCandidates = new ArrayList<JavaField>(5);
        for (JavaField nextField : accessor.getInlineFields(name)) {
            String className;
            if (!accessor.isAccessibleFrom(nextField, type)) continue;
            JavaType parentTypeOfField = (JavaType)nextField.getParent(JavaType.class, new Class[0]);
            assert (parentTypeOfField != null) : "Parameter 'parentTypeOfField' of method 'resolveSimplePotentialInlineDependency' must not be null";
            for (JavaType nextTypeToCheck : this.getTypesToCheck(type)) {
                if (parentTypeOfField != nextTypeToCheck && !accessor.isDerivedFrom(nextTypeToCheck, parentTypeOfField)) continue;
                targetFieldCandidates.add(nextField);
            }
            String fieldClassName = parentTypeOfField.getFqName();
            String string = className = this.m_staticNameMap != null ? this.m_staticNameMap.get(name) : null;
            if (className != null && fieldClassName.equals(className)) {
                targetFieldCandidates.add(nextField);
                continue;
            }
            if (this.m_staticImports == null || !this.m_staticImports.contains(fieldClassName)) continue;
            targetFieldCandidates.add(nextField);
        }
        if (!targetFieldCandidates.isEmpty()) {
            this.processTargetFieldCandidates(targetFieldCandidates, accessor, fromModule, from, line, false);
        }
    }

    private void processTargetFieldCandidates(List<JavaField> fieldCandidates, IJavaElementAccessor accessor, JavaModule fromModule, JavaElement from, int line, boolean isQualifiedAccess) {
        assert (fieldCandidates != null && !fieldCandidates.isEmpty()) : "Parameter 'fieldCandidates' of method 'processTargetFieldCandidates' must not be empty";
        assert (accessor != null) : "Parameter 'accessor' of method 'processTargetFieldCandidates' must not be null";
        assert (fromModule != null) : "Parameter 'fromModule' of method 'processTargetFieldCandidates' must not be null";
        assert (from != null) : "Parameter 'from' of method 'processTargetFieldCandidates' must not be null";
        JavaField field = null;
        JavaType typeOfField = null;
        if (fieldCandidates.size() == 1) {
            field = fieldCandidates.get(0);
            if (!isQualifiedAccess) {
                typeOfField = (JavaType)field.getParent(JavaType.class, new Class[0]);
            }
        } else {
            THashMap typeToFieldCandidate = new THashMap();
            String targetTypeFqName = null;
            for (JavaField nextFieldCandidate : fieldCandidates) {
                JavaType nextParentType = (JavaType)nextFieldCandidate.getParent(JavaType.class, new Class[0]);
                assert (nextParentType != null) : "'nextParentType' of method 'processTargetFieldCandidates' must not be null";
                if (targetTypeFqName == null) {
                    targetTypeFqName = nextParentType.getFqName();
                } else if (!targetTypeFqName.equals(nextParentType.getFqName())) {
                    return;
                }
                typeToFieldCandidate.put(nextParentType, nextFieldCandidate);
            }
            assert (targetTypeFqName != null && targetTypeFqName.length() > 0) : "'targetTypeFqName' of method 'processTargetFieldCandidates' must not be empty";
            JavaType toType = InlineDependencyProcessor.getToType(accessor, fromModule, from, line, targetTypeFqName);
            if (toType != null) {
                field = (JavaField)typeToFieldCandidate.get(toType);
                typeOfField = toType;
            }
        }
        if (field != null) {
            if (!isQualifiedAccess) {
                assert (typeOfField != null) : "'typeOfField' of method 'processTargetFieldCandidates' must not be null";
                JavaType typeOfFrom = (JavaType)from.getParent(JavaType.class, ParentMode.SELF_OR_FIRST_PARENT);
                assert (typeOfFrom != null) : "'typeOfFrom' of method 'processTargetFieldCandidates' must not be null";
                if (typeOfFrom != typeOfField && accessor.isDerivedFrom(typeOfFrom, typeOfField)) {
                    JavaField targetField = accessor.getField(typeOfFrom, field.getShortName());
                    targetField.removeFlag(JavaElementFlag.EXTERNAL);
                    this.addInlineDependency(accessor, from, targetField, line, JavaDependencyType.READ_FIELD_INLINE);
                    return;
                }
            }
            this.addInlineDependency(accessor, from, field, line, JavaDependencyType.READ_FIELD_INLINE);
        }
    }

    private void resolveQualifiedPotentialInlineDependency(IJavaElementAccessor accessor, JavaModule fromModule, JavaElement from, JavaType type, String qName, int line) {
        assert (accessor != null) : "Parameter 'accessor' of method 'resolveQualifiedPotentialInlineDependency' must not be null";
        assert (fromModule != null) : "Parameter 'fromModule' of method 'resolveQualifiedPotentialInlineDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'resolveQualifiedPotentialInlineDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'resolveQualifiedPotentialInlineDependency' must not be null";
        assert (qName != null && qName.length() > 0) : "Parameter 'qName' of method 'resolveQualifiedPotentialInlineDependency' must not be empty";
        int dotPos = qName.lastIndexOf(46);
        assert (dotPos > 0) : "Invalid qName: " + qName;
        String name = qName.substring(dotPos + 1);
        String classPart = qName.substring(0, dotPos);
        ArrayList<JavaField> targetFieldCandidates = new ArrayList<JavaField>(5);
        for (JavaField nextField : accessor.getInlineFields(name)) {
            if (!accessor.isAccessibleFrom(nextField, type)) continue;
            JavaType parentTypeOfField = (JavaType)nextField.getParent(JavaType.class, new Class[0]);
            assert (parentTypeOfField != null) : "Parameter 'parentTypeOfField' of method 'resolveQualifiedPotentialInlineDependency' must not be null";
            if (parentTypeOfField.hasFlag(JavaElementFlag.NESTED) && parentTypeOfField.hasAsParent((NamedElement)type, false)) {
                targetFieldCandidates.add(nextField);
                continue;
            }
            String nextParentTypeName = parentTypeOfField.getFqName().replace('$', '.');
            if (!nextParentTypeName.equals(classPart) && !nextParentTypeName.endsWith("." + classPart)) continue;
            if (this.m_classImports != null && this.m_classImports.contains(parentTypeOfField.getTopMostType().getFqName())) {
                targetFieldCandidates.add(nextField);
                continue;
            }
            String nextParentTypePackage = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(parentTypeOfField.getFqName());
            if (this.m_packageImports != null && this.m_packageImports.contains(nextParentTypePackage)) {
                targetFieldCandidates.add(nextField);
                continue;
            }
            if (!nextParentTypePackage.equals(JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(type.getFqName()))) continue;
            targetFieldCandidates.add(nextField);
        }
        if (!targetFieldCandidates.isEmpty()) {
            this.processTargetFieldCandidates(targetFieldCandidates, accessor, fromModule, from, line, true);
        }
    }

    private void addInlineDependency(IJavaElementAccessor accessor, JavaElement from, JavaElement to, int line, JavaDependencyType type) {
        assert (accessor != null) : "Parameter 'accessor' of method 'addInlineDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'addInlineDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addInlineDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'addInlineDependency' must not be null";
        JavaIgnoreAccess ignoreAccess = accessor.getIgnoreAccess();
        if (to instanceof JavaType) {
            if (ignoreAccess.ignoreTypeAccess(null, type, ((JavaType)to).getFqName())) {
                return;
            }
        } else {
            String toShortName = to.getShortName();
            if (to instanceof JavaField) {
                if (SyntheticsHelper.isFieldSynthetic(toShortName)) {
                    return;
                }
                JavaType parentType = (JavaType)to.getParent(JavaType.class, new Class[0]);
                assert (parentType != null) : "'parentType' of method 'addInlineDependency' must not be null";
                if (ignoreAccess.ignoreFieldAccess(null, type, parentType.getFqName(), toShortName)) {
                    return;
                }
            } else {
                assert (to != null && to instanceof JavaMethod) : "Unexpected class in method 'addInlineDependency': " + String.valueOf(to);
                JavaType parentType = (JavaType)to.getParent(JavaType.class, new Class[0]);
                assert (parentType != null) : "'parentType' of method 'addInlineDependency' must not be null";
                String fqTypeName = parentType.getFqName();
                if (SyntheticsHelper.isMethodSynthetic(fqTypeName, toShortName, false)) {
                    return;
                }
                if (ignoreAccess.ignoreMethodAccess(null, type, fqTypeName, toShortName)) {
                    return;
                }
            }
        }
        if (!InlineDependencyProcessor.dependencyAlreadyExists(from, to, null, type, line)) {
            JavaDependency dependency = DependencyCreator.create(null, type, from, to, line);
            from.addDependency(dependency);
        }
    }

    private JavaType resolveType(IJavaElementAccessor accessor, JavaModule fromModule, JavaType fromType, JavaElement from, String name, int line) {
        assert (accessor != null) : "Parameter 'accessor' of method 'resolveDotClassUsage' must not be null";
        assert (fromModule != null) : "Parameter 'fromModule' of method 'resolveDotClassUsage' must not be null";
        assert (fromType != null) : "Parameter 'fromType' of method 'resolveDotClassUsage' must not be null";
        assert (from != null) : "Parameter 'from' of method 'resolveDotClassUsage' must not be null";
        assert (name != null) : "Parameter 'name' of method 'resolveDotClassUsage' must not be null";
        int dotPos = name.lastIndexOf(46);
        String classNamePart = name;
        if (dotPos > 0) {
            classNamePart = name.substring(dotPos + 1);
        }
        Collection<JavaType> potentialTargetTypes = accessor.getTypesByShortName(classNamePart);
        String fromPackageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(fromType.getFqName());
        ArrayList<JavaType> targetTypeCandidates = new ArrayList<JavaType>(5);
        for (JavaType type : potentialTargetTypes) {
            if (dotPos > 0) {
                String normalizedName = type.getFqName().replace('$', '.');
                if (!normalizedName.equals(name) && !normalizedName.endsWith("." + name)) continue;
                targetTypeCandidates.add(type);
            }
            String typePackageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(type.getFqName());
            if (type.isNested()) {
                if (type.getParent(SourceFile.class, new Class[0]) == fromType.getParent(SourceFile.class, new Class[0])) {
                    targetTypeCandidates.add(type);
                    continue;
                }
                if (type.isPrivate() || dotPos <= 0 || !type.getName().replace('$', '.').endsWith(name)) continue;
                targetTypeCandidates.add(type);
                continue;
            }
            if (fromPackageName.equals(typePackageName)) {
                targetTypeCandidates.add(type);
                continue;
            }
            if (this.m_classImports != null && this.m_classImports.contains(type.getTopMostType().getFqName())) {
                targetTypeCandidates.add(type);
                continue;
            }
            if (this.m_packageImports == null || !this.m_packageImports.contains(typePackageName)) continue;
            targetTypeCandidates.add(type);
        }
        if (targetTypeCandidates.isEmpty()) {
            return null;
        }
        if (targetTypeCandidates.size() == 1) {
            return (JavaType)targetTypeCandidates.get(0);
        }
        String targetTypeFqName = null;
        for (JavaType nextTypedCandidate : targetTypeCandidates) {
            if (targetTypeFqName == null) {
                targetTypeFqName = nextTypedCandidate.getFqName();
                continue;
            }
            if (targetTypeFqName.equals(nextTypedCandidate.getFqName())) continue;
            return null;
        }
        assert (targetTypeFqName != null && targetTypeFqName.length() > 0) : "'targetTypeFqName' of method 'resolveDotClassUsage' must not be empty";
        return InlineDependencyProcessor.getToType(accessor, fromModule, from, line, targetTypeFqName);
    }

    private void resolveDotClassUsage(IJavaElementAccessor accessor, JavaModule fromModule, JavaElement from, JavaType type, String name, int line) {
        assert (accessor != null) : "Parameter 'accessor' of method 'resolveDotClassUsage' must not be null";
        assert (fromModule != null) : "Parameter 'fromModule' of method 'resolveDotClassUsage' must not be null";
        assert (type != null) : "Parameter 'type' of method 'resolveDotClassUsage' must not be null";
        assert (from != null) : "Parameter 'from' of method 'resolveDotClassUsage' must not be null";
        assert (name != null) : "Parameter 'name' of method 'resolveDotClassUsage' must not be null";
        JavaType toType = this.resolveType(accessor, fromModule, type, from, name, line);
        if (toType != null) {
            this.addInlineDependency(accessor, from, toType, line, JavaDependencyType.CLASS_ACCESS_INLINE);
        }
    }

    public void addSimplePotentialInlineDependency(JavaModule fromModule, JavaElement from, JavaType type, String name, int line) {
        if (from == null) {
            return;
        }
        if (this.m_simple == null) {
            this.m_simple = new ArrayList(2);
        }
        this.m_simple.add(new DependencyInfo(fromModule, from, type, name, line));
    }

    public void addQualifiedPotentialInlineDependency(JavaModule fromModule, JavaElement from, JavaType type, String name, int line) {
        if (from == null) {
            return;
        }
        assert (name.indexOf(46) > 0) : "Name must be qualified: " + name;
        if (this.m_qualified == null) {
            this.m_qualified = new ArrayList(2);
        }
        this.m_qualified.add(new DependencyInfo(fromModule, from, type, name, line));
    }

    public void addDotClassUsage(JavaModule fromModule, JavaElement from, JavaType type, String name, int line) {
        if (from == null) {
            return;
        }
        if (this.m_dotClass == null) {
            this.m_dotClass = new ArrayList(2);
        }
        this.m_dotClass.add(new DependencyInfo(fromModule, from, type, name, line));
    }

    public boolean isEmpty() {
        return !(this.m_simple != null && !this.m_simple.isEmpty() || this.m_qualified != null && !this.m_qualified.isEmpty() || this.m_dotClass != null && !this.m_dotClass.isEmpty() || this.m_annotations != null && !this.m_annotations.isEmpty());
    }

    @Override
    public void process(IJavaElementAccessor accessor) {
        assert (accessor != null) : "Parameter 'accessor' of method 'process' must not be null";
        if (!this.isEmpty()) {
            if (this.m_packageImports == null) {
                this.m_packageImports = new ArrayList(1);
            }
            this.m_packageImports.add(0, "java.lang");
            if (this.m_simple != null) {
                for (DependencyInfo nextSimple : this.m_simple) {
                    this.resolveSimplePotentialInlineDependency(accessor, nextSimple.getFromModule(), nextSimple.getElement(), nextSimple.getType(), nextSimple.getName(), nextSimple.getLine());
                }
            }
            if (this.m_qualified != null) {
                for (DependencyInfo nextQualified : this.m_qualified) {
                    this.resolveQualifiedPotentialInlineDependency(accessor, nextQualified.getFromModule(), nextQualified.getElement(), nextQualified.getType(), nextQualified.getName(), nextQualified.getLine());
                }
            }
            if (this.m_dotClass != null) {
                for (DependencyInfo nextDotClass : this.m_dotClass) {
                    this.resolveDotClassUsage(accessor, nextDotClass.getFromModule(), nextDotClass.getElement(), nextDotClass.getType(), nextDotClass.getName(), nextDotClass.getLine());
                }
            }
            if (this.m_annotations != null) {
                for (JavaElement element : this.m_annotations.keySet()) {
                    try {
                        AnnotationResolver resolver = new AnnotationResolver(element, accessor);
                        this.m_annotations.get((Object)element).forEach(a -> a.accept((AnnotationValue.AnnotationVisitor)resolver));
                    }
                    catch (Throwable t) {
                        String msg = "Unable to resolve annotations";
                        element.addIssue((Issue)new JavaFileParseError((NamedElement)element, "Unable to resolve annotations", -1, -1));
                        LOGGER.error("Unable to resolve annotations:\n" + JavaElementInfoDump.getInfo(element), t);
                    }
                }
            }
        }
    }

    @Override
    public boolean isImported(String topLevelType, String fqName) {
        int lastDot;
        assert (topLevelType != null) : "Parameter 'topLevelType' of method 'isImported' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'isImported' must not be null";
        if (this.m_classImports != null) {
            if (this.m_classImports.contains(fqName)) {
                return true;
            }
            if (!fqName.equals(topLevelType) && this.m_classImports.contains(topLevelType)) {
                return true;
            }
        }
        if ((lastDot = topLevelType.lastIndexOf(46)) != -1) {
            String pkgName = topLevelType.substring(0, lastDot);
            if (pkgName.equals("java.lang")) {
                return true;
            }
            if (this.m_packageImports != null && this.m_packageImports.contains(pkgName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean importsTypeFromPackage(String packageName) {
        assert (packageName != null && packageName.length() > 0) : "Parameter 'packageName' of method 'importsTypeFromPackage' must not be empty";
        if (this.m_classImports != null) {
            for (String next : this.m_classImports) {
                String nextPackage = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(next);
                if (!packageName.equals(nextPackage)) continue;
                return true;
            }
        }
        return false;
    }

    private class AnnotationResolver
    extends AnnotationValue.AnnotationVisitor
    implements Annotation.IVisitor,
    EnumAnnotationValue.IVisitor,
    ClassAnnotation.IVisitor {
        private final JavaElement m_fromElement;
        private final IJavaElementAccessor m_accessor;
        private final JavaModule m_fromModule;
        private final JavaType m_fromType;
        private final JavaDependencyContext m_context;
        private int m_nestingLevel = 0;

        private AnnotationResolver(JavaElement fromElement, IJavaElementAccessor accessor) {
            assert (fromElement != null) : "Parameter 'fromElement' of method 'AnnotationResolver' must not be null";
            assert (accessor != null) : "Parameter 'accessor' of method 'AnnotationResolver' must not be null";
            this.m_fromElement = fromElement;
            this.m_accessor = accessor;
            this.m_fromModule = (JavaModule)((Object)fromElement.getParent(JavaModule.class, new Class[0]));
            if (this.m_fromElement instanceof JavaType) {
                this.m_context = JavaDependencyContext.TYPE;
                this.m_fromType = (JavaType)this.m_fromElement;
            } else if (this.m_fromElement instanceof JavaMethod) {
                this.m_context = JavaDependencyContext.METHOD;
                this.m_fromType = (JavaType)fromElement.getParent(JavaType.class, new Class[0]);
            } else {
                assert (this.m_fromElement instanceof JavaField);
                this.m_context = JavaDependencyContext.FIELD;
                this.m_fromType = (JavaType)fromElement.getParent(JavaType.class, new Class[0]);
            }
        }

        public void visitAnnotationValue(AnnotationValue annotationValue) {
            assert (annotationValue != null) : "Parameter 'annotationValue' of method 'visitAnnotationValue' must not be null";
            annotationValue.finishModification();
            annotationValue.visitChildren((AnnotationValue.AnnotationVisitor)this);
        }

        public void visitClassAnnotation(ClassAnnotation annotation) {
            assert (annotation != null) : "Parameter 'annotation' of method 'visitClassAnnotation' must not be null";
            String className = annotation.getClassName();
            JavaType type = InlineDependencyProcessor.this.resolveType(this.m_accessor, this.m_fromModule, this.m_fromType, this.m_fromElement, className, annotation.getLineNumber());
            if (type != null) {
                annotation.setType((NamedElement)type);
                JavaDependencyWithContext dep = this.m_fromElement.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.ANNOTATION_VALUE}).stream().map(d -> (JavaDependencyWithContext)((Object)d)).filter(d -> d.getTo() == type && d.getRawLineNumber() == -1 && d.getDependencyContext() == this.m_context).findFirst().orElse(null);
                if (dep != null) {
                    dep.setLineNumber(annotation.getLineNumber());
                } else {
                    dep = (JavaDependencyWithContext)DependencyCreator.create(this.m_context, JavaDependencyType.ANNOTATION_VALUE, this.m_fromElement, type, annotation.getLineNumber());
                    this.m_fromElement.addDependency(dep);
                }
                JavaDependency inlineDep = this.m_fromElement.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.CLASS_ACCESS_INLINE}).stream().map(d -> (JavaDependency)((Object)d)).filter(d -> d.getTo() == type && d.getRawLineNumber() == annotation.getLineNumber()).findFirst().orElse(null);
                if (inlineDep != null) {
                    this.m_fromElement.removeDependency(inlineDep);
                } else {
                    this.m_fromType.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.CLASS_ACCESS_INLINE}).stream().map(d -> (JavaDependency)((Object)d)).filter(d -> d.getTo() == type && d.getRawLineNumber() == annotation.getLineNumber()).findFirst().ifPresent(d -> this.m_fromType.removeDependency((ParserDependency)d));
                }
            }
            annotation.finishModification();
            annotation.visitChildren((AnnotationValue.AnnotationVisitor)this);
        }

        public void visitEnumAnnotationValue(EnumAnnotationValue annotationValue) {
            assert (annotationValue != null) : "Parameter 'annotationValue' of method 'visitEnumAnnotationValue' must not be null";
            String name = annotationValue.getEnumString();
            int index = name.lastIndexOf(46);
            if (index > 0) {
                JavaField enumField;
                String className = name.substring(0, index);
                String fieldName = name.substring(index + 1);
                JavaType enumType = InlineDependencyProcessor.this.resolveType(this.m_accessor, this.m_fromModule, this.m_fromType, this.m_fromElement, className, annotationValue.getLineNumber());
                if (enumType != null && (enumField = (JavaField)enumType.getFirstChild(e -> e.getShortName().equals(fieldName), JavaField.class)) != null) {
                    annotationValue.setEnumConstant((NamedElement)enumField);
                    JavaDependencyWithContext dep = this.m_fromElement.getOutgoingDependencies(new IParserDependencyType[]{JavaDependencyType.ANNOTATION_ENUMERATION_VALUE}).stream().map(d -> (JavaDependencyWithContext)((Object)d)).filter(d -> d.getTo() == enumField && d.getRawLineNumber() == -1 && d.getDependencyContext() == this.m_context).findFirst().orElse(null);
                    if (dep != null) {
                        dep.setLineNumber(annotationValue.getLineNumber());
                    } else {
                        dep = (JavaDependencyWithContext)DependencyCreator.create(this.m_context, JavaDependencyType.ANNOTATION_ENUMERATION_VALUE, this.m_fromElement, enumField, annotationValue.getLineNumber());
                        this.m_fromElement.addDependency(dep);
                    }
                }
            }
            annotationValue.finishModification();
            annotationValue.visitChildren((AnnotationValue.AnnotationVisitor)this);
        }

        public void visitAnnotation(Annotation annotation) {
            int annotationLineNumber;
            assert (annotation != null) : "Parameter 'annotation' of method 'visitAnnotation' must not be null";
            String className = annotation.getAnnotationClassName();
            JavaType annotationType = InlineDependencyProcessor.this.resolveType(this.m_accessor, this.m_fromModule, this.m_fromType, this.m_fromElement, className, annotationLineNumber = annotation.getLineNumber());
            if (annotationType != null) {
                JavaDependencyType depType = this.m_nestingLevel > 0 ? JavaDependencyType.NESTED_ANNOTATION_VALUE : JavaDependencyType.HAS_ANNOTATION;
                annotation.setAnnotationClass((NamedElement)annotationType);
                annotationType.addFlag(JavaElementFlag.ANNOTATION);
                AnnotationDependencyWithContext dep = this.m_fromElement.getOutgoingDependencies(new IParserDependencyType[]{depType}).stream().filter(d -> d.getTo() == annotationType && ((JavaDependency)((Object)d)).getRawLineNumber() == -1 && d.getDependencyContext() == this.m_context).findFirst().orElse(null);
                if (dep != null) {
                    dep.setLineNumber(annotationLineNumber);
                } else if (!DependencyProcessor.dependencyAlreadyExists(this.m_fromElement, annotationType, this.m_context, depType, annotationLineNumber)) {
                    dep = (AnnotationDependencyWithContext)DependencyCreator.create(this.m_context, depType, this.m_fromElement, annotationType, annotationLineNumber);
                    this.m_fromElement.addDependency(dep);
                }
                if (dep != null) {
                    dep.setAnnotation(annotation);
                }
            }
            ++this.m_nestingLevel;
            annotation.finishModification();
            annotation.visitChildren((AnnotationValue.AnnotationVisitor)this);
            --this.m_nestingLevel;
        }
    }

    private static final class DependencyInfo {
        private final JavaModule m_fromModule;
        private final JavaElement m_element;
        private final JavaType m_type;
        private final String m_name;
        private final int m_line;

        DependencyInfo(JavaModule fromModule, JavaElement element, JavaType type, String name, int line) {
            assert (fromModule != null) : "Parameter 'fromModule' of method 'DependencyInfo' must not be null";
            assert (element != null) : "Parameter 'element' of method 'DependencyInfo' must not be null";
            assert (type != null) : "Parameter 'type' of method 'DependencyInfo' must not be null";
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'DependencyInfo' must not be empty";
            this.m_fromModule = fromModule;
            this.m_element = element;
            this.m_type = type;
            this.m_name = name.intern();
            this.m_line = line;
        }

        protected JavaModule getFromModule() {
            return this.m_fromModule;
        }

        protected JavaElement getElement() {
            return this.m_element;
        }

        protected JavaType getType() {
            return this.m_type;
        }

        protected String getName() {
            return this.m_name;
        }

        protected int getLine() {
            return this.m_line;
        }
    }
}

