/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.RootDirectoryPathValidator;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.AssignmentInfo;
import com.hello2morrow.sonargraph.core.model.system.AssignmentInfoComparator;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaLanguageProvider;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.RootDirectoryPathCollector;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaManualWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IJavaWorkspaceProvider;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathCollector;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.RootDirectoryPathsModification;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaWorkspaceExtension
extends Extension
implements IJavaWorkspaceExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaWorkspaceExtension.class);
    private final IJavaLanguageProvider m_languageProvider;
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;

    JavaWorkspaceExtension(IJavaLanguageProvider languageProvider, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'JavaWorkspaceExtension' must not be null";
        assert (softwareSystem != null) : "'softwareSystem' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'JavaWorkspaceExtension' must not be null";
        this.m_languageProvider = languageProvider;
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
    }

    @Override
    public IPathValidator getSourceRootDirectoryPathValidator() {
        return new RootDirectoryPathValidator(((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class), IPathValidator.PathType.ARCHIVE_OR_DIRECTORY, JavaSourceRootDirectoryPath.class);
    }

    @Override
    public OperationResult createSourceRootDirectoryPath(IWorkerContext workerContext, JavaModule module, TFile file) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createSourceRootDirectoryPath' must not be null";
        assert (module != null) : "Parameter 'module' of method 'createSourceRootDirectoryPath' must not be null";
        assert (file != null) : "Parameter 'file' of method 'createSourceRootDirectoryPath' must not be null";
        OperationResult result = new OperationResult("Create Java Source Root Directory");
        ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).cancelSaveSnapshot();
        ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        WorkspaceExtension.setNeedsReparse((SoftwareSystem)this.m_softwareSystem, (OperationResult)result);
        this.createSourceRootDirectoryPathInternal(module, file);
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        return result;
    }

    private RootDirectoryPath createSourceRootDirectoryPathInternal(JavaModule module, TFile file) {
        assert (module != null) : "Parameter 'module' of method 'createSourceRootDirectoryPath' must not be null";
        SoftwareSystem softwareSystem = (SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0]);
        assert (softwareSystem != null) : "'softwareSystem' of method 'createSourceRootDirectoryPathInternal' must not be null";
        ValidationResult validationResult = this.getSourceRootDirectoryPathValidator().isValid(null, file);
        assert (validationResult.isSuccess()) : "Not a valid root: " + String.valueOf(file) + " with message " + (String)validationResult.getErrors().get(0);
        RootDirectoryPath rootDirectoryPath = module.createNonStandardRootDirectoryPath((IModelServiceProvider)softwareSystem, (NamedElement)module, file);
        module.addChild((NamedElement)rootDirectoryPath);
        softwareSystem.setNeedsSave(true);
        softwareSystem.setNeedsReparse(true);
        return rootDirectoryPath;
    }

    @Override
    public IPathValidator getDetectRootDirectoryPathsStartPathValidator() {
        return new IPathValidator(){

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null || newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (!newInput.canRead()) {
                    result.addError("Can not read");
                } else if (!newInput.isDirectory()) {
                    result.addError("Must be a directory");
                }
                return result;
            }

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.ARCHIVE_OR_DIRECTORY;
            }
        };
    }

    @Override
    public IRootDirectoryPathCollector getRootDirectoryPathsDetector() {
        return new RootDirectoryPathCollector(this.m_softwareSystem);
    }

    @Override
    public OperationResult apply(IWorkerContext workerContext, RootDirectoryPathsModification modification) {
        Map<AssignmentInfo<Workspace>, JavaModule> map;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'apply' must not be null";
        assert (modification != null) : "Parameter 'modification' of method 'apply' must not be null";
        assert (!modification.isEmpty()) : "Parameter 'modification' of method 'apply' must not be empty";
        ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).cancelSaveSnapshot();
        ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        OperationResult result = new OperationResult("Apply Java Root Directory Paths Modification");
        workerContext.setNumberOfSteps(2, new int[]{90, 10});
        workerContext.working("Remove/create root directories", true);
        boolean needsReparse = false;
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        List<RootDirectoryPath> unassignedRootDirectoryPaths = modification.getUnassignedRootDirectoryPaths();
        Map<AssignmentInfo<JavaModule>, DetectedRootDirectoryPath> assignedRootDirectoryPaths = modification.getAssignedRootDirectoryPaths();
        ModifiableModel modifiableModel = workspaceExtension.switchToFactsModel();
        workerContext.beginBlockOfWork(unassignedRootDirectoryPaths.size() + assignedRootDirectoryPaths.size());
        for (RootDirectoryPath next : unassignedRootDirectoryPaths) {
            JavaModule nextModule = (JavaModule)((Object)next.getParent(JavaModule.class, new Class[0]));
            needsReparse = needsReparse && next.hasChildren(false, new Class[]{ProgrammingElement.class});
            this.m_languageProvider.aboutToDeleteWorkspaceElements(workerContext, this.m_softwareSystem, nextModule, Collections.singletonList(next));
            next.remove();
            workerContext.workItemCompleted();
        }
        TreeMap<Object, RootDirectoryPath> assignmentInfoToRootDirectoryPath = new TreeMap<Object, RootDirectoryPath>((Comparator<Object>)new AssignmentInfoComparator(JavaModule.class));
        for (Map.Entry entry : assignedRootDirectoryPaths.entrySet()) {
            DetectedRootDirectoryPath detectedRootDirectoryPath = (DetectedRootDirectoryPath)entry.getValue();
            JavaModule nextModule = (JavaModule)((AssignmentInfo)entry.getKey()).getNamedElement();
            switch (detectedRootDirectoryPath.getType()) {
                case CLASSES_DIRECTORY: 
                case CLASSES_ARCHIVE: {
                    RootDirectoryPath rootDirectoryPath = workspaceExtension.createRootDirectoryPathInternal((Module)nextModule, detectedRootDirectoryPath.getDirectory(), true);
                    assignmentInfoToRootDirectoryPath.put((AssignmentInfo)entry.getKey(), rootDirectoryPath);
                    break;
                }
                case SOURCE_DIRECTORY: 
                case SOURCE_ARCHIVE: {
                    RootDirectoryPath sourceRootDirectoryPath = this.createSourceRootDirectoryPathInternal(nextModule, detectedRootDirectoryPath.getDirectory());
                    assignmentInfoToRootDirectoryPath.put((AssignmentInfo)entry.getKey(), sourceRootDirectoryPath);
                }
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
        workerContext.working("Adjust assignment positions", true);
        assignmentInfoToRootDirectoryPath.putAll(modification.getAssignmentChangedRootDirectoryPaths());
        if (!assignmentInfoToRootDirectoryPath.isEmpty()) {
            needsReparse = true;
            for (RootDirectoryPath rootDirectoryPath : assignmentInfoToRootDirectoryPath.values()) {
                JavaModule javaModule = (JavaModule)((Object)rootDirectoryPath.getParent(JavaModule.class, new Class[0]));
                assert (javaModule != null) : "Parameter 'nextModule' of method 'apply' must not be null";
                this.m_languageProvider.aboutToMoveWorkspaceElements(workerContext, this.m_softwareSystem, javaModule, Collections.singletonList(rootDirectoryPath));
            }
            for (Map.Entry entry : assignmentInfoToRootDirectoryPath.entrySet()) {
                JavaModule javaModule = (JavaModule)((AssignmentInfo)entry.getKey()).getNamedElement();
                RootDirectoryPath nextRootDirectoryPath = (RootDirectoryPath)entry.getValue();
                javaModule.moveChild(RootDirectoryPath.class, (NamedElement)nextRootDirectoryPath, ((AssignmentInfo)entry.getKey()).getPos());
            }
        }
        if (!(map = modification.getMovedModules()).isEmpty()) {
            needsReparse = true;
            TreeMap<AssignmentInfo<Workspace>, JavaModule> assignmentInfoToMovedModules = new TreeMap<AssignmentInfo<Workspace>, JavaModule>((Comparator<AssignmentInfo<Workspace>>)new AssignmentInfoComparator(Workspace.class));
            assignmentInfoToMovedModules.putAll(map);
            for (JavaModule javaModule : assignmentInfoToMovedModules.values()) {
                this.m_languageProvider.aboutToMoveWorkspaceElements(workerContext, this.m_softwareSystem, javaModule, Collections.singletonList(javaModule));
            }
            for (Map.Entry entry : assignmentInfoToMovedModules.entrySet()) {
                Workspace nextWorkspace = (Workspace)((AssignmentInfo)entry.getKey()).getNamedElement();
                nextWorkspace.moveChild(Module.class, (NamedElement)entry.getValue(), ((AssignmentInfo)entry.getKey()).getPos());
            }
        }
        modification.getSoftwareSystem().setNeedsSave(true);
        if (needsReparse) {
            WorkspaceExtension.setNeedsReparse((SoftwareSystem)modification.getSoftwareSystem(), (OperationResult)result);
        }
        workerContext.endStep();
        this.m_softwareSystem.setIsClearable(workspaceExtension.isClearable());
        EnumSet<Modification> modifications = EnumSet.of(Modification.WORKSPACE_MODIFIED);
        if (modifiableModel != null) {
            workspaceExtension.finishSwitchToFactsModel(modifiableModel, modifications);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
        ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).saveSnapshot();
        ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).runAutomatedAnalyzers(workerContext);
        return result;
    }

    @Override
    public OperationResult createModulesFromEclipseWorkspace(IWorkerContext workerContext, Set<ImportModuleCandidate> moduleCandidates, IJavaWorkspaceExtension.ModuleImportMode importMode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createModulesFromEclipseWorkspace' must not be null";
        assert (moduleCandidates != null && !moduleCandidates.isEmpty()) : "Parameter 'moduleCandidates' of method 'createModulesFromEclipseWorkspace' must not be empty";
        workerContext.working("Adding modules", true);
        if (importMode == IJavaWorkspaceExtension.ModuleImportMode.MODULE_ADDITION) {
            ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).cancelSaveSnapshot();
            ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        }
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        OperationResult result = new OperationResult(importMode.equals((Object)IJavaWorkspaceExtension.ModuleImportMode.SYSTEM_CREATION) ? "Creating system from Eclipse workspace" : "Importing modules from Eclipse workspace");
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            workerContext.working("Adding module: " + nextModuleCandidate.getName(), true);
            Module module = null;
            if (nextModuleCandidate.isIncluded()) {
                module = workspaceExtension.createModule((Module.IModuleType)JavaModule.JavaModuleType.MANUAL, nextModuleCandidate.getName(), null, modification);
            } else {
                if (!nextModuleCandidate.isAlreadyInWorkspace()) continue;
                module = (Module)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(nextModuleCandidate.getName(), !Platform.isCaseSensitive()), JavaModule.class);
            }
            assert (module != null) : "'module' of method 'createModulesFromEclipseWorkspace' must not be null";
            workerContext.working("Adding root directory paths", false);
            for (ImportRootDirectoryPathCandidate nextRootPathCandidate : nextModuleCandidate.getRootPaths()) {
                if (!nextRootPathCandidate.isIncluded() || nextRootPathCandidate.isAlreadyInWorkspace()) continue;
                if (nextRootPathCandidate.hasSource()) {
                    this.createSourceRootDirectoryPathInternal((JavaModule)module, nextRootPathCandidate.getFile());
                    continue;
                }
                workspaceExtension.createRootDirectoryPathInternal(module, nextRootPathCandidate.getFile(), true);
            }
        }
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            workerContext.working("Adding dependencies from module: " + nextModuleCandidate.getName(), false);
            JavaModule fromModule = (JavaModule)((Object)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(nextModuleCandidate.getName(), !Platform.isCaseSensitive()), JavaModule.class));
            if (fromModule == null) continue;
            for (String efferentModule : nextModuleCandidate.getDependencies()) {
                JavaModule toModule = (JavaModule)((Object)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(efferentModule, !Platform.isCaseSensitive()), JavaModule.class));
                if (toModule == null) continue;
                fromModule.addOutgoingWorkspaceDependency(this.createWorkspaceDependency((IWorkspaceDependencyElement)fromModule, (IWorkspaceDependencyElement)toModule, JavaWorkspaceDependency.DependencyType.MANUAL_DEPENDENCY));
            }
        }
        workspaceExtension.refreshWorkspaceDependencies(modification);
        this.finalizeModuleImport(workerContext, importMode, modification, result);
        return result;
    }

    @Override
    public OperationResult createModulesFromBazel(IWorkerContext workerContext, Set<ImportModuleCandidate> moduleCandidates, IJavaWorkspaceExtension.ModuleImportMode importMode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createModulesFromBazelWorkspace' must not be null";
        assert (moduleCandidates != null && !moduleCandidates.isEmpty()) : "Parameter 'moduleCandidates' of method 'createModulesFromBazelWorkspace' must not be empty";
        if (importMode == IJavaWorkspaceExtension.ModuleImportMode.MODULE_ADDITION) {
            ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).cancelSaveSnapshot();
            ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        }
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        OperationResult result = new OperationResult(importMode.equals((Object)IJavaWorkspaceExtension.ModuleImportMode.SYSTEM_CREATION) ? "Creating system from bazel workspace" : "Importing modules from bazel workspace");
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            workerContext.working("Adding module: " + nextModuleCandidate.getName(), true);
            Module module = null;
            if (nextModuleCandidate.isIncluded()) {
                module = workspaceExtension.createModule((Module.IModuleType)JavaModule.JavaModuleType.MANUAL, nextModuleCandidate.getName(), null, modification);
            } else {
                if (!nextModuleCandidate.isAlreadyInWorkspace()) continue;
                module = (Module)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(nextModuleCandidate.getName(), !Platform.isCaseSensitive()), JavaModule.class);
            }
            assert (module != null) : "'module' of method 'createModulesFromBazelWorkspace' must not be null";
            workerContext.working("Adding root directory paths", true);
            for (ImportRootDirectoryPathCandidate nextRootPathCandidate : nextModuleCandidate.getRootPaths()) {
                if (!nextRootPathCandidate.isIncluded() || nextRootPathCandidate.isAlreadyInWorkspace()) continue;
                if (nextRootPathCandidate.hasSource()) {
                    this.createSourceRootDirectoryPathInternal((JavaModule)module, nextRootPathCandidate.getFile());
                    continue;
                }
                workspaceExtension.createRootDirectoryPathInternal(module, nextRootPathCandidate.getFile(), true);
            }
        }
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            workerContext.working("Adding dependencies from module: " + nextModuleCandidate.getName(), true);
            JavaModule fromModule = (JavaModule)((Object)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(nextModuleCandidate.getName(), !Platform.isCaseSensitive()), JavaModule.class));
            if (fromModule == null) continue;
            for (String efferentModule : nextModuleCandidate.getDependencies()) {
                JavaModule toModule = (JavaModule)((Object)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(efferentModule, !Platform.isCaseSensitive()), JavaModule.class));
                if (toModule == null) continue;
                fromModule.addOutgoingWorkspaceDependency(this.createWorkspaceDependency((IWorkspaceDependencyElement)fromModule, (IWorkspaceDependencyElement)toModule, JavaWorkspaceDependency.DependencyType.MANUAL_DEPENDENCY));
            }
        }
        workspaceExtension.refreshWorkspaceDependencies(modification);
        this.finalizeModuleImport(workerContext, importMode, modification, result);
        return result;
    }

    private void finalizeModuleImport(IWorkerContext workerContext, IJavaWorkspaceExtension.ModuleImportMode mode, EnumSet<Modification> modification, OperationResult result) {
        assert (mode != null) : "Parameter 'mode' of method 'finalizeModuleImport' must not be null";
        if (mode.equals((Object)IJavaWorkspaceExtension.ModuleImportMode.SYSTEM_CREATION)) {
            workerContext.working("Saving system", true);
            result.addMessagesFrom(((ISoftwareSystemController)this.m_softwareSystem.getExtension(ISoftwareSystemController.class)).saveSoftwareSystem());
        } else if (mode.equals((Object)IJavaWorkspaceExtension.ModuleImportMode.MODULE_ADDITION)) {
            this.m_softwareSystem.setNeedsSave(true);
        } else assert (false) : "Unexpected module import mode";
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modification, result);
    }

    @Override
    public boolean isModuleAlreadyInWorkspace(String moduleCandidateName) {
        List modules = ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class);
        for (Module nextModule : modules) {
            if (!moduleCandidateName.equalsIgnoreCase(nextModule.getName())) continue;
            LOGGER.debug("Module already exists: '" + nextModule.getName() + "'");
            return true;
        }
        return false;
    }

    @Override
    public final boolean isRootDirectoryPathAlreadyInWorkspace(TFile rootDirectoryPathCandidate, IJavaWorkspaceProvider.RootDirectoryType rootDirectoryType) {
        assert (rootDirectoryPathCandidate != null) : "Parameter 'rootDirectoryPathCandidate' of method 'isRootDirectoryPathAlreadyInWorkspace' must not be null";
        assert (rootDirectoryType != null) : "Parameter 'rootDirectoryType' of method 'isRootDirectoryPathAlreadyInWorkspace' must not be null";
        List modules = ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class);
        for (Module nextModule : modules) {
            Class clazz = rootDirectoryType == IJavaWorkspaceProvider.RootDirectoryType.CLASS ? JavaClassRootDirectoryPath.class : JavaSourceRootDirectoryPath.class;
            List rootDirectoryPaths = nextModule.getChildren(clazz, false);
            for (RootDirectoryPath nextRootDirectoryPath : rootDirectoryPaths) {
                if (!FileUtility.areEqual((TFile)rootDirectoryPathCandidate, (TFile)nextRootDirectoryPath.getDirectoryFile())) continue;
                LOGGER.debug("Root path: '{}' of type '{}' already present in module: '{}'", new Object[]{rootDirectoryPathCandidate.getName(), rootDirectoryType, nextModule.getName()});
                return true;
            }
        }
        return false;
    }

    @Override
    public final void checkModuleCandidatesForDuplicates(IWorkerContext workerContext, Set<ImportModuleCandidate> moduleCandidates) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'checkModuleCandidatesForDuplicates' must not be null";
        assert (moduleCandidates != null) : "Parameter 'moduleCandidates' of method 'checkModuleCandidatesForDuplicates' must not be null";
        if (moduleCandidates.isEmpty()) {
            return;
        }
        List existingModules = ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class);
        HashSet<String> existingModuleNames = new HashSet<String>();
        HashSet<String> existingJavaSourceRootDirectoryPaths = new HashSet<String>();
        HashSet<String> existingJavaClassRootDirectoryPaths = new HashSet<String>();
        workerContext.working("Collecting info from existing software system", true);
        for (Module nextExistingModule : existingModules) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            existingModuleNames.add(nextExistingModule.getName().toLowerCase());
            List sourceRootDirectoryPaths = nextExistingModule.getChildren(JavaSourceRootDirectoryPath.class, false);
            for (RootDirectoryPath nextSourceRootDirectoryPath : sourceRootDirectoryPaths) {
                String identifyingPath = FileUtility.getIdentifyingPath((TFile)nextSourceRootDirectoryPath.getDirectoryFile());
                existingJavaSourceRootDirectoryPaths.add(identifyingPath);
            }
            List classRootDirectoryPaths = nextExistingModule.getChildren(JavaClassRootDirectoryPath.class, false);
            for (RootDirectoryPath nextClassRootDirectoryPath : classRootDirectoryPaths) {
                String identifyingPath = FileUtility.getIdentifyingPath((TFile)nextClassRootDirectoryPath.getDirectoryFile());
                existingJavaClassRootDirectoryPaths.add(identifyingPath);
            }
        }
        workerContext.working("Checking if candidate names or root paths are already existing", true);
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            nextModuleCandidate.setAlreadyInWorkspace(existingModuleNames.contains(nextModuleCandidate.getName().toLowerCase()));
            for (ImportRootDirectoryPathCandidate nextRootDirectoryPathCandidate : nextModuleCandidate.getRootPaths()) {
                String identifyingPath = FileUtility.getIdentifyingPath((TFile)nextRootDirectoryPathCandidate.getFile());
                if (nextRootDirectoryPathCandidate.hasSource()) {
                    nextRootDirectoryPathCandidate.setAlreadyInWorkspace(existingJavaSourceRootDirectoryPaths.contains(identifyingPath));
                    continue;
                }
                nextRootDirectoryPathCandidate.setAlreadyInWorkspace(existingJavaClassRootDirectoryPaths.contains(identifyingPath));
            }
        }
    }

    public WorkspaceDependency createWorkspaceDependency(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to, JavaWorkspaceDependency.DependencyType type) {
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'createWorkspaceDependency' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createWorkspaceDependency' must not be null";
        JavaManualWorkspaceDependency dependency = null;
        switch (type) {
            case MANUAL_DEPENDENCY: {
                dependency = new JavaManualWorkspaceDependency(from, to);
                dependency.setAdditionalDependencyData(new WorkspaceDependency.AdditionalDependencyData());
                break;
            }
            default: {
                LOGGER.error("Unsupported dependency type {}", (Object)type.getStandardName());
                assert (false) : "Dependency type '" + type.getStandardName() + "' not supported";
                break;
            }
        }
        return dependency;
    }

    public static WorkspaceDependency createWorkspaceDependency(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to, String toId, String toName, JavaWorkspaceDependency.DependencyType type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        assert (from != null) : "Parameter 'from' of method 'createWorkspaceDependency' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'createWorkspaceDependency' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'createWorkspaceDependency' must not be empty";
        assert (type != null) : "Parameter 'type' of method 'createWorkspaceDependency' must not be null";
        assert (dependencyData != null) : "Parameter 'dependencyData' of method 'createWorkspaceDependency' must not be null";
        JavaManualWorkspaceDependency dependency = null;
        IWorkspaceDependencyElement endpoint = to;
        boolean isEndpointCreated = false;
        if (endpoint == null) {
            NamedElement parent = ((NamedElement)from.getUnderlyingObject()).getParent();
            UnresolvedWorkspaceDependencyElement unresolved = Module.addUnresolvedWorkspaceDependencyElement((NamedElement)parent, (String)toName, (String)toId);
            endpoint = unresolved;
            isEndpointCreated = true;
        }
        switch (type) {
            case MANUAL_DEPENDENCY: {
                dependency = new JavaManualWorkspaceDependency(from, endpoint);
                break;
            }
            default: {
                LOGGER.error("Unsupported dependency type {}", (Object)type.getStandardName());
            }
        }
        if (dependency == null) {
            if (isEndpointCreated) {
                ((UnresolvedWorkspaceDependencyElement)endpoint).remove();
            }
        } else {
            dependency.setAdditionalDependencyData(dependencyData);
        }
        return dependency;
    }
}

