/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoFunction;
import java.io.IOException;

public class GoFunctionWithBody
extends GoFunction {
    private int m_numberOfStatements = -1;
    private int m_cyclomaticComplexity = -1;
    private int m_modifiedCyclomaticComplexity = -1;
    private short m_numberOfLogicalOperations = (short)-1;
    private short m_maxNesting = (short)-1;

    public GoFunctionWithBody(NamedElement parent) {
        super(parent);
    }

    public GoFunctionWithBody(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int numberOfParameters) {
        super(msp, parent, name, lineNumber, numberOfParameters);
    }

    public String getImageResourceName() {
        return "Function";
    }

    @IntProperty
    public int getNumberOfStatements() {
        return this.m_numberOfStatements;
    }

    @IntProperty
    public int getCyclomaticComplexity() {
        return this.m_cyclomaticComplexity;
    }

    @IntProperty
    public int getExtendedCyclomaticComplexity() {
        if (this.m_cyclomaticComplexity == -1) {
            return -1;
        }
        if (this.m_numberOfLogicalOperations == -1) {
            return this.m_cyclomaticComplexity;
        }
        return this.m_cyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @IntProperty
    public int getModifiedExtendedCyclomaticComplexity() {
        if (this.m_modifiedCyclomaticComplexity == -1) {
            return -1;
        }
        if (this.m_numberOfLogicalOperations == -1) {
            return this.m_modifiedCyclomaticComplexity;
        }
        return this.m_modifiedCyclomaticComplexity + this.m_numberOfLogicalOperations;
    }

    @IntProperty
    public int getModifiedCyclomaticComplexity() {
        return this.m_modifiedCyclomaticComplexity;
    }

    @IntProperty
    public int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        return 1 + this.m_numberOfStatements;
    }

    @IntProperty
    public int getMaxNesting() {
        return this.m_maxNesting;
    }

    public void setMaxNesting(int maxNesting) {
        this.m_maxNesting = (short)maxNesting;
    }

    public void setNumberOfStatements(int numberOfStatements) {
        this.m_numberOfStatements = numberOfStatements;
    }

    public void setCyclomaticComplexity(int cyclomaticComplexity) {
        this.m_cyclomaticComplexity = cyclomaticComplexity;
    }

    public void setModifiedCyclomaticComplexity(int modifiedCyclomaticComplexity) {
        this.m_modifiedCyclomaticComplexity = modifiedCyclomaticComplexity;
    }

    public void setNumberOfLogicalOperations(int numberOfLogicalOperations) {
        this.m_numberOfLogicalOperations = (short)numberOfLogicalOperations;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfStatements = reader.readInt();
        this.m_cyclomaticComplexity = reader.readInt();
        this.m_modifiedCyclomaticComplexity = reader.readInt();
        this.m_numberOfLogicalOperations = (short)reader.readInt();
        this.m_maxNesting = reader.readShort();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfStatements);
        writer.writeInt(this.m_cyclomaticComplexity);
        writer.writeInt(this.m_modifiedCyclomaticComplexity);
        writer.writeInt((int)this.m_numberOfLogicalOperations);
        writer.writeShort(this.m_maxNesting);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGoFunctionWithBody(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitGoFunctionWithBody(GoFunctionWithBody var1);
    }
}

