/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.settings;

import com.hello2morrow.sonargraph.foundation.utilities.PathReader;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GoLocator {
    private static final Logger LOGGER;
    private static List<String> PATH;
    private static String GO;
    private static String GO_EXE;

    static {
        int n;
        String[] extraLocations;
        LOGGER = LoggerFactory.getLogger(GoLocator.class);
        PATH = new ArrayList<String>();
        if (Platform.isWindows()) {
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null || programFiles.length() == 0) {
                programFiles = "C:\\Program Files";
            }
            GO = "go.exe";
            extraLocations = new String[]{programFiles + "\\go\\bin"};
        } else if (Platform.isMac()) {
            GO = "go";
            extraLocations = new String[]{"/usr/local/bin", "/opt/homebrew/bin"};
        } else {
            GO = "go";
            extraLocations = new String[]{"/usr/local/bin", "/usr/bin"};
        }
        String path = PathReader.readPathFromEnvironment();
        if (path != null) {
            String[] dirs;
            String[] stringArray = dirs = path.split(File.pathSeparator);
            int n2 = dirs.length;
            n = 0;
            while (n < n2) {
                String dir = stringArray[n];
                PATH.add(dir);
                ++n;
            }
        }
        String[] stringArray = extraLocations;
        n = extraLocations.length;
        int n3 = 0;
        while (n3 < n) {
            File dirFile;
            String dir = stringArray[n3];
            if (!PATH.contains(dir) && (dirFile = new File(dir)).isDirectory()) {
                PATH.add(dir);
            }
            ++n3;
        }
    }

    public static String locateGoExecutable() {
        TFile goExe = null;
        if (GO_EXE == null) {
            for (String dir : PATH) {
                goExe = new TFile(dir, GO);
                if (!goExe.exists() || !goExe.canExecute()) continue;
                GO_EXE = goExe.getNormalizedAbsolutePath();
                LOGGER.info("Located go executable at: " + GO_EXE);
                break;
            }
        }
        if (GO_EXE == null) {
            LOGGER.error("Could not locate go in path " + PATH.toString());
        }
        return GO_EXE;
    }
}

