/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoFunctionWithBody;
import java.io.IOException;

public final class GoMethod
extends GoFunctionWithBody
implements IRefactorable {
    private String m_receiverType;

    public GoMethod(NamedElement parent) {
        super(parent);
    }

    public GoMethod(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int numberOfParameters, String receiverType) {
        super(msp, parent, name, lineNumber, numberOfParameters);
        this.m_receiverType = receiverType;
    }

    @Override
    public String getImageResourceName() {
        return "GoMethod";
    }

    public String getReceiverType() {
        return this.m_receiverType;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_receiverType = reader.readString();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_receiverType);
    }

    @Override
    public String getPresentationName(boolean shortName) {
        StringBuilder sb = new StringBuilder();
        if (!shortName && this.getParent() instanceof ProgrammingElement) {
            sb.append(this.getParent().getPresentationName(shortName)).append('.');
        }
        sb.append(this.getShortName());
        if (this.m_receiverType != null && !this.m_receiverType.isEmpty()) {
            sb.append('(').append(this.m_receiverType).append(')');
        }
        if (this.getTypeParameters().size() > 0) {
            sb.append('[').append(Joiner.join(this.getTypeParameters())).append(']');
        }
        sb.append('(').append(Joiner.join(this.getArgumentTypes())).append(')');
        if (this.getReturnTypes().size() > 0) {
            if (this.getReturnTypes().size() > 1) {
                sb.append('(').append(Joiner.join(this.getReturnTypes())).append(')');
            } else {
                sb.append(' ').append(this.getReturnTypes().get(0));
            }
        }
        return sb.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGoMethod(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitGoMethod(GoMethod var1);
    }
}

