/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericWorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser.Accessor;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser.GoParser;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoMessageCause;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoSourceFile;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoConstant;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoDependency;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoEmbeddedElement;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoFunction;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoInterface;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoMethod;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoStruct;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoTypeAlias;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoVariable;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoExternal;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoExternalModule;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;

final class ModelBuilder {
    private final IModelServiceProvider m_softwareSystem;
    private final GoModule m_module;
    private final IAddedOrChangedSourceFileProcessor m_processor;
    private final GoExternal m_external;
    private final Map<Integer, ProgrammingElement> m_peMap = new THashMap();
    private final List<DependencyProcessor> m_processors = new ArrayList<DependencyProcessor>(1024);

    ModelBuilder(GoModule module, IAddedOrChangedSourceFileProcessor processor) {
        assert (module != null);
        this.m_module = module;
        this.m_softwareSystem = (IModelServiceProvider)module.getParent(SoftwareSystem.class, new Class[0]);
        this.m_processor = processor;
        this.m_external = new GoExternal(null);
    }

    OperationResult buildModel(String goExeDir) {
        GoParser parser = new GoParser();
        RootDirectoryPath rootDir = (RootDirectoryPath)this.m_module.getUniqueExistingChild(RootDirectoryPath.class);
        OperationResultWithOutcome<JSONArray> result = parser.run((File)rootDir.getDirectoryFile(), goExeDir);
        if (result.isFailure()) {
            return result;
        }
        JSONArray module = (JSONArray)result.getOutcome();
        String name = Accessor.getAttribute(module, Accessor.FieldName.NAME, String.class);
        String pathName = Accessor.getAttribute(module, Accessor.FieldName.PATH, String.class);
        JSONArray packages = Accessor.getAttribute(module, Accessor.FieldName.PACKAGES, JSONArray.class);
        JSONArray importedModules = Accessor.getAttribute(module, Accessor.FieldName.IMPORTED_MODULES, JSONArray.class);
        assert (this.m_module.getName().equals(name));
        assert (rootDir.getDirectoryFile().getPath().equals(pathName));
        try {
            for (Object pkgObj : packages) {
                JSONArray pkg = (JSONArray)pkgObj;
                this.processPackage(rootDir, pkg, name);
            }
            for (Object extModuleObj : importedModules) {
                JSONArray extModule = (JSONArray)extModuleObj;
                String modName = Accessor.getAttribute(extModule, Accessor.FieldName.NAME, String.class);
                GoExternalModule externalModule = new GoExternalModule((NamedElement)this.m_external, modName.isEmpty() ? "go-stdlib" : modName);
                JSONArray extPackages = Accessor.getAttribute(extModule, Accessor.FieldName.PACKAGES, JSONArray.class);
                this.m_external.addChild((NamedElement)externalModule);
                for (Object ep : extPackages) {
                    JSONArray extPackage = (JSONArray)ep;
                    this.processExternalPackage(externalModule, extPackage);
                }
                if (!externalModule.hasChildren()) continue;
                GenericWorkspaceDependency dep = new GenericWorkspaceDependency((IWorkspaceDependencyElement)this.m_module, (IWorkspaceDependencyElement)externalModule, (WorkspaceDependency.IWorkspaceDependencyType)GenericWorkspaceDependency.GenericWorkspaceDependencyType.GENERATED_WORKSPACE_DEPENDENCY);
                this.m_module.addOutgoingWorkspaceDependency((WorkspaceDependency)dep);
            }
            this.m_processors.forEach(p -> p.run());
        }
        catch (Throwable ex) {
            result.addError((OperationResult.IMessageCause)GoMessageCause.INTERNAL_ERROR, ex);
        }
        return result;
    }

    private void processExternalPackage(GoExternalModule parent, JSONArray extPackage) {
        String pkgPath = Accessor.getAttribute(extPackage, Accessor.FieldName.PKG_PATH, String.class);
        String pkgName = Accessor.getAttribute(extPackage, Accessor.FieldName.NAME, String.class);
        if (pkgPath.startsWith(parent.getName()) && (pkgPath = pkgPath.substring(parent.getName().length())).startsWith("/")) {
            pkgPath = pkgPath.substring(1);
        }
        Object currentParent = parent;
        if (!pkgPath.isBlank()) {
            String[] pathComponents = pkgPath.split("\\/");
            StringBuilder currentPath = new StringBuilder();
            String[] stringArray = pathComponents;
            int n = pathComponents.length;
            int n2 = 0;
            while (n2 < n) {
                String pathComponent = stringArray[n2];
                GoDirectoryFragment extFrag = (GoDirectoryFragment)((Object)currentParent.getFirstChild(ef -> ef.getShortName().equals(pathComponent), GoDirectoryFragment.class));
                if (currentPath.length() > 0) {
                    currentPath.append('/');
                }
                currentPath.append(pathComponent);
                if (extFrag == null) {
                    extFrag = new GoDirectoryFragment(this.m_softwareSystem, (NamedElement)currentParent, pathComponent);
                    currentParent.addChild((NamedElement)extFrag);
                }
                currentParent = extFrag;
                ++n2;
            }
        }
        JSONArray files = Accessor.getAttribute(extPackage, Accessor.FieldName.FILES, JSONArray.class);
        for (Object sf : files) {
            JSONArray jsonSource = (JSONArray)sf;
            String path = Accessor.getAttribute(jsonSource, Accessor.FieldName.PATH, String.class);
            JSONArray children = Accessor.getAttribute(jsonSource, Accessor.FieldName.CHILDREN, JSONArray.class);
            GoSourceFile src = new GoSourceFile(this.m_softwareSystem, (NamedElement)currentParent, new TFile(path));
            currentParent.addChild((NamedElement)src);
            NamedElement pkg = this.createPackage(src, pkgName, pkgPath, parent.getName());
            for (Object child : children) {
                this.processChild(pkg, (JSONArray)child);
            }
        }
    }

    private void processPackage(RootDirectoryPath root, JSONArray pkg, String moduleName) {
        String name = Accessor.getAttribute(pkg, Accessor.FieldName.NAME, String.class);
        String path = Accessor.getAttribute(pkg, Accessor.FieldName.PATH, String.class);
        String pkgPath = Accessor.getAttribute(pkg, Accessor.FieldName.PKG_PATH, String.class);
        JSONArray sources = Accessor.getAttribute(pkg, Accessor.FieldName.FILES, JSONArray.class);
        IDirectoryPath parentFragment = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)root, (String)path, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new GoDirectoryFragment(msp, parent, name);
            }
        });
        for (Object srcObj : sources) {
            JSONArray jsonSrc = (JSONArray)srcObj;
            String sourceName = Accessor.getAttribute(jsonSrc, Accessor.FieldName.PATH, String.class);
            JSONArray children = Accessor.getAttribute(jsonSrc, Accessor.FieldName.CHILDREN, JSONArray.class);
            TFile srcFile = new TFile((File)parentFragment.getFile(), sourceName);
            GoSourceFile src = new GoSourceFile(this.m_softwareSystem, parentFragment.getNamedElement(), srcFile);
            parentFragment.getNamedElement().addChild((NamedElement)src);
            this.m_processor.processAddedOrChangedSourceFile((SourceFile)src);
            NamedElement parent = this.createPackage(src, name, pkgPath, moduleName);
            for (Object child : children) {
                this.processChild(parent, (JSONArray)child);
            }
        }
    }

    private NamedElement createPackage(GoSourceFile src, String name, String pkgPath, String moduleName) {
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        if (((String)pkgPath).startsWith(moduleName) && ((String)(pkgPath = ((String)pkgPath).substring(moduleName.length()))).startsWith("/")) {
            pkgPath = ((String)pkgPath).substring(1);
        }
        pkgPath = (pos = ((String)pkgPath).lastIndexOf(47)) > 0 ? ((String)pkgPath).substring(0, pos + 1) + name : name;
        String[] pkgComponents = ((String)pkgPath).split("\\/");
        GoSourceFile parent = src;
        assert (pkgComponents.length >= 1);
        String[] stringArray = pkgComponents;
        int n = pkgComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgName = stringArray[n2];
            GenericPackage pkg = new GenericPackage(this.m_softwareSystem, (NamedElement)parent, pkgName);
            parent.addChild((NamedElement)pkg);
            parent = pkg;
            ++n2;
        }
        return parent;
    }

    private void processChild(NamedElement parent, JSONArray element) {
        String elementType = (String)element.get(0);
        Long id = Accessor.getAttribute(element, Accessor.FieldName.ID, Long.class);
        String name = Accessor.getAttribute(element, Accessor.FieldName.NAME, String.class);
        Long line = Accessor.getAttribute(element, Accessor.FieldName.LINE, Long.class);
        JSONArray dependencies = Accessor.getAttribute(element, Accessor.FieldName.DEPENDENCIES, JSONArray.class);
        JSONArray typeParams = null;
        IRefactorable pe = null;
        String type = null;
        Long numParams = null;
        GoFunction func = null;
        switch (elementType) {
            case "Struct": {
                typeParams = Accessor.getAttribute(element, Accessor.FieldName.TYPE_PARAMETERS, JSONArray.class);
                pe = new GoStruct(this.m_softwareSystem, parent, name, line.intValue(), this.convertToStringList(typeParams));
                break;
            }
            case "Interface": {
                typeParams = Accessor.getAttribute(element, Accessor.FieldName.TYPE_PARAMETERS, JSONArray.class);
                pe = new GoInterface(this.m_softwareSystem, parent, name, line.intValue(), this.convertToStringList(typeParams));
                break;
            }
            case "TypeAlias": {
                type = Accessor.getAttribute(element, Accessor.FieldName.TYPE, String.class);
                typeParams = Accessor.getAttribute(element, Accessor.FieldName.TYPE_PARAMETERS, JSONArray.class);
                pe = new GoTypeAlias(this.m_softwareSystem, parent, name, line.intValue(), type, this.convertToStringList(typeParams));
                break;
            }
            case "Constant": {
                pe = new GoConstant(this.m_softwareSystem, parent, name, line.intValue());
                break;
            }
            case "Variable": {
                if (name.equals("_")) break;
                type = Accessor.getAttribute(element, Accessor.FieldName.TYPE, String.class);
                pe = new GoVariable(this.m_softwareSystem, parent, name, line.intValue(), type);
                break;
            }
            case "Function": {
                numParams = Accessor.getAttribute(element, Accessor.FieldName.NUMBER_OF_PARAMETERS, Long.class);
                String receiverType = Accessor.getAttribute(element, Accessor.FieldName.RECEIVER_TYPE, String.class);
                func = receiverType != null && receiverType.length() > 0 ? new GoMethod(this.m_softwareSystem, parent, name, line.intValue(), numParams.intValue(), receiverType) : new GoFunction(this.m_softwareSystem, parent, name, line.intValue(), numParams.intValue());
                this.processSignature(element, func);
                pe = func;
                break;
            }
            case "FunctionWithBody": {
                numParams = Accessor.getAttribute(element, Accessor.FieldName.NUMBER_OF_PARAMETERS, Long.class);
                func = this.processFunction(element, parent, name, line.intValue(), numParams.intValue());
                this.processSignature(element, func);
                pe = func;
                break;
            }
            case "EmbeddedElement": {
                pe = new GoEmbeddedElement(this.m_softwareSystem, parent, name, line.intValue());
                break;
            }
            default: {
                assert (false) : "Unexpected element type: " + elementType;
                break;
            }
        }
        if (pe != null) {
            parent.addChild(pe);
            this.m_peMap.put(id.intValue(), (ProgrammingElement)pe);
            JSONArray children = Accessor.getAttribute(element, Accessor.FieldName.CHILDREN, JSONArray.class);
            if (children != null) {
                for (Object child : children) {
                    this.processChild((NamedElement)pe, (JSONArray)child);
                }
            }
            if (dependencies != null) {
                for (Object aDep : dependencies) {
                    JSONArray jsonDep = (JSONArray)aDep;
                    String depType = (String)jsonDep.get(0);
                    Long targetId = (Long)jsonDep.get(1);
                    Long depLine = (Long)jsonDep.get(2);
                    ProgrammingElement target = this.m_peMap.get(targetId.intValue());
                    if (target != null) {
                        GoDependency dep = new GoDependency((ProgrammingElement)pe, target, depType, depLine.intValue());
                        pe.addDependency((ParserDependency)dep);
                        continue;
                    }
                    DependencyProcessor processor = new DependencyProcessor((ProgrammingElement)pe, depType, targetId.intValue(), depLine.intValue());
                    this.m_processors.add(processor);
                }
            }
        }
    }

    private List<String> convertToStringList(JSONArray array) {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(array.size());
        array.forEach(e -> {
            String val = (String)e;
            if (!val.isBlank()) {
                result.add(val);
            }
        });
        return result;
    }

    private void processSignature(JSONArray element, GoFunction func) {
        JSONArray paramTypes = Accessor.getAttribute(element, Accessor.FieldName.PARAMETERS, JSONArray.class);
        JSONArray returnTypes = Accessor.getAttribute(element, Accessor.FieldName.RETURN_TYPES, JSONArray.class);
        JSONArray typeParams = Accessor.getAttribute(element, Accessor.FieldName.TYPE_PARAMETERS, JSONArray.class);
        func.setParameterTypes(this.convertToStringList(paramTypes));
        func.setReturnTypes(this.convertToStringList(returnTypes));
        func.setTypeParameters(this.convertToStringList(typeParams));
    }

    private GoFunction processFunction(JSONArray element, NamedElement parent, String name, int line, int numParams) {
        int numberOfStatements = Accessor.getAttribute(element, Accessor.FieldName.NUMBER_OF_STATEMENTS, Long.class).intValue();
        int cyclomaticComplexity = Accessor.getAttribute(element, Accessor.FieldName.CYCLOMATIC_COMPLEXITY, Long.class).intValue();
        int modifiedCyclomaticComplexity = Accessor.getAttribute(element, Accessor.FieldName.MODIFIED_CYCLOMATIC_COMPLEXITY, Long.class).intValue();
        int numberOfLogicalOperations = Accessor.getAttribute(element, Accessor.FieldName.LOGICAL_AND_OR_OPERATIONS, Long.class).intValue();
        int maxNesting = Accessor.getAttribute(element, Accessor.FieldName.MAX_INDENTATION_LEVEL, Long.class).intValue();
        String receiverType = Accessor.getAttribute(element, Accessor.FieldName.RECEIVER_TYPE, String.class);
        GoFunctionWithBody result = receiverType != null && receiverType.length() > 0 ? new GoMethod(this.m_softwareSystem, parent, name, line, numParams, receiverType) : new GoFunctionWithBody(this.m_softwareSystem, parent, name, line, numParams);
        result.setCyclomaticComplexity(cyclomaticComplexity);
        result.setNumberOfStatements(numberOfStatements);
        result.setModifiedCyclomaticComplexity(modifiedCyclomaticComplexity);
        result.setNumberOfLogicalOperations(numberOfLogicalOperations);
        result.setMaxNesting(maxNesting);
        return result;
    }

    GoExternal getExternal() {
        return this.m_external;
    }

    private class DependencyProcessor
    implements Runnable {
        private final ProgrammingElement m_from;
        private final String m_type;
        private final int m_targetId;
        private final int m_line;

        public DependencyProcessor(ProgrammingElement from, String type, int targetId, int line) {
            this.m_from = from;
            this.m_type = type;
            this.m_targetId = targetId;
            this.m_line = line;
        }

        @Override
        public void run() {
            ProgrammingElement target = ModelBuilder.this.m_peMap.get(this.m_targetId);
            assert (target != null);
            GoDependency dep = new GoDependency(this.m_from, target, this.m_type, this.m_line);
            this.m_from.addDependency((ParserDependency)dep);
        }
    }
}

