/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.progress.ProgressDaemon;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser.ModelBuilder;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoSourceFile;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoExternal;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoExternalModule;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModule;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoRefreshJob
implements IAddedOrChangedSourceFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoRefreshJob.class);
    private static String LAST_REFRESH_TIME = "lastRefreshTime";
    private static int MAX_PARSER_PROCESSES = 4;
    private static int MAX_SOURCE_PROCESSING_THREADS = 6;
    private static int DEFAULT_REFRESH_TIME = 30000;
    private final String m_goExeDir;
    private final IAddedOrChangedSourceFileProcessor m_processor;
    private final ExecutorService m_sourceProcessorService;
    private final SoftwareSystem m_softwareSystem;
    private final Map<String, GoModule> m_moduleMap = new THashMap();
    private long m_expectedRefreshTime = DEFAULT_REFRESH_TIME;
    private ExecutorService m_parsingService;

    public GoRefreshJob(String goExeDir, IAddedOrChangedSourceFileProcessor processor, SoftwareSystem softwareSystem) {
        this.m_goExeDir = goExeDir;
        this.m_processor = processor;
        this.m_sourceProcessorService = Executors.newFixedThreadPool(MAX_SOURCE_PROCESSING_THREADS);
        this.m_softwareSystem = softwareSystem;
        String lastRefreshTime = softwareSystem.getSystemProperty(LAST_REFRESH_TIME);
        if (lastRefreshTime != null) {
            try {
                this.m_expectedRefreshTime = Long.valueOf(lastRefreshTime);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void processAddedOrChangedSourceFile(SourceFile sourceFile) {
        this.m_sourceProcessorService.submit(() -> this.m_processor.processAddedOrChangedSourceFile(sourceFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseModule(GoModule module, GoExternal external, OperationResult globalResult) {
        RootDirectoryPath root = (RootDirectoryPath)module.getUniqueExistingChild(RootDirectoryPath.class);
        root.forgetChildren(true);
        module.removeOutgoingWorkspaceDependencies();
        ModelBuilder builder = new ModelBuilder(module, this);
        OperationResult result = builder.buildModel(this.m_goExeDir);
        GoExternal moduleExternal = builder.getExternal();
        for (GoExternalModule extModule : moduleExternal.getChildren(GoExternalModule.class)) {
            if (!extModule.hasChildren()) continue;
            GoModule mod = this.m_moduleMap.get(extModule.getName());
            if (mod != null) {
                this.mergeIntoModule(module, extModule, mod);
                continue;
            }
            this.mergeIntoExternal(module, extModule, external);
        }
        GoRefreshJob goRefreshJob = this;
        synchronized (goRefreshJob) {
            globalResult.addMessagesFrom(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeIntoModule(GoModule srcModule, GoExternalModule extModule, GoModule targetModule) {
        GoModule goModule = targetModule;
        synchronized (goModule) {
            this.merge((NamedElement)extModule, (NamedElement)targetModule, false);
            srcModule.redirectWorkspaceDependencyTo(extModule, (IWorkspaceDependencyElement)targetModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeIntoExternal(GoModule srcModule, GoExternalModule module, GoExternal external) {
        GoExternal goExternal = external;
        synchronized (goExternal) {
            GoExternalModule target = (GoExternalModule)((Object)external.getFirstChild(em -> em.getShortName().equals(module.getShortName()), GoExternalModule.class));
            if (target == null) {
                module.changeParent((NamedElement)external, true);
            } else {
                this.merge((NamedElement)module, (NamedElement)target, true);
                srcModule.redirectWorkspaceDependencyTo(module, target);
            }
        }
    }

    private void merge(NamedElement from, NamedElement target, boolean isExternal) {
        for (GoDirectoryFragment dir : from.getChildren(GoDirectoryFragment.class)) {
            GoDirectoryFragment targetDir = (GoDirectoryFragment)((Object)target.getFirstChild(c -> c.getShortName().equals(dir.getShortName()), GoDirectoryFragment.class));
            if (targetDir == null) {
                if (isExternal) {
                    dir.changeParent(target, true);
                    continue;
                }
                LOGGER.error(String.format("Cannot locate directory fragment '%s' in internal target module", dir.getName()));
                dir.remove();
                continue;
            }
            this.merge((NamedElement)dir, (NamedElement)targetDir, isExternal);
        }
        for (GoSourceFile src : from.getChildren(GoSourceFile.class)) {
            GoSourceFile targetSrc = (GoSourceFile)((Object)target.getFirstChild(c -> c.getShortName().equals(src.getShortName()), GoSourceFile.class));
            if (targetSrc == null) {
                if (isExternal) {
                    src.changeParent(target, true);
                    continue;
                }
                LOGGER.error(String.format("Cannot locate source file '%s' in internal target module", src.getName()));
                src.remove();
                continue;
            }
            this.mergeProgrammingElements((NamedElement)src, (NamedElement)targetSrc, isExternal);
        }
    }

    private void mergeProgrammingElements(NamedElement from, NamedElement target, boolean isExternal) {
        for (NamedElement child : from.getChildren(NamedElement.class)) {
            NamedElement targetPe = (NamedElement)target.getFirstChild(c -> c.getPresentationName(false).equals(child.getPresentationName(false)), NamedElement.class);
            if (targetPe == null) {
                if (isExternal) {
                    child.changeParent(target, true);
                    continue;
                }
                LOGGER.error(String.format("Cannot locate element '%s' in internal target module", child.getPresentationName(false)));
                child.remove();
                continue;
            }
            if (child instanceof ProgrammingElement) {
                ProgrammingElement pe = (ProgrammingElement)child;
                pe.transferIncomingDependenciesTo((ProgrammingElement)targetPe);
                this.mergeProgrammingElements(child, targetPe, isExternal);
                continue;
            }
            this.mergeProgrammingElements(child, targetPe, isExternal);
        }
    }

    public boolean refreshSystem(IWorkerContext workerContext, OperationResult result) {
        long startingTime = System.currentTimeMillis();
        Workspace ws = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        List modules = ws.getChildren(GoModule.class);
        workerContext.beginSubTask("Parsing Go modules");
        ProgressDaemon pd = new ProgressDaemon(workerContext, (double)this.m_expectedRefreshTime);
        GoExternal external = (GoExternal)((Object)ws.getUniqueExistingChild(GoExternal.class));
        external.forgetChildren(true);
        this.m_parsingService = Executors.newFixedThreadPool(Math.min(MAX_PARSER_PROCESSES, modules.size()));
        modules.forEach(m -> {
            GoModule goModule = this.m_moduleMap.put(m.getName(), (GoModule)((Object)m));
        });
        modules.forEach(m -> {
            Future<?> future = this.m_parsingService.submit(() -> this.parseModule((GoModule)((Object)m), external, result));
        });
        this.m_parsingService.shutdown();
        try {
            this.m_parsingService.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ws.accept((NamedElement.INamedElementVisitor)new ExternalCleanupVisitor());
        this.m_sourceProcessorService.shutdown();
        try {
            this.m_sourceProcessorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        pd.finish();
        workerContext.endSubTask();
        long totalTime = System.currentTimeMillis() - startingTime;
        this.m_softwareSystem.setSystemProperty(LAST_REFRESH_TIME, Long.toString(totalTime));
        return result.isSuccess();
    }

    private class ExternalCleanupVisitor
    extends NamedElementVisitor
    implements GoModule.IVisitor,
    ProgrammingElement.IVisitor,
    GoSourceFile.IVisitor {
        private ExternalCleanupVisitor() {
            super(true);
        }

        public void visitProgrammingElement(ProgrammingElement element) {
            this.visitChildrenOf((NamedElement)element);
            if (!element.hasChildren() && !element.hasIncomingDependencies()) {
                element.remove();
            }
        }

        @Override
        public void visitGoSourceFile(GoSourceFile element) {
            this.visitChildrenOf((NamedElement)element);
            if (!element.hasChildren()) {
                element.remove();
            }
        }

        @Override
        public void visitGoModule(GoModule element) {
        }
    }
}

