/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.ICloneable;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoLanguage;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoSourceFile;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModule;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

final class GoRefactoringAdapter
extends LanguageProviderRefactoringAdapter {
    private final Set<String> m_keyWords;

    GoRefactoringAdapter(Set<String> keyWords) {
        assert (keyWords != null) : "Parameter 'keyWords' of method 'GoRefactoringAdapter' must not be null";
        this.m_keyWords = keyWords;
    }

    protected Language getLanguage() {
        return GoLanguage.INSTANCE;
    }

    protected Class<? extends Module> getModuleClass() {
        return GoModule.class;
    }

    protected Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> getRefactorables() {
        LinkedHashMap<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorables = new LinkedHashMap<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>>(2);
        refactorables.put(GoSourceFile.class, new LinkedHashSet<Class>(Arrays.asList(GenericRootDirectory.class, GoDirectoryFragment.class)));
        refactorables.put(GoDirectoryFragment.class, new LinkedHashSet<Class>(Arrays.asList(GoDirectoryFragment.class, GenericRootDirectory.class)));
        return refactorables;
    }

    protected NamespaceFragment createNamespaceFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        assert (msp != null) : "Parameter 'msp' of method 'createNamespaceFragment' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createNamespaceFragment' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createNamespaceFragment' must not be empty";
        return new GenericPackage(msp, parent, shortName);
    }

    protected DirectoryFragment createDirectoryFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        assert (msp != null) : "Parameter 'msp' of method 'createDirectoryFragment' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createDirectoryFragment' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createDirectoryFragment' must not be empty";
        return new GoDirectoryFragment(msp, parent, shortName);
    }

    private boolean isValidDirectoryName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isValidDirectoryName' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'identifier' of method 'isValidDirectoryName' must not be empty";
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (this.m_keyWords.contains(name)) {
                return false;
            }
            if (FileUtility.isValidName((String)nextToken)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCompilationUnitName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isValidCompilationUnitName' must not be empty";
        if (this.m_keyWords.contains(name)) {
            return false;
        }
        return FileUtility.isValidName((String)name);
    }

    protected ITextValidator getRenameRefactoringValidator(final NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getRenameRefactoringValidator' must not be null";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (newInputString == null || newInputString.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (result.inputModified()) {
                    if (namedElement instanceof GoSourceFile) {
                        if (!GoRefactoringAdapter.this.isValidCompilationUnitName(newInputString)) {
                            result.addError("Source file name '" + newInputString + "' not valid");
                            return result;
                        }
                    } else if (namedElement instanceof GoDirectoryFragment) {
                        if (!FileUtility.isValidName((String)newInputString)) {
                            result.addError("Directory name '" + newInputString + "' not valid");
                            return result;
                        }
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled element: " + String.valueOf(namedElement)));
                    }
                }
                return result;
            }
        };
    }

    protected ITextValidator getMoveToParentNameRefactoringValidator(List<NamedElement> namedElements, MoveRenameRefactoringElementType elementType) {
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'getMoveToParentNameRefactoringValidator' must not be empty";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (newInputString == null) {
                    result.addError("Must not be 'null'");
                } else if (!newInputString.isEmpty() && !GoRefactoringAdapter.this.isValidDirectoryName(newInputString)) {
                    result.addError("Package name '" + newInputString + "' not valid");
                }
                return result;
            }
        };
    }

    private GoDirectoryFragment renameDirectory(GoDirectoryFragment directory, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (directory != null) : "Parameter 'directory' of method 'renameDirectory' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameDirectory' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameDirectory' must not be null";
        GoDirectoryFragment modifiableVersionOfPackageFragmentToBeRenamed = (GoDirectoryFragment)refactoringStateHandler.getModifiableVersionOf((ICloneable)directory);
        modifiableVersionOfPackageFragmentToBeRenamed.setShortName(newName);
        return modifiableVersionOfPackageFragmentToBeRenamed;
    }

    protected Set<NamedElement> rename(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, String newName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'rename' must not be null";
        assert (elementType != null) : "Parameter 'refactoringElementType' of method 'rename' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'rename' must not be empty";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'rename' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'rename' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'rename' must not be null";
        this.checkCollisions(namedElements, statusInfo, null, newName, elementType, null);
        if (statusInfo.getStatus() == StatusInfo.Status.NONE || statusInfo.getStatus().isApplicable()) {
            Object cache = null;
            THashSet collidingInfo = new THashSet();
            for (NamedElement nextNamedElement : namedElements) {
                NamedElement nextParent = nextNamedElement.getParent();
                assert (nextParent != null) : "'nextParent' of method 'rename' must not be null";
                cache = this.checkAdditionalCollisions(elementType, Collections.singletonList(nextNamedElement), (RootDirectoryPath)nextNamedElement.getParent(GenericRootDirectory.class, new Class[0]), nextParent instanceof GoDirectoryFragment ? nextParent.getName() : "", newName, (Set)collidingInfo, cache);
            }
            collidingInfo.forEach(i -> statusInfo.addCollisionInfo(i));
        }
        if (statusInfo.getStatus() == StatusInfo.Status.NONE || statusInfo.getStatus().isApplicable()) {
            switch (elementType) {
                case ELEMENT: {
                    assert (false) : "Unexpected refactoring element type: " + String.valueOf(elementType);
                    break;
                }
                case COMPONENT: {
                    for (NamedElement nextNamedElement : namedElements) {
                        assert (nextNamedElement instanceof GoSourceFile) : "Unexpected class in method 'rename': " + String.valueOf(nextNamedElement);
                        GoSourceFile nextCompilationUnit = (GoSourceFile)nextNamedElement;
                        this.renameCompilationUnit(nextCompilationUnit, newName, refactoringStateHandler);
                    }
                    break;
                }
                case DIRECTORY: {
                    for (NamedElement nextNamedElement : namedElements) {
                        assert (nextNamedElement != null && nextNamedElement instanceof GoDirectoryFragment) : "Unexpected class in method 'rename': " + String.valueOf(nextNamedElement);
                        GoDirectoryFragment nextPackage = (GoDirectoryFragment)nextNamedElement;
                        NamedElement parentOfNextPackage = nextPackage.getParent();
                        GoDirectoryFragment existing = (GoDirectoryFragment)this.findByRelevantRenameName(newName, parentOfNextPackage, GoDirectoryFragment.class);
                        if (existing != null) {
                            this.moveChildrenTo((PhysicalRecursiveElement)nextPackage, (ICloneable)existing, refactoringStateHandler, GoDirectoryFragment.class);
                            continue;
                        }
                        this.renameDirectory(nextPackage, newName, refactoringStateHandler);
                    }
                    break;
                }
                case NAMESPACE: {
                    assert (false) : "Unexpected refactoring element type: " + String.valueOf(elementType);
                    break;
                }
                default: {
                    assert (false) : "Unhandled 'refactoringElementType' in 'rename':" + String.valueOf(elementType);
                    break;
                }
            }
        }
        return Collections.emptySet();
    }

    private GoSourceFile renameCompilationUnit(GoSourceFile compilationUnit, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (compilationUnit != null) : "Parameter 'compilationUnit' of method 'renameCompilationUnit' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameCompilationUnit' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameCompilationUnit' must not be null";
        String path = compilationUnit.getPath();
        int pathSepPos = path.lastIndexOf(47);
        assert (pathSepPos != -1) : "Path separator not found: " + path;
        int extensionPos = path.lastIndexOf(46);
        assert (extensionPos > pathSepPos) : "Invalid path: " + path;
        GoSourceFile modifiableVersionOfToBeRenamed = (GoSourceFile)refactoringStateHandler.getModifiableVersionOf((ICloneable)compilationUnit);
        modifiableVersionOfToBeRenamed.setPath(path.substring(0, pathSepPos + 1) + newName + path.substring(extensionPos));
        return modifiableVersionOfToBeRenamed;
    }

    protected Set<NamedElement> moveRename(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, RootDirectoryPath targetRootDirectory, String moveToParentName, String newName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'moveRename' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'moveRename' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'moveRename' must not be empty";
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'moveRename' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'moveRename' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'moveRename' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveRename' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'moveRename' must not be null";
        switch (elementType) {
            case ELEMENT: {
                assert (false) : "Unexpected refactoring element type: " + String.valueOf(elementType);
                break;
            }
            case COMPONENT: {
                NamedElement targetRootDirectoryOrPackage = this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                this.checkCollisions(namedElements, statusInfo, targetRootDirectoryOrPackage, newName, elementType, targetRootDirectoryOrPackage);
                if (statusInfo.getStatus() == StatusInfo.Status.NONE || statusInfo.getStatus().isApplicable()) {
                    THashSet collidingInfo = new THashSet();
                    this.checkAdditionalCollisions(elementType, namedElements, targetRootDirectory, moveToParentName, newName, (Set)collidingInfo, null);
                    collidingInfo.forEach(i -> statusInfo.addCollisionInfo(i));
                }
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof GoSourceFile) : "Unexpected class in method 'move': " + String.valueOf(next);
                    GoSourceFile nextCompilationUnit = (GoSourceFile)next;
                    nextCompilationUnit = this.renameCompilationUnit(nextCompilationUnit, newName, refactoringStateHandler);
                    ICloneable nextCloneable = (ICloneable)nextCompilationUnit.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextCompilationUnit, (ICloneable)targetRootDirectoryOrPackage);
                }
                break;
            }
            case DIRECTORY: {
                IRefactoringTarget target = this.getMoveToParent(targetRootDirectory, moveToParentName);
                this.checkCollisions(namedElements, statusInfo, target != null ? target.getNamedElement() : null, newName, elementType, target != null ? target.getNamedElement() : null);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof GoDirectoryFragment) : "Unexpected class in method 'moveRename': " + String.valueOf(next);
                    GoDirectoryFragment nextDirectory = (GoDirectoryFragment)next;
                    GoDirectoryFragment existing = null;
                    if (target != null) {
                        existing = (GoDirectoryFragment)this.findByRelevantRenameName(newName, target.getNamedElement(), GoDirectoryFragment.class);
                    }
                    if (existing != null) {
                        this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, GoDirectoryFragment.class);
                        continue;
                    }
                    boolean nextCreateNewParent = this.createNewPhysicalRecursiveTarget((PhysicalRecursiveElement)nextDirectory, moveToParentName);
                    nextDirectory = this.renameDirectory(nextDirectory, newName, refactoringStateHandler);
                    NamedElement nextNewParent = nextCreateNewParent ? this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, (PhysicalRecursiveElement)nextDirectory) : this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                    ICloneable nextCurrentParentOfpackageToMove = (ICloneable)nextDirectory.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCurrentParentOfpackageToMove != null) : "'nextCurrentParentOfpackageToMove' of method 'moveRenam' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCurrentParentOfpackageToMove, (IRefactorable)nextDirectory, (ICloneable)nextNewParent);
                }
                break;
            }
            case NAMESPACE: {
                assert (false) : "Unexpected 'refactoringElementType': " + String.valueOf(elementType);
                break;
            }
            default: {
                assert (false) : "Unhandled 'elementType' in 'moveRename':" + String.valueOf(elementType);
                break;
            }
        }
        return Collections.emptySet();
    }

    protected Set<NamedElement> move(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, RootDirectoryPath targetRootDirectory, String moveToParentName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'move' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'move' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'move' must not be empty";
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'move' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'move' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'move' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'move' must not be null";
        switch (elementType) {
            case ELEMENT: {
                assert (false) : "Unexpected refactoring element type: " + String.valueOf(elementType);
                break;
            }
            case COMPONENT: {
                NamedElement targetPackageOrRootDir = this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                this.checkCollisions(namedElements, statusInfo, targetPackageOrRootDir, null, elementType, targetPackageOrRootDir);
                if (statusInfo.getStatus() == StatusInfo.Status.NONE || statusInfo.getStatus().isApplicable()) {
                    Object cache = null;
                    THashSet collidingInfo = new THashSet();
                    for (NamedElement nextNamedElement : namedElements) {
                        cache = this.checkAdditionalCollisions(elementType, Collections.singletonList(nextNamedElement), targetRootDirectory, moveToParentName, this.getRelevantRenameName(nextNamedElement), (Set)collidingInfo, cache);
                    }
                    collidingInfo.forEach(i -> statusInfo.addCollisionInfo(i));
                }
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof GoSourceFile) : "Unexpected class in method 'move': " + String.valueOf(next);
                    GoSourceFile nextCompilationUnit = (GoSourceFile)next;
                    ICloneable nextCloneable = (ICloneable)nextCompilationUnit.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextCompilationUnit, (ICloneable)targetPackageOrRootDir);
                }
                break;
            }
            case DIRECTORY: {
                IRefactoringTarget target = this.getMoveToParent(targetRootDirectory, moveToParentName);
                this.checkCollisions(namedElements, statusInfo, target != null ? target.getNamedElement() : null, null, elementType, target != null ? target.getNamedElement() : null);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof GoDirectoryFragment) : "Unexpected class in method 'move': " + String.valueOf(next);
                    GoDirectoryFragment nextDirectory = (GoDirectoryFragment)next;
                    GoDirectoryFragment existing = null;
                    if (target != null) {
                        existing = (GoDirectoryFragment)this.findByRelevantRenameName(this.getRelevantRenameName((NamedElement)nextDirectory), target.getNamedElement(), GoDirectoryFragment.class);
                    }
                    if (existing != null) {
                        this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, GoDirectoryFragment.class);
                        continue;
                    }
                    NamedElement nextNewParent = this.createNewPhysicalRecursiveTarget((PhysicalRecursiveElement)nextDirectory, moveToParentName) ? this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, (PhysicalRecursiveElement)nextDirectory) : this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                    ICloneable nextCurrentParentOfpackageToMove = (ICloneable)nextDirectory.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCurrentParentOfpackageToMove != null) : "'nextCurrentParentOfpackageToMove' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCurrentParentOfpackageToMove, (IRefactorable)nextDirectory, (ICloneable)nextNewParent);
                }
                break;
            }
            case NAMESPACE: {
                assert (false) : "Unexpected 'refactoringElementType': " + String.valueOf(elementType);
                break;
            }
            default: {
                assert (false) : "Unhandled 'elementType' in 'move':" + String.valueOf(elementType);
                break;
            }
        }
        return Collections.emptySet();
    }

    static final class ElementNameParts {
        private String m_namespace = "";
        private String m_name;

        ElementNameParts() {
        }

        void setNamespace(String name) {
            assert (name != null) : "Parameter 'name' of method 'setNamespace' must not be null";
            this.m_namespace = name;
        }

        void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        boolean isValid() {
            return this.m_namespace != null && this.m_name != null && this.m_name.length() > 0;
        }

        String getFullName() {
            assert (this.isValid()) : "Not valid: " + String.valueOf(this);
            return (String)(this.m_namespace.isEmpty() ? "" : this.m_namespace + ".") + this.m_name;
        }

        public String toString() {
            return "ElementNameParts [m_namespace=" + this.m_namespace + ", m_name=" + this.m_name + "]";
        }

        static ElementNameParts create(ProgrammingElement element) {
            assert (element != null) : "Parameter 'type' of method 'create' must not be null";
            ElementNameParts parts = new ElementNameParts();
            String name = element.getName();
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                parts.setNamespace(name.substring(0, pos));
                name = name.substring(pos + 1);
            }
            parts.setName(name);
            return parts;
        }
    }
}

