/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CSharpDependencyType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.DependencyFactory;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.logical.IGenericParameter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.logical.IGenericParameterResolver;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.logical.ILogicalType;
import java.io.IOException;

public abstract class CSharpProgrammingElement
extends ProgrammingElementWithChildren
implements IGenericParameterResolver {
    protected static final int FLAG_STATIC = 1;
    protected static final int FLAG_VOLATILE = 2;
    protected static final int FLAG_EXTENSION = 4;
    protected static final int FLAG_VIRTUAL = 8;
    protected static final int FLAG_SEALED = 16;
    protected static final int FLAG_ABSTRACT = 32;
    protected static final int FLAG_CONST = 64;
    protected static final int FLAG_NESTED = 128;
    protected static final int FLAG_INDEXER = 256;
    protected static final int FLAG_PARTIAL = 512;
    protected static final int FLAG_UNSAFE = 1024;
    protected static final int FLAG_READONLY = 2048;
    protected static final int FLAG_OVERRIDE = 4096;
    protected static final int FLAG_NEW = 8192;
    protected static final int FLAG_VARIABLE_PARAMETERS = 16384;
    protected static final int FLAG_ASYNC = 32768;
    protected static final int FLAG_HIDDEN = 0x100000;
    private byte m_accessSpecifier;
    protected int m_flags;

    protected CSharpProgrammingElement(IModelServiceProvider msp, NamedElement parent, String name) {
        super(msp, parent, name);
    }

    protected CSharpProgrammingElement(NamedElement parent) {
        super(parent);
    }

    public String getSignature() {
        return null;
    }

    @Override
    public IGenericParameter getGenericParameterByName(String name) {
        return ((CSharpProgrammingElement)this.getParent(CSharpProgrammingElement.class, new Class[0])).getGenericParameterByName(name);
    }

    @Override
    public IGenericParameter getGenericParameterAt(int index) {
        return ((CSharpProgrammingElement)this.getParent(CSharpProgrammingElement.class, new Class[0])).getGenericParameterAt(index);
    }

    @Override
    public ProgrammingElement getOwner() {
        return ((CSharpProgrammingElement)this.getParent(CSharpProgrammingElement.class, new Class[0])).getOwner();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte(this.m_accessSpecifier);
        writer.writeInt(this.m_flags);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_accessSpecifier = reader.readByte();
        this.m_flags = reader.readInt();
    }

    public CSharpAccessSpecifier getAccessSpecifier() {
        return CSharpAccessSpecifier.values()[this.m_accessSpecifier];
    }

    public void setAccessSpecifier(CSharpAccessSpecifier accessSpecifier) {
        this.m_accessSpecifier = (byte)accessSpecifier.ordinal();
    }

    public void addAttribute(ILogicalType attr, int lineNumber) {
        assert (attr != null);
        assert (lineNumber > 0);
        for (ProgrammingElement programmingElement : attr.getTypeFragments()) {
            ParserDependency dep = DependencyFactory.addDependency(CSharpDependencyType.HAS_ATTRIBUTE, (ProgrammingElement)this, programmingElement, lineNumber);
            this.addDependency(dep);
        }
    }

    public boolean isStatic() {
        return (this.m_flags & 1) != 0;
    }

    public void setStatic(boolean set) {
        this.setFlag(1, set);
    }

    public boolean isUnsafe() {
        return (this.m_flags & 0x400) != 0;
    }

    public void setUnsafe(boolean set) {
        this.setFlag(1024, set);
    }

    public final boolean isHidden() {
        return (this.m_flags & 0x100000) != 0;
    }

    public final void setHidden(boolean set) {
        this.setFlag(0x100000, set);
    }

    public boolean isAsync() {
        return (this.m_flags & 0x8000) != 0;
    }

    public void setAsync(boolean set) {
        this.setFlag(32768, set);
    }

    public boolean isVolatile() {
        return (this.m_flags & 2) != 0;
    }

    public void setVolatile(boolean set) {
        this.setFlag(2, set);
    }

    public boolean isExtension() {
        return (this.m_flags & 4) != 0;
    }

    public void setExtension(boolean set) {
        this.setFlag(4, set);
    }

    public boolean isVirtual() {
        return (this.m_flags & 8) != 0;
    }

    public void setVirtual(boolean set) {
        this.setFlag(8, set);
    }

    public boolean isSealed() {
        return (this.m_flags & 0x10) != 0;
    }

    public void setSealed(boolean set) {
        this.setFlag(16, set);
    }

    public boolean isAbstract() {
        return (this.m_flags & 0x20) != 0;
    }

    public void setAbstract(boolean set) {
        this.setFlag(32, set);
    }

    public boolean isConst() {
        return (this.m_flags & 0x40) != 0;
    }

    public void setConst(boolean set) {
        this.setFlag(64, set);
    }

    public boolean isOverride() {
        return (this.m_flags & 0x1000) != 0;
    }

    public void setOverride(boolean set) {
        this.setFlag(4096, set);
    }

    public boolean isNew() {
        return (this.m_flags & 0x2000) != 0;
    }

    public void setNew(boolean set) {
        this.setFlag(8192, set);
    }

    public boolean isReadonly() {
        return (this.m_flags & 0x800) != 0;
    }

    public void setReadonly(boolean set) {
        this.setFlag(2048, set);
    }

    protected boolean testFlag(int flag) {
        return (this.m_flags & flag) != 0;
    }

    protected void setFlag(int flag, boolean set) {
        this.m_flags = set ? (this.m_flags |= flag) : (this.m_flags &= ~flag);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCSharpProgrammingElement(CSharpProgrammingElement var1);
    }
}

