/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.IKeywordProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.base.RelativeCyclicityMetricIds;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.SourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.path.ParserLogEntry;
import com.hello2morrow.sonargraph.core.model.path.ParserLogEntryContainer;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedExternalLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.SystemSettings;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.settings.SaveAsVisitor;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.CSharpRefactoringAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.CSharpRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.CSharpWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.IProjectInfoProvider;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpDirectoryCyclesInModulesAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpDirectoryCyclesInModulesMetricAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpDirectoryCyclesInSystemAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpDirectoryCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpNamespaceCyclesInModuleAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpNamespaceCyclesInModuleMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpNamespaceCyclesInSystemAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.analysis.CSharpNamespaceCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpExtendsClassRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpImplementsInterfaceRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpIsClassRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpIsEnumRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpIsInterfaceRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpTypeOfRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.CSharpModelBuilder;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.RoslynDaemon;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.plugin.PluginCSharpAccess;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.script.CSharpAccess;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpCauses;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpLanguage;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.element.CSharpIssueId;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.element.CSharpProviderId;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpSourceFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpExternalRoslynType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpLogicalModuleNamespace;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpLogicalSystemNamespace;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMember;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethod;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMethodWithBody;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpNamespaceFragment;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpProperty;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.IRoslynDaemon;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ITaskMonitor;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ProjectInfo;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskMonitor;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskState;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSolutionFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpAssembly;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpExternal;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpMetricId;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModuleType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpRoslynModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.CSharpPersistenceProvider;
import com.hello2morrow.sonargraph.plugin.csharp.IPluginCSharpAccess;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSharpLanguageProvider
extends LanguageProvider
implements IKeywordProvider,
IProjectInfoProvider {
    public static final String FOLDER_NAME = "csharp";
    public static final String SONARGRAPH_CSHARP_HOME = String.valueOf(CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir()) + System.getProperty("file.separator") + "csharp";
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpLanguageProvider.class);
    private static final int SOURCE_PROCESSING_DAEMONS = 6;
    private static final String[] IMPORT_START_TOKENS = new String[]{"using"};
    private static final Set<String> KEYWORDS;
    private final LanguageProviderRefactoringAdapter m_refactoringAdapter = new CSharpRefactoringAdapter(this);
    private TFile m_userHome;
    private TFile m_csharpHome;
    private IRoslynDaemon m_daemon;
    private ITaskMonitor<List<ProjectInfo>> m_openSolutionTask;
    private ExecutorService m_executorService;

    static {
        String[] keywords = new String[]{"abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fxied", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while", "add", "and", "alias", "ascending", "args", "async", "await", "by", "descending", "dynamic", "equals", "file", "from", "get", "global", "group", "init", "into", "join", "let", "managed", "nameof", "nint", "not", "notnull", "nuint", "on", "or", "orderby", "partial", "record", "remove", "required", "scoped", "select", "set", "unmanaged", "value", "var", "when", "where", "with", "yield"};
        KEYWORDS = new HashSet<String>(keywords.length);
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String nextKeyword = stringArray[n2];
            KEYWORDS.add(nextKeyword);
            ++n2;
        }
    }

    public CSharpLanguageProvider() {
        super((Language)CSharpLanguage.INSTANCE);
    }

    public LanguageProviderRefactoringAdapter getRefactoringAdapter() {
        return this.m_refactoringAdapter;
    }

    public LanguageProviderRefactoringDescriptorProvider getRefactoringDescriptorProvider() {
        return new CSharpRefactoringDescriptorProvider();
    }

    public Set<String> getKeywords(IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getKeywords' must not be null";
        return Collections.unmodifiableSet(KEYWORDS);
    }

    public void setUserHome(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'setCSharpUserHome' must not be null";
        this.m_userHome = dir;
    }

    private void addParserArtefacts(CategoryProvider categoryProvider) {
        assert (categoryProvider != null) : "Parameter 'categoryProvider' of method 'addParserArtefacts' must not be null";
        categoryProvider.setCategory(CSharpProgrammingElement.class, 9);
        categoryProvider.setCategory(CSharpType.class, 10);
        categoryProvider.setCategory(CSharpExternalRoslynType.class, 12);
        categoryProvider.setCategory(CSharpMember.class, 14);
        categoryProvider.setCategory(CSharpProperty.class, 16);
        categoryProvider.setCategory(CSharpMethod.class, 17);
        categoryProvider.setCategory(CSharpMethodWithBody.class, 17);
    }

    public CategoryProvider getPhysicalCategoryProvider() {
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(CSharpModule.class, 1);
        categoryProvider.setCategory(CSharpAssembly.class, 7);
        categoryProvider.setCategory(CSharpSourceFile.class, 8);
        categoryProvider.setCategory(CSharpNamespaceFragment.class, 11);
        this.addParserArtefacts(categoryProvider);
        categoryProvider.setCategory(CSharpExternal.class, 1000);
        return categoryProvider;
    }

    public CategoryProvider getLogicalCategoryProvider() {
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(CSharpExternalLogicalNamespaceRoot.class, 1000);
        categoryProvider.setCategory(CSharpLogicalModuleNamespace.class, 2);
        categoryProvider.setCategory(CSharpLogicalSystemNamespace.class, 2);
        categoryProvider.setCategory(PhysicalElementBasedExternalLogicalRoot.class, 1000);
        categoryProvider.setCategory(CSharpExternal.class, 1000);
        this.addParserArtefacts(categoryProvider);
        return categoryProvider;
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        super.initialize(installation, finishModelProcessor);
        if (this.m_userHome == null) {
            this.m_userHome = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        }
        this.m_csharpHome = new TFile((File)this.m_userHome, FOLDER_NAME);
        if (!this.m_csharpHome.isDirectory()) {
            this.m_csharpHome.mkdir();
            assert (this.m_csharpHome.isDirectory()) : "Not a directory: " + this.m_csharpHome.getPath();
        }
    }

    public void clearSystem(SoftwareSystem softwareSystem, boolean onRefresh) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearSystem' must not be null";
        super.clearSystem(softwareSystem, onRefresh);
    }

    public Set<IConfigurableAnalyzerId> getAnalyzerIds() {
        return new HashSet<IConfigurableAnalyzerId>(Arrays.asList(CSharpAnalyzerId.values()));
    }

    public List<? extends AnalyzerAdapter> getAnalyzerAdapters(IAnalyzerController controller, Set<IConfigurableAnalyzerId> licensedAnalyzerIds) {
        assert (controller != null) : "Parameter 'controller' of method 'getAnalyzerAdapters' must not be null";
        assert (licensedAnalyzerIds != null) : "Parameter 'licensedAnalyzerIds' of method 'getAnalyzerAdapters' must not be null";
        ArrayList<Object> result = new ArrayList<Object>();
        if (licensedAnalyzerIds.contains(CSharpNamespaceCyclesInModuleAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpNamespaceCyclesInModuleAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpNamespaceCyclesInSystemAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpNamespaceCyclesInSystemAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpNamespaceCyclesInModuleMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpNamespaceCyclesInModuleMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpNamespaceCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpNamespaceCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpDirectoryCyclesInModulesAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpDirectoryCyclesInModulesAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpDirectoryCyclesInSystemAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpDirectoryCyclesInSystemAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpDirectoryCyclesInModulesMetricAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpDirectoryCyclesInModulesMetricAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(CSharpDirectoryCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new CSharpDirectoryCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        return result;
    }

    public Set<IIssueId> getIssueIds() {
        return new HashSet<IIssueId>(Arrays.asList(CSharpIssueId.values()));
    }

    protected void clearExternal(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearExternal' must not be null";
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        for (CSharpModule module : workspace.getChildren(CSharpModule.class)) {
            ArrayList<WorkspaceDependency> dependenciesToRemove = new ArrayList<WorkspaceDependency>();
            for (WorkspaceDependency dependency : module.getOutgoingWorkspaceDependencies()) {
                if (!(dependency.getTo() instanceof CSharpAssembly)) continue;
                dependenciesToRemove.add(dependency);
            }
            for (WorkspaceDependency dependency : dependenciesToRemove) {
                module.removeOutgoingWorkspaceDependency(dependency);
            }
        }
        super.clearExternal(softwareSystem);
    }

    public boolean prepareRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, PrepareRefreshResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isRefreshPossible' must not be null";
        assert (result != null) : "Parameter 'result' of method 'isRefreshPossible' must not be null";
        List csharpModules = ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CSharpRoslynModule.class);
        result.setParserRefreshPossible(this.getLanguage(), csharpModules.size() > 0);
        return false;
    }

    public void aboutToRefreshSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        super.aboutToRefreshSystem(workerContext, softwareSystem, result);
        if (this.m_openSolutionTask == null) {
            this.startRoslynDaemon(softwareSystem, result);
            if (result.isFailure()) {
                return;
            }
        }
        assert (this.m_openSolutionTask != null) : "'m_openSolutionTask' of method 'aboutToRefreshSystem' must not be null";
        this.m_openSolutionTask.join();
    }

    public void aboutToRefreshModules(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener listener) {
        assert (false) : "Unexpected call";
    }

    public boolean refreshSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshSystem' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'refreshSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshSystem' must not be null";
        TaskState state = this.m_openSolutionTask.getState();
        if (state != TaskState.Finished) {
            result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_ERROR, this.m_openSolutionTask.getErrorMessage(), new Object[0]);
            if (state == TaskState.Dead) {
                this.startRoslynDaemon(softwareSystem, result);
            }
            return false;
        }
        List<ProjectInfo> projects = this.m_openSolutionTask.getResult();
        if (projects.isEmpty()) {
            result.addError((OperationResult.IMessageCause)CSharpCauses.SOLUTION_IS_EMPTY, "The solution does not contain any C# modules", new Object[0]);
            return false;
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        String flavor = "";
        for (CSharpRoslynModule mod : ws.getChildren(CSharpRoslynModule.class)) {
            if (!projects.stream().anyMatch(pi -> pi.getName().equals(mod.getProjectName()))) {
                String localFlavor = flavor;
                ProjectInfo pi2 = projects.stream().filter(p -> p.getName().startsWith(mod.getProjectName() + "(" + localFlavor)).findFirst().orElse(null);
                if (pi2 == null) continue;
                mod.setProjectName(pi2.getName());
                softwareSystem.needsSave();
                if (flavor.length() == 0) {
                    flavor = pi2.getFlavor();
                }
                projectNames.add(pi2.getName());
                continue;
            }
            projectNames.add(mod.getProjectName());
        }
        if (projectNames.isEmpty()) {
            projectNames.add(projects.get(0).getName());
        }
        TaskMonitor<JSONObject> refreshTask = this.m_daemon.parseProjects(projectNames, workerContext);
        refreshTask.join();
        state = refreshTask.getState();
        if (state == TaskState.Finished) {
            CSharpModelBuilder mb = new CSharpModelBuilder(softwareSystem, new SourceProcessor());
            NamedElement modelRoot = mb.buildModel(refreshTask.getResult());
            for (String parserLogEntry : this.m_daemon.getParserLogMessages()) {
                int firstSemic = parserLogEntry.indexOf(59);
                int secondSemic = parserLogEntry.indexOf(59, firstSemic + 1);
                assert (firstSemic > 0);
                assert (secondSemic > 0);
                String file = parserLogEntry.substring(0, firstSemic);
                int lineNumber = Integer.valueOf(parserLogEntry.substring(firstSemic + 1, secondSemic));
                String msg = parserLogEntry.substring(secondSemic + 1);
                CSharpSourceFile src = mb.getSource(file);
                if (src != null) {
                    ParserLogEntryContainer container = (ParserLogEntryContainer)src.getUniqueChild(ParserLogEntryContainer.class);
                    if (container == null) {
                        container = new ParserLogEntryContainer((NamedElement)src);
                        src.addChild((NamedElement)container);
                    }
                    ParserLogEntry entry = new ParserLogEntry((NamedElement)container, "Error", msg, lineNumber);
                    container.addChild((NamedElement)entry);
                    continue;
                }
                LOGGER.error(String.format("Could not locate file '%s'", file));
                LOGGER.error(String.format("Parser error: %s:%d: %s", file, lineNumber, msg));
            }
            for (CSharpModule module : ws.getChildren(CSharpModule.class)) {
                module.remove();
            }
            CSharpExternal external = (CSharpExternal)((Object)ws.getUniqueExistingChild(CSharpExternal.class));
            external.forgetChildren(true);
            for (CSharpRoslynModule module : modelRoot.getChildren(CSharpRoslynModule.class)) {
                module.changeParent((NamedElement)ws, true);
            }
            for (CSharpAssembly assembly : modelRoot.getChildren(CSharpAssembly.class)) {
                assembly.changeParent((NamedElement)external, true);
            }
            return true;
        }
        if (state == TaskState.Dead) {
            this.startRoslynDaemon(softwareSystem, result);
        }
        result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_ERROR, refreshTask.getErrorMessage(), new Object[0]);
        return false;
    }

    public void accept(final ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        assert (content != null) : "Parameter 'content' of method 'accept' must not be null";
        SourceLineProcessor sourceLineProcessor = new SourceLineProcessor();
        sourceLineProcessor.accept(content, new ISourceLineProcessor.SourceLineVisitor(){

            public void visitCharLiteral(int offset, String c) {
                if (!$assertionsDisabled && c == null) {
                    throw new AssertionError((Object)"Parameter 'c' of method 'visitCharLiteral' must not be null");
                }
                visitor.visitLiteral(offset, c.length());
            }

            public void visitStringLiteral(int offset, String s) {
                if (!$assertionsDisabled && s == null) {
                    throw new AssertionError((Object)"Parameter 's' of method 'visitStringLiteral' must not be null");
                }
                visitor.visitLiteral(offset, s.length());
            }

            public void visitSingleLineComment(int offset, String comment) {
                if (!$assertionsDisabled && comment == null) {
                    throw new AssertionError((Object)"Parameter 'comment' of method 'visitSingleLineComment' must not be null");
                }
                visitor.visitComment(offset, comment.length());
            }

            public void visitMultiLineComment(int offset, String comment) {
                if (!$assertionsDisabled && comment == null) {
                    throw new AssertionError((Object)"Parameter 'comment' of method 'visitMultiLineComment' must not be null");
                }
                visitor.visitComment(offset, comment.length());
            }

            public void visitWord(int offset, String word) {
                if (!$assertionsDisabled && word == null) {
                    throw new AssertionError((Object)"Parameter 'comment' of method 'word' must not be null");
                }
                if (KEYWORDS.contains(word)) {
                    visitor.visitKeyword(offset, word.length());
                }
            }
        });
    }

    public IAdditionalFileInfoProvider getPersistenceProvider(Installation installation) {
        return new CSharpPersistenceProvider(installation);
    }

    public IProviderId getProviderId() {
        return CSharpProviderId.INSTANCE;
    }

    public void initialize(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super.initialize(softwareSystem, finishModelProcessor);
        CSharpWorkspaceExtension workspaceExtension = new CSharpWorkspaceExtension(softwareSystem, this);
        softwareSystem.addExtension((Extension)workspaceExtension);
        finishModelProcessor.addListener((ISoftwareSystemLifecycleListener)workspaceExtension);
    }

    public void finishSaveSoftwareSystemAs(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'finishSaveSoftwareSystemAs' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSaveSoftwareSystemAs' must not be null";
        SaveAsVisitor visitor = new SaveAsVisitor();
        ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)visitor);
    }

    private boolean startRoslynDaemon(SoftwareSystem softwareSystem, OperationResult result) {
        this.m_daemon = new RoslynDaemon(result);
        if (result.isSuccess() && this.m_daemon.start()) {
            CSharpSolutionFile solution = (CSharpSolutionFile)((Object)((CSharpSystemSettings)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(CSharpSystemSettings.class))).getUniqueExistingChild(CSharpSolutionFile.class));
            this.m_openSolutionTask = this.m_daemon.openSolution(solution.getFile().getNormalizedAbsolutePath());
            return true;
        }
        result.addError((OperationResult.IMessageCause)CSharpCauses.DAEMON_FAILED_TO_START, "C# parser daemon failed to start", new Object[0]);
        return false;
    }

    public void finishLoadFromPersistence(Installation installation, SoftwareSystem softwareSystem, OperationResult result, boolean snapshotOrUndoRedoMode) {
        CSharpSolutionFile solution;
        assert (installation != null) : "Parameter 'installation' of method 'finishLoadFromPersistence' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishLoadFromPersistence' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishLoadFromPersistence' must not be null";
        if (!snapshotOrUndoRedoMode && this.m_daemon == null && (solution = (CSharpSolutionFile)((Object)((CSharpSystemSettings)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(CSharpSystemSettings.class))).getUniqueExistingChild(CSharpSolutionFile.class))).exists() && solution.getFile().canRead()) {
            this.startRoslynDaemon(softwareSystem, result);
        }
    }

    public void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        super.aboutToCreateFirstModule(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        if (!workspace.hasChildren(false, new Class[]{CSharpExternal.class})) {
            workspace.addChild((NamedElement)new CSharpExternal((NamedElement)workspace));
        }
        if (this.m_executorService == null) {
            this.m_executorService = Executors.newFixedThreadPool(6);
        }
    }

    public void lastModuleDeleted(SoftwareSystem softwareSystem) {
        super.lastModuleDeleted(softwareSystem);
        ((CSharpExternal)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CSharpExternal.class))).remove();
        this.stopRoslynDaemon();
    }

    private void stopRoslynDaemon() {
        if (this.m_daemon != null) {
            if (this.m_openSolutionTask != null) {
                if (!this.m_daemon.isReady()) {
                    this.m_daemon.cancel();
                    this.m_openSolutionTask.join();
                }
                this.m_daemon.closeSolution();
            }
            this.m_daemon.stop();
            this.m_daemon = null;
            this.m_openSolutionTask = null;
            this.m_executorService.shutdown();
            this.m_executorService = null;
        }
    }

    public void softwareSystemClosed(SoftwareSystem softwareSystem) {
        super.softwareSystemClosed(softwareSystem);
        this.stopRoslynDaemon();
    }

    protected Module.IModuleType getModuleType(String moduleTypeStandardName) {
        assert (moduleTypeStandardName != null) : "Parameter 'moduleTypeStandardName' of method 'getModuleType' must not be null";
        CSharpModuleType moduleType = null;
        try {
            moduleType = CSharpModuleType.fromStandardName(moduleTypeStandardName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return moduleType;
    }

    protected Module createModule(SoftwareSystem softwareSystem, Module.IModuleType type, String id, String name, String description) {
        assert (softwareSystem != null) : "Parameter 'system' of method 'createSpecificModule' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createModule' must not be null";
        assert (type instanceof CSharpModuleType) : "Not a C# module type: " + type.getClass().getSimpleName();
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'createModule' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createModule' must not be empty";
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CSharpRoslynModule module = new CSharpRoslynModule((NamedElement)workspace, name, id, name);
        if (description != null) {
            module.setDescription(description);
        }
        workspace.addChild((NamedElement)module);
        return module;
    }

    protected Class<? extends External> getExternalClass() {
        return CSharpExternal.class;
    }

    protected Class<? extends Module> getModuleClass() {
        return CSharpModule.class;
    }

    protected RelevantSourceLinesScanner.ScannerInfo getScannerInfo() {
        return new RelevantSourceLinesScanner.ScannerInfo(IMPORT_START_TOKENS);
    }

    protected EnumSet<Modification> moveSoftwareSystemElements(Workspace sourceWorkspace, Workspace targetWorkspace) {
        EnumSet modifications = super.moveSoftwareSystemElements(sourceWorkspace, targetWorkspace);
        SystemSettings sourceSystemSettings = (SystemSettings)sourceWorkspace.getUniqueChild(CSharpSystemSettings.class);
        if (sourceSystemSettings != null) {
            assert (sourceSystemSettings != null) : "'sourceSystemSettings' must not be null";
            SystemSettings targetSystemSettings = (SystemSettings)targetWorkspace.getUniqueChild(CSharpSystemSettings.class);
            if (targetSystemSettings != null) {
                targetSystemSettings.remove();
            }
            sourceSystemSettings.changeParent((NamedElement)targetWorkspace, true);
            ArrayList<Module> noLongerPresentModules = new ArrayList<Module>();
            for (Module sourceModule : sourceWorkspace.getChildren(CSharpModule.class)) {
                Module targetModule = (Module)targetWorkspace.getUniqueChild((NamedElement.IFilter)new NameFilter(sourceModule.getName()), CSharpModule.class);
                if (targetModule == null) {
                    noLongerPresentModules.add(sourceModule);
                    continue;
                }
                CSharpWorkspaceExtension.moveElements(sourceModule, targetModule);
            }
            if (!noLongerPresentModules.isEmpty()) {
                modifications.add(Modification.WORKSPACE_MODIFIED);
                noLongerPresentModules.forEach(m -> m.remove());
            }
        }
        return modifications;
    }

    protected List<StructureItem> getPhysicalStructureItems() {
        return Arrays.asList(StructureItem.MODULE, StructureItem.ROOT_DIRECTORY, StructureItem.DIRECTORY_FRAGMENT, StructureItem.COMPONENT, StructureItem.NAMESPACE, StructureItem.PROGRAMMING_ELEMENT);
    }

    protected CoreAccess getSystemAccess(Installation installation, SoftwareSystem system, IMetricIdProvider metricIdProvider, ScriptApi api) {
        assert (installation != null) : "Parameter 'installation' of method 'getSystemAccess' must not be null";
        assert (system != null) : "Parameter 'system' of method 'getSystemAccess' must not be null";
        return new CSharpAccess(installation, system, metricIdProvider, api);
    }

    public LogicalSystemNamespace createLogicalSystemNamespace(NamedElement parent, String name) {
        return new CSharpLogicalSystemNamespace(parent, name);
    }

    public LogicalModuleNamespace createLogicalModuleNamespace(NamedElement parent, String name) {
        return new CSharpLogicalModuleNamespace(parent, name);
    }

    public String getBundleId() {
        return "com.hello2morrow.sonargraph.language.provider.csharp";
    }

    public List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers() {
        return Arrays.asList(new IAssignableAttributeRetriever[]{new CSharpExtendsClassRetriever(), new CSharpImplementsInterfaceRetriever(), new CSharpTypeOfRetriever(), new CSharpIsClassRetriever(), new CSharpIsInterfaceRetriever(), new CSharpIsEnumRetriever()});
    }

    public LogicalNamespaceRoot createLogicalNamespaceRoot(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createLogicalNamespaceRoot' must not be null";
        return new CSharpLogicalNamespaceRoot(parent);
    }

    public ExternalLogicalNamespaceRoot createExternalLogicalNamespaceRoot(NamedElement parent, NamedElement external, LogicalNamespaceScope scope) {
        assert (parent != null) : "Parameter 'parent' of method 'createExternalLogicalNamespaceRoot' must not be null";
        assert (external != null) : "Parameter 'external' of method 'createExternalLogicalNamespaceRoot' must not be null";
        return new CSharpExternalLogicalNamespaceRoot(parent, external, scope);
    }

    public Double computeLanguageSpecificMaintainabilityLevel(SoftwareSystem system, Module module) {
        assert (system != null) : "Parameter 'system' of method 'computeLanguageSpecificMaintainabilityLevel' must not be null";
        assert (module != null) : "Parameter 'module' of method 'computeLanguageSpecificMaintainabilityLevel' must not be null";
        IMetricAccessor ma = (IMetricAccessor)((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class);
        Number relativeNamespaceCyclicity = ma.getMetricValue(system, (NamedElement)module, (IMetricLevel)CoreMetricLevel.MODULE, (IMetricId)CSharpMetricId.CS_RELATIVE_CYCLICITY_NAMESPACES, false);
        if (relativeNamespaceCyclicity == null) {
            return null;
        }
        Number numberOfNamespaces = ma.getMetricValue(system, (NamedElement)module, (IMetricLevel)CoreMetricLevel.MODULE, (IMetricId)CSharpMetricId.CS_NAMESPACES_FULLY_ANALYZED, false);
        if (numberOfNamespaces == null) {
            return null;
        }
        double ml = 100.0 - relativeNamespaceCyclicity.doubleValue();
        double np = numberOfNamespaces.doubleValue();
        if (np < 20.0) {
            ml = 100.0 * (20.0 - np) / 20.0 + np / 20.0 * ml;
        }
        return ml;
    }

    public IMetricLevel getNamespaceMetricLevel() {
        return CSharpMetricLevel.CS_NAMESPACE;
    }

    public IMetricId getNamespacesMetricId() {
        return CSharpMetricId.CS_NAMESPACES;
    }

    public Set<RelativeCyclicityMetricIds> getRelativeCyclicityMetricIds() {
        return Set.of(new RelativeCyclicityMetricIds((IMetricId)CSharpMetricId.CS_DIRECTORIES_FULLY_ANALYZED, (IMetricId)CSharpMetricId.CS_RELATIVE_CYCLICITY_DIRECTORIES, (IMetricId)CSharpMetricId.CS_AVERAGE_RELATIVE_CYCLICITY_DIRECTORIES), new RelativeCyclicityMetricIds((IMetricId)CSharpMetricId.CS_NAMESPACES_FULLY_ANALYZED, (IMetricId)CSharpMetricId.CS_RELATIVE_CYCLICITY_NAMESPACES, (IMetricId)CSharpMetricId.CS_AVERAGE_RELATIVE_CYCLICITY_NAMESPACES));
    }

    public IMetricId getFullyAnalyzedNamespacesMetricId() {
        return CSharpMetricId.CS_NAMESPACES_FULLY_ANALYZED;
    }

    public IMetricLevel getDirectoryMetricLevel() {
        return CSharpMetricLevel.CS_DIRECTORY;
    }

    public IMetricId getDirectoriesMetricId() {
        return CSharpMetricId.CS_DIRECTORIES;
    }

    public IMetricId getFullyAnalyzedDirectoriesMetricId() {
        return CSharpMetricId.CS_DIRECTORIES_FULLY_ANALYZED;
    }

    public Collection<String> getSourceExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        String[] stringArray = CSharpFileType.SOURCE_FILE.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        return extensions;
    }

    public void addPluginAccess(Installation installation, SoftwareSystem softwareSystem, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (installation != null) : "Parameter 'installation' of method 'addPluginAccess' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addPluginAccess' must not be null";
        assert (access != null) : "Parameter 'access' of method 'addPluginAccess' must not be null";
        access.put(IPluginCSharpAccess.class, (IPluginCoreAccess)new PluginCSharpAccess(installation, softwareSystem));
    }

    public WorkspaceDependency createWorkspaceDependency(SoftwareSystem softwareSystem, IWorkspaceDependencyElement from, String toId, String toName, String type, WorkspaceDependency.AdditionalDependencyData dependencyData) {
        return null;
    }

    public boolean controlsParserModelRefresh() {
        return true;
    }

    public boolean checkWorkspaceDependenciesFromSnapshot() {
        return false;
    }

    @Override
    public List<ProjectInfo> getProjectsFromSolution() {
        if (this.m_openSolutionTask == null) {
            return Collections.emptyList();
        }
        if (this.m_openSolutionTask.getState() == TaskState.Running) {
            this.m_openSolutionTask.join();
        }
        if (this.m_openSolutionTask.getState() == TaskState.Finished) {
            return this.m_openSolutionTask.getResult();
        }
        return Collections.emptyList();
    }

    public boolean moduleOrderIsRelevant() {
        return false;
    }

    public boolean supportsDeltaRefresh() {
        return false;
    }

    private class SourceProcessor
    implements IAddedOrChangedSourceFileProcessor {
        private SourceProcessor() {
        }

        public void processAddedOrChangedSourceFile(SourceFile sourceFile) {
            CSharpLanguageProvider.this.m_executorService.submit(() -> CSharpLanguageProvider.this.processAddedOrChangedSourceFile(sourceFile));
        }
    }
}

