/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.api.csharp.CSharpTypeKind;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpGenericProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpNamespaceFragment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CSharpType
extends CSharpGenericProgrammingElement
implements IType,
IRefactorable {
    private static final int SNAPSHOT_VERSION_PARTIAL_TYPE_SUFFIX_COUNTER = 24;
    private CSharpTypeKind m_kind;
    private CSharpType m_prev;
    private CSharpType m_next;
    private String m_signature;
    private int m_fqNamePartSuffixCounter = -1;

    public CSharpType(IModelServiceProvider msp, NamedElement parent, String name, String[] typeParameters, CSharpTypeKind kind) {
        super(msp, parent, name, typeParameters);
        assert (kind != null) : "Parameter 'kind' of method 'CSharpRoslynType' must not be null";
        this.m_kind = kind;
        if (parent instanceof CSharpType) {
            this.setFlag(128, true);
        }
    }

    public CSharpType(NamedElement parent) {
        super(parent);
    }

    public void setFqNamePartSuffixCounter(int counter) {
        assert (counter >= -1);
        this.m_fqNamePartSuffixCounter = counter;
    }

    public String getFullyQualifiedNamePart() {
        String fqNamePart = super.getFullyQualifiedNamePart();
        if (this.m_fqNamePartSuffixCounter != -1) {
            return fqNamePart + INNER_NAME_PARTS_SEPARATOR + this.m_fqNamePartSuffixCounter;
        }
        return fqNamePart;
    }

    public boolean isMember() {
        return false;
    }

    public String getImageResourceName() {
        switch (this.m_kind) {
            case Attribute: {
                return "CSharpClass";
            }
            case Class: {
                return "CSharpClass";
            }
            case Delegate: {
                return "CSharpDelegate";
            }
            case Enum: {
                return "CSharpEnum";
            }
            case Interface: {
                return "CSharpInterface";
            }
            case Record: {
                return "CSharpRecord";
            }
            case Struct: {
                return "CSharpStruct";
            }
        }
        return super.getImageResourceName();
    }

    public CSharpTypeKind getKind() {
        return this.m_kind;
    }

    @Override
    public String getSignature() {
        return this.m_signature;
    }

    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    public void setPartial(boolean partial) {
        this.setFlag(512, partial);
    }

    public boolean isPartial() {
        return this.testFlag(512);
    }

    public void addPartialFragment(CSharpType segment) {
        this.m_next = segment;
        segment.m_prev = this;
    }

    public List<CSharpType> getPartialSegments() {
        CSharpType type = this;
        while (type.m_prev != null) {
            type = type.m_prev;
        }
        ArrayList<CSharpType> result = new ArrayList<CSharpType>();
        while (type != null) {
            result.add(type);
            type = type.m_next;
        }
        return result;
    }

    public String getName() {
        if (this.getParent() instanceof IWorkspaceDependencyElement) {
            return this.getShortName();
        }
        if (this.getParent() instanceof CSharpNamespaceFragment) {
            return this.getParent().getName() + "." + this.getShortName();
        }
        return this.getParent().getName() + "." + this.getShortName();
    }

    @Override
    public int getNumberOfGenericTypeParameters() {
        if (this.isNested()) {
            return ((CSharpType)this.getParent()).getNumberOfGenericTypeParameters() + super.getNumberOfGenericTypeParameters();
        }
        return super.getNumberOfGenericTypeParameters();
    }

    @IntProperty
    public int getNumberOfMethods() {
        return this.getChildren(IRoutine.class).size();
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isNested() {
        return this.testFlag(128);
    }

    public boolean isInterface() {
        return this.m_kind == CSharpTypeKind.Interface;
    }

    public boolean isClass() {
        return this.m_kind == CSharpTypeKind.Class;
    }

    public boolean isEnum() {
        return this.m_kind == CSharpTypeKind.Enum;
    }

    public String getFullyQualifiedTypeName() {
        return this.getName();
    }

    public final ProgrammingElement getOriginal() {
        return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
    }

    public final ProgrammingElement getRepresentative() {
        return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte((byte)this.m_kind.ordinal());
        writer.write((ISnapshotWriter.IStorable)this.m_prev);
        writer.write((ISnapshotWriter.IStorable)this.m_next);
        writer.writeString(this.m_signature);
        writer.writeInt(this.m_fqNamePartSuffixCounter);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_kind = CSharpTypeKind.values()[reader.readByte()];
        this.m_prev = (CSharpType)reader.read(CSharpType.class, new SnapshotArgument[0]);
        this.m_next = (CSharpType)reader.read(CSharpType.class, new SnapshotArgument[0]);
        this.m_signature = reader.readString();
        if (reader.getVersion() >= 24) {
            this.m_fqNamePartSuffixCounter = reader.readInt();
        }
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpType(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCSharpType(CSharpType var1);
    }
}

