/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.path;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class CSharpFileType
extends Enum<CSharpFileType>
implements IFileType {
    public static final /* enum */ CSharpFileType SOURCE_FILE = new CSharpFileType("C# Source File", ".cs");
    public static final /* enum */ CSharpFileType PROJECT_FILE = new CSharpFileType("C# Visual Studio Project File", ".csproj");
    public static final /* enum */ CSharpFileType SHARED_PROJECT_FILE = new CSharpFileType("C# Visual Studio Shared Project File", ".shproj");
    public static final /* enum */ CSharpFileType ASSEMBLY = new CSharpFileType("C# Assembly", ".dll", ".winmd");
    public static final /* enum */ CSharpFileType WINMD = new CSharpFileType("Windows 8 Meta Data File", ".winmd");
    public static final /* enum */ CSharpFileType SOLUTION_FILE = new CSharpFileType("Visual Studio C# Solution File", ".sln", ".slnf");
    public static final /* enum */ CSharpFileType SHARED_PROJECT_ITEMS_FILE = new CSharpFileType("Visual Studio Shared Project Items File", ".projitems");
    public static final /* enum */ CSharpFileType XAML_CS = new CSharpFileType("XAML C# file", ".xaml.cs");
    public static final /* enum */ CSharpFileType XAML_GENERATED_HANDLER = new CSharpFileType("XAML C# Handler File (generated)", ".g.cs");
    public static final /* enum */ CSharpFileType XAML_GENERATED_DEFINITION = new CSharpFileType("XAML C# Definition File (generated)", ".g.i.cs");
    private final String m_presentationName;
    private final String[] m_extensions;
    private static final /* synthetic */ CSharpFileType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CSharpFileType[]{SOURCE_FILE, PROJECT_FILE, SHARED_PROJECT_FILE, ASSEMBLY, WINMD, SOLUTION_FILE, SHARED_PROJECT_ITEMS_FILE, XAML_CS, XAML_GENERATED_HANDLER, XAML_GENERATED_DEFINITION};
    }

    private CSharpFileType(String presentationName, String ... extensions) {
        assert (presentationName != null) : "Parameter 'presentationName' of method 'CSharpFileType' must not be null";
        assert (extensions != null && extensions.length > 0) : "Parameter 'extensions' of method 'CSharpFileType' must not be empty";
        this.m_presentationName = presentationName;
        this.m_extensions = extensions;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String[] getExtensions() {
        return this.m_extensions;
    }

    public String getDefaultExtension() {
        return this.m_extensions[0];
    }

    public boolean hasExtension(String extension) {
        return FileUtility.hasExtension((IFileType)this, (String)extension);
    }

    public boolean endsWith(String name) {
        assert (name != null) : "'name' must not be null";
        String[] stringArray = this.m_extensions;
        int n = this.m_extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String nextExtension = stringArray[n2];
            if (name.endsWith(nextExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static CSharpFileType[] values() {
        CSharpFileType[] cSharpFileTypeArray = ENUM$VALUES;
        int n = cSharpFileTypeArray.length;
        CSharpFileType[] cSharpFileTypeArray2 = new CSharpFileType[n];
        System.arraycopy(ENUM$VALUES, 0, cSharpFileTypeArray2, 0, n);
        return cSharpFileTypeArray2;
    }

    public static CSharpFileType valueOf(String string) {
        return Enum.valueOf(CSharpFileType.class, string);
    }
}

