/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.DotnetSdkLocator;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.parser.roslyn.RuntimeInfo;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.IRoslynDaemon;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ListProjectsResult;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ProjectInfo;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskMonitor;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskState;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoslynDaemon
implements IRoslynDaemon {
    private static String Ok = "OK";
    private static String Error = "Error";
    private static String Started = "Started";
    private static String Finished = "Finished";
    private static String Progress = "Progress";
    private static String Cancelled = "Cancelled";
    private static String ModelData = "ModelData";
    private static final Logger LOGGER = LoggerFactory.getLogger(RoslynDaemon.class);
    private final String m_msBuildPath;
    private final String m_dotNetExe;
    private String m_currentSolutionPath;
    private List<ProjectInfo> m_projectInfoList;
    private final List<String> m_parserLogMessages = new ArrayList<String>();
    private Process m_process;
    private PrintStream m_commandStream;
    private BufferedReader m_processOutput;
    private BufferedReader m_errorOutput;
    private boolean m_isReady;
    private String m_startupError;
    private String m_daemonPath;

    public RoslynDaemon(OperationResult result) {
        this.m_msBuildPath = DotnetSdkLocator.locateDotnetSdk(result);
        this.m_daemonPath = this.getDaemonPath();
        this.m_dotNetExe = DotnetSdkLocator.locateDotnetExecutable();
    }

    private String getDaemonPath() {
        TFile daemonPath;
        TFile daemonDir = new TFile("../com.hello2morrow.sonargraph.language.provider.csharp/csparser/SonargraphAnalyzer/bin/Debug/net8.0");
        if (daemonDir.isDirectory() && (daemonPath = new TFile((File)daemonDir, "SonargraphAnalyzer.dll")).isFile()) {
            if (!daemonPath.canExecute()) {
                daemonPath.setExecutable(true);
            }
            return daemonPath.getNormalizedAbsolutePath();
        }
        try {
            String arch;
            File path = RuntimeInfo.getFileInBundle("com.hello2morrow.sonargraph.language.provider.csharp", ".");
            daemonDir = new TFile(path, "bin").getNormalizedAbsoluteFile();
            if (!daemonDir.isDirectory() && !(daemonDir = new TFile(path, "../bin").getNormalizedAbsoluteFile()).isDirectory()) {
                daemonDir = new TFile(path, "../../bin").getNormalizedAbsoluteFile();
            }
            assert (daemonDir.isDirectory()) : "Could not locate Roslyn daemon directory above here: " + String.valueOf(path);
            daemonDir = Platform.isLinux() ? ((arch = System.getProperty("os.arch")).contains("aarch64") || arch.contains("arm64") ? new TFile((File)daemonDir, "linux-arm64") : new TFile((File)daemonDir, "linux")) : (Platform.isMac() ? ((arch = System.getProperty("os.arch")).contains("aarch64") || arch.contains("arm64") ? new TFile((File)daemonDir, "mac-arm64") : new TFile((File)daemonDir, "mac")) : new TFile((File)daemonDir, "windows"));
            if (daemonDir.isDirectory()) {
                LOGGER.info("Located csparser path for Roslyn daemon: " + daemonDir.getPath());
            } else {
                LOGGER.error("Daemon directory does not exits: " + daemonDir.getAbsolutePath());
            }
        }
        catch (FileNotFoundException e) {
            daemonDir = null;
        }
        if (daemonDir != null && daemonDir.isDirectory()) {
            daemonPath = new TFile((File)daemonDir, "SonargraphAnalyzer.dll");
            return daemonPath.getNormalizedAbsolutePath();
        }
        LOGGER.error("Could not locate the C# parser daemon!");
        return null;
    }

    @Override
    public boolean start() {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (this.m_daemonPath == null) {
            return false;
        }
        if (this.m_msBuildPath != null && this.m_msBuildPath.length() > 0) {
            pb.command(this.m_dotNetExe, this.m_daemonPath, this.m_msBuildPath);
            LOGGER.info("MSBuildPath is: " + this.m_msBuildPath);
        } else {
            pb.command(this.m_dotNetExe, this.m_daemonPath);
        }
        try {
            this.m_process = pb.start();
        }
        catch (IOException e) {
            LOGGER.error("Could not start Roslyn daemon: " + e.getMessage(), (Throwable)e);
            return false;
        }
        this.m_commandStream = new PrintStream(this.m_process.getOutputStream());
        this.m_processOutput = new BufferedReader(new InputStreamReader(this.m_process.getInputStream(), StandardCharsets.UTF_8));
        this.m_errorOutput = new BufferedReader(new InputStreamReader(this.m_process.getErrorStream(), StandardCharsets.UTF_8));
        String reply = this.readLineFromProcess();
        if (reply == null) {
            this.endProcess();
            return false;
        }
        Thread errorMonitor = new Thread(() -> this.monitorErrorOutput());
        boolean success = true;
        errorMonitor.start();
        if (reply.startsWith(Error + ": ")) {
            this.endProcess();
            this.m_startupError = reply.substring(7);
            LOGGER.error("Roslyn daemon startup error: " + this.m_startupError);
            success = false;
        } else if (!reply.equals(Started)) {
            this.m_startupError = reply;
            LOGGER.error("Roslyn daemon startup error - unexpected reply: " + this.m_startupError);
            this.stop();
            success = false;
        }
        if (!success) {
            try {
                errorMonitor.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        this.m_isReady = true;
        return true;
    }

    @Override
    public String getStartupErrorMessage() {
        return this.m_startupError;
    }

    private boolean sendCommand(String command) {
        assert (command != null) : "Parameter 'command' of method 'sendCommand' must not be null";
        this.m_commandStream.println(command);
        if (this.m_commandStream.checkError()) {
            LOGGER.error("Failed to send command to RoslynDaemon: " + command);
            this.endProcess();
            return false;
        }
        return true;
    }

    private void monitorErrorOutput() {
        try {
            String line;
            while ((line = this.m_errorOutput.readLine()) != null) {
                if (line.startsWith("L:")) {
                    this.m_parserLogMessages.add(line.substring(2));
                    continue;
                }
                if (line.startsWith("E:")) {
                    LOGGER.error(line.substring(2));
                    continue;
                }
                if (line.startsWith("W:")) {
                    LOGGER.warn(line.substring(2));
                    continue;
                }
                LOGGER.debug(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String readLineFromProcess() {
        try {
            String result = this.m_processOutput.readLine();
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Error when reading from Roslyn Daemon: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private synchronized void endProcess() {
        while (true) {
            try {
                this.m_process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.m_process = null;
        this.m_isReady = false;
        this.m_projectInfoList = null;
    }

    @Override
    public synchronized boolean isReady() {
        return this.m_isReady;
    }

    @Override
    public synchronized boolean isAlive() {
        return this.m_process != null && this.m_process.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOpenSolution(TaskMonitor<List<ProjectInfo>> tm, String solutionFilePath) {
        String line;
        block28: {
            block29: {
                line = this.readLineFromProcess();
                if (line != null) break block28;
                tm.setState(TaskState.Dead);
                this.endProcess();
                if (this.m_process == null) break block29;
                RoslynDaemon roslynDaemon = this;
                synchronized (roslynDaemon) {
                    this.m_isReady = true;
                }
            }
            return;
        }
        try {
            if (!line.equals(Started)) {
                LOGGER.error("Unexpected reply for OpenSolution: " + line);
            }
            if ((line = this.readLineFromProcess()) == null) {
                tm.setState(TaskState.Dead);
                this.endProcess();
            } else if (line.startsWith(Error + ": ")) {
                tm.setErrorMessage(line.substring(7));
            } else if (line.equals(Cancelled)) {
                tm.setState(TaskState.Cancelled);
            } else if (line.equals(Finished)) {
                this.m_projectInfoList = new ArrayList<ProjectInfo>();
                while (true) {
                    String projectInfo;
                    if ((projectInfo = this.readLineFromProcess()) == null) {
                        tm.setState(TaskState.Dead);
                        this.endProcess();
                        break;
                    }
                    if (projectInfo.length() == 0) break;
                    String[] parts = projectInfo.split(";");
                    assert (parts.length == 3);
                    this.m_projectInfoList.add(new ProjectInfo(parts[0], parts[1], parts[2]));
                }
                if (this.m_projectInfoList.size() > 0) {
                    this.m_currentSolutionPath = solutionFilePath;
                    tm.setResult(this.m_projectInfoList);
                    tm.setState(TaskState.Finished);
                } else {
                    tm.setErrorMessage("Daemon did not return expected list of projects");
                }
            } else {
                String msg = "Unexpected reply for OpenSolution: " + line;
                tm.setErrorMessage(msg);
                LOGGER.error(msg);
            }
        }
        catch (Throwable throwable) {
            if (this.m_process != null) {
                RoslynDaemon roslynDaemon = this;
                synchronized (roslynDaemon) {
                    this.m_isReady = true;
                }
            }
            throw throwable;
        }
        if (this.m_process != null) {
            RoslynDaemon roslynDaemon = this;
            synchronized (roslynDaemon) {
                this.m_isReady = true;
            }
        }
    }

    @Override
    public TaskMonitor<List<ProjectInfo>> openSolution(String solutionFilePath) {
        assert (solutionFilePath != null && solutionFilePath.length() > 0) : "Parameter 'solutionFilePath' of method 'openSolution' must not be empty";
        assert (this.isReady());
        if (solutionFilePath.equals(this.m_currentSolutionPath)) {
            TaskMonitor<List<ProjectInfo>> result = new TaskMonitor<List<ProjectInfo>>(TaskState.Finished);
            assert (this.m_projectInfoList != null && !this.m_projectInfoList.isEmpty());
            result.setResult(this.m_projectInfoList);
        }
        this.m_currentSolutionPath = null;
        if (!this.sendCommand("OpenSolution")) {
            return new TaskMonitor<List<ProjectInfo>>();
        }
        if (!this.sendCommand(solutionFilePath)) {
            return new TaskMonitor<List<ProjectInfo>>();
        }
        this.m_isReady = false;
        return new TaskMonitor<List<ProjectInfo>>(tm -> this.handleOpenSolution((TaskMonitor<List<ProjectInfo>>)tm, solutionFilePath));
    }

    @Override
    public boolean closeSolution() {
        assert (this.isReady());
        if (!this.sendCommand("CloseSolution")) {
            return false;
        }
        String line = this.readLineFromProcess();
        if (line == null || !line.equals(Ok)) {
            this.endProcess();
            return false;
        }
        this.m_currentSolutionPath = null;
        return true;
    }

    @Override
    public ListProjectsResult listProjects() {
        assert (this.isReady());
        if (!this.sendCommand("ListProjects")) {
            return new ListProjectsResult("Roslyn daemon died");
        }
        String line = this.readLineFromProcess();
        if (line == null) {
            this.endProcess();
            return new ListProjectsResult("Roslyn daemon died");
        }
        if (line.equals(Ok)) {
            ListProjectsResult result = new ListProjectsResult(null);
            while (true) {
                if ((line = this.readLineFromProcess()) == null) {
                    return new ListProjectsResult("Roslyn daemon died");
                }
                if (line.length() == 0) break;
                result.addProject(line);
            }
            return result;
        }
        if (line.startsWith(Error)) {
            return new ListProjectsResult(line.substring(7));
        }
        return new ListProjectsResult("Unexpected answer: " + line);
    }

    /*
     * Exception decompiling
     */
    private void handleParseProjects(TaskMonitor<JSONObject> tm, IWorkerContext workerContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 56[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public TaskMonitor<JSONObject> parseProjects(Collection<String> projectNames, IWorkerContext workerContext) {
        assert (this.isReady());
        if (!this.sendCommand("ParseProjects")) {
            return new TaskMonitor<JSONObject>();
        }
        this.m_parserLogMessages.clear();
        for (String projectName : projectNames) {
            if (this.sendCommand(projectName)) continue;
            return new TaskMonitor<JSONObject>();
        }
        if (!this.sendCommand("")) {
            return new TaskMonitor<JSONObject>();
        }
        this.m_isReady = false;
        workerContext.working("Parsing solution...", true);
        workerContext.beginBlockOfWork(100);
        return new TaskMonitor<JSONObject>(tm -> this.handleParseProjects((TaskMonitor<JSONObject>)tm, workerContext));
    }

    @Override
    public boolean cancel() {
        if (!this.isAlive()) {
            return false;
        }
        return this.sendCommand("Cancel");
    }

    @Override
    public void stop() {
        String reply;
        if (!this.isReady()) {
            return;
        }
        if (this.sendCommand("Quit") && !Ok.equals(reply = this.readLineFromProcess())) {
            LOGGER.error("Unexpected reply for Quit command: " + reply);
        }
        this.endProcess();
    }

    @Override
    public List<String> getParserLogMessages() {
        return this.m_parserLogMessages;
    }
}

