/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.SystemSettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.XmlAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModule;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModuleDependency;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractSystemExtension;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.SystemEnvSupport;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpLanguage;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSolutionFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModuleType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpRoslynModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.ObjectFactory;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpManualModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpProjectFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpProjectFileBasedModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpRoslynModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpRoslynSystemConfiguration;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpVisualStudioProjectDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system.XsdCSharpVisualStudioProjectToAssemblyDependency;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSharpPersistenceProvider
extends XmlAdditionalInfoProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpPersistenceProvider.class);
    private final XmlPersistenceContext m_persistenceContext = new XmlPersistenceContext("com.hello2morrow.sonargraph.languageprovider.csharp.persistence.system", CSharpResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, "com/hello2morrow/sonargraph/languageprovider/csharp/persistence/system/csharpSoftwareSystem"));
    private boolean m_canLoadSnapshot = true;
    private boolean m_sawSolutionFile = false;

    public CSharpPersistenceProvider(Installation installation) {
        super(installation);
    }

    public boolean canLoadSnapshot() {
        return this.m_canLoadSnapshot;
    }

    public boolean systemCanBeLoaded() {
        return this.m_sawSolutionFile;
    }

    public XmlPersistenceContext getPersistentContext() {
        return this.m_persistenceContext;
    }

    public boolean canCreateWorkspaceDependencies() {
        return false;
    }

    protected XsdAbstractModule createXmlModule(Module.IModuleType moduleType) {
        assert (moduleType == CSharpModuleType.ROSLYN);
        return new ObjectFactory().createXsdCSharpRoslynModule();
    }

    public void getSystemDetailsFromXml(SoftwareSystem softwareSystem, XsdAbstractSystemExtension systemExtension, OperationResult result) {
        super.getSystemDetailsFromXml(softwareSystem, systemExtension, result);
        assert (systemExtension.getLanguage().equals(CSharpLanguage.INSTANCE.getStandardName())) : "Language '" + systemExtension.getLanguage() + "' of systemExtension does not match '" + CSharpLanguage.INSTANCE.getStandardName();
        if (systemExtension instanceof XsdCSharpRoslynSystemConfiguration) {
            XsdCSharpRoslynSystemConfiguration config = (XsdCSharpRoslynSystemConfiguration)systemExtension;
            String solutionPath = config.getSolutionFilePath();
            this.addSolutionFileToSystem(softwareSystem, new TFile((File)softwareSystem.getDirectoryFile(), solutionPath));
        }
    }

    public void addSystemDetailsToXml(SoftwareSystem softwareSystem, com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem systemXml) {
        super.addSystemDetailsToXml(softwareSystem, systemXml);
        if (!softwareSystem.getUsedLanguages().contains(this.getLanguage())) {
            return;
        }
        XsdCSharpRoslynSystemConfiguration xmlSystemConfig = new ObjectFactory().createXsdCSharpRoslynSystemConfiguration();
        systemXml.getSystemExtension().add(xmlSystemConfig);
        xmlSystemConfig.setLanguage(CSharpLanguage.INSTANCE.getStandardName());
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        SystemSettings settings = (SystemSettings)ws.getFirstChild(CSharpSystemSettings.class);
        assert (settings != null);
        CSharpSolutionFile solutionFile = (CSharpSolutionFile)((Object)settings.getUniqueExistingChild(CSharpSolutionFile.class));
        xmlSystemConfig.setSolutionFilePath(solutionFile.getPath());
    }

    protected void getModuleDetailsFromXml(Installation inst, SoftwareSystem softwareSystem, Module module, XsdAbstractModule moduleXml, OperationResult result) {
        super.getModuleDetailsFromXml(inst, softwareSystem, module, moduleXml, result);
        assert (moduleXml instanceof XsdCSharpModule) : "Unexpected class: " + moduleXml.getClass().getName();
        assert (module instanceof CSharpRoslynModule);
        CSharpRoslynModule csModule = (CSharpRoslynModule)module;
        if (!(moduleXml instanceof XsdCSharpManualModule)) {
            if (moduleXml instanceof XsdCSharpProjectFileBasedModule) {
                XsdCSharpProjectFileBasedModule xmlCSharpModule = (XsdCSharpProjectFileBasedModule)moduleXml;
                XsdCSharpProjectFile projectFileXml = xmlCSharpModule.getCsharpProjectFile();
                String projectFilePath = projectFileXml.getPath();
                String resolvedPath = SystemEnvSupport.resolveEscaped((String)projectFilePath);
                TFile baseDir = ((Files)softwareSystem.getUniqueChild(Files.class)).getSystemBaseDirectory();
                TFile solutionFile = this.determineFileFromPath(baseDir, projectFileXml.getSolutionFilePath());
                if (solutionFile != null) {
                    this.addSolutionFileToSystem(softwareSystem, solutionFile);
                }
                TFile projectFile = new TFile(resolvedPath);
                csModule.setProjectName(FileUtility.getFileNameWithoutExtension((TFile)projectFile));
                csModule.setRootPath(projectFile.getParent());
            } else {
                assert (moduleXml instanceof XsdCSharpRoslynModule);
                XsdCSharpRoslynModule xmlCSharpModule = (XsdCSharpRoslynModule)moduleXml;
                csModule.setProjectName(xmlCSharpModule.getProjectNameWithFlavor());
                csModule.setRootPath(xmlCSharpModule.getProjectRootPath());
            }
        }
    }

    private void addSolutionFileToSystem(SoftwareSystem softwareSystem, TFile solutionFilePath) {
        CSharpSolutionFile solutionFile;
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CSharpSystemSettings settings = (CSharpSystemSettings)((Object)ws.getUniqueChild(CSharpSystemSettings.class));
        if (settings == null) {
            settings = new CSharpSystemSettings((NamedElement)ws);
            ws.addChild((NamedElement)settings);
        }
        if ((solutionFile = (CSharpSolutionFile)((Object)settings.getUniqueChild(CSharpSolutionFile.class))) == null) {
            solutionFile = new CSharpSolutionFile((NamedElement)settings, solutionFilePath);
            settings.addChild((NamedElement)solutionFile);
        } else if (!solutionFile.getFile().getNormalizedAbsolutePath().equals(solutionFilePath.getNormalizedAbsolutePath())) {
            LOGGER.warn("Sonargraph does not support more than one solution file per system");
        }
        this.m_sawSolutionFile = true;
    }

    private TFile determineFileFromPath(TFile baseDir, String path) {
        if (path != null && path.trim().length() > 0) {
            if (FileUtility.isAbsolutePath((String)path)) {
                return new TFile(path);
            }
            return new TFile((File)baseDir, path);
        }
        return null;
    }

    public void addModuleDetailsToXml(SoftwareSystem softwareSystem, Module module, com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem systemXml, XsdAbstractModule moduleXml) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addModuleDetailsToXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addModuleDetailsToXml' must not be null";
        assert (systemXml != null) : "Parameter 'systemXml' of method 'addModuleDetailsToXml' must not be null";
        assert (moduleXml != null) : "Parameter 'moduleXml' of method 'addModuleDetailsToXml' must not be null";
        XsdCSharpRoslynModule csharpModuleXml = (XsdCSharpRoslynModule)moduleXml;
        assert (module.getType() == CSharpModuleType.ROSLYN);
        this.addRoslynModuleDetailsToXml((CSharpRoslynModule)module, csharpModuleXml);
    }

    private void addRoslynModuleDetailsToXml(CSharpRoslynModule module, XsdCSharpRoslynModule csharpModuleXml) {
        csharpModuleXml.setLanguage(CSharpLanguage.INSTANCE.getStandardName());
        csharpModuleXml.setName(module.getShortName());
        csharpModuleXml.setId(module.getId());
        csharpModuleXml.setDescription(module.getDescription());
        csharpModuleXml.setProjectNameWithFlavor(module.getProjectName());
        csharpModuleXml.setProjectRootPath(module.getRootPath());
    }

    public Language getLanguage() {
        return CSharpLanguage.INSTANCE;
    }

    protected XsdAbstractModuleDependency createWorkspaceDependency(Module origin, WorkspaceDependency dependency) {
        assert (origin != null) : "Parameter 'origin' of method 'createWorkspaceDependency' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'createWorkspaceDependency' must not be null";
        assert (dependency.getType() instanceof CSharpWorkspaceDependency.DependencyType) : "Unexpected class: " + dependency.getType().getClass().getName();
        CSharpWorkspaceDependency.DependencyType dependencyType = (CSharpWorkspaceDependency.DependencyType)dependency.getType();
        switch (dependencyType) {
            case VISUAL_STUDIO_PROJECT_DEPENDENCY: {
                return new ObjectFactory().createXsdCSharpVisualStudioProjectDependency();
            }
            case VISUAL_STUDIO_PROJECT_TO_ASSEMBLY_DEPENDENCY: {
                return new ObjectFactory().createXsdCSharpVisualStudioProjectToAssemblyDependency();
            }
        }
        assert (false) : "type '" + dependencyType.getStandardName() + "' is not yet supported";
        return null;
    }

    public WorkspaceDependency.IWorkspaceDependencyType getWorkspaceDependencyType(Class<? extends XsdAbstractModuleDependency> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getWorkspaceDependencyType' must not be null";
        if (clazz.equals(XsdCSharpVisualStudioProjectDependency.class)) {
            return CSharpWorkspaceDependency.DependencyType.VISUAL_STUDIO_PROJECT_DEPENDENCY;
        }
        if (clazz.equals(XsdCSharpVisualStudioProjectToAssemblyDependency.class)) {
            return CSharpWorkspaceDependency.DependencyType.VISUAL_STUDIO_PROJECT_TO_ASSEMBLY_DEPENDENCY;
        }
        assert (false) : "No type defined for WorkspaceDependency '" + clazz.getCanonicalName() + "'";
        return null;
    }

    public Module.IModuleType getModuleType(Class<? extends XsdAbstractModule> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getModuleType' must not be null";
        if (clazz.equals(XsdCSharpManualModule.class)) {
            this.m_canLoadSnapshot = false;
            return CSharpModuleType.ROSLYN;
        }
        if (clazz.equals(XsdCSharpProjectFileBasedModule.class)) {
            this.m_canLoadSnapshot = false;
            return CSharpModuleType.ROSLYN;
        }
        if (clazz.equals(XsdCSharpRoslynModule.class)) {
            return CSharpModuleType.ROSLYN;
        }
        assert (false) : "No type defined for C# module '" + clazz.getCanonicalName() + "'";
        return null;
    }
}

