/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.element;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpLanguage;
import java.util.Collections;
import java.util.List;

public final class CSharpIssueId
extends Enum<CSharpIssueId>
implements IIssueId {
    public static final /* enum */ CSharpIssueId CS_PARSER_ERROR = new CSharpIssueId("C# parser error", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.ELEMENT, false);
    public static final /* enum */ CSharpIssueId CS_PARSER_WARNING = new CSharpIssueId("C# parser warning", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, false);
    public static final /* enum */ CSharpIssueId EXTERN_ALIAS_ISSUE = new CSharpIssueId("Cannot resolve extern alias", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.ELEMENT, false);
    public static final /* enum */ CSharpIssueId INST_PROFILE_GROOVY_TEMPLATE_ERROR = new CSharpIssueId("C# profile Groovy error (Installation)", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId PROFILE_GROOVY_TEMPLATE_ERROR = new CSharpIssueId("C# profile Groovy error (System)", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId INST_PROFILE_DIRECTORY_NOT_EXISTS = new CSharpIssueId("Assembly directory of C# installation profile does not exist", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId PROFILE_DIRECTORY_NOT_EXISTS = new CSharpIssueId("Assembly directory does not exist", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId INSTALLATION_PROFILE_MISSING = new CSharpIssueId("The specified C# installation profile does not exist", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId REFERENCED_PROFILE_INVALID = new CSharpIssueId("The referenced C# installation profile has errors", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId INVALID_BUILD_EXECUTABLE = new CSharpIssueId("Invalid executable for processing C# project files", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId DUPLICATE_EXTERN_ALIAS = new CSharpIssueId("Duplicate extern alias", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId ASSEMBLY_NOT_FOUND = new CSharpIssueId("Referenced assembly not found", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId ASSEMBLY_PROCESSING_FAILED = new CSharpIssueId("Processing of assembly failed", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId CSHARP_PROJECT_NOT_ACCESSIBLE = new CSharpIssueId("Referenced C# project cannot be accessed", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId CSHARP_PROJECT_FILE_MISSING = new CSharpIssueId("No Visual Studio C# project file specified", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId PROJECT_FILE_PROCESSING_FAILED = new CSharpIssueId("Processing of .csproj file failed", IssueCategory.WORKSPACE, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId PROJECT_FILE_PROCESSING_WITH_FALLBACK_PARSER = new CSharpIssueId("Processing of .csproj file failed using MSBuild.", IssueCategory.WORKSPACE, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId CSHARP_INSTALLATION_ISSUE = new CSharpIssueId("C# Installation Issue", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId ENVIRONMENT_VARIABLE_MISSING = new CSharpIssueId("Environment variable missing", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId ACTIVE_PROFILE_NOT_DEFINED = new CSharpIssueId("No active C# profile defined", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.WARNING));
    public static final /* enum */ CSharpIssueId ACTIVE_PROFILE_NOT_FOUND = new CSharpIssueId("Specified active C# profile is missing", IssueCategory.INSTALLATION_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId PROFILE_CONFIGURATION_ERROR = new CSharpIssueId("C# profile configuration error", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId NO_INSTALLATION_PROFILE_REFERENCED_MATCHING_NETSTANDARD_VERSION = new CSharpIssueId("No C# installation profile referenced by module or system that matches used NetStandard target framework version", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId NO_INSTALLATION_PROFILE_REFERENCED_MATCHING_NETFRAMEWORK_VERSION = new CSharpIssueId("No C# installation profile referenced by module or system that matches used NetFramework target framework version", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.WARNING), IIssueId.PatternEditMode.UNEDITABLE, true);
    public static final /* enum */ CSharpIssueId DUPLICATE_ASSEMBLY_NAME = new CSharpIssueId("The module's assembly name is not unique", IssueCategory.SYSTEM_CONFIGURATION, Collections.singletonList(Severity.ERROR), IIssueId.PatternEditMode.UNEDITABLE, true);
    private final String m_presentationName;
    private final IssueCategory m_category;
    private final List<Severity> m_supportedSeverities;
    private final IIssueId.PatternEditMode m_patternEditMode;
    private final boolean m_requiresIndividualResolution;
    private static final /* synthetic */ CSharpIssueId[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CSharpIssueId[]{CS_PARSER_ERROR, CS_PARSER_WARNING, EXTERN_ALIAS_ISSUE, INST_PROFILE_GROOVY_TEMPLATE_ERROR, PROFILE_GROOVY_TEMPLATE_ERROR, INST_PROFILE_DIRECTORY_NOT_EXISTS, PROFILE_DIRECTORY_NOT_EXISTS, INSTALLATION_PROFILE_MISSING, REFERENCED_PROFILE_INVALID, INVALID_BUILD_EXECUTABLE, DUPLICATE_EXTERN_ALIAS, ASSEMBLY_NOT_FOUND, ASSEMBLY_PROCESSING_FAILED, CSHARP_PROJECT_NOT_ACCESSIBLE, CSHARP_PROJECT_FILE_MISSING, PROJECT_FILE_PROCESSING_FAILED, PROJECT_FILE_PROCESSING_WITH_FALLBACK_PARSER, CSHARP_INSTALLATION_ISSUE, ENVIRONMENT_VARIABLE_MISSING, ACTIVE_PROFILE_NOT_DEFINED, ACTIVE_PROFILE_NOT_FOUND, PROFILE_CONFIGURATION_ERROR, NO_INSTALLATION_PROFILE_REFERENCED_MATCHING_NETSTANDARD_VERSION, NO_INSTALLATION_PROFILE_REFERENCED_MATCHING_NETFRAMEWORK_VERSION, DUPLICATE_ASSEMBLY_NAME};
    }

    public static CSharpIssueId fromStandardName(String standardName) throws IllegalArgumentException {
        assert (standardName != null) : "'standardName' must not be null";
        assert (standardName.length() > 0) : "'standardName' must not be empty";
        String name = StringUtility.convertStandardNameToConstantName((String)standardName);
        return CSharpIssueId.valueOf(name);
    }

    private CSharpIssueId(String presentationName, IssueCategory category, List<Severity> severities) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'CSharpIssueId' must not be empty";
        assert (category != null) : "Parameter 'category' of method 'CSharpIssueId' must not be null";
        assert (severities != null && !severities.isEmpty()) : "Parameter 'severities' of method 'CSharpIssueId' must not be empty";
        this.m_presentationName = presentationName;
        this.m_category = category;
        this.m_supportedSeverities = severities;
        this.m_patternEditMode = null;
        this.m_requiresIndividualResolution = false;
    }

    private CSharpIssueId(String presentationName, IssueCategory category, List<Severity> severities, IIssueId.PatternEditMode matchingMode, boolean requiresIndividualResolution) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'CSharpIssueId' must not be empty";
        assert (category != null) : "Parameter 'category' of method 'CSharpIssueId' must not be null";
        assert (severities != null && !severities.isEmpty()) : "Parameter 'severities' of method 'CSharpIssueId' must not be empty";
        assert (matchingMode != null) : "Parameter 'matchingMode' of method 'CSharpIssueId' must not be null";
        this.m_presentationName = presentationName;
        this.m_category = category;
        this.m_supportedSeverities = severities;
        this.m_patternEditMode = matchingMode;
        this.m_requiresIndividualResolution = requiresIndividualResolution;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public IssueCategory getCategory() {
        return this.m_category;
    }

    public List<Severity> getSupportedSeverities() {
        return this.m_supportedSeverities;
    }

    public boolean isParserModelIssue() {
        return true;
    }

    public boolean persist() {
        return true;
    }

    public boolean isResolvable() {
        return this.m_patternEditMode != null;
    }

    public IIssueId.PatternEditMode getPatternEditMode() {
        return this.m_patternEditMode;
    }

    public boolean requiresIndividualResolution() {
        return this.m_requiresIndividualResolution;
    }

    public String getProviderName() {
        return CSharpLanguage.INSTANCE.getStandardName();
    }

    public static CSharpIssueId[] values() {
        CSharpIssueId[] cSharpIssueIdArray = ENUM$VALUES;
        int n = cSharpIssueIdArray.length;
        CSharpIssueId[] cSharpIssueIdArray2 = new CSharpIssueId[n];
        System.arraycopy(ENUM$VALUES, 0, cSharpIssueIdArray2, 0, n);
        return cSharpIssueIdArray2;
    }

    public static CSharpIssueId valueOf(String string) {
        return Enum.valueOf(CSharpIssueId.class, string);
    }
}

