/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn;

import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ITaskMonitor;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.TaskState;
import java.util.function.Consumer;

public class TaskMonitor<T>
implements ITaskMonitor<T> {
    private Thread m_thread;
    private TaskState m_state = TaskState.Running;
    private String m_errorMessage;
    private T m_result;

    public TaskMonitor(Consumer<TaskMonitor<T>> task) {
        this.m_thread = new Thread(() -> task.accept(this));
        this.m_thread.start();
    }

    public TaskMonitor(TaskState state) {
        this.m_state = state;
    }

    public TaskMonitor() {
        this(TaskState.Dead);
    }

    @Override
    public synchronized TaskState getState() {
        return this.m_state;
    }

    public synchronized void setState(TaskState state) {
        this.m_state = state;
    }

    @Override
    public synchronized String getErrorMessage() {
        switch (this.m_state) {
            case Dead: {
                return "C# daemon dies unexpectedly";
            }
            case Error: {
                return this.m_errorMessage;
            }
            case Cancelled: {
                return "Operation was cancelled";
            }
        }
        assert (false) : "Unexpected state " + this.m_state.toString();
        return null;
    }

    public synchronized void setErrorMessage(String errorMessage) {
        this.m_state = TaskState.Error;
        this.m_errorMessage = errorMessage;
    }

    @Override
    public T getResult() {
        return this.m_result;
    }

    public void setResult(T result) {
        this.m_result = result;
    }

    @Override
    public void join() {
        try {
            this.m_thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

