/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.csharp.command.system.CSharpCommandId;
import com.hello2morrow.sonargraph.languageprovider.csharp.command.system.CSharpSolutionImportData;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.ICSharpWorkspaceExtension;

public final class CreateNewSolutionFileBasedCSharpSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    public static final ICommandId ID = CSharpCommandId.CREATE_SOFTWARE_SYSTEM_FROM_VS_SOLUTION_FILE;
    private final IInteraction m_interaction;
    private boolean m_canceled;

    public CreateNewSolutionFileBasedCSharpSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateNewVSSolutionFileBasedSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return ID;
    }

    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            this.m_canceled = true;
            return;
        }
        CSharpSolutionImportData importData = new CSharpSolutionImportData();
        if (!this.m_interaction.collect(importData)) {
            this.m_canceled = true;
            return;
        }
        ICSharpWorkspaceExtension extension = (ICSharpWorkspaceExtension)this.getController().getSoftwareSystem().getExtension(ICSharpWorkspaceExtension.class);
        OperationResult createModulesResult = extension.createModulesFromSolutionFileImportOnSystemCreation(workerContext, importData.getSolutionFile(), importData.getProjectsToImport());
        if (!createModulesResult.isFailure()) {
            createModulesResult.addMessagesFrom(this.getController().saveSoftwareSystem(workerContext));
        }
        this.m_interaction.processModuleCreationResult(createModulesResult);
    }

    public boolean canceled() {
        return this.m_canceled;
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collect(CSharpSolutionImportData var1);

        public void processModuleCreationResult(OperationResult var1);
    }
}

