/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.IHasSignature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CSharpMember
extends CSharpProgrammingElement
implements IHasSignature {
    private String m_signature;

    protected CSharpMember(NamedElement parent) {
        super(parent);
    }

    protected CSharpMember(IModelServiceProvider msp, NamedElement parent, String name) {
        super(msp, parent, name);
    }

    protected List<String> parseSignature() {
        String sig = this.getSignature();
        int breakPos = sig.lastIndexOf("):");
        String returnType = sig.substring(breakPos + 2);
        String[] args = sig.substring(1, breakPos).split(";");
        ArrayList<String> result = new ArrayList<String>(args.length + 1);
        result.add(returnType);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            result.add(arg);
            ++n2;
        }
        return result;
    }

    public CSharpType getEnclosingType() {
        return (CSharpType)this.getParent(CSharpType.class, new Class[0]);
    }

    public String getName() {
        return this.getParent().getName() + "." + this.getShortName();
    }

    public String getPresentationName(boolean parentIsPresented) {
        if (parentIsPresented) {
            return this.getShortName();
        }
        return this.getParent().getPresentationName(false) + "." + this.getShortName();
    }

    public final boolean isMember() {
        return true;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_signature = reader.readString();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
    }

    @Override
    public final String getSignature() {
        return this.m_signature;
    }

    public String getTypeCheckingSignature() {
        return this.m_signature;
    }

    @Override
    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpMember(this);
        } else {
            super.accept(visitor);
        }
    }

    public String getDebugInfo() {
        if (this.m_signature != null) {
            StringBuilder builder = new StringBuilder(super.getDebugInfo());
            builder.append("\n");
            builder.append(this.m_signature);
            return builder.toString();
        }
        return super.getDebugInfo();
    }

    public static interface IVisitor {
        public void visitCSharpMember(CSharpMember var1);
    }
}

