/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpVisualStudio;
import de.schlichtherle.truezip.file.TFile;

final class ProjectFileValidator
implements IPathValidator {
    ProjectFileValidator() {
    }

    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.FILE;
    }

    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        if (currentInput == null && (newInput == null || newInput.getPath().isEmpty())) {
            ValidationResult result = new ValidationResult(FileUtility.areEqual(null, (TFile)newInput));
            result.addError("Must not be empty");
            return result;
        }
        ValidationResult result = new ValidationResult(FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (!newInput.exists()) {
            result.addError("Specified C# project file '" + newInput.getNormalizedAbsolutePath() + "' does not exist.");
            return result;
        }
        if (!newInput.getAbsolutePath().endsWith(CSharpVisualStudio.PROJECT_FILE_EXTENSION.getPresentationName())) {
            result.addError("Specified file '" + newInput.getNormalizedAbsolutePath() + "'" + StringUtility.LINE_SEPARATOR + "does not have the expected file extension '" + CSharpVisualStudio.PROJECT_FILE_EXTENSION.getPresentationName());
            return result;
        }
        return result;
    }
}

