/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpMember;
import java.io.IOException;
import java.util.List;

public final class CSharpProperty
extends CSharpMember
implements IField {
    private static final int FLAG_HAS_SETTER = 65536;
    private static final int FLAG_HAS_GETTER = 131072;
    private CSharpAccessSpecifier m_writeAccessSpecifier = CSharpAccessSpecifier.PRIVATE;
    private boolean m_isIndexer;

    public CSharpProperty(NamedElement parent) {
        super(parent);
    }

    public CSharpProperty(IModelServiceProvider msp, NamedElement parent, String name, boolean isIndexer) {
        super(msp, parent, name);
        this.m_isIndexer = isIndexer;
    }

    public String getShortName() {
        Object result = super.getShortName();
        if (this.m_isIndexer) {
            List<String> sigList = this.parseSignature();
            result = (String)result + "[" + Joiner.join(sigList.subList(1, sigList.size())) + "]";
        }
        return result;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_writeAccessSpecifier = CSharpAccessSpecifier.values()[reader.readByte()];
        this.m_isIndexer = reader.readBoolean();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeByte((byte)this.m_writeAccessSpecifier.ordinal());
        writer.writeBoolean(this.m_isIndexer);
    }

    public CSharpAccessSpecifier getReadAccessSpecifier() {
        return super.getAccessSpecifier();
    }

    public CSharpAccessSpecifier getWriteAccessSpecifier() {
        return this.m_writeAccessSpecifier;
    }

    public void setWriteAccessSpecifier(CSharpAccessSpecifier writeAccessSpecifier) {
        this.m_writeAccessSpecifier = writeAccessSpecifier;
    }

    public boolean isIndexer() {
        return this.m_isIndexer;
    }

    public void setHasGetter() {
        this.setFlag(131072, true);
    }

    public void setHasSetter() {
        this.setFlag(65536, true);
    }

    public boolean hasGetter() {
        return this.testFlag(131072);
    }

    public boolean hasSetter() {
        return this.testFlag(65536);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpProperty(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCSharpProperty(CSharpProperty var1);
    }
}

